/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.uamanager;

import com.ibm.db2.tools.common.uamanager.UAMException;
import com.ibm.db2.tools.common.uamanager.UAManager;
import com.ibm.db2.tools.common.uamanager.UAPopupModel;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class UAHtmlFilter {
    private static final String NAME = "UAHtmlFilter";
    private String strEncoding = "Unicode";
    private boolean unicodeSupported = true;
    private byte[] unicodeBytes;
    private char[] alreadyUnicode;
    private InputStreamReader isrUc;
    private int lengthOfUC;
    private BufferedReader htmlFile;
    private UAPopupModel popupModel;
    private Hashtable theIPCache = new Hashtable(20);
    private Vector endMarkers = new Vector();
    private static final String begCMT = "<!--";
    private static final String begID = "infopopid=";
    private static final String begIDCAPS = "INFOPOPID=";
    private static final String capsDebug = "<DEBUGTEXT>";
    private static final String capsEndDebug = "</DEBUGTEXT>";
    private static final String capsDebugCMT = "DEBUGTEXT: ";
    private static final String begDebug = "<DebugText>";
    private static final String endDebug = "</DebugText>";
    private static final String endCMT = "-->";
    private String LeadIn = "";
    private String currentSection = "";
    private String errMsg = "UA Error:  No popup defined for ";
    private String cachedStr = "";
    private String sourceofCache = "";
    private String capsEndBody = "</BODY>";
    private String capsEndHTML = "</HTML>";
    private String capsBegFooter = "BEGIN FOOTER RECORDS";
    private boolean firstIter = true;
    private boolean tryAgain = true;
    private boolean haveParsedString = false;
    private String alreadyTried = "";
    private static boolean enhancedDebug = false;
    static final String enhancedTest = "enhancedDebug";

    UAHtmlFilter(UAPopupModel uAPopupModel) throws UAMException {
        this.popupModel = uAPopupModel;
        this.sourceofCache = this.popupModel.getDir();
        enhancedDebug = UAManager.getSettingFromControlVariable(enhancedTest);
        this.endMarkers.addElement(this.capsEndBody);
        this.endMarkers.addElement(this.capsEndHTML);
        this.endMarkers.addElement(this.capsBegFooter);
        this.buildReaderForHTML(this.popupModel.getDir());
    }

    public synchronized void setPUModel(UAPopupModel uAPopupModel) throws UAMException {
        this.popupModel.setCodebase(uAPopupModel.getCodebase());
        this.tryAgain = true;
        if (uAPopupModel.getWindowCode() == 0 || uAPopupModel.getWindowCode() != this.popupModel.getWindowCode() && !uAPopupModel.getDir().equals(this.popupModel.getDir()) || uAPopupModel.getWindowCode() == this.popupModel.getWindowCode() && !uAPopupModel.getDir().equals(this.popupModel.getDir()) && this.cacheContains()) {
            this.cachedStr = "";
            this.theIPCache.clear();
            this.haveParsedString = false;
            this.buildReaderForHTML(uAPopupModel.getDir());
        }
        this.firstIter = true;
        this.popupModel = uAPopupModel;
    }

    private void buildReaderForHTML(String string) throws UAMException {
        this.sourceofCache = string;
        if (!this.tryAgain) {
            return;
        }
        if (this.alreadyTried.equals(string)) {
            return;
        }
        this.alreadyTried = string;
        int n2 = string.toUpperCase().indexOf(".HTM#");
        if (n2 > 0) {
            string = string.substring(0, n2 + 4);
        }
        try {
            if (this.popupModel.getCodebase() == null) {
                File file = new File(string);
                FileInputStream fileInputStream = new FileInputStream(file);
                this.lengthOfUC = (int)file.length();
                this.alreadyUnicode = new char[this.lengthOfUC + 1];
                this.isrUc = new InputStreamReader((InputStream)fileInputStream, this.strEncoding);
            } else {
                InputStream inputStream = UAManager.buildInputStream(null, string);
                try {
                    URL uRL = new URL(this.popupModel.getCodebase(), string);
                    URLConnection uRLConnection = uRL.openConnection();
                    this.lengthOfUC = uRLConnection.getContentLength();
                    this.isrUc = new InputStreamReader(inputStream, this.strEncoding);
                    this.alreadyUnicode = new char[this.lengthOfUC + 1];
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    this.unicodeSupported = false;
                    this.unicodeBytes = new byte[this.lengthOfUC + 1];
                    this.unicodeBytes = this.readBytesFromStream(this.lengthOfUC, this.unicodeBytes, inputStream);
                }
            }
        }
        catch (IOException iOException) {
            try {
                String string2 = UAManager.getIpNlvRecoveryName();
                if (string2 == null || !this.tryAgain || string.equals(string2)) {
                    throw new UAMException(NAME, "UA Error: UAHtmlFilterthrewan I/O exception while reading the fileand cannot attempt a recovery." + iOException.toString());
                }
                if (this.tryAgain && !string2.equals(this.alreadyTried)) {
                    this.buildReaderForHTML(string2);
                }
                this.tryAgain = false;
            }
            catch (Throwable throwable) {
                throw new UAMException(NAME, "UA Error: UAHtmlFilterthrewan I/O exception while reading the fileand failed during recovery." + throwable.toString());
            }
        }
        catch (SecurityException securityException) {
            throw new UAMException(NAME, "UA Error: UAHtmlFilter threw a security exception while reading the html file.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new UAMException(NAME, "UA Error: UAHtmlFilter received invalid arguments for reading the html file.");
        }
    }

    private synchronized void cacheTheString(String string) {
        this.cachedStr = string;
    }

    private synchronized String getPopupFromCache() {
        return (String)this.theIPCache.get(this.popupModel.getName());
    }

    private synchronized boolean cachedRawStringContains() {
        int n2 = this.cachedStr.indexOf("\"" + this.popupModel.getName() + "\"");
        return n2 > 0;
    }

    private synchronized boolean cacheContains() {
        this.firstIter = false;
        return this.theIPCache.containsKey(this.popupModel.getName());
    }

    private synchronized int checkStringForEnd(String string) {
        int n2 = 0;
        while (n2 < this.endMarkers.size()) {
            if (string.toUpperCase().indexOf((String)this.endMarkers.elementAt(n2)) > -1) {
                return string.toUpperCase().indexOf((String)this.endMarkers.elementAt(n2));
            }
            ++n2;
        }
        return -1;
    }

    private synchronized String parseRawString() {
        int n2;
        String string;
        String string2;
        int n3;
        int n4;
        String string3;
        String string4;
        StringTokenizer stringTokenizer;
        int n5 = this.cachedStr.toUpperCase().indexOf(begIDCAPS);
        boolean bl = n5 <= 0;
        String string5 = "=\"" + this.popupModel.getName() + "\"";
        int n6 = this.cachedStr.indexOf(string5) + string5.length();
        String string6 = this.cachedStr.substring(n6);
        if ((string6 = string6.substring(string6.indexOf(">") + 1)).toUpperCase().startsWith("</A>")) {
            string6 = string6.substring(string6.toUpperCase().indexOf("</A>") + 4);
        }
        String string7 = "<A NAME=";
        String string8 = "_MORE\"></A>";
        int n7 = string6.toUpperCase().indexOf(string7);
        int n8 = string6.toUpperCase().indexOf(string8);
        String string9 = "";
        if (n8 * n7 != 1 && n7 < n8 && !bl && (stringTokenizer = new StringTokenizer(string9 = string6.substring(n7, n8 + string8.length()), "\"", false)).countTokens() == 3) {
            String string10 = (String)stringTokenizer.nextElement();
            string4 = (String)stringTokenizer.nextElement();
            string3 = (String)stringTokenizer.nextElement();
            n4 = string7.equals(string10);
            n3 = string3.equals("></A>");
            if (n4 != 0 && n3 != 0) {
                string6 = string6.substring(0, n7);
            }
        }
        if (n7 > 0 && n7 < string6.length() && string6.indexOf(begID) * string6.indexOf(begIDCAPS) == 1) {
            string6 = string6.substring(0, n7);
        }
        if (string6.toUpperCase().indexOf(this.capsBegFooter) != -1) {
            string6 = string6.substring(0, string6.toUpperCase().indexOf(this.capsBegFooter));
        }
        int n9 = string6.indexOf(begCMT);
        int n10 = -1;
        while (n10 < n9) {
            int n11 = string6.indexOf(endCMT, n9);
            string6 = n11 != -1 ? ((string3 = string6.substring(n9 + begCMT.length(), n11)).toUpperCase().indexOf(begIDCAPS) != -1 ? string6.substring(0, n9) : ((n4 = string3.toUpperCase().indexOf(capsDebugCMT)) != -1 ? (enhancedDebug ? string6.substring(0, n9) + begDebug + string3.substring(n4 + capsDebugCMT.length()) + endDebug + string6.substring(n11 + endCMT.length()) : string6.substring(0, n9) + string6.substring(n11 + endCMT.length())) : string6.substring(0, n9) + string6.substring(n11 + endCMT.length()))) : string6.substring(0, n9);
            n9 = string6.indexOf(begCMT);
        }
        if (string6.toUpperCase().indexOf(this.capsEndBody) != -1) {
            string6 = string6.substring(0, string6.toUpperCase().indexOf(this.capsEndBody));
        } else if (string6.toUpperCase().indexOf(this.capsEndHTML) != -1) {
            string6 = string6.substring(0, string6.toUpperCase().indexOf(this.capsEndHTML));
        }
        string4 = "<B><IMG";
        string3 = "</B>";
        n4 = string6.toUpperCase().indexOf(string4);
        if (n4 != -1) {
            String string11;
            n3 = string6.toUpperCase().indexOf(string3, n4);
            string6 = string6.substring(0, n4) + string6.substring(n3 + string3.length());
            String string12 = "<B>";
            string2 = "</B>";
            int n12 = string6.toUpperCase().indexOf(string12);
            if (n12 != -1) {
                int n13 = string6.toUpperCase().indexOf(string2, n12);
                string6 = string6.substring(0, n12) + string6.substring(n13 + string2.length());
            }
            string = "<P><DT>";
            n2 = string6.toUpperCase().indexOf(string);
            int n14 = -1;
            while (n14 < n2) {
                string6 = string6.substring(0, n2) + string6.substring(n2 + 3);
                n2 = string6.toUpperCase().indexOf(string);
            }
            String string13 = "<A HREF";
            String string14 = "</A>";
            int n15 = string6.toUpperCase().indexOf(string13);
            int n16 = -1;
            while (n16 < n15) {
                int n17 = string6.toUpperCase().indexOf(string14);
                string11 = string6.substring(n15, n17);
                string11 = string11.substring(string11.indexOf(">") + 1);
                string6 = string6.substring(0, n15) + string11 + string6.substring(n17 + string14.length());
                n15 = string6.toUpperCase().indexOf(string13);
            }
            String string15 = "<IMG";
            string11 = ">";
            int n18 = string6.toUpperCase().indexOf(string15);
            int n19 = -1;
            while (n19 < n18) {
                int n20 = string6.indexOf(string11, n18);
                string6 = string6.substring(0, n18) + string6.substring(n20 + string11.length());
                n18 = string6.toUpperCase().indexOf(string15);
            }
            String string16 = "<BR><BR>";
            int n21 = string6.toUpperCase().indexOf(string16);
            int n22 = -1;
            while (n22 < n21) {
                string6 = string6.substring(0, n21) + string6.substring(n21 + string16.length());
                n21 = string6.toUpperCase().indexOf(string16);
            }
            String string17 = "<B></B>";
            int n23 = string6.toUpperCase().indexOf(string17);
            int n24 = -1;
            while (n24 < n23) {
                string6 = string6.substring(0, n23) + string6.substring(n23 + string17.length());
                n23 = string6.toUpperCase().indexOf(string17);
            }
        }
        n3 = string6.toUpperCase().indexOf(capsDebug);
        int n25 = -1;
        while (n25 < n3) {
            int n26 = string6.toUpperCase().indexOf(capsEndDebug);
            String string18 = string6.substring(n3 + capsDebug.length(), n26);
            string6 = enhancedDebug ? string6.substring(0, n3) + "<P><B>" + string18 + "</B></P>" + string6.substring(n26 + capsEndDebug.length()) : string6.substring(0, n3) + string6.substring(n26 + capsEndDebug.length());
            n3 = string6.toUpperCase().indexOf(capsDebug);
        }
        string2 = "<BR>";
        if (string6.toUpperCase().startsWith("\n" + string2)) {
            string6 = string6.substring(string6.toUpperCase().indexOf(string2) + string2.length());
        }
        if (string6.toUpperCase().endsWith(string2)) {
            string6 = string6.substring(0, string6.toUpperCase().lastIndexOf(string2));
        }
        String string19 = "(";
        string = "&#40;";
        n2 = string6.indexOf(string19);
        this.haveParsedString = true;
        return string6;
    }

    private synchronized String getCleanString(String string) {
        string = string.trim();
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = string.length();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        int n3 = 0;
        while (n3 < n2) {
            char c2 = string.charAt(n3);
            if (bl) {
                if (!Character.isWhitespace(c2)) {
                    if (!bl3) {
                        stringBuffer.append(c2);
                    }
                    if (!bl2) {
                        bl = false;
                    }
                }
            } else if (Character.isWhitespace(c2)) {
                stringBuffer.append(' ');
                bl = true;
            } else if (c2 == '<' && n2 > n3 + 3 && string.substring(n3, n3 + 3).equalsIgnoreCase("<P>")) {
                stringBuffer.append("<p>");
                n3 += 2;
                bl = true;
            } else if (c2 == '<' && n2 > n3 + begCMT.length() && string.substring(n3, n3 + begCMT.length()).equalsIgnoreCase(begCMT)) {
                n3 += begCMT.length();
                bl3 = true;
            } else if (c2 == '<') {
                bl2 = true;
                stringBuffer.append('<');
            } else if (n2 > n3 + endCMT.length() && string.substring(n3, n3 + endCMT.length()).equalsIgnoreCase(endCMT)) {
                bl2 = false;
            } else if (bl2 && c2 == '>') {
                bl2 = false;
                stringBuffer.append('>');
            } else if (!bl3) {
                stringBuffer.append(c2);
            }
            ++n3;
        }
        this.theIPCache.put(this.popupModel.getName(), stringBuffer.toString());
        return stringBuffer.toString();
    }

    public synchronized String readSection() throws UAMException {
        if (this.sourceofCache.equals(this.popupModel.getDir()) && this.cacheContains()) {
            String string = this.getPopupFromCache();
            return string;
        }
        if (this.sourceofCache.equals(this.popupModel.getDir()) && this.cachedRawStringContains()) {
            String string = this.getCleanString(this.parseRawString());
            return string;
        }
        if (this.haveParsedString && this.sourceofCache.equals(this.popupModel.getDir())) {
            return this.errMsg + this.popupModel.getName() + " in " + this.popupModel.getDir();
        }
        if (!this.sourceofCache.equals(this.popupModel.getDir())) {
            this.buildReaderForHTML(this.popupModel.getDir());
        }
        if (!this.unicodeSupported && this.unicodeBytes != null) {
            String string = this.stringFromUnicode(this.unicodeBytes);
            this.cacheTheString(string);
            return this.readSection();
        }
        int n2 = -1;
        String string = null;
        if (this.isrUc == null) {
            return this.errMsg + this.popupModel.getName();
        }
        this.alreadyUnicode = this.readCharsFromStream(this.lengthOfUC, this.alreadyUnicode, this.isrUc);
        if (this.alreadyUnicode == null) {
            return this.errMsg + this.popupModel.getName();
        }
        string = new String(this.alreadyUnicode);
        n2 = this.checkStringForEnd(string);
        if (n2 > 0) {
            string = string.substring(0, n2);
        }
        if (string != null) {
            this.cacheTheString(string);
        }
        return this.readSection();
    }

    private byte[] readBytesFromStream(int n2, byte[] byArray, InputStream inputStream) throws UAMException {
        int n3 = 0;
        int n4 = 0;
        try {
            while (n3 != -1 && n2 != 0) {
                n3 = inputStream.read(byArray, n3, byArray.length - n4);
                n4 += n3;
            }
            inputStream.close();
        }
        catch (IOException iOException) {
            this.tryAgain = false;
        }
        if (++n4 != n2) {
            throw new UAMException(NAME, "UA Error: UAHtmlFilter failed to read entire IP content file.");
        }
        return byArray;
    }

    private char[] readCharsFromStream(int n2, char[] cArray, InputStreamReader inputStreamReader) throws UAMException {
        int n3 = 0;
        int n4 = 0;
        try {
            while (n3 != -1) {
                n3 = inputStreamReader.read(cArray, n3, cArray.length - n4);
                n4 += n3;
            }
            inputStreamReader.close();
        }
        catch (IOException iOException) {
            this.tryAgain = false;
        }
        if ((++n4 + 1) * 2 < n2) {
            throw new UAMException(NAME, "UA Error: UAHtmlFilter failed to read entire IP content file.");
        }
        return cArray;
    }

    private String stringFromUnicode(byte[] byArray) {
        boolean bl;
        int n2;
        char c2 = (char)(byArray[0] << 8 & 0xFF00 | byArray[1] & 0xFF);
        if (c2 == '\ufeff') {
            n2 = 2;
            bl = true;
        } else if (c2 == '\ufffe') {
            n2 = 2;
            bl = false;
        } else {
            n2 = 0;
            bl = true;
        }
        char[] cArray = new char[(byArray.length - n2) / 2];
        int n3 = 0;
        int n4 = n2;
        while (n3 < cArray.length) {
            cArray[n3] = bl ? (char)(byArray[n4] << 8 & 0xFF00 | byArray[n4 + 1] & 0xFF) : (char)(byArray[n4 + 1] << 8 & 0xFF00 | byArray[n4] & 0xFF);
            ++n3;
            n4 += 2;
        }
        return new String(cArray);
    }
}

