/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.uamanager;

import com.ibm.db2.tools.common.CommonFrame;
import com.ibm.db2.tools.common.CommonPanel;
import com.ibm.db2.tools.common.CommonTrace;
import com.ibm.db2.tools.common.support.AssistManager;
import com.ibm.db2.tools.common.support.CUtil2;
import com.ibm.db2.tools.common.uamanager.HelpFileNames;
import java.applet.Applet;
import java.applet.AppletContext;
import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import javax.swing.JApplet;

public class HelpManager
implements HelpFileNames {
    private static String DOC_DIRECTORY = "../doc";
    private static final String HTML_DIRECTORY = "prodcd/" + HelpManager.defaultLocaleString();
    private static final String HELP_DIRECTORY_WITH_SLASH = "/db2help/";
    private static final String HELP_DIRECTORY_RELATIVE = "../doc/prodcd/" + HelpManager.defaultLocaleString() + "/db2help/";
    private static final String HTML_EXTENSION = ".htm";
    private static final String HTTP_PROTOCOL_PREFIX = "http:";
    public static final String HELPMENU = "HelpMenu";
    static Applet applet = null;
    static URL base = null;
    public static final String ECLIPSE_PREFIX = "eclipse:";
    protected static final String ECLIPSEHOST = "EclipseHost";
    protected static final String ECLIPSEPORT = "EclipsePort";
    private static String EclipseHost = CUtil2.getDB2HelpSystemHostName();
    private static String EclipsePort = CUtil2.getDB2HelpSystemPortNumber();

    public static void setDocDirectory(String string) {
        DOC_DIRECTORY = string;
    }

    public static String getDocDirectory() {
        return DOC_DIRECTORY;
    }

    public static void setApplet(Applet applet) {
        HelpManager.applet = applet;
        if (HelpManager.applet != null) {
            base = HelpManager.applet.getCodeBase();
        }
    }

    public static Applet getApplet() {
        return applet;
    }

    public static Component showHelp(Component component) {
        String string = null;
        String string2 = null;
        Component component2 = null;
        if (component != null) {
            Component component3 = component;
            while (component3 != null) {
                if (component3 instanceof CommonPanel) {
                    if (string == null || string.length() == 0) {
                        string = ((CommonPanel)component3).getHelpName();
                    }
                    if (string2 == null || string2.length() == 0) {
                        string2 = ((CommonPanel)component3).getHelpIndex();
                    }
                } else if (component3 instanceof CommonFrame) {
                    if (string == null || string.length() == 0) {
                        string = ((CommonFrame)component3).getHelpName();
                    }
                    if (string2 == null || string2.length() == 0) {
                        string2 = ((CommonFrame)component3).getHelpIndex();
                    }
                }
                if (string != null && string.length() != 0) {
                    component2 = component3;
                    component3 = null;
                    continue;
                }
                component3 = component3.getParent();
            }
        }
        if (component2 != null) {
            HelpManager.showHelp(string, string2);
        } else {
            HelpManager.showHelp(null, null);
        }
        return component2;
    }

    public static void showHelp(String string, String string2) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.uamanager", "HelpManager", "showHelp(String helpName, String helpIndex)", new Object[]{string, string2});
        }
        if (string == null) {
            CommonTrace.exit(commonTrace);
            return;
        }
        if (string.equals("")) {
            CommonTrace.exit(commonTrace);
            return;
        }
        if (string.equals("no_help")) {
            CommonTrace.exit(commonTrace);
            return;
        }
        CommonTrace.write(commonTrace, "URL of help file = " + (base != null ? base.toString() : "") + string + HTML_EXTENSION + (string2 != null && string2.length() > 0 ? "#" + string2 : ""));
        if (applet == null) {
            if (string.indexOf(":") == -1) {
                HelpManager.openBrowser(HELP_DIRECTORY_WITH_SLASH + string);
            } else {
                HelpManager.openBrowser(string);
            }
            CommonTrace.exit(commonTrace);
            return;
        }
        AppletContext appletContext = applet.getAppletContext();
        URL uRL = null;
        uRL = HelpManager.getHelpURL(string, string2);
        appletContext.showDocument(uRL, "db2info");
        CommonTrace.exit(commonTrace);
    }

    public static void showHelp(String string, String string2, String string3) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.uamanager", "HelpManager", "showHelp(String helpName, String helpIndex, String helpSubDir)", new Object[]{string, string2, string3});
        }
        if (string == null) {
            CommonTrace.exit(commonTrace);
            return;
        }
        if (string.equals("")) {
            CommonTrace.exit(commonTrace);
            return;
        }
        if (string.equals("no_help")) {
            CommonTrace.exit(commonTrace);
            return;
        }
        CommonTrace.write(commonTrace, "URL of help file = " + (base != null ? base.toString() : "") + string + HTML_EXTENSION + (string2 != null && string2.length() > 0 ? "#" + string2 : ""));
        if (applet == null) {
            CommonTrace.write(commonTrace, "Help requested inside an application. Attempting to launch browser...");
            HelpManager.openBrowser(string3 + string);
            CommonTrace.exit(commonTrace);
            return;
        }
        AppletContext appletContext = applet.getAppletContext();
        URL uRL = null;
        uRL = HelpManager.getHelpURL(string, string2, string3);
        CommonTrace.write(commonTrace, "getHelpURL() returned: " + uRL.toString());
        appletContext.showDocument(uRL, "db2info");
        CommonTrace.exit(commonTrace);
    }

    public static URL getHelpURL(String string, String string2) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.uamanager", "HelpManager", "getHelpURL(String helpName, String helpIndex)", new Object[]{string, string2});
        }
        String string3 = HELP_DIRECTORY_RELATIVE + string + HTML_EXTENSION + (string2 != null && string2.length() > 0 ? "#" + string2 : "");
        URL uRL = null;
        try {
            uRL = new URL(base, string3);
        }
        catch (MalformedURLException malformedURLException) {
            CommonTrace.catchBlock(commonTrace);
            CommonTrace.write(commonTrace, "Can't construct help URL from: " + base + "," + string3);
        }
        return (URL)CommonTrace.exit(commonTrace, uRL);
    }

    public static URL getHelpURL(String string, String string2, String string3) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.uamanager", "HelpManager", "getHelpURL(String helpName, String helpIndex, String helpSubDir)", new Object[]{string, string2, string3});
        }
        String string4 = System.getProperty("file.separator");
        String string5 = DOC_DIRECTORY + string4 + HTML_DIRECTORY + string3 + string + HTML_EXTENSION + (string2 != null && string2.length() > 0 ? "#" + string2 : "");
        URL uRL = null;
        try {
            uRL = new URL(base, string5);
        }
        catch (MalformedURLException malformedURLException) {
            CommonTrace.catchBlock(commonTrace);
            CommonTrace.write(commonTrace, "Can't construct help URL from: " + base + "," + string5);
        }
        return (URL)CommonTrace.exit(commonTrace, uRL);
    }

    public static Process executeCommand(String string) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.uamanager", "HelpManager", "executeCommand(String cmd)", new Object[]{string});
        }
        Process process = null;
        Runtime runtime = Runtime.getRuntime();
        try {
            process = runtime.exec(string);
        }
        catch (IOException iOException) {
            CommonTrace.catchBlock(commonTrace);
            CommonTrace.write(commonTrace, "Cannot execute command: " + string);
        }
        return (Process)CommonTrace.exit(commonTrace, process);
    }

    public static boolean fileExists(String string) {
        return HelpManager.getFullPathName(string) != null;
    }

    public static boolean isUnix() {
        boolean bl = false;
        String string = System.getProperty("os.name").toUpperCase(Locale.US);
        if (string.equals("AIX") || string.equals("UNIX") || string.equals("SOLARIS") || string.equals("HP-UX") || string.equals("SUNOS") || string.equals("LINUX") || string.equals("IRIX")) {
            bl = true;
        }
        return bl;
    }

    public static boolean isAix() {
        boolean bl = false;
        String string = System.getProperty("os.name").toUpperCase(Locale.US);
        if (string.equals("AIX")) {
            bl = true;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getFullPathName(String string) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.uamanager", "HelpManager", "getFullPathName(String fileName)", new Object[]{string});
        }
        String string2 = System.getProperty("file.separator");
        Object object = null;
        if ((string = string.trim()).startsWith("/") || string.startsWith("\\")) {
            string = string.substring(1);
        }
        String string3 = null;
        String string4 = null;
        if (string.indexOf(":") == -1) {
            string3 = DOC_DIRECTORY + string2;
            string3 = string3 + HTML_DIRECTORY + string2 + string;
            if (string4 != null) {
                string4 = string4 + HTML_DIRECTORY + string2 + string;
            }
        } else {
            string3 = string;
        }
        if (!(string.toLowerCase().endsWith(HTML_EXTENSION) || string.toLowerCase().endsWith(".html") || string.endsWith("/"))) {
            if (string4 != null) {
                string4 = string4 + HTML_EXTENSION;
            }
            string3 = string3 + HTML_EXTENSION;
        }
        if (!string.toLowerCase().startsWith(HTTP_PROTOCOL_PREFIX)) {
            Object object2;
            File file = null;
            try {
                object2 = new URL(string3);
                file = new File(((URL)object2).getFile());
                if (!file.exists()) {
                    file = new File(string3);
                }
            }
            catch (MalformedURLException malformedURLException) {
                CommonTrace.catchBlock(commonTrace);
                file = new File(string3);
            }
            object2 = null;
            try {
                object2 = file.getCanonicalPath();
            }
            catch (IOException iOException) {
                CommonTrace.catchBlock(commonTrace);
                object2 = file.getAbsolutePath();
            }
            object2 = ((String)object2).replace('\\', string2.charAt(0));
            object = object2 = ((String)object2).replace('/', string2.charAt(0));
            if (file.exists()) return (String)CommonTrace.exit(commonTrace, object);
            if (string4 == null) return (String)CommonTrace.exit(commonTrace, null);
            File file2 = new File(string4);
            try {
                object2 = file2.getCanonicalPath();
            }
            catch (IOException iOException) {
                CommonTrace.catchBlock(commonTrace);
                object2 = file2.getAbsolutePath();
            }
            object2 = ((String)object2).replace('\\', string2.charAt(0));
            object = object2 = ((String)object2).replace('/', string2.charAt(0));
            if (file2.exists()) return (String)CommonTrace.exit(commonTrace, object);
            return (String)CommonTrace.exit(commonTrace, null);
        }
        object = string;
        return (String)CommonTrace.exit(commonTrace, object);
    }

    public static void setEclipseHost(String string) {
        EclipseHost = string;
    }

    public static String getEclipseHost() {
        return EclipseHost;
    }

    public static void setEclipsePort(String string) {
        EclipsePort = string;
    }

    public static String getEclipsePort() {
        return EclipsePort;
    }

    public static void launchEclipse(String string) {
        String string2;
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.uamanager", "HelpManager", "launchEclipse(String eclipsePath)", new Object[]{string});
        }
        string2 = (string2 = string.substring(ECLIPSE_PREFIX.length()).replace('\\', '/')).startsWith("//") ? string2.substring(1) : string2;
        String string3 = EclipseHost;
        String string4 = EclipsePort;
        String string5 = null;
        int n2 = EclipseHost.indexOf(47);
        if (n2 > -1) {
            string3 = EclipseHost.substring(0, n2);
            string5 = EclipseHost.substring(n2);
        }
        if (string5 == null && string4 != null && !string4.trim().equals("")) {
            string5 = "/help";
        }
        StringBuffer stringBuffer = new StringBuffer("http://");
        stringBuffer = string4 != null && string4.trim().length() > 0 ? stringBuffer.append(string3).append(":").append(string4) : stringBuffer.append(string3);
        stringBuffer = string5 != null ? stringBuffer.append(string5).append(string2) : stringBuffer.append(string2);
        String string6 = stringBuffer.toString();
        CommonTrace.write(commonTrace, "InfoCenter: opening " + string6);
        HelpManager.openBrowser(string6);
        CommonTrace.exit(commonTrace);
    }

    public static void openBrowser(String string) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.uamanager", "HelpManager", "openBrowser(String fileName)", new Object[]{string});
        }
        if (string != null ? string.substring(0, ECLIPSE_PREFIX.length()).equalsIgnoreCase(ECLIPSE_PREFIX) : false) {
            HelpManager.launchEclipse(string);
            CommonTrace.exit(commonTrace);
            return;
        }
        String string2 = HelpManager.getFullPathName(string);
        if (string2 == null) {
            CommonTrace.exit(commonTrace);
            return;
        }
        String string3 = System.getProperty("os.name").toUpperCase();
        CommonTrace.write(commonTrace, "fullPath[" + string2 + "]");
        if (HelpManager.isUnix()) {
            Object object;
            Object object2;
            String string4 = null;
            try {
                object2 = new URL(string2);
                string4 = ((URL)object2).toExternalForm();
            }
            catch (MalformedURLException malformedURLException) {
                object = new File(string2);
                try {
                    string4 = ((File)object).toURL().toExternalForm();
                }
                catch (MalformedURLException malformedURLException2) {
                    string4 = null;
                }
            }
            if (string4 == null) {
                string4 = string2;
            }
            if ((object2 = HelpManager.executeCommand("mozilla -remote 'openURL(" + string4 + ")'")) != null) {
                object = "mozilla " + string4;
                try {
                    int n2 = ((Process)object2).waitFor();
                    if (n2 != 0) {
                        object2 = HelpManager.executeCommand((String)object);
                    } else {
                        boolean bl = ((Process)object2).getErrorStream().read() != -1;
                        BufferedInputStream bufferedInputStream = new BufferedInputStream(((Process)object2).getErrorStream());
                        if (n2 != 0 || bufferedInputStream.available() != -1) {
                            object2 = HelpManager.executeCommand((String)object);
                        }
                    }
                }
                catch (IOException iOException) {
                    CommonTrace.catchBlock(commonTrace);
                    CommonTrace.write(commonTrace, "Error running command: " + (String)object);
                }
                catch (InterruptedException interruptedException) {
                    CommonTrace.catchBlock(commonTrace);
                    CommonTrace.write(commonTrace, "Error running command: " + (String)object);
                    CommonTrace.write(commonTrace, "Exception = " + interruptedException);
                }
            }
        } else if (string3.equals("WINDOWS 95") || string3.equals("WINDOWS ME") || string3.equals("WINDOWS 98")) {
            HelpManager.executeCommand("command.com /c start \"" + string2 + "\"");
        } else if (string3.equals("WINDOWS NT") || string3.equals("WINDOWS XP") || string3.equals("WINDOWS 2000") || string3.startsWith("WINDOWS")) {
            HelpManager.executeCommand("cmd.exe /c start  \"\" \"" + string2 + "\"");
        } else if (string3.equals("OS/2")) {
            HelpManager.executeCommand("netscape " + string2);
        } else {
            CommonTrace.write(commonTrace, "Browser launching is not implemented for operating system: " + string3);
        }
        CommonTrace.exit(commonTrace);
    }

    public static void openURLorFile(String string, JApplet jApplet) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.uamanager", "HelpManager", "openURLorFile(String it, JApplet applet)", new Object[]{string, jApplet});
        }
        if (string != null) {
            try {
                URL uRL = new URL(string);
                if (jApplet != null) {
                    jApplet.getAppletContext().showDocument(uRL, "db2info");
                } else {
                    HelpManager.openBrowser(string);
                }
            }
            catch (MalformedURLException malformedURLException) {
                CommonTrace.catchBlock(commonTrace);
                try {
                    if (jApplet != null) {
                        URL uRL = jApplet.getCodeBase();
                        URL uRL2 = new URL(uRL, string);
                        jApplet.getAppletContext().showDocument(uRL2, "db2info");
                    } else {
                        HelpManager.openBrowser(string);
                    }
                }
                catch (MalformedURLException malformedURLException2) {
                    CommonTrace.catchBlock(commonTrace);
                    CommonTrace.write(commonTrace, "MalformedURLException for URL: " + string);
                }
                catch (Throwable throwable) {
                    CommonTrace.catchBlock(commonTrace);
                    CommonTrace.write(commonTrace, "Unexpected error viewing: " + string);
                    CommonTrace.write(commonTrace, throwable.getMessage());
                }
            }
            CommonTrace.exit(commonTrace);
            return;
        }
        CommonTrace.exit(commonTrace);
    }

    public static String defaultLocaleString() {
        String string = AssistManager.getPreferredLanguage().toString();
        if (AssistManager.getSupportsServerLangsOnly() && !AssistManager.isServerLanguage() || !AssistManager.isSkipsCurrentLangInstalledCheck() && !AssistManager.isCurrentLangInstalledLocally()) {
            string = "en_US";
        }
        return string;
    }
}

