/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.trace;

import com.ibm.db2.tools.common.trace.MethodInfo;

public class TraceInfo {
    private MethodInfo methodInfo;
    private String writeStatement = "";
    private static String indent = "";
    private String returnValue = "";
    private static boolean indentVisible = true;
    private static boolean timeStampVisible = true;
    public static final int ENTRY = 0;
    public static final int RETURN = 1;
    public static final int WRITE = 2;
    public static final int THROW = 3;
    public static final int CATCH = 4;
    private int type = 0;
    private String timeStamp = "";

    public TraceInfo() {
    }

    public TraceInfo(MethodInfo methodInfo, int n2, String string) {
        this.methodInfo = methodInfo;
        this.type = n2;
        this.timeStamp = string;
    }

    public void setType(int n2) {
        this.type = n2;
    }

    public int getType() {
        return this.type;
    }

    private String getTypeAsString() {
        String string = "";
        switch (this.type) {
            case 0: {
                string = "- entry";
                break;
            }
            case 1: {
                string = "- return(" + (MethodInfo.noValues ? "" : this.returnValue) + ")";
                break;
            }
            case 2: {
                string = "- " + this.writeStatement;
                break;
            }
            case 3: {
                string = "- throw(" + (MethodInfo.noValues ? "" : this.returnValue) + ")";
                break;
            }
            case 4: {
                string = "- catch";
            }
        }
        return string;
    }

    public void setTimeStamp(String string) {
        this.timeStamp = string;
    }

    public void setMethodInfo(MethodInfo methodInfo) {
        this.methodInfo = methodInfo;
    }

    public MethodInfo getMethodInfo() {
        return this.methodInfo;
    }

    public void setWriteStatement(String string) {
        this.writeStatement = string;
    }

    public void setReturnValue(String string) {
        this.returnValue = string;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (timeStampVisible) {
            stringBuffer.append(this.getTimeStamp());
            stringBuffer.append(" ");
        }
        stringBuffer.append(this.getIndent());
        stringBuffer.append(this.methodInfo);
        stringBuffer.append(" ");
        stringBuffer.append(this.getTypeAsString());
        return stringBuffer.toString();
    }

    public static void setIndentVisible(boolean bl) {
        indentVisible = bl;
    }

    public static void setTimeStampVisible(boolean bl) {
        timeStampVisible = bl;
    }

    private String getIndent() {
        String string = "";
        if (indentVisible) {
            string = indent;
        }
        return string;
    }

    private String getTimeStamp() {
        String string = "";
        if (timeStampVisible) {
            string = this.timeStamp;
        }
        return string;
    }

    public static void resetIndent() {
        indent = "";
    }

    public static void increaseIndent() {
        indent = indent + "|";
    }

    public static void decreaseIndent() {
        if (indent.length() > 0) {
            indent = indent.substring(0, indent.length() - 1);
        }
    }
}

