/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.trace;

import com.ibm.db2.tools.common.trace.MethodCount;
import com.ibm.db2.tools.common.trace.MethodCountCompare;
import com.ibm.db2.tools.common.trace.MethodInfo;
import com.ibm.db2.tools.common.trace.MethodInfoCompare;
import com.ibm.db2.tools.common.trace.SortableVector;
import com.ibm.db2.tools.common.trace.TraceInfo;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;

public class TraceFormatter {
    private static String filterFile = null;
    private static boolean rank = false;
    private static SortableVector nonWildCardList;
    private static Vector wildCardList;
    private static final String SEPARATOR = "^";
    private static final String DOUBLESEPARATOR = "^^";
    private static final String TRIPLESEPARATOR = "^^^";

    static void updateCount(Vector vector, MethodInfo methodInfo) {
        boolean bl = false;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            MethodCount methodCount = (MethodCount)enumeration.nextElement();
            if (!methodCount.getMethodInfo().equals(methodInfo)) continue;
            methodCount.incrementCount();
            bl = true;
            break;
        }
        if (!bl) {
            vector.addElement(new MethodCount(methodInfo));
        }
    }

    static int countCharsInString(String string, String string2) {
        int n2 = 0;
        int n3 = 0;
        while ((n3 = string.indexOf(string2, n3) + 1) != 0) {
            ++n2;
        }
        return n2;
    }

    static void readTrace(BufferedReader bufferedReader, Hashtable hashtable, SortableVector sortableVector) throws IOException, Exception {
        int n2 = 0;
        String string = "";
        try {
            string = bufferedReader.readLine();
            ++n2;
            Vector<TraceInfo> vector = null;
            while (string != null) {
                if (!string.startsWith("-") && string.length() != 0) {
                    if (string.indexOf(SEPARATOR) == -1) {
                        System.out.println("Skipping line " + n2 + ": " + string);
                    } else {
                        Object object;
                        int n3 = TraceFormatter.countCharsInString(string, SEPARATOR);
                        int n4 = string.indexOf(DOUBLESEPARATOR);
                        while (n4 == -1) {
                            string = string + bufferedReader.readLine();
                            ++n2;
                            n4 = string.indexOf(DOUBLESEPARATOR);
                        }
                        int n5 = string.indexOf(TRIPLESEPARATOR);
                        if (n4 >= 0) {
                            if (n5 == -1) {
                                object = string.substring(n4 + 2);
                                int n6 = TraceFormatter.countCharsInString((String)object, SEPARATOR);
                                while (n6 < 2) {
                                    object = (String)object + bufferedReader.readLine();
                                    ++n2;
                                    n6 = TraceFormatter.countCharsInString((String)object, SEPARATOR);
                                }
                                string = string.substring(0, n4) + DOUBLESEPARATOR + (String)object;
                                n3 = TraceFormatter.countCharsInString(string, SEPARATOR);
                            } else {
                                object = string.substring(n5 + 3);
                                int n7 = TraceFormatter.countCharsInString((String)object, SEPARATOR);
                                while (n7 < 2) {
                                    object = (String)object + bufferedReader.readLine();
                                    ++n2;
                                    n7 = TraceFormatter.countCharsInString((String)object, SEPARATOR);
                                }
                                string = string.substring(0, n5) + TRIPLESEPARATOR + (String)object;
                                n3 = TraceFormatter.countCharsInString(string, SEPARATOR);
                            }
                        }
                        object = new StringTokenizer(string, SEPARATOR);
                        String string2 = ((StringTokenizer)object).nextToken();
                        String string3 = ((StringTokenizer)object).nextToken().trim();
                        String string4 = "";
                        String string5 = SEPARATOR;
                        if (!rank) {
                            string5 = "(";
                        }
                        if (n5 == -1) {
                            while (string3 != null && !string3.equals("")) {
                                string4 = string4 + string3 + string5;
                                string3 = ((StringTokenizer)object).nextToken().trim();
                                string5 = rank ? "^ " : ", ";
                            }
                            string5 = rank ? DOUBLESEPARATOR : ")";
                            string4 = string4.substring(0, string4.length() - 1) + string5;
                        } else {
                            string4 = string3;
                            ((StringTokenizer)object).nextToken();
                        }
                        String string6 = ((StringTokenizer)object).nextToken().trim();
                        String string7 = ((StringTokenizer)object).nextToken().trim();
                        try {
                            MethodInfo methodInfo = new MethodInfo(string4);
                            TraceInfo traceInfo = new TraceInfo();
                            traceInfo.setMethodInfo(methodInfo);
                            traceInfo.setTimeStamp(string2);
                            if (string6.startsWith("entry")) {
                                traceInfo.setType(0);
                                if (rank) {
                                    TraceFormatter.updateCount(sortableVector, methodInfo);
                                }
                            } else if (string6.startsWith("return")) {
                                traceInfo.setType(1);
                                string6 = string6.substring(string6.indexOf("return(") + 7, string6.lastIndexOf(")")).trim();
                                traceInfo.setReturnValue(string6);
                            } else if (string6.startsWith("throw")) {
                                traceInfo.setType(3);
                                string6 = string6.substring(string6.indexOf("throw(") + 6, string6.lastIndexOf(")")).trim();
                                traceInfo.setReturnValue(string6);
                            } else if (string6.startsWith("catch")) {
                                traceInfo.setType(4);
                            } else {
                                traceInfo.setType(2);
                                traceInfo.setWriteStatement(string6.trim());
                            }
                            if (!rank) {
                                vector = (Vector<TraceInfo>)hashtable.get(string7);
                                if (filterFile == null || TraceFormatter.isMethodIncluded(traceInfo.getMethodInfo())) {
                                    if (vector == null) {
                                        vector = new Vector<TraceInfo>();
                                        vector.addElement(traceInfo);
                                        hashtable.put(string7, vector);
                                    } else {
                                        vector.addElement(traceInfo);
                                    }
                                }
                            }
                        }
                        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                            // empty catch block
                        }
                    }
                }
                string = bufferedReader.readLine();
                ++n2;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Exception while processing line " + n2 + ": " + string);
            throw exception;
        }
    }

    static void writeTrace(PrintWriter printWriter, Hashtable hashtable) {
        int n2 = 0;
        TraceInfo traceInfo = null;
        Stack<MethodInfo> stack = new Stack<MethodInfo>();
        printWriter.println("---- Beginning of trace ----");
        ++n2;
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            printWriter.println(string);
            ++n2;
            printWriter.println();
            TraceInfo.resetIndent();
            Vector vector = (Vector)hashtable.get(string);
            hashtable.remove(string);
            Enumeration enumeration2 = vector.elements();
            vector = null;
            while (enumeration2.hasMoreElements()) {
                traceInfo = (TraceInfo)enumeration2.nextElement();
                if (traceInfo.getType() == 0) {
                    stack.push(traceInfo.getMethodInfo());
                    TraceInfo.increaseIndent();
                } else if (traceInfo.getType() == 4) {
                    while (!stack.isEmpty()) {
                        if (((MethodInfo)stack.peek()).equals(traceInfo.getMethodInfo())) break;
                        stack.pop();
                        TraceInfo.decreaseIndent();
                    }
                }
                printWriter.println(traceInfo);
                ++n2;
                if (traceInfo.getType() != 1 && traceInfo.getType() != 3 || stack.isEmpty()) continue;
                stack.pop();
                TraceInfo.decreaseIndent();
            }
            printWriter.println();
            ++n2;
        }
        printWriter.flush();
        printWriter.close();
    }

    private static void readFilter(BufferedReader bufferedReader) throws IOException {
        nonWildCardList = new SortableVector(new MethodInfoCompare());
        wildCardList = new Vector();
        String string = bufferedReader.readLine();
        while (string != null) {
            MethodInfo methodInfo = new MethodInfo(string);
            if (methodInfo.containsWildCard()) {
                wildCardList.addElement(methodInfo);
            } else {
                nonWildCardList.addElement(methodInfo);
            }
            string = bufferedReader.readLine();
        }
        nonWildCardList.sort();
    }

    private static boolean isMethodIncluded(MethodInfo methodInfo) {
        boolean bl = false;
        int n2 = 0;
        while (n2 < wildCardList.size()) {
            if (methodInfo.equals((MethodInfo)wildCardList.elementAt(n2))) {
                bl = true;
                break;
            }
            ++n2;
        }
        if (!bl) {
            bl = nonWildCardList.binarySearch(methodInfo) != -1;
        }
        return bl;
    }

    public static void main(String[] stringArray) {
        BufferedReader bufferedReader = null;
        int n2 = 0;
        if (stringArray.length > 0) {
            while (stringArray[n2].startsWith("-")) {
                if (stringArray[n2].equalsIgnoreCase("-NOPACKAGES") && !MethodInfo.noPackages) {
                    if (!rank) {
                        MethodInfo.noPackages = true;
                    }
                } else if (stringArray[n2].equalsIgnoreCase("-NOCLASSES") && !MethodInfo.noClasses) {
                    if (!rank) {
                        MethodInfo.noClasses = true;
                    }
                } else if (stringArray[n2].equalsIgnoreCase("-NOPARAMETERS") && !MethodInfo.noParameters) {
                    if (!rank) {
                        MethodInfo.noParameters = true;
                    }
                } else if (stringArray[n2].equalsIgnoreCase("-NOVALUES") && !MethodInfo.noValues) {
                    if (!rank) {
                        MethodInfo.noValues = true;
                    }
                } else if (stringArray[n2].equalsIgnoreCase("-NOTIMESTAMP")) {
                    TraceInfo.setTimeStampVisible(false);
                } else if (stringArray[n2].equalsIgnoreCase("-RANK") && !rank) {
                    MethodInfo.setRanking(true);
                    rank = true;
                    MethodInfo.noPackages = false;
                    MethodInfo.noClasses = false;
                    MethodInfo.noParameters = false;
                    MethodInfo.noValues = true;
                    MethodInfo.noNames = true;
                } else {
                    if (stringArray[n2].equalsIgnoreCase("-FILTER")) break;
                    TraceFormatter.printUsageMessage();
                    return;
                }
                if (++n2 < stringArray.length) continue;
                TraceFormatter.printUsageMessage();
                return;
            }
            if (stringArray[n2].equalsIgnoreCase("-FILTER")) {
                filterFile = stringArray[n2 + 1];
                n2 += 2;
            }
            if (stringArray.length == n2 + 2) {
                PrintWriter printWriter;
                BufferedReader bufferedReader2;
                if (filterFile != null) {
                    try {
                        bufferedReader = new BufferedReader(new FileReader(filterFile));
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        System.out.println("Filter file " + filterFile + " could not be opened.");
                        return;
                    }
                }
                try {
                    bufferedReader2 = new BufferedReader(new FileReader(stringArray[n2]));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    System.out.println("Input file " + stringArray[n2] + " could not be opened.");
                    return;
                }
                try {
                    printWriter = new PrintWriter(new BufferedWriter(new FileWriter(stringArray[n2 + 1])));
                }
                catch (IOException iOException) {
                    System.out.println("Output file " + stringArray[n2 + 1] + " could not be opened.");
                    return;
                }
                Hashtable hashtable = new Hashtable();
                SortableVector sortableVector = new SortableVector(new MethodCountCompare());
                if (bufferedReader != null) {
                    try {
                        TraceFormatter.readFilter(bufferedReader);
                    }
                    catch (IOException iOException) {
                        System.out.println("Error reading " + stringArray[n2] + ".");
                    }
                }
                try {
                    TraceFormatter.readTrace(bufferedReader2, hashtable, sortableVector);
                }
                catch (IOException iOException) {
                    System.out.println("Error reading " + stringArray[n2] + ".");
                }
                catch (Exception exception) {
                    System.out.println(exception.getMessage());
                }
                if (rank) {
                    sortableVector.sort();
                    Enumeration enumeration = sortableVector.elements();
                    while (enumeration.hasMoreElements()) {
                        printWriter.println(enumeration.nextElement());
                    }
                    printWriter.flush();
                    printWriter.close();
                } else {
                    TraceFormatter.writeTrace(printWriter, hashtable);
                }
            } else {
                TraceFormatter.printUsageMessage();
            }
        } else {
            TraceFormatter.printUsageMessage();
        }
    }

    private static void printUsageMessage() {
        System.out.println("Usage: TraceFormatter [options] [-filter <filter file>] <input file> <output file>");
        System.out.println();
        System.out.println("Options include:");
        System.out.println();
        System.out.println("-nopackages");
        System.out.println("-noclasses");
        System.out.println("-noparameters");
        System.out.println("-novalues");
        System.out.println("-notimestamp");
        System.out.println("-rank");
    }
}

