/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.support;

import com.ibm.db2.tools.common.support.Popup;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Window;
import javax.swing.JComponent;
import javax.swing.JWindow;

public class WindowPopup
extends JWindow
implements Popup {
    private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected JComponent invoker;
    protected int saveX;
    protected int saveY;
    protected boolean firstShow;

    public WindowPopup(Window window) {
        super(window);
        String string = System.getProperty("os.name");
        this.firstShow = string.indexOf("Solaris") > -1 || string.indexOf("SunOS") > -1;
        super.enableEvents(0L);
        super.disableEvents(4L);
        this.setName("###overrideRedirect###");
    }

    public WindowPopup(Frame frame) {
        super(frame);
        String string = System.getProperty("os.name");
        this.firstShow = string.indexOf("Solaris") > -1 || string.indexOf("SunOS") > -1;
        super.enableEvents(0L);
        super.disableEvents(4L);
        this.setName("###overrideRedirect###");
    }

    public void addComponent(Component component, Object object) {
        super.getContentPane().add(component, object);
    }

    public void removeComponent(Component component) {
        super.getContentPane().remove(component);
    }

    public void update(Graphics graphics) {
        super.paint(graphics);
    }

    public void appear(JComponent jComponent) {
        this.invoker = jComponent;
        ((Component)this).setLocation(this.saveX, this.saveY);
        ((Component)this).setVisible(true);
        if (this.firstShow) {
            ((Component)this).setVisible(false);
            ((Component)this).setVisible(true);
            this.firstShow = false;
        }
    }

    public void appear(JComponent jComponent, Dimension dimension, JComponent jComponent2, int n2, int n3) {
        if (this.getComponentCount() > 0) {
            super.getContentPane().removeAll();
        }
        this.invoker = jComponent2;
        ((Component)this).setBackground(jComponent.getBackground());
        this.addComponent(jComponent, "Center");
        ((Component)this).setSize(dimension);
        ((Component)this).setLocation(n2, n3);
        ((Component)this).setVisible(true);
        if (this.firstShow) {
            ((Component)this).setVisible(false);
            ((Component)this).setVisible(true);
            this.firstShow = false;
        }
    }

    public void disappear() {
        if (this.getComponentCount() > 0) {
            super.getContentPane().removeAll();
        }
        ((Component)this).setVisible(false);
        ((Container)this).removeNotify();
        this.invoker = null;
    }

    public void dispose() {
        super.dispose();
    }

    public JComponent getInvoker() {
        return this.invoker;
    }

    public Rectangle getBounds() {
        return super.getBounds();
    }

    public int getHeight() {
        return this.getBounds().height;
    }

    public int getWidth() {
        return this.getBounds().width;
    }

    public Rectangle getBoundsOnScreen() {
        return this.getBounds();
    }

    public void setLocationOnScreen(int n2, int n3) {
        this.saveX = n2;
        this.saveY = n3;
    }

    public String toString() {
        return "class javax.swing.DefaultPopupFactory$WindowPopup";
    }
}

