/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.support;

import com.ibm.db2.tools.common.CommonTrace;
import com.ibm.db2.tools.common.support.ViewVectorEvent;
import com.ibm.db2.tools.common.support.ViewVectorListener;
import java.beans.Customizer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.event.EventListenerList;

public class ViewVector
extends Vector
implements Observer,
PropertyChangeListener {
    private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String DELETE = "DELETE";
    protected EventListenerList listenerList = new EventListenerList();
    private int eventStackSize = 0;
    static /* synthetic */ Class class$com$ibm$db2$tools$common$support$ViewVectorListener;

    public ViewVector(int n2, int n3) {
        super(n2, n3);
    }

    public ViewVector(int n2) {
        super(n2);
    }

    public ViewVector() {
    }

    public ViewVector(Collection collection) {
        super(collection);
        this.startObserving(this.elementData);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.support", "ViewVector", this, "propertyChange(PropertyChangeEvent evt)", new Object[]{propertyChangeEvent});
        }
        if (DELETE.equals(propertyChangeEvent.getPropertyName())) {
            int n2 = this.indexOf(propertyChangeEvent.getSource());
            if (n2 >= 0) {
                this.removeElementAt(n2);
            }
        } else {
            this.fireElementChanged(this.indexOf(propertyChangeEvent.getSource()));
        }
        CommonTrace.exit(commonTrace);
    }

    public void update(Observable observable, Object object) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.support", "ViewVector", this, "update(Observable o, Object arg)", new Object[]{observable, object});
        }
        if (DELETE.equals(object)) {
            int n2 = this.indexOf(observable);
            if (n2 >= 0) {
                this.removeElementAt(n2);
            }
        } else {
            this.fireElementChanged(this.indexOf(observable));
        }
        CommonTrace.exit(commonTrace);
    }

    protected void startObserving(Object object) {
        if (null != object && object instanceof Observable) {
            ((Observable)object).addObserver(this);
        }
        if (null != object && object instanceof Customizer) {
            ((Customizer)object).addPropertyChangeListener(this);
        }
    }

    protected void startObserving(Object[] objectArray) {
        int n2 = 0;
        while (n2 < objectArray.length) {
            if (null != objectArray[n2] && objectArray[n2] instanceof Observable) {
                ((Observable)objectArray[n2]).addObserver(this);
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 < objectArray.length) {
            if (null != objectArray[n3] && objectArray[n3] instanceof Customizer) {
                ((Customizer)objectArray[n3]).addPropertyChangeListener(this);
            }
            ++n3;
        }
    }

    protected void startObserving(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            if (null != e2 && e2 instanceof Observable) {
                ((Observable)e2).addObserver(this);
            }
            if (null == e2 || !(e2 instanceof Customizer)) continue;
            ((Customizer)e2).addPropertyChangeListener(this);
        }
    }

    protected void stopObserving(Object object) {
        if (null != object && object instanceof Observable) {
            ((Observable)object).deleteObserver(this);
        }
        if (null != object && object instanceof Customizer) {
            ((Customizer)object).removePropertyChangeListener(this);
        }
    }

    protected void stopObserving(Object[] objectArray) {
        int n2 = 0;
        while (n2 < objectArray.length) {
            if (null != objectArray[n2] && objectArray[n2] instanceof Observable) {
                ((Observable)objectArray[n2]).deleteObserver(this);
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 < objectArray.length) {
            if (null != objectArray[n3] && objectArray[n3] instanceof Customizer) {
                ((Customizer)objectArray[n3]).removePropertyChangeListener(this);
            }
            ++n3;
        }
    }

    protected void stopObserving(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            if (null != e2 && e2 instanceof Observable) {
                ((Observable)e2).deleteObserver(this);
            }
            if (null == e2 || !(e2 instanceof Customizer)) continue;
            ((Customizer)e2).removePropertyChangeListener(this);
        }
    }

    public boolean removeAll(Collection collection) {
        boolean bl = false;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (!this.remove(iterator.next())) continue;
            bl = true;
        }
        return bl;
    }

    public boolean retainAll(Collection collection) {
        boolean bl = false;
        int n2 = this.size();
        int n3 = n2 - 1;
        while (n3 >= 0) {
            if (!collection.contains(this.elementAt(n3))) {
                this.removeElementAt(n3);
                bl = true;
            }
            --n3;
        }
        return bl;
    }

    public synchronized void setSize(int n2) {
        int n3 = this.elementCount;
        if (n2 >= 0 && n2 < n3) {
            int n4 = n2;
            while (n4 < n3) {
                this.stopObserving(this.elementData[n4]);
                ++n4;
            }
        }
        ++this.eventStackSize;
        super.setSize(n2);
        --this.eventStackSize;
        if (n2 >= 0 && n2 < n3) {
            this.fireElementsDeleted(n2, n3 - 1);
        }
    }

    public synchronized void setElementAt(Object object, int n2) {
        if (n2 >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n2 + " >= " + this.elementCount);
        }
        this.stopObserving(this.elementData[n2]);
        ++this.eventStackSize;
        super.setElementAt(object, n2);
        --this.eventStackSize;
        this.startObserving(this.elementData[n2]);
        this.fireElementChanged(n2);
    }

    public synchronized void removeElementAt(int n2) {
        if (n2 >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n2 + " >= " + this.elementCount);
        }
        if (n2 < 0) {
            throw new ArrayIndexOutOfBoundsException(n2);
        }
        this.stopObserving(this.elementData[n2]);
        ++this.eventStackSize;
        super.removeElementAt(n2);
        --this.eventStackSize;
        this.fireElementsDeleted(n2, n2);
    }

    public synchronized void insertElementAt(Object object, int n2) {
        ++this.eventStackSize;
        super.insertElementAt(object, n2);
        --this.eventStackSize;
        this.startObserving(object);
        this.fireElementsInserted(n2, n2);
    }

    public synchronized void addElement(Object object) {
        ++this.eventStackSize;
        super.addElement(object);
        --this.eventStackSize;
        this.startObserving(object);
        this.fireElementsInserted(this.elementCount - 1, this.elementCount - 1);
    }

    public boolean removeElement(Object object) {
        int n2 = this.indexOf(object);
        ++this.eventStackSize;
        boolean bl = super.removeElement(object);
        --this.eventStackSize;
        if (bl && n2 >= 0) {
            this.stopObserving(object);
            this.fireElementsDeleted(n2, n2);
        }
        return bl;
    }

    public synchronized void removeAllElements() {
        this.stopObserving(this.elementData);
        ++this.eventStackSize;
        super.removeAllElements();
        --this.eventStackSize;
        this.fireElementsDeleted(0, Integer.MAX_VALUE);
    }

    public synchronized Object set(int n2, Object object) {
        ++this.eventStackSize;
        Object object2 = super.set(n2, object);
        --this.eventStackSize;
        this.stopObserving(object2);
        this.startObserving(object);
        this.fireElementChanged(n2);
        return object2;
    }

    public synchronized boolean add(Object object) {
        ++this.eventStackSize;
        boolean bl = super.add(object);
        --this.eventStackSize;
        if (bl) {
            this.startObserving(object);
            this.fireElementsInserted(this.elementCount - 1, this.elementCount - 1);
        }
        return bl;
    }

    public synchronized Object remove(int n2) {
        ++this.eventStackSize;
        Object e2 = super.remove(n2);
        --this.eventStackSize;
        if (null != e2) {
            this.stopObserving(e2);
            this.fireElementsDeleted(n2, n2);
        }
        return e2;
    }

    public boolean remove(Object object) {
        int n2 = this.indexOf(object);
        ++this.eventStackSize;
        boolean bl = super.remove(object);
        --this.eventStackSize;
        if (bl && n2 >= 0) {
            this.stopObserving(object);
            this.fireElementsDeleted(n2, n2);
        }
        return bl;
    }

    public void add(int n2, Object object) {
        ++this.eventStackSize;
        super.add(n2, object);
        --this.eventStackSize;
        this.startObserving(object);
        this.fireElementsInserted(n2, n2);
    }

    public synchronized boolean addAll(Collection collection) {
        int n2 = this.elementCount;
        ++this.eventStackSize;
        boolean bl = super.addAll(collection);
        --this.eventStackSize;
        if (bl) {
            this.startObserving(collection);
            this.fireElementsInserted(n2, this.elementCount - 1);
        }
        return bl;
    }

    public synchronized boolean addAll(int n2, Collection collection) {
        int n3 = this.elementCount;
        this.stopObserving(this.elementData);
        ++this.eventStackSize;
        boolean bl = super.addAll(n2, collection);
        --this.eventStackSize;
        this.startObserving(this.elementData);
        if (bl) {
            this.fireElementsInserted(n2, n2 + this.elementCount - n3 - 1);
        }
        return bl;
    }

    protected void removeRange(int n2, int n3) {
        this.stopObserving(this.elementData);
        ++this.eventStackSize;
        super.removeRange(n2, n3);
        --this.eventStackSize;
        this.startObserving(this.elementData);
        this.fireElementsDeleted(n2, n3 - 1);
    }

    public void addViewVectorListener(ViewVectorListener viewVectorListener) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.support", "ViewVector", this, "addViewVectorListener(ViewVectorListener l)", new Object[]{viewVectorListener});
        }
        this.listenerList.add(class$com$ibm$db2$tools$common$support$ViewVectorListener == null ? (class$com$ibm$db2$tools$common$support$ViewVectorListener = ViewVector.class$("com.ibm.db2.tools.common.support.ViewVectorListener")) : class$com$ibm$db2$tools$common$support$ViewVectorListener, viewVectorListener);
        CommonTrace.exit(commonTrace);
    }

    public void removeViewVectorListener(ViewVectorListener viewVectorListener) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.support", "ViewVector", this, "removeViewVectorListener(ViewVectorListener l)", new Object[]{viewVectorListener});
        }
        this.listenerList.remove(class$com$ibm$db2$tools$common$support$ViewVectorListener == null ? (class$com$ibm$db2$tools$common$support$ViewVectorListener = ViewVector.class$("com.ibm.db2.tools.common.support.ViewVectorListener")) : class$com$ibm$db2$tools$common$support$ViewVectorListener, viewVectorListener);
        CommonTrace.exit(commonTrace);
    }

    public void fireElementsInserted(int n2, int n3) {
        this.fireVectorChanged(new ViewVectorEvent(this, n2, n3, 1));
    }

    public void fireElementsDeleted(int n2, int n3) {
        this.fireVectorChanged(new ViewVectorEvent(this, n2, n3, -1));
    }

    public void fireElementChanged(int n2) {
        this.fireVectorChanged(new ViewVectorEvent(this, n2, n2, 0));
    }

    public void fireVectorChanged(ViewVectorEvent viewVectorEvent) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.support", "ViewVector", this, "fireVectorChanged(ViewVectorEvent e)");
        }
        if (0 == this.eventStackSize) {
            Object[] objectArray = this.listenerList.getListenerList();
            int n2 = objectArray.length - 2;
            while (n2 >= 0) {
                if (objectArray[n2] == (class$com$ibm$db2$tools$common$support$ViewVectorListener == null ? ViewVector.class$("com.ibm.db2.tools.common.support.ViewVectorListener") : class$com$ibm$db2$tools$common$support$ViewVectorListener)) {
                    ((ViewVectorListener)objectArray[n2 + 1]).vectorChanged(viewVectorEvent);
                }
                n2 -= 2;
            }
        }
        CommonTrace.exit(commonTrace);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

