/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.support;

import com.ibm.db2.tools.common.support.AssistManager;
import com.ibm.db2.tools.common.support.AssistValidityProvider;
import com.ibm.db2.tools.common.support.ViewJLabelBaseRenderer;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.NumberFormat;
import javax.swing.JTable;

public class ViewTimestampRenderer
extends ViewJLabelBaseRenderer
implements AssistValidityProvider {
    private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected DateFormat dateFormatter;
    protected NumberFormat nanosFormatter;
    protected boolean valueRequired = false;
    protected boolean ignoreNullValues = false;
    protected boolean showNanos = true;

    public ViewTimestampRenderer() {
        this.setValidityProvider(this);
    }

    protected void setValue(Object object) {
        this.valueRequired = false;
        StringBuffer stringBuffer = new StringBuffer();
        if (object != null) {
            if (object instanceof Timestamp) {
                stringBuffer.append(this.getDateFormatter().format(object));
                if (this.showNanos) {
                    stringBuffer.append(" ");
                    stringBuffer.append(this.getNanosFormatter().format(((Timestamp)object).getNanos() / 1000));
                }
            } else if (object instanceof String) {
                try {
                    Timestamp timestamp = Timestamp.valueOf((String)object);
                    stringBuffer.append(this.getDateFormatter().format(timestamp));
                    if (this.showNanos) {
                        stringBuffer.append(" ");
                        stringBuffer.append(this.getNanosFormatter().format(timestamp.getNanos() / 1000));
                    }
                }
                catch (Exception exception) {
                    stringBuffer = new StringBuffer();
                    stringBuffer.append(object.toString());
                    this.valueRequired = true;
                }
            }
            this.setText(stringBuffer.toString());
        } else {
            this.setText("");
            if (!this.ignoreNullValues) {
                this.valueRequired = true;
            }
        }
        this.setHorizontalAlignment(4);
    }

    public boolean isValueRequired(JTable jTable, Object object, int n2, int n3) {
        return this.valueRequired;
    }

    public void setShowNanos(boolean bl) {
        this.showNanos = bl;
    }

    public void setDateFormatter(DateFormat dateFormat) {
        this.dateFormatter = dateFormat;
    }

    public DateFormat getDateFormatter() {
        if (null == this.dateFormatter) {
            this.dateFormatter = DateFormat.getDateTimeInstance(2, 2, AssistManager.getPreferredLocale());
        }
        return this.dateFormatter;
    }

    public void setNanosFormatter(NumberFormat numberFormat) {
        this.nanosFormatter = numberFormat;
    }

    public NumberFormat getNanosFormatter() {
        if (null == this.nanosFormatter) {
            this.nanosFormatter = NumberFormat.getInstance(AssistManager.getPreferredLocale());
            this.nanosFormatter.setMinimumIntegerDigits(6);
            this.nanosFormatter.setMaximumIntegerDigits(6);
            this.nanosFormatter.setMaximumFractionDigits(0);
            this.nanosFormatter.setGroupingUsed(false);
        }
        return this.nanosFormatter;
    }

    public void setIgnoreNullValues(boolean bl) {
        this.ignoreNullValues = bl;
    }
}

