/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.support;

import com.ibm.db2.tools.common.CommonTrace;
import com.ibm.db2.tools.common.support.ViewObjectColumnsInterface;
import com.ibm.db2.tools.common.support.ViewObjectDataInterface;
import com.ibm.db2.tools.common.support.ViewObjectInterface;
import com.ibm.db2.tools.common.support.ViewTableAbstractModel;
import java.util.Vector;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class ViewTableTreeModel
extends ViewTableAbstractModel
implements TreeExpansionListener,
TreeModelListener {
    private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected JTree tree;
    protected TreeModel treeModel;

    public ViewTableTreeModel(TreeModel treeModel, ViewObjectInterface viewObjectInterface, Object object) {
        this.setTreeModel(treeModel, this.getColumnsInterfacesArray(viewObjectInterface), object);
    }

    public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
        this.delayedFireTableDataChanged();
    }

    public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
        this.delayedFireTableDataChanged();
    }

    public void treeNodesChanged(TreeModelEvent treeModelEvent) {
        this.delayedFireTableDataChanged();
    }

    public void treeNodesInserted(TreeModelEvent treeModelEvent) {
        this.delayedFireTableDataChanged();
    }

    public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
        this.delayedFireTableDataChanged();
    }

    public void treeStructureChanged(TreeModelEvent treeModelEvent) {
        this.delayedFireTableDataChanged();
    }

    public JTree getTree() {
        return this.tree;
    }

    public TreeModel getTreeModel() {
        return this.treeModel;
    }

    protected void setTreeModel(TreeModel treeModel, ViewObjectColumnsInterface[] viewObjectColumnsInterfaceArray, Object object) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.support", "ViewTableTreeModel", this, "setTreeModel(TreeModel aTreeModel, ViewObjectColumnsInterface[] newColumnInterfaces, Object scope)", new Object[]{treeModel, viewObjectColumnsInterfaceArray, object});
        }
        if (treeModel == null) {
            throw (IllegalArgumentException)CommonTrace.throwException(commonTrace, new IllegalArgumentException("setTreeModel() - Null parameter"));
        }
        this.treeModel = treeModel;
        this.columnInterfaces = null;
        this.setColumnIdentifiers(ViewTableAbstractModel.convertToVector(viewObjectColumnsInterfaceArray), object);
        this.fireTableDataChanged();
        CommonTrace.exit(commonTrace);
    }

    public int getRowCount() {
        return this.tree.getRowCount();
    }

    public boolean isCellEditable(int n2, int n3) {
        ViewObjectDataInterface viewObjectDataInterface = (ViewObjectDataInterface)((DefaultMutableTreeNode)this.tree.getPathForRow(n2).getLastPathComponent()).getUserObject();
        return viewObjectDataInterface.isEditable(n3, this.scope);
    }

    public Object getValueAt(int n2, int n3) {
        Object object = null;
        TreePath treePath = this.tree.getPathForRow(n2);
        if (null != treePath) {
            ViewObjectDataInterface viewObjectDataInterface = (ViewObjectDataInterface)((DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject();
            object = viewObjectDataInterface.getData(n3, this.scope);
        }
        return object;
    }

    public void setValueAt(Object object, int n2, int n3) {
        ViewObjectDataInterface viewObjectDataInterface = (ViewObjectDataInterface)((DefaultMutableTreeNode)this.tree.getPathForRow(n2).getLastPathComponent()).getUserObject();
        viewObjectDataInterface.setData(object, n3, this.scope);
        this.fireTableChanged(new TableModelEvent(this, n2, n2, n3));
    }

    protected void delayedFireTableDataChanged() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ViewTableTreeModel.this.fireTableDataChanged();
            }
        });
    }

    public void setColumnIdentifiers(Vector vector, Object object) {
        if (!vector.equals(this.columnInterfaces) || null != this.scope && !this.scope.equals(object) || null != object && !object.equals(this.scope)) {
            if (null != this.tree) {
                this.tree.removeTreeExpansionListener(this);
                this.tree.getModel().removeTreeModelListener(this);
                this.tree = null;
            }
            super.setColumnIdentifiers(vector, object);
            int n2 = 0;
            while (n2 < this.columnSettings.length) {
                if (null != this.columnSettings[n2] && this.columnSettings[n2].getCellRenderer() instanceof JTree) {
                    if (null == this.tree) {
                        ((JTree)((Object)this.columnSettings[n2].getCellRenderer())).setModel(this.treeModel);
                        this.tree = (JTree)((Object)this.columnSettings[n2].getCellRenderer());
                        this.tree.addTreeExpansionListener(this);
                        this.tree.getModel().addTreeModelListener(this);
                    } else {
                        throw new IllegalArgumentException("Cannot have two columns whose cell renderers are instances if JTree");
                    }
                }
                ++n2;
            }
        }
    }
}

