/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.support;

import com.ibm.db2.tools.common.support.CellExpanderRenderer;
import com.ibm.db2.tools.common.support.ViewTreeCellRenderer;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public class ViewTableTreeCellRenderer
extends JTree
implements TableCellRenderer,
CellExpanderRenderer {
    private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected int visibleRow;
    protected JTable table;
    protected String valueText = "";

    public ViewTableTreeCellRenderer() {
        this.setCellRenderer(this.createDefaultTreeCellRenderer());
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n2, int n3) {
        if (null != object) {
            this.valueText = object.toString();
        }
        if (null == this.table) {
            this.table = jTable;
        }
        if (bl) {
            this.setBackground(this.table.getSelectionBackground());
            this.setForeground(this.table.getSelectionForeground());
        } else {
            this.setBackground(this.table.getBackground());
            this.setForeground(this.table.getForeground());
        }
        if (this.table.getRowHeight() < this.getRowHeight()) {
            this.table.setRowHeight(this.getRowHeight());
        }
        if (this.getRowHeight() < this.table.getRowHeight()) {
            this.setRowHeight(this.table.getRowHeight());
        }
        this.visibleRow = n2;
        return this;
    }

    public TreeCellRenderer createDefaultTreeCellRenderer() {
        return new ViewTreeCellRenderer();
    }

    public void updateUI() {
        super.updateUI();
        TreeCellRenderer treeCellRenderer = this.getCellRenderer();
        if (treeCellRenderer instanceof DefaultTreeCellRenderer) {
            DefaultTreeCellRenderer defaultTreeCellRenderer = (DefaultTreeCellRenderer)treeCellRenderer;
            defaultTreeCellRenderer.setBorderSelectionColor(null);
            defaultTreeCellRenderer.setTextSelectionColor(UIManager.getColor("Table.selectionForeground"));
            defaultTreeCellRenderer.setBackgroundSelectionColor(UIManager.getColor("Table.selectionBackground"));
        }
    }

    public void setBounds(int n2, int n3, int n4, int n5) {
        if (null != this.table) {
            super.setBounds(n2, 0, n4, this.table.getHeight());
        }
    }

    public void paint(Graphics graphics) {
        if (null != this.table) {
            graphics.translate(0, -this.visibleRow * this.getRowHeight());
        }
        super.paint(graphics);
    }

    public int getTextOffset() {
        int n2 = 0;
        TreePath treePath = this.getPathForRow(this.visibleRow);
        if (null != treePath) {
            n2 = treePath.getPathCount() * this.getRowHeight();
        }
        return n2;
    }

    public String getText() {
        return this.valueText;
    }
}

