/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.support;

import com.ibm.db2.tools.common.ViewTable;
import com.ibm.db2.tools.common.support.AssistCollator;
import com.ibm.db2.tools.common.support.AssistComparator;
import com.ibm.db2.tools.common.support.AssistKey;
import com.ibm.db2.tools.common.support.AssistManager;
import com.ibm.db2.tools.common.support.ViewIconNameObjectInterface;
import com.ibm.db2.tools.common.support.ViewTableColumn;
import com.ibm.db2.tools.common.support.ViewTableColumnModel;
import com.ibm.db2.tools.common.support.ViewTableColumnModelEvent;
import com.ibm.db2.tools.common.support.ViewTableRollupModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class ViewTableSortFilterModel
extends AbstractTableModel
implements TableColumnModelListener,
TableModel,
TableModelListener,
PropertyChangeListener,
Serializable {
    private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected TableModel dataModel;
    protected ViewTableColumnModel columnModel;
    protected ViewTable table;
    protected Object[] expansionInfo = null;
    protected int[] sortFilterInfo = null;
    protected int[] rSortFilterInfo = null;
    protected boolean expanding = false;
    protected boolean updating = false;
    protected boolean advancedEventProcessing = false;
    protected boolean fireTableStructureChanged = false;
    static /* synthetic */ Class class$javax$swing$event$TableModelListener;

    public void shutdown() {
        Enumeration enumeration = this.columnModel.getAllColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = (TableColumn)enumeration.nextElement();
            tableColumn.removePropertyChangeListener(this);
        }
    }

    public int getRowIndex(int n2) {
        if (this.isUpdating() && this.isExpanding()) {
            return n2;
        }
        if (null == this.sortFilterInfo) {
            return n2;
        }
        return this.sortFilterInfo[n2];
    }

    public boolean isExpanding() {
        return this.expanding;
    }

    protected void setExpanding(boolean bl) {
        this.expanding = bl;
    }

    public boolean isUpdating() {
        return this.updating;
    }

    protected void setUpdating(boolean bl) {
        this.updating = bl;
    }

    public boolean isAdvancedEventProcessing() {
        return this.advancedEventProcessing;
    }

    public void setAdvancedEventProcessing(boolean bl) {
        this.advancedEventProcessing = bl;
    }

    public void sortColumn(ViewTableColumn viewTableColumn, int n2) {
        viewTableColumn.setSortDirection(n2);
    }

    public int[] getSortFilterInfo() {
        return this.sortFilterInfo;
    }

    public void setSortFilterInfo(int[] nArray) {
        this.sortFilterInfo = nArray;
    }

    public void setModel(TableModel tableModel) {
        if (tableModel == null) {
            throw new IllegalArgumentException("Cannot set a null TableModel");
        }
        TableModel tableModel2 = this.dataModel;
        if (tableModel != tableModel2) {
            if (null != tableModel2) {
                tableModel2.removeTableModelListener(this);
            }
            this.setUpdating(true);
            this.dataModel = tableModel;
            this.dataModel.addTableModelListener(this);
            if (this.columnModel != null) {
                this.fireTableStructureChanged = true;
                this.applyExpandFilterSort();
            }
        }
    }

    public TableModel getModel() {
        return this.dataModel;
    }

    public void setColumnModel(ViewTableColumnModel viewTableColumnModel) {
        if (viewTableColumnModel == null) {
            throw new IllegalArgumentException("Cannot set a null ColumnModel");
        }
        ViewTableColumnModel viewTableColumnModel2 = this.columnModel;
        if (viewTableColumnModel != viewTableColumnModel2) {
            TableColumn tableColumn;
            Enumeration enumeration;
            this.setUpdating(true);
            if (null != viewTableColumnModel2) {
                viewTableColumnModel2.removeColumnModelListener(this);
                enumeration = viewTableColumnModel2.getAllColumns();
                while (enumeration.hasMoreElements()) {
                    tableColumn = (TableColumn)enumeration.nextElement();
                    tableColumn.removePropertyChangeListener(this);
                }
            }
            this.columnModel = viewTableColumnModel;
            this.columnModel.addColumnModelListener(this);
            enumeration = this.columnModel.getAllColumns();
            while (enumeration.hasMoreElements()) {
                tableColumn = (TableColumn)enumeration.nextElement();
                tableColumn.addPropertyChangeListener(this);
            }
            this.applyExpandFilterSort();
        }
    }

    public TableColumnModel getColumnModel() {
        return this.columnModel;
    }

    public void setTable(ViewTable viewTable) {
        if (viewTable == null) {
            throw new IllegalArgumentException("Cannot set a null ViewTable");
        }
        this.table = viewTable;
    }

    public ViewTable getTable() {
        return this.table;
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        this.setUpdating(true);
        if (null == tableModelEvent || tableModelEvent.getFirstRow() == -1) {
            this.fireTableStructureChanged = true;
            Object[] objectArray = this.listenerList.getListenerList();
            int n2 = objectArray.length - 2;
            while (n2 >= 0) {
                if (objectArray[n2] == (class$javax$swing$event$TableModelListener == null ? ViewTableSortFilterModel.class$("javax.swing.event.TableModelListener") : class$javax$swing$event$TableModelListener) && (objectArray[n2 + 1] instanceof ViewTable || objectArray[n2 + 1] instanceof ViewTableRollupModel)) {
                    this.setUpdating(true);
                    ((TableModelListener)objectArray[n2 + 1]).tableChanged(tableModelEvent);
                }
                n2 -= 2;
            }
            this.applyExpandFilterSort();
        } else if (null == this.sortFilterInfo) {
            this.fireTableChanged(tableModelEvent);
        } else if (tableModelEvent.getFirstRow() < 0 || tableModelEvent.getLastRow() > this.sortFilterInfo.length - 1 || tableModelEvent.getFirstRow() == 0 && tableModelEvent.getLastRow() == this.sortFilterInfo.length - 1) {
            this.applyExpandFilterSort();
        } else {
            int n3;
            int n4 = tableModelEvent.getFirstRow();
            if (n4 > (n3 = tableModelEvent.getLastRow())) {
                n4 = tableModelEvent.getLastRow();
                n3 = tableModelEvent.getFirstRow();
            }
            if (null == this.expansionInfo && this.isAdvancedEventProcessing()) {
                if (tableModelEvent.getType() == -1) {
                    this.processDelete(n4, n3);
                } else if (tableModelEvent.getType() == 1) {
                    this.processInsert(n4, n3);
                } else if (tableModelEvent.getType() == 0) {
                    this.processUpdate(n4, n3);
                }
            } else if (tableModelEvent.getType() == 0) {
                if ((n4 = this.rSortFilterInfo[n4]) > (n3 = this.rSortFilterInfo[n3])) {
                    n4 = this.rSortFilterInfo[n3];
                    n3 = this.rSortFilterInfo[n4];
                }
                if (-1 == n4) {
                    n4 = 0;
                }
                if (-1 == n3) {
                    n3 = this.sortFilterInfo.length - 1;
                }
                boolean bl = false;
                int n5 = n4;
                while (n5 <= n3) {
                    if (null != this.expansionInfo[n5]) {
                        bl = true;
                        break;
                    }
                    ++n5;
                }
                if (bl) {
                    this.applyExpandFilterSort();
                } else {
                    this.setUpdating(false);
                    this.fireTableRowsUpdated(n4, n3);
                }
            } else {
                this.applyExpandFilterSort();
            }
        }
    }

    public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
        if (0 == tableColumnModelEvent.getFromIndex()) {
            ((ViewTableColumnModelEvent)tableColumnModelEvent).getColumn().addPropertyChangeListener(this);
        }
    }

    public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
        TableColumn tableColumn = ((ViewTableColumnModelEvent)tableColumnModelEvent).getColumn();
        if (tableColumn != null && tableColumnModelEvent.getToIndex() == 0) {
            tableColumn.removePropertyChangeListener(this);
        }
    }

    public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
    }

    public void columnMarginChanged(ChangeEvent changeEvent) {
    }

    public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
    }

    public int getRowCount() {
        if (this.isUpdating() && this.isExpanding()) {
            return this.dataModel.getRowCount();
        }
        if (null == this.sortFilterInfo) {
            return this.dataModel.getRowCount();
        }
        return this.sortFilterInfo.length;
    }

    public int getColumnCount() {
        return this.dataModel.getColumnCount();
    }

    public String getColumnName(int n2) {
        return this.dataModel.getColumnName(n2);
    }

    public Class getColumnClass(int n2) {
        return this.dataModel.getColumnClass(n2);
    }

    public boolean isCellEditable(int n2, int n3) {
        if (this.isUpdating() && this.isExpanding()) {
            return this.dataModel.isCellEditable(n2, n3);
        }
        return this.dataModel.isCellEditable(this.getRowIndex(n2), n3);
    }

    public Object getValueAt(int n2, int n3) {
        if (this.isUpdating() && this.isExpanding()) {
            return this.dataModel.getValueAt(n2, n3);
        }
        return this.getExpandedValueAt(n2, n3);
    }

    public void setValueAt(Object object, int n2, int n3) {
        if (this.isUpdating() && this.isExpanding()) {
            this.dataModel.setValueAt(object, n2, n3);
        } else if (null != this.expansionInfo && null != this.expansionInfo[n2] && n3 == ((int[])this.expansionInfo[n2])[0]) {
            ((Vector)this.dataModel.getValueAt(this.getRowIndex(n2), n3)).setElementAt(object, ((int[])this.expansionInfo[n2])[1]);
        } else {
            this.dataModel.setValueAt(object, this.getRowIndex(n2), n3);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("rollup") || string.equals("sortDirection") || string.equals("sortOrdinal") || string.equals("filterEnabled") || string.equals("operator") || string.equals("filterValues")) {
            this.applyExpandFilterSort();
        }
    }

    public void fireTableChanged(TableModelEvent tableModelEvent) {
        if (tableModelEvent == null || tableModelEvent.getFirstRow() == -1) {
            Object[] objectArray = this.listenerList.getListenerList();
            int n2 = objectArray.length - 2;
            while (n2 >= 0) {
                if (objectArray[n2] == (class$javax$swing$event$TableModelListener == null ? ViewTableSortFilterModel.class$("javax.swing.event.TableModelListener") : class$javax$swing$event$TableModelListener)) {
                    if (objectArray[n2 + 1] instanceof ViewTable || objectArray[n2 + 1] instanceof ViewTableRollupModel) {
                        ((TableModelListener)objectArray[n2 + 1]).tableChanged(new TableModelEvent((TableModel)tableModelEvent.getSource()));
                    } else {
                        ((TableModelListener)objectArray[n2 + 1]).tableChanged(tableModelEvent);
                    }
                }
                n2 -= 2;
            }
        } else {
            super.fireTableChanged(tableModelEvent);
        }
    }

    protected void processDelete(int n2, int n3) {
        int n4;
        this.setUpdating(true);
        int n5 = this.sortFilterInfo.length;
        int n6 = -1;
        int n7 = 0;
        int n8 = n2;
        while (n8 <= n3) {
            n4 = this.rSortFilterInfo[n8];
            this.sortFilterInfo[n4] = -1;
            if (n4 < n5) {
                n5 = n4;
            }
            if (n4 > n6) {
                n6 = n4;
            }
            ++n7;
            ++n8;
        }
        n4 = 0;
        int[] nArray = new int[this.sortFilterInfo.length - n7];
        int n9 = 0;
        while (n9 < this.sortFilterInfo.length) {
            if (this.sortFilterInfo[n9] > -1) {
                nArray[n4] = this.sortFilterInfo[n9] > n3 ? this.sortFilterInfo[n9] - (n3 - n2 + 1) : this.sortFilterInfo[n9];
                ++n4;
            }
            ++n9;
        }
        this.sortFilterInfo = nArray;
        this.updateReverseReference();
        this.setUpdating(false);
        if (n6 > -1) {
            this.fireTableRowsDeleted(n5, n6);
        }
    }

    protected void processInsert(int n2, int n3) {
        this.setUpdating(true);
        int n4 = 0;
        while (n4 < this.sortFilterInfo.length) {
            if (this.sortFilterInfo[n4] >= n2) {
                this.sortFilterInfo[n4] = this.sortFilterInfo[n4] + (n3 - n2 + 1);
            }
            ++n4;
        }
        ViewTableColumn[] viewTableColumnArray = this.getSortingColumns();
        int n5 = this.sortFilterInfo.length;
        int n6 = -1;
        int n7 = n2;
        while (n7 <= n3) {
            if (this.passesFilter(n7)) {
                int n8 = -1;
                int n9 = -1;
                if (viewTableColumnArray.length > 0) {
                    n8 = 0;
                    n9 = this.sortFilterInfo.length;
                    int n10 = 1;
                    while (n10 < viewTableColumnArray.length) {
                        ViewTableColumn viewTableColumn = viewTableColumnArray[n10];
                        if (viewTableColumn != null) {
                            AssistCollator assistCollator = (AssistCollator)AssistCollator.getInstance();
                            Object object = this.getExpandedValueAt(n7, viewTableColumn.getModelIndex());
                            n9 = this.getLastInsertion(object = this.table.getOriginalType(viewTableColumn, object), viewTableColumn, n8 = this.getFirstInsertion(object, viewTableColumn, n8, n9), n9);
                            if (n9 < n8) {
                                ++n9;
                            }
                            if (n9 == n8) break;
                        }
                        ++n10;
                    }
                } else {
                    n8 = this.sortFilterInfo.length;
                    n9 = this.sortFilterInfo.length;
                }
                int[] nArray = new int[this.sortFilterInfo.length + 1];
                int n11 = 0;
                while (n11 < n9) {
                    nArray[n11] = this.sortFilterInfo[n11];
                    ++n11;
                }
                nArray[n9] = n7;
                int n12 = n9 + 1;
                while (n12 < nArray.length) {
                    nArray[n12] = this.sortFilterInfo[n12 - 1];
                    ++n12;
                }
                if (n9 < n5) {
                    n5 = n9;
                }
                if (n9 > n6) {
                    n6 = n9;
                }
                this.sortFilterInfo = nArray;
            }
            ++n7;
        }
        this.updateReverseReference();
        this.setUpdating(false);
        if (n6 > -1) {
            this.fireTableRowsInserted(n5, n6);
        }
    }

    protected void processUpdate(int n2, int n3) {
        this.applyExpandFilterSort();
    }

    protected int getFirstInsertion(Object object, ViewTableColumn viewTableColumn, int n2, int n3) {
        AssistCollator assistCollator = (AssistCollator)AssistCollator.getInstance();
        int n4 = n2;
        int n5 = n2;
        while (n5 < n3) {
            Object object2 = this.getExpandedValueAt(this.sortFilterInfo[n5], viewTableColumn.getModelIndex());
            if (assistCollator.compare(object, object2 = this.table.getOriginalType(viewTableColumn, object2)) == 0 || (16 == viewTableColumn.getSortDirection() ? assistCollator.compare(object, object2) < 0 : assistCollator.compare(object, object2) > 0)) break;
            ++n4;
            ++n5;
        }
        return n4;
    }

    protected int getLastInsertion(Object object, ViewTableColumn viewTableColumn, int n2, int n3) {
        AssistCollator assistCollator = (AssistCollator)AssistCollator.getInstance();
        int n4 = n3;
        int n5 = n3 - 1;
        while (n5 >= n2) {
            Object object2 = this.getExpandedValueAt(this.sortFilterInfo[n5], viewTableColumn.getModelIndex());
            if (assistCollator.compare(object, object2 = this.table.getOriginalType(viewTableColumn, object2)) == 0 || (16 == viewTableColumn.getSortDirection() ? assistCollator.compare(object, object2) > 0 : assistCollator.compare(object, object2) < 0)) break;
            --n4;
            --n5;
        }
        return n4;
    }

    public Object getExpandedValueAt(int n2, int n3) {
        Object object = this.dataModel.getValueAt(this.sortFilterInfo[n2], n3);
        if (null != this.expansionInfo && null != this.expansionInfo[n2] && n3 == ((int[])this.expansionInfo[n2])[0]) {
            object = ((Vector)object).elementAt(((int[])this.expansionInfo[n2])[1]);
        }
        return object;
    }

    protected boolean passesFilter(int n2) {
        boolean bl = true;
        if (this.columnModel.isFilterEnabled()) {
            Object object;
            Object object2;
            ViewTableColumn viewTableColumn = null;
            Enumeration enumeration = this.columnModel.getColumns();
            int n3 = 0;
            while (enumeration.hasMoreElements()) {
                AccessibleContext accessibleContext;
                String string;
                viewTableColumn = (ViewTableColumn)enumeration.nextElement();
                if (null != viewTableColumn.getFilterValues() && !viewTableColumn.test(string = (accessibleContext = (object2 = (object = (AccessibleTable)((Object)this.table.getAccessibleContext())).getAccessibleAt(n2, n3)).getAccessibleContext()).getAccessibleName())) {
                    bl = false;
                    break;
                }
                ++n3;
            }
            enumeration = this.columnModel.getHiddenColumns();
            while (enumeration.hasMoreElements()) {
                viewTableColumn = (ViewTableColumn)enumeration.nextElement();
                if (null == viewTableColumn.getFilterValues()) continue;
                object = this.getExpandedValueAt(n2, viewTableColumn.getModelIndex());
                object2 = this.getDisplayableString(object = this.table.getOriginalType(viewTableColumn, object));
                if (object2 == null || viewTableColumn.test((String)object2)) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    protected void updateReverseReference() {
        this.rSortFilterInfo = new int[this.dataModel.getRowCount()];
        Arrays.fill(this.rSortFilterInfo, -1);
        int n2 = 0;
        while (n2 < this.sortFilterInfo.length) {
            this.rSortFilterInfo[this.sortFilterInfo[n2]] = n2;
            ++n2;
        }
    }

    protected ViewTableColumn[] getSortingColumns() {
        ViewTableColumn[] viewTableColumnArray;
        ViewTableColumn[] viewTableColumnArray2 = new ViewTableColumn[this.columnModel.getAllColumnCount() + 1];
        int n2 = -1;
        Enumeration enumeration = this.columnModel.getAllColumns();
        while (enumeration.hasMoreElements()) {
            viewTableColumnArray = (ViewTableColumn[])enumeration.nextElement();
            int n3 = viewTableColumnArray.getSortOrdinal();
            if (viewTableColumnArray.getSortDirection() == 1 || 0 == n3) continue;
            viewTableColumnArray2[n3] = viewTableColumnArray;
            if (n2 >= n3) continue;
            n2 = n3;
        }
        viewTableColumnArray = new ViewTableColumn[n2 + 1];
        System.arraycopy(viewTableColumnArray2, 0, viewTableColumnArray, 0, n2 + 1);
        return viewTableColumnArray;
    }

    protected void applyExpandFilterSort() {
        this.setUpdating(true);
        this.setExpanding(true);
        ViewTableColumn[] viewTableColumnArray = this.getSortingColumns();
        int n2 = this.dataModel.getRowCount();
        int[] nArray = new int[n2];
        int n3 = 0;
        while (n3 < nArray.length) {
            nArray[n3] = n3;
            ++n3;
        }
        this.expansionInfo = new Object[n2];
        Object object = null;
        int n4 = 0;
        while (n4 < viewTableColumnArray.length) {
            ViewTableColumn viewTableColumn = viewTableColumnArray[n4];
            if (viewTableColumn != null && viewTableColumn.isRollup()) {
                int[] nArray2 = null;
                Object[] objectArray = null;
                int n5 = 0;
                int n6 = 0;
                while (n6 < n2) {
                    object = this.dataModel.getValueAt(nArray[n6 + n5], viewTableColumn.getModelIndex());
                    if (object instanceof Vector) {
                        Vector vector = (Vector)object;
                        int n7 = Math.max(0, vector.size() - 1);
                        nArray2 = new int[nArray.length + n7];
                        objectArray = new Object[nArray.length + n7];
                        Arrays.fill(nArray2, -1);
                        System.arraycopy(nArray, 0, nArray2, 0, n6 + n5);
                        int n8 = n6;
                        while (n8 < n6 + n7 + 1) {
                            nArray2[n8 + n5] = nArray[n6 + n5];
                            ++n8;
                        }
                        System.arraycopy(nArray, n6 + n5 + 1, nArray2, n6 + n5 + n7 + 1, nArray.length - n6 - n5 - 1);
                        System.arraycopy(this.expansionInfo, 0, objectArray, 0, n6 + n5);
                        int[] nArray3 = new int[]{viewTableColumn.getModelIndex(), 0};
                        objectArray[n6 + n5] = nArray3;
                        int n9 = 0;
                        while (n9 < n7) {
                            nArray3 = new int[]{viewTableColumn.getModelIndex(), n9 + 1};
                            objectArray[n6 + n5 + n9 + 1] = nArray3;
                            ++n9;
                        }
                        System.arraycopy(this.expansionInfo, n6 + n5 + 1, objectArray, n6 + n5 + n7 + 1, this.expansionInfo.length - n6 - n5 - 1);
                        nArray = nArray2;
                        this.expansionInfo = objectArray;
                        n5 += n7;
                    }
                    ++n6;
                }
            }
            ++n4;
        }
        this.sortFilterInfo = nArray;
        this.updateReverseReference();
        this.setExpanding(false);
        this.applyFilterSort();
    }

    protected void applyFilterSort() {
        this.setUpdating(true);
        int[] nArray = (int[])this.sortFilterInfo.clone();
        Object[] objectArray = null;
        if (null != this.expansionInfo) {
            objectArray = new Object[this.expansionInfo.length];
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < nArray.length) {
            if (this.passesFilter(n3)) {
                nArray[n2] = this.sortFilterInfo[n3];
                if (null != this.expansionInfo && null != this.expansionInfo[n3]) {
                    objectArray[n2] = ((int[])this.expansionInfo[n3]).clone();
                }
                ++n2;
            }
            ++n3;
        }
        this.sortFilterInfo = new int[n2];
        this.expansionInfo = (Object[])new int[n2][2];
        System.arraycopy(nArray, 0, this.sortFilterInfo, 0, n2);
        System.arraycopy(objectArray, 0, this.expansionInfo, 0, n2);
        this.updateReverseReference();
        this.applySort();
    }

    protected void applySort() {
        this.setUpdating(true);
        ViewTableColumn[] viewTableColumnArray = this.getSortingColumns();
        if (viewTableColumnArray.length == 0) {
            this.expansionInfo = new Object[this.sortFilterInfo.length];
            int n2 = 0;
            int n3 = 0;
            while (n3 < this.rSortFilterInfo.length) {
                if (this.rSortFilterInfo[n3] >= 0) {
                    this.sortFilterInfo[n2] = n3;
                    ++n2;
                }
                ++n3;
            }
        } else {
            Object object = null;
            int n4 = viewTableColumnArray.length - 1;
            while (n4 >= 0) {
                ViewTableColumn viewTableColumn = viewTableColumnArray[n4];
                if (viewTableColumn != null) {
                    AssistCollator assistCollator = (AssistCollator)AssistCollator.getInstance();
                    AssistKey[] assistKeyArray = new AssistKey[this.sortFilterInfo.length];
                    int n5 = 0;
                    while (n5 < this.sortFilterInfo.length) {
                        object = this.getExpandedValueAt(n5, viewTableColumn.getModelIndex());
                        object = this.table.getOriginalType(viewTableColumn, object);
                        assistKeyArray[n5] = assistCollator.getCollationKey(object, n5);
                        ++n5;
                    }
                    AssistComparator assistComparator = new AssistComparator(16 == viewTableColumn.getSortDirection());
                    Arrays.sort(assistKeyArray, assistComparator);
                    int[] nArray = (int[])this.sortFilterInfo.clone();
                    Object[] objectArray = null;
                    if (null != this.expansionInfo) {
                        objectArray = (Object[])this.expansionInfo.clone();
                        this.expansionInfo = new Object[this.expansionInfo.length];
                    }
                    int n6 = 0;
                    while (n6 < this.sortFilterInfo.length) {
                        int n7 = assistKeyArray[n6].getSourceIndex();
                        this.sortFilterInfo[n6] = nArray[n7];
                        if (null != this.expansionInfo && null != objectArray[n7]) {
                            this.expansionInfo[n6] = objectArray[n7];
                        }
                        ++n6;
                    }
                }
                --n4;
            }
            this.updateReverseReference();
        }
        this.setUpdating(false);
        if (this.fireTableStructureChanged) {
            this.fireTableStructureChanged();
        } else {
            this.fireTableDataChanged();
        }
        this.fireTableStructureChanged = false;
    }

    private String getDisplayableString(Object object) {
        String string = "";
        if (null != object) {
            if (object instanceof ViewIconNameObjectInterface) {
                string = ((ViewIconNameObjectInterface)object).getName();
            } else if (object instanceof Timestamp) {
                DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 2, AssistManager.getPreferredLocale());
                string = dateFormat.format((Timestamp)object);
            } else if (object instanceof Date) {
                DateFormat dateFormat = DateFormat.getDateInstance(2, AssistManager.getPreferredLocale());
                string = dateFormat.format((Date)object);
            } else {
                string = object.toString();
            }
        }
        return string;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        try {
            objectInputStream.defaultReadObject();
            this.listenerList = new EventListenerList();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace(System.err);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

