/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.support;

import com.ibm.db2.tools.common.CmStringPool;
import com.ibm.db2.tools.common.CommonTrace;
import com.ibm.db2.tools.common.ViewTable;
import com.ibm.db2.tools.common.support.ViewObjectColumnSettings;
import com.ibm.db2.tools.common.support.ViewObjectNamedSettings;
import com.ibm.db2.tools.common.support.ViewObjectNamedSettingsSet;
import com.ibm.db2.tools.common.support.ViewTableAbstractModel;
import com.ibm.db2.tools.common.support.ViewTableColumn;
import com.ibm.db2.tools.common.support.ViewTableColumnModel;
import com.ibm.db2.tools.common.support.ViewTableColumnModelEvent;
import com.ibm.db2.tools.common.support.ViewTablePersistencyProvider;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.SwingPropertyChangeSupport;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class ViewTableSettingsCache
implements PropertyChangeListener,
Serializable,
TableColumnModelListener {
    private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected static ViewTablePersistencyProvider persistencyProvider;
    protected String settingsKey;
    protected ViewTable table;
    protected Hashtable hash = new Hashtable();
    ViewObjectNamedSettingsSet currentSettingsSetCache = null;
    Object scopeForCache = null;
    private SwingPropertyChangeSupport changeSupport = new SwingPropertyChangeSupport(this);

    public static void setPersistencyProvider(ViewTablePersistencyProvider viewTablePersistencyProvider) {
        persistencyProvider = viewTablePersistencyProvider;
    }

    public static ViewTablePersistencyProvider getPersistencyProvider() {
        return persistencyProvider;
    }

    public void setSettingsKey(String string) {
        String string2 = this.getSettingsKey();
        if (!this.areEqual(string2, string)) {
            ViewObjectNamedSettingsSet viewObjectNamedSettingsSet = this.getSettingsSet(string, this.getScope());
            this.settingsKey = string;
            this.currentSettingsSetChanged(viewObjectNamedSettingsSet);
            this.changeSupport.firePropertyChange("settingsKey", string2, this.settingsKey);
        }
    }

    public String getSettingsKey() {
        return this.settingsKey;
    }

    public ViewTable getTable() {
        return this.table;
    }

    public void setTable(ViewTable viewTable) {
        ViewTable viewTable2 = this.table;
        if (this.table != viewTable) {
            TableColumn tableColumn;
            Enumeration<TableColumn> enumeration;
            if (null != viewTable2) {
                viewTable2.removePropertyChangeListener(this);
                viewTable2.getColumnModel().removeColumnModelListener(this);
                enumeration = viewTable2.getColumnModel().getColumns();
                while (enumeration.hasMoreElements()) {
                    tableColumn = enumeration.nextElement();
                    tableColumn.removePropertyChangeListener(this);
                }
            }
            this.table = viewTable;
            if (null != this.table) {
                this.table.addPropertyChangeListener(this);
                this.table.getColumnModel().addColumnModelListener(this);
                enumeration = this.table.getColumnModel().getColumns();
                while (enumeration.hasMoreElements()) {
                    tableColumn = enumeration.nextElement();
                    tableColumn.addPropertyChangeListener(this);
                }
            }
        }
    }

    public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
        if (tableColumnModelEvent instanceof ViewTableColumnModelEvent) {
            ViewTableColumn viewTableColumn = (ViewTableColumn)((ViewTableColumnModelEvent)tableColumnModelEvent).getColumn();
            viewTableColumn.addPropertyChangeListener(this);
            if (((ViewTableColumnModelEvent)tableColumnModelEvent).getFromIndex() < 0) {
                this.updateColumnSettings(null);
            }
        }
    }

    public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
        if (tableColumnModelEvent instanceof ViewTableColumnModelEvent) {
            ViewTableColumn viewTableColumn = (ViewTableColumn)((ViewTableColumnModelEvent)tableColumnModelEvent).getColumn();
            viewTableColumn.removePropertyChangeListener(this);
            if (((ViewTableColumnModelEvent)tableColumnModelEvent).getToIndex() < 0 && ((ViewTableColumnModelEvent)tableColumnModelEvent).getFromIndex() >= 0) {
                this.updateColumnSettings(null);
            }
        }
    }

    public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
        this.updateColumnSettings(null, true);
    }

    public void columnMarginChanged(ChangeEvent changeEvent) {
    }

    public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getSource() instanceof ViewTableColumn) {
            this.updateColumnSettings((ViewTableColumn)propertyChangeEvent.getSource(), true);
        }
        if (propertyChangeEvent.getPropertyName().equals("columnModel")) {
            Object object;
            Object object2;
            TableColumnModel tableColumnModel = (TableColumnModel)propertyChangeEvent.getOldValue();
            if (null != tableColumnModel) {
                tableColumnModel.removeColumnModelListener(this);
                object2 = tableColumnModel.getColumns();
                while (object2.hasMoreElements()) {
                    object = (TableColumn)object2.nextElement();
                    ((TableColumn)object).removePropertyChangeListener(this);
                }
            }
            if (null != (object2 = (TableColumnModel)propertyChangeEvent.getNewValue())) {
                object2.addColumnModelListener(this);
                object = object2.getColumns();
                while (object.hasMoreElements()) {
                    TableColumn tableColumn = (TableColumn)object.nextElement();
                    tableColumn.addPropertyChangeListener(this);
                }
            }
            this.updateColumnSettings(null);
        } else if (propertyChangeEvent.getPropertyName().equals("filterEnabled")) {
            this.updateColumnSettings(null);
        } else if (propertyChangeEvent.getPropertyName().equals("currentSettings")) {
            this.saveCurrentSettingsSet();
        }
    }

    public Object getScope() {
        if (null != this.table && this.table.getModel() instanceof ViewTableAbstractModel) {
            return ((ViewTableAbstractModel)this.table.getModel()).getScope();
        }
        return null;
    }

    public ViewObjectColumnSettings getColumnSettings(int n2) {
        ViewObjectColumnSettings viewObjectColumnSettings = null;
        ViewObjectNamedSettings viewObjectNamedSettings = this.getCurrentSettings();
        if (null != viewObjectNamedSettings.getColumnSettings()) {
            viewObjectColumnSettings = viewObjectNamedSettings.getColumnSettings(n2);
        }
        return viewObjectColumnSettings;
    }

    public ViewObjectNamedSettings getCurrentSettings() {
        return this.getNamedSettings()[this.getSettingsSet().getCurrentSettingsIndex()];
    }

    private final ViewObjectNamedSettings[] getNamedSettings() {
        return this.getSettingsSet().getNamedSettings();
    }

    public ViewObjectNamedSettingsSet getSettingsSet() {
        return this.getSettingsSet(this.getSettingsKey(), this.getScope());
    }

    public void setInitialSettingsSet(ViewObjectNamedSettingsSet viewObjectNamedSettingsSet, String string, Object object) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.support", "ViewTableSettingsCache", this, "setInitialSettingsSet(ViewObjectNamedSettingsSet aSettingsSet, String aSettingsKey, Object aScope)", new Object[]{viewObjectNamedSettingsSet, string, object});
        }
        if (null == string || string.trim().equals("")) {
            throw (IllegalArgumentException)CommonTrace.throwException(commonTrace, new IllegalArgumentException("The aSettingsKey parameter cannot be a null or an empty string"));
        }
        this.hash.put(this.getInitialKey(string, object), viewObjectNamedSettingsSet);
        if (this.useCurrent(string, object)) {
            this.currentSettingsSetCache = null;
            this.currentSettingsSetChanged();
        }
        if (CommonTrace.isTrace()) {
            // empty if block
        }
        CommonTrace.exit(commonTrace);
    }

    private final ViewObjectNamedSettingsSet getSettingsSet(String string, Object object) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.support", "ViewTableSettingsCache", this, "getSettingsSet(String aSettingsKey, Object aScope)", new Object[]{string, object});
        }
        ViewObjectNamedSettingsSet viewObjectNamedSettingsSet = null;
        if (null != string && !string.trim().equals("")) {
            if (this.useCurrent(string, object) && this.areEqual(this.getScope(), this.scopeForCache) && null != this.currentSettingsSetCache) {
                viewObjectNamedSettingsSet = this.currentSettingsSetCache;
            } else {
                ViewObjectNamedSettings[] viewObjectNamedSettingsArray = null;
                int n2 = 0;
                ViewObjectNamedSettingsSet viewObjectNamedSettingsSet2 = this.getCustomSettingsSet(string, object);
                if (null != viewObjectNamedSettingsSet2 && null != (viewObjectNamedSettingsArray = viewObjectNamedSettingsSet2.getNamedSettings())) {
                    n2 = viewObjectNamedSettingsArray.length;
                }
                ViewObjectNamedSettings[] viewObjectNamedSettingsArray2 = null;
                int n3 = 0;
                ViewObjectNamedSettingsSet viewObjectNamedSettingsSet3 = this.getInitialSettingsSet(string, object);
                if (null != viewObjectNamedSettingsSet3 && null != (viewObjectNamedSettingsArray2 = viewObjectNamedSettingsSet3.getNamedSettings())) {
                    n3 = viewObjectNamedSettingsArray2.length;
                }
                viewObjectNamedSettingsSet = null;
                ViewObjectNamedSettings[] viewObjectNamedSettingsArray3 = null;
                if (n2 > 0 && 0 <= viewObjectNamedSettingsSet2.getCurrentSettingsIndex() && viewObjectNamedSettingsSet2.getCurrentSettingsIndex() < n2) {
                    boolean bl = true;
                    int n4 = n3 + 1;
                    while (n4 < n2) {
                        if (1 == n4 && null == viewObjectNamedSettingsArray[n4]) {
                            viewObjectNamedSettingsArray[n4] = this.getDefaultView().getNamedSettings(1);
                        } else if (null == viewObjectNamedSettingsArray[n4] || null == viewObjectNamedSettingsArray[n4].getName() || viewObjectNamedSettingsArray[n4].getName().trim().equals("")) {
                            bl = false;
                            break;
                        }
                        ++n4;
                    }
                    if (bl) {
                        viewObjectNamedSettingsSet = (ViewObjectNamedSettingsSet)viewObjectNamedSettingsSet2.clone();
                        viewObjectNamedSettingsArray3 = viewObjectNamedSettingsSet.getNamedSettings();
                    }
                }
                if (null == viewObjectNamedSettingsSet || null == viewObjectNamedSettingsArray3 || viewObjectNamedSettingsArray3.length < n3 + 1) {
                    if (n3 > 0) {
                        viewObjectNamedSettingsSet = new ViewObjectNamedSettingsSet();
                        viewObjectNamedSettingsArray3 = new ViewObjectNamedSettings[n3 + 1];
                    } else {
                        viewObjectNamedSettingsSet = this.getDefaultView();
                        viewObjectNamedSettingsArray3 = viewObjectNamedSettingsSet.getNamedSettings();
                    }
                }
                if (n3 > 0) {
                    System.arraycopy(viewObjectNamedSettingsArray2, 0, viewObjectNamedSettingsArray3, 1, n3);
                    if (0 == n2) {
                        viewObjectNamedSettingsSet.setCurrentSettingsIndex(viewObjectNamedSettingsSet3.getCurrentSettingsIndex() + 1);
                    }
                    viewObjectNamedSettingsSet.setFirstCustomSettingsIndex(n3 + 1);
                }
                viewObjectNamedSettingsSet.setNamedSettings(viewObjectNamedSettingsArray3);
                this.currentSettingsSetChanged(viewObjectNamedSettingsSet);
            }
        } else {
            viewObjectNamedSettingsSet = this.getDefaultView();
        }
        return (ViewObjectNamedSettingsSet)CommonTrace.exit(commonTrace, viewObjectNamedSettingsSet);
    }

    private final ViewObjectNamedSettingsSet getInitialSettingsSet(String string, Object object) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.support", "ViewTableSettingsCache", this, "getInitialSettingsSet(String aSettingsKey, Object aScope)", new Object[]{string, object});
        }
        if (null == string || string.trim().equals("")) {
            throw (IllegalArgumentException)CommonTrace.throwException(commonTrace, new IllegalArgumentException("The aSettingsKey parameter cannot be a null or an empty string"));
        }
        ViewObjectNamedSettingsSet viewObjectNamedSettingsSet = (ViewObjectNamedSettingsSet)this.hash.get(this.getInitialKey(string, object));
        return (ViewObjectNamedSettingsSet)CommonTrace.exit(commonTrace, viewObjectNamedSettingsSet);
    }

    private final ViewObjectNamedSettingsSet getCustomSettingsSet(String string, Object object) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.support", "ViewTableSettingsCache", this, "getCustomSettingsSet(String aSettingsKey, Object aScope)", new Object[]{string, object});
        }
        if (null == string || string.trim().equals("")) {
            throw (IllegalArgumentException)CommonTrace.throwException(commonTrace, new IllegalArgumentException("The aSettingsKey parameter cannot be a null or an empty string"));
        }
        ViewObjectNamedSettingsSet viewObjectNamedSettingsSet = null;
        if (null != persistencyProvider) {
            viewObjectNamedSettingsSet = persistencyProvider.getSettings(this.getCustomKey(string, object));
        } else {
            if (CommonTrace.isTrace()) {
                CommonTrace.write(commonTrace, "The persistencyProvider is not set. Using the hash for now");
            }
            viewObjectNamedSettingsSet = (ViewObjectNamedSettingsSet)this.hash.get(this.getCustomKey(string, object));
        }
        return (ViewObjectNamedSettingsSet)CommonTrace.exit(commonTrace, viewObjectNamedSettingsSet);
    }

    protected void saveCurrentSettingsSet() {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.support", "ViewTableSettingsCache", this, "saveCurrentSettingsSet()");
        }
        if (null == this.getSettingsKey() || this.getSettingsKey().trim().equals("")) {
            throw (IllegalArgumentException)CommonTrace.throwException(commonTrace, new IllegalArgumentException("The aSettingsKey parameter cannot be a null or an empty string"));
        }
        if (null != this.currentSettingsSetCache) {
            ViewObjectNamedSettingsSet viewObjectNamedSettingsSet = (ViewObjectNamedSettingsSet)this.currentSettingsSetCache.clone();
            int n2 = viewObjectNamedSettingsSet.getFirstCustomSettingsIndex();
            ViewObjectNamedSettings[] viewObjectNamedSettingsArray = viewObjectNamedSettingsSet.getNamedSettings();
            if (viewObjectNamedSettingsArray.length > 1) {
                int n3 = Math.min(n2, viewObjectNamedSettingsArray.length);
                int n4 = 1;
                while (n4 < n3) {
                    viewObjectNamedSettingsArray[n4] = null;
                    ++n4;
                }
            }
            if (null != persistencyProvider) {
                persistencyProvider.putSettings(this.getCustomKey(this.getSettingsKey(), this.getScope()), viewObjectNamedSettingsSet);
            } else {
                if (CommonTrace.isTrace()) {
                    CommonTrace.write(commonTrace, "The persistencyProvider is not set. Using the hash for now");
                }
                this.hash.put(this.getCustomKey(this.getSettingsKey(), this.getScope()), viewObjectNamedSettingsSet);
            }
        }
        CommonTrace.exit(commonTrace);
    }

    public final void currentSettingsSetChanged() {
        this.currentSettingsSetChanged(this.getSettingsSet());
    }

    private final void currentSettingsSetChanged(ViewObjectNamedSettingsSet viewObjectNamedSettingsSet) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.support", "ViewTableSettingsCache", this, "currentSettingsSetChanged(ViewObjectNamedSettingsSet newSettingsSet)", new Object[]{viewObjectNamedSettingsSet});
        }
        if (null == viewObjectNamedSettingsSet) {
            throw (IllegalArgumentException)CommonTrace.throwException(commonTrace, new IllegalArgumentException("The newSettingsSet parameter cannot be a null."));
        }
        ViewObjectNamedSettingsSet viewObjectNamedSettingsSet2 = this.currentSettingsSetCache;
        if (viewObjectNamedSettingsSet != viewObjectNamedSettingsSet2) {
            if (null != viewObjectNamedSettingsSet2) {
                viewObjectNamedSettingsSet2.removePropertyChangeListener(this);
            }
            this.currentSettingsSetCache = viewObjectNamedSettingsSet;
            this.scopeForCache = this.getScope();
            viewObjectNamedSettingsSet.addPropertyChangeListener(this);
            this.changeSupport.firePropertyChange("currentSettingsSet", viewObjectNamedSettingsSet2, viewObjectNamedSettingsSet);
        }
        CommonTrace.exit(commonTrace);
    }

    private final void updateColumnSettings(ViewTableColumn viewTableColumn) {
        this.updateColumnSettings(viewTableColumn, false);
    }

    private final void updateColumnSettings(ViewTableColumn viewTableColumn, boolean bl) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.support", "ViewTableSettingsCache", this, "updateColumnSettings(ViewTableColumn column, boolean fromTable)", new Object[]{viewTableColumn, new Boolean(bl)});
        }
        if (null != this.getSettingsKey() && !this.getSettingsKey().trim().equals("")) {
            ViewObjectNamedSettingsSet viewObjectNamedSettingsSet = this.getSettingsSet();
            int n2 = viewObjectNamedSettingsSet.getCurrentSettingsIndex();
            ViewObjectNamedSettings viewObjectNamedSettings = viewObjectNamedSettingsSet.getNamedSettings()[n2];
            ViewObjectNamedSettings viewObjectNamedSettings2 = 0 == n2 ? viewObjectNamedSettings : (ViewObjectNamedSettings)viewObjectNamedSettings.clone();
            if (null == viewObjectNamedSettings2.getColumnSettings()) {
                viewObjectNamedSettings2.setColumnSettings(new ViewObjectColumnSettings[this.table.getModel().getColumnCount()]);
            }
            ViewObjectColumnSettings viewObjectColumnSettings = null;
            if (CommonTrace.isTrace()) {
                CommonTrace.write(commonTrace, "Saving the column settings:");
            }
            viewObjectNamedSettings2.setFilterEnabled(((ViewTableColumnModel)this.table.getColumnModel()).isFilterEnabled());
            int n3 = this.table.getColumnModel().getColumnCount();
            int n4 = 0;
            while (n4 < n3) {
                viewTableColumn = (ViewTableColumn)this.table.getColumnModel().getColumn(n4);
                viewObjectColumnSettings = viewTableColumn.getColumnSettings();
                viewObjectColumnSettings.setVisibleOrdinal(n4 + 1);
                if (CommonTrace.isTrace()) {
                    CommonTrace.write(commonTrace, "  " + viewTableColumn.getClass() + "  " + viewTableColumn.getModelIndex() + "  " + viewObjectColumnSettings.getVisibleOrdinal() + "  " + viewTableColumn.getHeaderValue());
                }
                viewObjectNamedSettings2.setColumnSettings(viewTableColumn.getModelIndex(), viewObjectColumnSettings);
                ++n4;
            }
            n3 = ((ViewTableColumnModel)this.table.getColumnModel()).getHiddenColumnCount();
            int n5 = -1;
            Enumeration enumeration = ((ViewTableColumnModel)this.table.getColumnModel()).getHiddenColumns();
            while (enumeration.hasMoreElements()) {
                viewTableColumn = (ViewTableColumn)enumeration.nextElement();
                viewObjectColumnSettings = viewTableColumn.getColumnSettings();
                viewObjectColumnSettings.setVisibleOrdinal(n5);
                if (CommonTrace.isTrace()) {
                    CommonTrace.write(commonTrace, "  " + viewTableColumn.getClass() + "  " + viewTableColumn.getModelIndex() + "  " + viewObjectColumnSettings.getVisibleOrdinal() + "  " + viewTableColumn.getHeaderValue());
                }
                viewObjectNamedSettings2.setColumnSettings(viewTableColumn.getModelIndex(), viewObjectColumnSettings);
                --n5;
            }
            if (n2 != 0) {
                viewObjectNamedSettings2.setName(viewObjectNamedSettings.getName() + "*");
                viewObjectNamedSettingsSet.setNamedSettings(0, viewObjectNamedSettings2);
                viewObjectNamedSettingsSet.setCurrentSettingsIndex(0, true);
            }
            viewObjectNamedSettings = viewObjectNamedSettings2;
            this.saveCurrentSettingsSet();
        }
        if (CommonTrace.isTrace()) {
            // empty if block
        }
        CommonTrace.exit(commonTrace);
    }

    private ViewObjectNamedSettingsSet getDefaultView() {
        ViewObjectNamedSettingsSet viewObjectNamedSettingsSet = new ViewObjectNamedSettingsSet();
        ViewObjectNamedSettings[] viewObjectNamedSettingsArray = new ViewObjectNamedSettings[2];
        viewObjectNamedSettingsArray[1] = new ViewObjectNamedSettings();
        viewObjectNamedSettingsArray[1].setName(CmStringPool.get(101));
        viewObjectNamedSettingsSet.setNamedSettings(viewObjectNamedSettingsArray);
        viewObjectNamedSettingsSet.setFirstCustomSettingsIndex(2);
        viewObjectNamedSettingsSet.setCurrentSettingsIndex(1);
        return viewObjectNamedSettingsSet;
    }

    private final String getInitialKey(String string, Object object) {
        return "I_" + string + "_" + object;
    }

    private final String getCustomKey(String string, Object object) {
        return string + "_" + object;
    }

    private final boolean useCurrent(String string, Object object) {
        return this.areEqual(string, this.getSettingsKey()) && this.areEqual(object, this.getScope());
    }

    private final boolean areEqual(Object object, Object object2) {
        boolean bl = null == object ? (null == object2 ? true : object2.equals(object)) : (null == object2 ? false : object.equals(object2));
        return bl;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.removePropertyChangeListener(propertyChangeListener);
    }
}

