/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.support;

import com.ibm.db2.tools.common.CommonImageRepository;
import com.ibm.db2.tools.common.ViewTable;
import com.ibm.db2.tools.common.support.AssistManager;
import com.ibm.db2.tools.common.support.ViewIconNameObjectInterface;
import com.ibm.db2.tools.common.support.ViewTableColumn;
import com.ibm.db2.tools.common.support.ViewTableColumnModel;
import com.ibm.db2.tools.common.support.ViewTableSortFilterModel;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class ViewTableRollupModel
extends AbstractTableModel
implements TableModelListener,
KeyListener,
MouseListener {
    private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected static final ImageIcon expandedImg = CommonImageRepository.getCommonIcon(CommonImageRepository.NESTED_EXPANDED_IMAGE);
    protected static final ImageIcon contractedImg = CommonImageRepository.getCommonIcon(CommonImageRepository.NESTED_CONTRACTED_IMAGE);
    protected ViewTableSortFilterModel sortFilterModel;
    protected ViewTableColumnModel columnModel;
    protected ViewTable table;
    ViewTableColumn[] rollupColumns = new ViewTableColumn[0];
    protected int[] rollupRows = new int[0];
    protected Hashtable collapsedRows;
    protected int[] visibleRows = new int[0];
    protected boolean updating = false;
    protected boolean fireTableStructureChanged = false;
    static /* synthetic */ Class class$javax$swing$event$TableModelListener;

    public int getRowCount() {
        if (this.isUpdating()) {
            return this.sortFilterModel.getRowCount();
        }
        return this.visibleRows.length;
    }

    public int getColumnCount() {
        return this.sortFilterModel.getColumnCount();
    }

    public String getColumnName(int n2) {
        return this.sortFilterModel.getColumnName(n2);
    }

    public Class getColumnClass(int n2) {
        return this.sortFilterModel.getColumnClass(n2);
    }

    public boolean isCellEditable(int n2, int n3) {
        if (this.isUpdating()) {
            return this.sortFilterModel.isCellEditable(n2, n3);
        }
        if (this.getRowIndex(n2) >= 0) {
            ViewTableColumn viewTableColumn = (ViewTableColumn)this.columnModel.getColumn(this.convertColumnIndexToView(n3));
            if (viewTableColumn.getSortDirection() != 1 && viewTableColumn.isRollup()) {
                return false;
            }
            return this.sortFilterModel.isCellEditable(this.getRowIndex(n2), n3);
        }
        return false;
    }

    public Object getValueAt(int n2, int n3) {
        if (this.isUpdating()) {
            return this.sortFilterModel.getValueAt(n2, n3);
        }
        int n4 = this.convertColumnIndexToView(n3);
        ViewTableColumn viewTableColumn = (ViewTableColumn)this.columnModel.getColumn(n4);
        if (this.getRowIndex(n2) >= 0) {
            if (viewTableColumn.getSortDirection() != 1 && viewTableColumn.isRollup()) {
                return null;
            }
            return this.sortFilterModel.getValueAt(this.getRowIndex(n2), n3);
        }
        int n5 = -this.getRowIndex(n2) - 1;
        int n6 = this.convertColumnIndexToView(n5);
        if (viewTableColumn.getModelIndex() == n5) {
            final String string = this.getUniqueString(this.sortFilterModel.getValueAt(this.rollupRows[this.getRollupLastExpandableRow(this.visibleRows[n2], this.rollupRows)], n5));
            final ImageIcon imageIcon = this.collapsedRows != null && this.collapsedRows.containsKey(this.getKeyForRow(this.visibleRows[n2], this.rollupRows)) ? contractedImg : expandedImg;
            return new ViewIconNameObjectInterface(){

                public Icon getIcon() {
                    return imageIcon;
                }

                public String getName() {
                    return string;
                }
            };
        }
        return null;
    }

    public void setValueAt(Object object, int n2, int n3) {
        if (this.isUpdating()) {
            this.sortFilterModel.setValueAt(object, n2, n3);
        } else {
            ViewTableColumn viewTableColumn = (ViewTableColumn)this.columnModel.getColumn(this.convertColumnIndexToView(n3));
            if (this.getRowIndex(n2) >= 0) {
                if (viewTableColumn.getSortDirection() != 1 && viewTableColumn.isRollup()) {
                    return;
                }
                this.sortFilterModel.setValueAt(object, this.getRowIndex(n2), n3);
            } else {
                return;
            }
        }
    }

    private String getUniqueString(Object object) {
        String string = "";
        if (null != object) {
            if (object instanceof ViewIconNameObjectInterface) {
                string = ((ViewIconNameObjectInterface)object).getName();
            } else if (object instanceof Timestamp) {
                DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 2, AssistManager.getPreferredLocale());
                string = dateFormat.format((Timestamp)object);
            } else if (object instanceof Date) {
                DateFormat dateFormat = DateFormat.getDateInstance(2, AssistManager.getPreferredLocale());
                string = dateFormat.format((Date)object);
            } else {
                string = object.toString();
            }
        }
        return string;
    }

    public int[] getModelIndices(int[] nArray) {
        int n2;
        int n3;
        Vector vector = new Vector();
        boolean[] blArray = new boolean[this.sortFilterModel.getModel().getRowCount()];
        Arrays.fill(blArray, false);
        int n4 = 0;
        while (n4 < nArray.length) {
            int n5 = this.getRowIndex(nArray[n4]);
            if (n5 >= 0) {
                blArray[this.getSortFilterModel().getRowIndex((int)n5)] = true;
            } else {
                int n6 = this.rollupRows[this.getRollupLastExpandableRow(this.visibleRows[nArray[n4]], this.rollupRows)];
                n2 = n3 = this.rollupRows[this.getRollupFirstExpandableRow(this.visibleRows[nArray[n4]], this.rollupRows)];
                while (n2 <= n6) {
                    blArray[this.getSortFilterModel().getRowIndex((int)n2)] = true;
                    ++n2;
                }
            }
            ++n4;
        }
        int[] nArray2 = new int[blArray.length];
        n3 = 0;
        n2 = 0;
        while (n2 < blArray.length) {
            if (blArray[n2]) {
                nArray2[n3] = n2;
                ++n3;
            }
            ++n2;
        }
        int[] nArray3 = new int[n3];
        System.arraycopy(nArray2, 0, nArray3, 0, n3);
        return nArray3;
    }

    public int getRowIndex(int n2) {
        if (this.isUpdating()) {
            return n2;
        }
        return this.rollupRows[this.visibleRows[n2]];
    }

    public void collapseAll() {
        if (this.collapsedRows == null) {
            this.collapsedRows = new Hashtable();
        }
        int n2 = 0;
        while (n2 < this.getRowCount()) {
            if (this.getRowIndex(n2) < 0) {
                this.collapsedRows.put(this.getKeyForRow(this.visibleRows[n2], this.rollupRows), new Object());
            }
            ++n2;
        }
        this.applyCollapse(this.rollupRows);
        this.table.revalidate();
        this.table.repaint();
    }

    public void expandAll() {
        if (this.collapsedRows != null) {
            int n2 = 0;
            while (n2 < this.rollupRows.length) {
                if (this.rollupRows[n2] < 0) {
                    this.collapsedRows.remove(this.getKeyForRow(n2, this.rollupRows));
                }
                ++n2;
            }
            this.applyCollapse(this.rollupRows);
            this.table.revalidate();
            this.table.repaint();
        }
    }

    public void setSortFilterModel(ViewTableSortFilterModel viewTableSortFilterModel) {
        ViewTableSortFilterModel viewTableSortFilterModel2 = this.sortFilterModel;
        if (viewTableSortFilterModel == null) {
            throw new IllegalArgumentException("Cannot set a null ViewTableSortFilterModel");
        }
        if (viewTableSortFilterModel != viewTableSortFilterModel2) {
            if (null != viewTableSortFilterModel2) {
                viewTableSortFilterModel2.removeTableModelListener(this);
            }
            this.setUpdating(true);
            this.sortFilterModel = viewTableSortFilterModel;
            this.columnModel = (ViewTableColumnModel)this.sortFilterModel.getColumnModel();
            this.applyRollup();
            this.sortFilterModel.addTableModelListener(this);
        }
    }

    public ViewTableSortFilterModel getSortFilterModel() {
        return this.sortFilterModel;
    }

    public void setTable(ViewTable viewTable) {
        if (viewTable == null) {
            throw new IllegalArgumentException("Cannot set a null ViewTable");
        }
        this.table = viewTable;
    }

    public ViewTable getTable() {
        return this.table;
    }

    public boolean isUpdating() {
        return this.updating || this.getSortFilterModel().isUpdating();
    }

    protected void setUpdating(boolean bl) {
        this.updating = bl;
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        this.setUpdating(true);
        if (null == tableModelEvent || tableModelEvent.getFirstRow() == -1) {
            this.fireTableStructureChanged = true;
            Object[] objectArray = this.listenerList.getListenerList();
            int n2 = objectArray.length - 2;
            while (n2 >= 0) {
                if (objectArray[n2] == (class$javax$swing$event$TableModelListener == null ? ViewTableRollupModel.class$("javax.swing.event.TableModelListener") : class$javax$swing$event$TableModelListener) && objectArray[n2 + 1] instanceof ViewTable) {
                    this.setUpdating(true);
                    ((TableModelListener)objectArray[n2 + 1]).tableChanged(tableModelEvent);
                }
                n2 -= 2;
            }
        } else {
            this.applyRollup();
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n2 = this.table.getSelectionModel().getAnchorSelectionIndex();
        int n3 = this.table.getColumnModel().getSelectionModel().getAnchorSelectionIndex();
        if (n2 >= 0 && n3 >= 0) {
            int n4 = -this.getRowIndex(n2) - 1;
            ViewTableColumn viewTableColumn = (ViewTableColumn)this.columnModel.getColumn(n3);
            int n5 = viewTableColumn.getModelIndex();
            if (n5 == n4 && viewTableColumn.getSortDirection() != 1 && viewTableColumn.isRollup()) {
                if (null == this.collapsedRows) {
                    this.collapsedRows = new Hashtable();
                }
                String string = this.getKeyForRow(this.visibleRows[n2], this.rollupRows);
                boolean bl = false;
                if (0 == keyEvent.getModifiers()) {
                    if (39 == keyEvent.getKeyCode()) {
                        if (null != this.collapsedRows.remove(string)) {
                            bl = true;
                        }
                    } else if (37 == keyEvent.getKeyCode() && null == this.collapsedRows.put(string, new Object())) {
                        bl = true;
                    }
                }
                if (bl) {
                    keyEvent.consume();
                    this.applyCollapse(this.rollupRows);
                    ((JTable)keyEvent.getComponent()).revalidate();
                    ((JTable)keyEvent.getComponent()).repaint();
                }
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        int n2 = ((JTable)mouseEvent.getComponent()).rowAtPoint(mouseEvent.getPoint());
        int n3 = ((JTable)mouseEvent.getComponent()).columnAtPoint(mouseEvent.getPoint());
        if (n2 < 0) {
            return;
        }
        int n4 = -this.getRowIndex(n2) - 1;
        ViewTableColumn viewTableColumn = (ViewTableColumn)this.columnModel.getColumn(n3);
        int n5 = viewTableColumn.getModelIndex();
        if (n5 == n4 && viewTableColumn.getSortDirection() != 1 && viewTableColumn.isRollup()) {
            String string;
            if (null == this.collapsedRows) {
                this.collapsedRows = new Hashtable();
            }
            if (null == this.collapsedRows.remove(string = this.getKeyForRow(this.visibleRows[n2], this.rollupRows))) {
                this.collapsedRows.put(string, new Object());
            }
            this.applyCollapse(this.rollupRows);
        }
        ((JTable)mouseEvent.getComponent()).revalidate();
        ((JTable)mouseEvent.getComponent()).repaint();
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void fireTableChanged(TableModelEvent tableModelEvent) {
        if (tableModelEvent == null || tableModelEvent.getFirstRow() == -1) {
            Object[] objectArray = this.listenerList.getListenerList();
            int n2 = objectArray.length - 2;
            while (n2 >= 0) {
                if (objectArray[n2] == (class$javax$swing$event$TableModelListener == null ? ViewTableRollupModel.class$("javax.swing.event.TableModelListener") : class$javax$swing$event$TableModelListener)) {
                    if (objectArray[n2 + 1] instanceof ViewTable) {
                        ((TableModelListener)objectArray[n2 + 1]).tableChanged(new TableModelEvent((TableModel)tableModelEvent.getSource()));
                    } else {
                        ((TableModelListener)objectArray[n2 + 1]).tableChanged(tableModelEvent);
                    }
                }
                n2 -= 2;
            }
        } else {
            super.fireTableChanged(tableModelEvent);
        }
    }

    public int convertColumnIndexToView(int n2) {
        if (n2 < 0) {
            return n2;
        }
        int n3 = 0;
        while (n3 < this.getColumnCount()) {
            if (this.columnModel.getColumn(n3).getModelIndex() == n2) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    protected int getRollupFirstExpandableRow(int n2, int[] nArray) {
        int n3 = nArray[n2];
        if (n3 >= 0) {
            throw new IllegalArgumentException("The parameter should be a virtual row.");
        }
        int n4 = -1;
        int n5 = n2 + 1;
        while (n5 < nArray.length) {
            if (nArray[n5] >= 0) {
                n4 = n5;
                break;
            }
            ++n5;
        }
        return n4;
    }

    protected int getRollupLastExpandableRow(int n2, int[] nArray) {
        int n3 = nArray[n2];
        if (n3 >= 0) {
            throw new IllegalArgumentException("The parameter should be a virtual row.");
        }
        n3 = -n3 - 1;
        int n4 = nArray.length - 1;
        int n5 = n2 + 1;
        while (n5 < nArray.length) {
            int n6 = nArray[n5];
            if (n6 < 0 && this.rollupColumns[n6 = -n6 - 1].getSortOrdinal() <= this.rollupColumns[n3].getSortOrdinal()) {
                n4 = n5 - 1;
                break;
            }
            ++n5;
        }
        return n4;
    }

    protected String getKeyForRow(int n2, int[] nArray) {
        int n3 = nArray[n2];
        if (n3 >= 0) {
            throw new IllegalArgumentException("The parameter should be a virtual row.");
        }
        n3 = -n3 - 1;
        int n4 = this.getRollupLastExpandableRow(n2, nArray);
        int n5 = this.rollupColumns[n3].getSortOrdinal();
        Enumeration enumeration = this.columnModel.getAllColumns();
        StringBuffer stringBuffer = new StringBuffer();
        while (enumeration.hasMoreElements()) {
            ViewTableColumn viewTableColumn = (ViewTableColumn)enumeration.nextElement();
            int n6 = viewTableColumn.getSortOrdinal();
            if (viewTableColumn.getSortDirection() == 1 || n6 <= 0 || n6 > n5) continue;
            stringBuffer.append(" - ");
            stringBuffer.append(this.getUniqueString(this.sortFilterModel.getValueAt(nArray[n4], viewTableColumn.getModelIndex())));
        }
        return stringBuffer.toString();
    }

    protected void applyCollapse(int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        int n2 = 0;
        int n3 = 0;
        while (n3 < nArray.length) {
            nArray2[n2] = n3;
            if (nArray[n3] < 0) {
                String string = this.getKeyForRow(n3, nArray);
                if (this.collapsedRows != null && this.collapsedRows.containsKey(string)) {
                    int n4;
                    n3 = n4 = this.getRollupLastExpandableRow(n3, nArray);
                }
            }
            ++n2;
            ++n3;
        }
        int[] nArray3 = new int[n2];
        int n5 = 0;
        while (n5 < n2) {
            nArray3[n5] = nArray2[n5];
            ++n5;
        }
        this.visibleRows = new int[0];
        this.rollupRows = nArray;
        this.visibleRows = nArray3;
    }

    protected void applyRollup() {
        this.setUpdating(true);
        if (null != this.columnModel && null != this.sortFilterModel) {
            int n2;
            Object object;
            ViewTableColumn[] viewTableColumnArray;
            Object[] objectArray = new Object[this.sortFilterModel.getRowCount()];
            this.rollupColumns = new ViewTableColumn[this.columnModel.getAllColumnCount()];
            int n3 = 0;
            Enumeration enumeration = this.columnModel.getAllColumns();
            while (enumeration.hasMoreElements()) {
                viewTableColumnArray = (ViewTableColumn[])enumeration.nextElement();
                if (viewTableColumnArray.getSortDirection() == 1 || !viewTableColumnArray.isRollup()) continue;
                this.rollupColumns[viewTableColumnArray.getModelIndex()] = viewTableColumnArray;
                ++n3;
            }
            viewTableColumnArray = new ViewTableColumn[n3 + 1];
            int n4 = 0;
            while (n4 < this.rollupColumns.length) {
                if (null != this.rollupColumns[n4]) {
                    viewTableColumnArray[this.rollupColumns[n4].getSortOrdinal()] = this.rollupColumns[n4];
                }
                ++n4;
            }
            int n5 = 0;
            int n6 = 1;
            while (n6 < viewTableColumnArray.length) {
                object = viewTableColumnArray[n6];
                Object object2 = null;
                Object object3 = null;
                if (null != object) {
                    int n7 = -1;
                    while (n7 < this.sortFilterModel.getRowCount() - 1) {
                        if (n7 > -1) {
                            object2 = this.table.getOriginalType((TableColumn)object, this.sortFilterModel.getValueAt(n7, ((TableColumn)object).getModelIndex()));
                            object3 = this.table.getOriginalType((TableColumn)object, this.sortFilterModel.getValueAt(n7 + 1, ((TableColumn)object).getModelIndex()));
                        } else {
                            object2 = object3 = this.table.getOriginalType((TableColumn)object, this.sortFilterModel.getValueAt(n7 + 1, ((TableColumn)object).getModelIndex()));
                        }
                        if (-1 == n7 || null == object2 && null != object3 || null != object2 && !object2.equals(object3)) {
                            if (null == objectArray[n7 + 1]) {
                                objectArray[n7 + 1] = new int[this.columnModel.getAllColumnCount() + 1];
                            }
                            n2 = ((ViewTableColumn)object).getSortOrdinal();
                            while (n2 < viewTableColumnArray.length) {
                                if (0 == ((int[])objectArray[n7 + 1])[viewTableColumnArray[n2].getModelIndex()]) {
                                    ((int[])objectArray[n7 + 1])[viewTableColumnArray[n2].getModelIndex()] = -viewTableColumnArray[n2].getModelIndex() - 1;
                                    ++n5;
                                }
                                ++n2;
                            }
                        }
                        ++n7;
                    }
                }
                ++n6;
            }
            object = new int[this.sortFilterModel.getRowCount() + n5];
            int n8 = 0;
            int n9 = 0;
            while (n9 < this.sortFilterModel.getRowCount()) {
                if (objectArray[n9] != null) {
                    int n10;
                    int[] nArray = new int[viewTableColumnArray.length];
                    n2 = 0;
                    int n11 = 0;
                    while (n11 < ((int[])objectArray[n9]).length) {
                        n10 = ((int[])objectArray[n9])[n11];
                        if (n10 < 0) {
                            int n12 = -n10 - 1;
                            nArray[this.rollupColumns[n12].getSortOrdinal()] = n10;
                            ++n2;
                        }
                        ++n11;
                    }
                    n10 = 0;
                    while (n10 < nArray.length) {
                        if (nArray[n10] < 0) {
                            object[n8] = nArray[n10];
                            ++n8;
                        }
                        ++n10;
                    }
                }
                object[n8] = n9;
                ++n8;
                ++n9;
            }
            this.applyCollapse((int[])object);
        } else {
            this.visibleRows = new int[0];
        }
        this.setUpdating(false);
        if (this.fireTableStructureChanged) {
            this.fireTableStructureChanged();
        } else {
            this.fireTableDataChanged();
        }
        this.fireTableStructureChanged = false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

