/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.support;

import com.ibm.db2.tools.common.support.ViewObjectAction;
import com.ibm.db2.tools.common.support.ViewObjectColumnSettings;
import com.ibm.db2.tools.common.support.ViewObjectInterface;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Vector;

public class ViewTableObject
implements ViewObjectInterface,
Serializable {
    private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected static final ViewTableObject mySharedInstance = new ViewTableObject();
    protected static HashMap myColumnNames = new HashMap(27);
    protected static HashMap myEditableCols = new HashMap(27);
    protected static HashMap myActions = new HashMap(27);
    protected HashMap columnSettings;
    private static int myScope = 0;
    protected Object[] myDataArray;

    private ViewTableObject() {
    }

    public ViewTableObject(Object[] objectArray) {
        this.myDataArray = objectArray;
    }

    public ViewTableObject(Vector vector) {
        int n2 = vector.size();
        this.myDataArray = new Object[n2];
        int n3 = 0;
        while (n3 < n2) {
            this.myDataArray[n3] = vector.get(n3);
            ++n3;
        }
    }

    public static ViewTableObject sharedInstance() {
        return mySharedInstance;
    }

    public static Integer getScope() {
        return new Integer(myScope++);
    }

    public static Object setColumns(String[] stringArray) {
        Integer n2 = ViewTableObject.getScope();
        ViewTableObject.setColumns(n2, stringArray);
        return n2;
    }

    public static void setColumns(Object object, String[] stringArray) {
        myColumnNames.put(object, stringArray);
        myEditableCols.put(object, new boolean[stringArray.length]);
    }

    public static void setEditable(Object object, int n2, boolean bl) {
        boolean[] blArray = (boolean[])myEditableCols.get(object);
        if (blArray == null) {
            System.err.println("Internal error: setColumns first.");
        } else if (blArray.length < n2) {
            System.err.println("Internal error: Too few columns.");
        } else {
            blArray[n2] = bl;
        }
    }

    public Object getData(int n2, Object object) {
        if (null == this.myDataArray) {
            return null;
        }
        if (n2 >= this.myDataArray.length) {
            return null;
        }
        return this.myDataArray[n2];
    }

    public void setData(Object object, int n2, Object object2) {
        this.myDataArray[n2] = object;
    }

    public String[] getColumnNames(Object object) {
        return (String[])myColumnNames.get(object);
    }

    public ViewObjectColumnSettings[] getColumnSettings(Object object) {
        if (this.columnSettings == null) {
            return null;
        }
        return (ViewObjectColumnSettings[])this.columnSettings.get(object);
    }

    public void setColumnSettings(Object object, ViewObjectColumnSettings[] viewObjectColumnSettingsArray) {
        if (this.columnSettings == null) {
            this.columnSettings = new HashMap(27);
        }
        this.columnSettings.put(object, viewObjectColumnSettingsArray);
    }

    public ViewObjectAction[] getActions(Object object) {
        return (ViewObjectAction[])myActions.get(object);
    }

    public void setActions(ViewObjectAction[] viewObjectActionArray, Object object) {
        if (viewObjectActionArray == null && myActions.containsKey(object)) {
            myActions.remove(object);
        } else {
            myActions.put(object, viewObjectActionArray);
        }
    }

    public boolean isEditable(int n2, Object object) {
        return ViewTableObject.isColumnEditable(n2, object);
    }

    public static boolean isColumnEditable(int n2, Object object) {
        boolean[] blArray = (boolean[])myEditableCols.get(object);
        if (blArray == null) {
            System.err.println("Internal error: setColumns first.");
            return false;
        }
        if (blArray.length < n2) {
            System.err.println("Internal error: Too few columns.");
            return false;
        }
        return blArray[n2];
    }
}

