/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.support;

import com.ibm.db2.tools.common.CommonTrace;
import com.ibm.db2.tools.common.support.ViewObjectColumnsInterface;
import com.ibm.db2.tools.common.support.ViewObjectDataInterface;
import com.ibm.db2.tools.common.support.ViewObjectInterface;
import com.ibm.db2.tools.common.support.ViewTableAbstractModel;
import com.ibm.db2.tools.common.support.ViewVector;
import com.ibm.db2.tools.common.support.ViewVectorEvent;
import com.ibm.db2.tools.common.support.ViewVectorListener;
import java.util.Vector;
import javax.swing.event.TableModelEvent;

public class ViewTableModel
extends ViewTableAbstractModel
implements ViewVectorListener {
    private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected Vector dataVector;
    boolean supressModelNotifications = false;

    public ViewTableModel(ViewObjectInterface[] viewObjectInterfaceArray, ViewObjectInterface viewObjectInterface, Object object) {
        this.setDataVector(ViewTableAbstractModel.convertToVector(viewObjectInterfaceArray), this.getColumnsInterfacesArray(viewObjectInterface), object);
    }

    public ViewTableModel(Vector vector, ViewObjectInterface viewObjectInterface, Object object) {
        this.setDataVector(vector, this.getColumnsInterfacesArray(viewObjectInterface), object);
    }

    public ViewTableModel(ViewObjectInterface[] viewObjectInterfaceArray, ViewObjectInterface[] viewObjectInterfaceArray2, Object object) {
        this.setDataVector(ViewTableAbstractModel.convertToVector(viewObjectInterfaceArray), viewObjectInterfaceArray2, object);
    }

    public ViewTableModel(Vector vector, ViewObjectInterface[] viewObjectInterfaceArray, Object object) {
        this.setDataVector(vector, viewObjectInterfaceArray, object);
    }

    public ViewTableModel(Vector vector, ViewObjectColumnsInterface viewObjectColumnsInterface, Object object) {
        this.setDataVector(vector, this.getColumnsInterfacesArray(viewObjectColumnsInterface), object);
    }

    public ViewTableModel(Vector vector, ViewObjectColumnsInterface[] viewObjectColumnsInterfaceArray, Object object) {
        this.setDataVector(vector, viewObjectColumnsInterfaceArray, object);
    }

    public void vectorChanged(ViewVectorEvent viewVectorEvent) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.support", "ViewTableModel", this, "vectorChanged(ViewVectorEvent e)", new Object[]{viewVectorEvent});
        }
        this.fireTableChanged(new TableModelEvent(this, viewVectorEvent.getFirstElement(), viewVectorEvent.getLastElement(), -1, viewVectorEvent.getType()));
        CommonTrace.exit(commonTrace);
    }

    public Vector getDataVector() {
        return this.dataVector;
    }

    protected void setDataVector(Vector vector, ViewObjectColumnsInterface[] viewObjectColumnsInterfaceArray, Object object) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.support", "ViewTableModel", this, "setDataVector(Vector newData, ViewObjectColumnsInterface[] newColumnInterfaces, Object scope)", new Object[]{vector, viewObjectColumnsInterfaceArray, object});
        }
        if (vector == null) {
            throw (IllegalArgumentException)CommonTrace.throwException(commonTrace, new IllegalArgumentException("setDataVector() - Null parameter"));
        }
        if (null != this.dataVector && this.dataVector instanceof ViewVector) {
            ((ViewVector)this.dataVector).removeViewVectorListener(this);
        }
        this.dataVector = new Vector(0);
        this.columnInterfaces = null;
        this.setColumnIdentifiers(ViewTableAbstractModel.convertToVector(viewObjectColumnsInterfaceArray), object);
        this.dataVector = vector;
        this.fireTableDataChanged();
        if (this.dataVector instanceof ViewVector) {
            this.supressModelNotifications = true;
            ((ViewVector)this.dataVector).addViewVectorListener(this);
        } else {
            this.supressModelNotifications = false;
        }
        CommonTrace.exit(commonTrace);
    }

    public void setDataVector(Vector vector, ViewObjectColumnsInterface[] viewObjectColumnsInterfaceArray) {
        this.setDataVector(vector, viewObjectColumnsInterfaceArray, this.getScope());
    }

    public void setDataVector(Vector vector, ViewObjectColumnsInterface viewObjectColumnsInterface) {
        ViewObjectColumnsInterface[] viewObjectColumnsInterfaceArray = new ViewObjectColumnsInterface[]{viewObjectColumnsInterface};
        this.setDataVector(vector, viewObjectColumnsInterfaceArray);
    }

    public void setDataVector(ViewObjectDataInterface[] viewObjectDataInterfaceArray, ViewObjectColumnsInterface[] viewObjectColumnsInterfaceArray) {
        this.setDataVector(ViewTableAbstractModel.convertToVector(viewObjectDataInterfaceArray), viewObjectColumnsInterfaceArray);
    }

    public void setDataVector(ViewObjectDataInterface[] viewObjectDataInterfaceArray, ViewObjectColumnsInterface viewObjectColumnsInterface) {
        this.setDataVector(ViewTableAbstractModel.convertToVector(viewObjectDataInterfaceArray), viewObjectColumnsInterface);
    }

    public void addRow(ViewObjectInterface viewObjectInterface) {
        if (viewObjectInterface == null) {
            throw new IllegalArgumentException("Cannot add a null ViewObjectInterface");
        }
        this.dataVector.addElement(viewObjectInterface);
        if (!this.supressModelNotifications) {
            this.fireTableChanged(new TableModelEvent(this, this.getRowCount() - 1, this.getRowCount() - 1, -1, 1));
        }
    }

    public void addRow(ViewObjectDataInterface viewObjectDataInterface) {
        if (viewObjectDataInterface == null) {
            throw new IllegalArgumentException("Cannot add a null ViewObjectDataInterface");
        }
        this.dataVector.addElement(viewObjectDataInterface);
        if (!this.supressModelNotifications) {
            this.fireTableChanged(new TableModelEvent(this, this.getRowCount() - 1, this.getRowCount() - 1, -1, 1));
        }
    }

    public void insertRow(int n2, ViewObjectInterface viewObjectInterface) {
        if (viewObjectInterface == null) {
            throw new IllegalArgumentException("Cannot add a null ViewObjectInterface");
        }
        this.dataVector.insertElementAt(viewObjectInterface, n2);
        if (!this.supressModelNotifications) {
            this.fireTableChanged(new TableModelEvent(this, n2, n2, -1, 1));
        }
    }

    public void insertRow(int n2, ViewObjectDataInterface viewObjectDataInterface) {
        if (viewObjectDataInterface == null) {
            throw new IllegalArgumentException("Cannot add a null ViewObjectDataInterface");
        }
        this.dataVector.insertElementAt(viewObjectDataInterface, n2);
        if (!this.supressModelNotifications) {
            this.fireTableChanged(new TableModelEvent(this, n2, n2, -1, 1));
        }
    }

    public void moveRow(int n2, int n3, int n4) {
        if (n2 < 0 || n2 >= this.getRowCount()) {
            throw new ArrayIndexOutOfBoundsException(n2);
        }
        if (n3 < 0 || n3 >= this.getRowCount()) {
            throw new ArrayIndexOutOfBoundsException(n3);
        }
        if (n2 > n3) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (n2 <= n4 && n4 <= n3) {
            return;
        }
        boolean bl = n4 < n2;
        int n5 = n2;
        while (n5 <= n3) {
            Object e2 = this.dataVector.elementAt(n5);
            this.dataVector.removeElementAt(n5);
            this.dataVector.insertElementAt(e2, n4);
            if (bl) {
                ++n4;
            }
            ++n5;
        }
        if (!this.supressModelNotifications) {
            this.fireTableDataChanged();
        }
    }

    public void removeRow(int n2) {
        this.dataVector.removeElementAt(n2);
        if (!this.supressModelNotifications) {
            this.fireTableRowsDeleted(n2, n2);
        }
    }

    public int getRowCount() {
        return this.dataVector.size();
    }

    public int getColumnCount() {
        return this.columnIdentifiers.size();
    }

    public boolean isCellEditable(int n2, int n3) {
        ViewObjectDataInterface viewObjectDataInterface = (ViewObjectDataInterface)this.dataVector.elementAt(n2);
        return viewObjectDataInterface.isEditable(n3, this.scope);
    }

    public Object getValueAt(int n2, int n3) {
        ViewObjectDataInterface viewObjectDataInterface = (ViewObjectDataInterface)this.dataVector.elementAt(n2);
        return viewObjectDataInterface.getData(n3, this.scope);
    }

    public void setValueAt(Object object, int n2, int n3) {
        ViewObjectDataInterface viewObjectDataInterface = (ViewObjectDataInterface)this.dataVector.elementAt(n2);
        viewObjectDataInterface.setData(object, n3, this.scope);
        this.fireTableChanged(new TableModelEvent(this, n2, n2, n3));
    }
}

