/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.support;

import com.ibm.db2.tools.common.CommonPopupMenu;
import com.ibm.db2.tools.common.CommonView;
import com.ibm.db2.tools.common.ViewTable;
import com.ibm.db2.tools.common.ViewToolBar;
import com.ibm.db2.tools.common.support.AssistIndex;
import com.ibm.db2.tools.common.support.AssistManager;
import com.ibm.db2.tools.common.support.ViewTableColumn;
import com.ibm.db2.tools.common.support.ViewTableColumnModel;
import com.ibm.db2.tools.common.support.ViewTableHeader;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;
import java.util.Enumeration;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class ViewTableHeaderManager
implements MouseListener,
MouseMotionListener,
ActionListener,
FocusListener,
KeyListener,
Serializable {
    private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected int focusColumn = -1;
    protected int refocusColumn = -1;
    AssistIndex sequence;
    AssistIndex direction;
    protected ViewTableHeader header;
    protected int lastEffectiveMouseX;
    protected CommonPopupMenu mPopup;
    protected Cursor tempCursor;

    public ViewTableHeaderManager(ViewTableHeader viewTableHeader) {
        this.header = viewTableHeader;
    }

    public void manageSortingColumn(int n2, int n3) {
        int n4;
        ViewTableColumn viewTableColumn = (ViewTableColumn)this.header.getColumnModel().getColumn(n2);
        int n5 = viewTableColumn.getSortableDirections();
        if (n3 != 273 && n3 != 1 && (n5 & n3) == 0) {
            return;
        }
        int n6 = this.header.getColumnModel().getColumnCount();
        if (this.sequence == null) {
            this.sequence = new AssistIndex(n6);
            this.direction = new AssistIndex(n6);
            n4 = 0;
            while (n4 < n6) {
                TableColumn tableColumn;
                if (n4 != n2 && (tableColumn = this.header.getColumnModel().getColumn(n4)) instanceof ViewTableColumn) {
                    ((ViewTableColumn)tableColumn).setSortDirection(1);
                    ((ViewTableColumn)tableColumn).setSortOrdinal(0);
                }
                ++n4;
            }
        }
        if (viewTableColumn instanceof ViewTableColumn) {
            if (n3 == 273) {
                n3 = viewTableColumn.getNextSortDirection();
            } else {
                viewTableColumn.setSortDirection(n3);
            }
            n4 = viewTableColumn.getModelIndex();
            int n7 = this.sequence.indexOf(n4);
            if (n3 == 0 || n3 == 1) {
                if (n7 > -1) {
                    this.sequence.removeIntAt(n7, false);
                    this.direction.removeIntAt(n7, false);
                    if (this.sequence.size() == 0) {
                        this.sequence = null;
                        this.direction = null;
                    }
                }
                viewTableColumn.setSortOrdinal(0);
                if (this.sequence != null) {
                    int n8 = 0;
                    while (n8 < this.sequence.size()) {
                        viewTableColumn = (ViewTableColumn)this.header.getColumnModel().getColumn(this.convertColumnIndexToView(this.sequence.intAt(n8)));
                        viewTableColumn.setSortOrdinal(n8 + 1);
                        ++n8;
                    }
                }
            } else if (n7 > -1) {
                this.direction.setIntAt(n3, n7);
                viewTableColumn.setSortOrdinal(n7 + 1);
            } else {
                this.sequence.addInt(n4);
                this.direction.addInt(n3);
                viewTableColumn.setSortOrdinal(this.sequence.size());
            }
        }
    }

    public void sort(int n2) {
        int n3 = this.header.getColumnModel().getColumnCount();
        int[] nArray = null;
        if (this.sequence != null) {
            TableColumn tableColumn;
            n2 = this.convertColumnIndexToView(this.sequence.intAt(0));
            nArray = this.header.getTable().getSelectedRows();
            int n4 = 0;
            while (n4 < nArray.length) {
                nArray[n4] = ((ViewTable)this.header.getTable()).convertRowIndexToModel(nArray[n4]);
                ++n4;
            }
            int n5 = 1;
            while (n5 < this.sequence.size()) {
                tableColumn = this.header.getColumnModel().getColumn(this.convertColumnIndexToView(this.sequence.intAt(n5)));
                if (!(tableColumn instanceof ViewTableColumn)) break;
                ((ViewTableColumn)tableColumn).setSortDirection(1);
                ((ViewTableColumn)tableColumn).setSortOrdinal(0);
                ++n5;
            }
            tableColumn = this.header.getColumnModel().getColumn(n2);
            ((ViewTableColumn)tableColumn).setSortOrdinal(0);
            this.sequence = null;
            this.direction = null;
            this.header.getTable().clearSelection();
            n4 = 0;
            while (n4 < nArray.length) {
                int n6 = ((ViewTable)this.header.getTable()).convertRowIndexToView(nArray[n4]);
                this.header.getTable().addRowSelectionInterval(n6, n6);
                ++n4;
            }
            this.header.getTable().setColumnSelectionInterval(n2, n2);
        } else {
            TableColumn tableColumn = this.header.getColumnModel().getColumn(n2);
            if (tableColumn instanceof ViewTableColumn) {
                int n7 = tableColumn.getModelIndex();
                int n8 = ((ViewTableColumn)tableColumn).getNextSortDirection();
                if (n8 > 0) {
                    nArray = this.header.getTable().getSelectedRows();
                    int n9 = 0;
                    while (n9 < nArray.length) {
                        nArray[n9] = ((ViewTable)this.header.getTable()).convertRowIndexToModel(nArray[n9]);
                        ++n9;
                    }
                    this.header.getTable().clearSelection();
                    ((ViewTableColumn)tableColumn).setSortDirection(n8);
                    int n10 = 0;
                    while (n10 < n3) {
                        if (n10 != n2) {
                            tableColumn = this.header.getColumnModel().getColumn(n10);
                            if (!(tableColumn instanceof ViewTableColumn)) break;
                            ((ViewTableColumn)tableColumn).setSortDirection(1);
                        }
                        ++n10;
                    }
                    n9 = 0;
                    while (n9 < nArray.length) {
                        int n11 = ((ViewTable)this.header.getTable()).convertRowIndexToView(nArray[n9]);
                        this.header.getTable().addRowSelectionInterval(n11, n11);
                        ++n9;
                    }
                    this.header.getTable().setColumnSelectionInterval(n2, n2);
                }
            }
        }
        this.header.repaint();
    }

    public int convertColumnIndexToView(int n2) {
        if (n2 < 0) {
            return n2;
        }
        int n3 = 0;
        while (n3 < this.header.getColumnModel().getColumnCount()) {
            if (this.header.getColumnModel().getColumn(n3).getModelIndex() == n2) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    public int getFocusColumn() {
        return this.focusColumn;
    }

    public void showPopup(Point point) {
        if (null == this.mPopup) {
            JPanel jPanel;
            Container container;
            this.mPopup = new CommonPopupMenu();
            this.header.add(this.mPopup);
            JTable jTable = this.header.getTable();
            Component component = null;
            Container container2 = jTable.getParent();
            if (container2 instanceof JViewport && (container = container2.getParent()) instanceof JScrollPane) {
                component = (JScrollPane)container;
            }
            if (null != component && null != component.getParent() && null != component.getParent().getParent() && component.getParent().getParent() instanceof CommonView && null != (jPanel = ((CommonView)(container = (CommonView)component.getParent().getParent())).getToolBarPanel()) && jPanel instanceof ViewToolBar) {
                this.mPopup.add(((ViewToolBar)jPanel).getCustomizeActions(true));
            }
        }
        if (this.mPopup.getComponentCount() > 0) {
            this.mPopup.show(this.header, point.x, point.y);
        }
    }

    public void handleMouseEvent(MouseEvent mouseEvent) {
        this.header.requestFocus();
        this.focusColumn = this.header.columnAtPoint(mouseEvent.getPoint());
        if (this.focusColumn >= 0) {
            int n2 = mouseEvent.getModifiers();
            if (mouseEvent.isPopupTrigger()) {
                this.showPopup(mouseEvent.getPoint());
            } else if (mouseEvent.getID() == 500) {
                ViewTableColumnModel viewTableColumnModel;
                ViewTableColumn viewTableColumn;
                if ((n2 & 8) > 0) {
                    if (this.header.getColumnModel() != null && this.header.getColumnModel() instanceof ViewTableColumnModel) {
                        ViewTableColumn viewTableColumn2 = (ViewTableColumn)this.header.getColumnModel().getColumn(this.focusColumn);
                        this.manageSortingColumn(this.focusColumn, viewTableColumn2.getNextSortDirection());
                        if ((n2 & 2) > 0) {
                            this.sort(this.focusColumn);
                        }
                    }
                } else if (this.header.getColumnModel() != null && this.header.getColumnModel() instanceof ViewTableColumnModel && (viewTableColumn = (ViewTableColumn)(viewTableColumnModel = (ViewTableColumnModel)this.header.getColumnModel()).getColumn(this.focusColumn)).getSortableDirections() != 0) {
                    int n3 = viewTableColumn.getNextSortDirection();
                    if (viewTableColumn.isRollup()) {
                        if (1 == n3) {
                            n3 = ViewTableColumn.getNextSortDirection(n3, viewTableColumn.getSortableDirections());
                        }
                    } else {
                        int n4 = 0;
                        Enumeration enumeration = viewTableColumnModel.getAllColumns();
                        while (enumeration.hasMoreElements()) {
                            ViewTableColumn viewTableColumn3 = (ViewTableColumn)enumeration.nextElement();
                            if (viewTableColumn3.getModelIndex() == viewTableColumn.getModelIndex()) continue;
                            if (viewTableColumn3.isRollup()) {
                                if (n4 >= viewTableColumn3.getSortOrdinal()) continue;
                                n4 = viewTableColumn3.getSortOrdinal();
                                continue;
                            }
                            viewTableColumn3.setChangeSupportEnabled(false);
                            viewTableColumn3.setSortDirection(1);
                            viewTableColumn3.setSortOrdinal(0);
                            viewTableColumn3.setChangeSupportEnabled(true);
                        }
                        viewTableColumn.setChangeSupportEnabled(false);
                        viewTableColumn.setSortOrdinal(++n4);
                        viewTableColumn.setChangeSupportEnabled(true);
                    }
                    viewTableColumn.setSortDirection(n3);
                }
            }
        }
        this.header.repaint();
        this.header.getTable().revalidate();
    }

    public void handleKeyEvent(KeyEvent keyEvent) {
        Serializable serializable;
        Object object;
        if (keyEvent.isConsumed()) {
            return;
        }
        if (this.mPopup != null && this.mPopup.isVisible()) {
            AssistManager.redirectKeyEvent(keyEvent, this.mPopup);
            return;
        }
        int n2 = keyEvent.getModifiers();
        int n3 = keyEvent.getID();
        int n4 = keyEvent.getKeyCode();
        int n5 = this.header.getColumnModel().getColumnCount();
        switch (n4) {
            case 38: {
                if (n3 != 401) break;
                if ((n2 & 8) > 0) {
                    object = this.header.getColumnModel();
                    if (object == null || !(object instanceof ViewTableColumnModel)) break;
                    this.manageSortingColumn(this.focusColumn, 16);
                    keyEvent.consume();
                    break;
                }
                this.focusColumn = this.focusColumn == 0 ? n5 - 1 : this.focusColumn - 1;
                keyEvent.consume();
                break;
            }
            case 37: {
                if (n3 != 401) break;
                if ((n2 & 2) > 0) {
                    if (this.focusColumn == -1) break;
                    if ((n2 & 8) > 0) {
                        if (this.focusColumn <= 0 || !this.header.getReorderingAllowed()) break;
                        object = this.header.getColumnModel().getColumn(this.focusColumn);
                        this.header.setDraggedColumn((TableColumn)object);
                        this.header.getColumnModel().moveColumn(this.focusColumn, this.focusColumn - 1);
                        --this.focusColumn;
                        this.header.setDraggedColumn(null);
                        keyEvent.consume();
                        break;
                    }
                    if (!this.header.getResizingAllowed()) break;
                    object = this.header.getColumnModel().getColumn(this.focusColumn);
                    this.header.setResizingColumn((TableColumn)object);
                    ((TableColumn)object).setWidth(((TableColumn)object).getWidth() - 1);
                    this.header.getTable().revalidate();
                    this.header.getTable().repaint();
                    this.header.setResizingColumn(null);
                    keyEvent.consume();
                    break;
                }
                if ((n2 & 8) > 0) {
                    object = this.header.getColumnModel();
                    if (object == null || !(object instanceof ViewTableColumnModel)) break;
                    this.manageSortingColumn(this.focusColumn, 1);
                    keyEvent.consume();
                    break;
                }
                this.focusColumn = this.focusColumn == 0 ? n5 - 1 : this.focusColumn - 1;
                keyEvent.consume();
                break;
            }
            case 39: {
                if (n3 != 401) break;
                if ((n2 & 2) > 0 && this.header.getResizingAllowed()) {
                    if (this.focusColumn == -1) break;
                    if ((n2 & 8) > 0) {
                        if (this.focusColumn >= n5 - 1 || !this.header.getReorderingAllowed()) break;
                        object = this.header.getColumnModel();
                        serializable = object.getColumn(this.focusColumn);
                        this.header.setDraggedColumn((TableColumn)serializable);
                        object.moveColumn(this.focusColumn, this.focusColumn + 1);
                        ++this.focusColumn;
                        this.header.setDraggedColumn(null);
                        keyEvent.consume();
                        break;
                    }
                    if (!this.header.getResizingAllowed()) break;
                    object = this.header.getColumnModel();
                    serializable = object.getColumn(this.focusColumn);
                    this.header.setResizingColumn((TableColumn)serializable);
                    ((TableColumn)serializable).setWidth(((TableColumn)serializable).getWidth() + 1);
                    this.header.getTable().revalidate();
                    this.header.getTable().repaint();
                    this.header.setResizingColumn(null);
                    keyEvent.consume();
                    break;
                }
                if ((n2 & 8) > 0) {
                    object = this.header.getColumnModel();
                    if (object == null || !(object instanceof ViewTableColumnModel)) break;
                    this.sort(this.focusColumn);
                    keyEvent.consume();
                    break;
                }
                this.focusColumn = this.focusColumn == n5 - 1 ? 0 : this.focusColumn + 1;
                keyEvent.consume();
                break;
            }
            case 40: {
                if (n3 != 401) break;
                if ((n2 & 8) > 0) {
                    object = this.header.getColumnModel();
                    if (object == null || !(object instanceof ViewTableColumnModel)) break;
                    this.manageSortingColumn(this.focusColumn, 256);
                    keyEvent.consume();
                    break;
                }
                this.focusColumn = this.focusColumn == n5 - 1 ? 0 : this.focusColumn + 1;
                keyEvent.consume();
            }
        }
        if (n2 == 1 && n4 == 121 && n3 == 402 && this.mPopup != null) {
            object = this.header.getHeaderRect(this.focusColumn);
            serializable = new Point(((Rectangle)object).x + ((Rectangle)object).width / 2, ((Rectangle)object).y + ((Rectangle)object).height / 2);
            this.showPopup((Point)serializable);
            keyEvent.consume();
        }
        this.header.repaint();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this.header) {
            this.handleMouseEvent(mouseEvent);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        Object object = mouseEvent.getSource();
        if (object == this.header) {
            this.handleMouseEvent(mouseEvent);
        } else {
            TableColumn tableColumn;
            this.header.setResizingColumn(null);
            Point point = mouseEvent.getPoint();
            this.lastEffectiveMouseX = point.x;
            TableColumnModel tableColumnModel = this.header.getColumnModel();
            int n2 = tableColumnModel.getColumnIndexAtX(point.x);
            if (n2 != -1 && this.canResize(tableColumn = this.getResizingColumn(point, n2))) {
                this.header.setResizingColumn(tableColumn);
                mouseEvent.consume();
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this.header) {
            this.handleMouseEvent(mouseEvent);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.header.setResizingColumn(null);
        if (this.canResize(this.getResizingColumn(mouseEvent.getPoint()))) {
            if (!Cursor.getPredefinedCursor(11).equals(this.header.getTable().getCursor())) {
                this.tempCursor = this.header.getTable().getCursor();
            }
            this.header.getTable().setCursor(Cursor.getPredefinedCursor(11));
        } else if (null != this.tempCursor) {
            this.header.getTable().setCursor(this.tempCursor);
            this.tempCursor = null;
        }
    }

    private boolean canResize(TableColumn tableColumn) {
        return tableColumn != null && this.header.getResizingAllowed() && tableColumn.getResizable();
    }

    private TableColumn getResizingColumn(Point point) {
        return this.getResizingColumn(point, this.header.getColumnModel().getColumnIndexAtX(point.x));
    }

    private TableColumn getResizingColumn(Point point, int n2) {
        int n3;
        if (n2 == -1) {
            return null;
        }
        Rectangle rectangle = this.header.getHeaderRect(n2);
        rectangle.grow(-3, 0);
        if (rectangle.x + rectangle.width > point.x) {
            return null;
        }
        int n4 = rectangle.x + rectangle.width / 2;
        int n5 = n3 = point.x < n4 ? n2 - 1 : n2;
        if (n3 == -1) {
            return null;
        }
        return this.header.getColumnModel().getColumn(n3);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        int n2 = mouseEvent.getX();
        int n3 = n2 - this.lastEffectiveMouseX;
        if (n3 == 0) {
            return;
        }
        TableColumn tableColumn = this.header.getResizingColumn();
        if (tableColumn != null) {
            int n4 = tableColumn.getWidth();
            int n5 = n4 + n3;
            tableColumn.setWidth(n5);
            int n6 = tableColumn.getWidth() - n4;
            this.lastEffectiveMouseX += n6;
            mouseEvent.consume();
        } else {
            this.lastEffectiveMouseX = n2;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
    }

    public void focusGained(FocusEvent focusEvent) {
        this.focusColumn = this.refocusColumn > -1 ? this.refocusColumn : -1;
        this.header.repaint();
    }

    public void focusLost(FocusEvent focusEvent) {
        this.refocusColumn = this.focusColumn;
        this.focusColumn = -1;
        this.header.repaint();
    }

    public void keyTyped(KeyEvent keyEvent) {
        this.handleKeyEvent(keyEvent);
    }

    public void keyPressed(KeyEvent keyEvent) {
        this.handleKeyEvent(keyEvent);
    }

    public void keyReleased(KeyEvent keyEvent) {
        this.handleKeyEvent(keyEvent);
    }
}

