/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.support;

import com.ibm.db2.tools.common.support.AssistTableHeaderRenderer;
import com.ibm.db2.tools.common.support.ViewTableColumn;
import com.ibm.db2.tools.common.support.ViewTableColumnModel;
import com.ibm.db2.tools.common.support.ViewTableHeaderManager;
import com.ibm.db2.tools.common.support.ViewTableSortFilterModel;
import java.awt.Component;
import java.io.IOException;
import java.io.ObjectOutputStream;
import javax.accessibility.AccessibleContext;
import javax.swing.JTable;
import javax.swing.ToolTipManager;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class ViewTableHeader
extends JTableHeader
implements TableModelListener {
    private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String uiClassID = "ViewTableHeaderUI";
    protected ViewTableSortFilterModel sortFilterModel;
    protected ViewTableHeaderManager headerManager;
    protected StringBuffer sb;
    protected boolean tempReorderingAllowed;
    protected boolean tempResizingAllowed;
    protected boolean tempPreviousEnable;

    public ViewTableHeader() {
        this(null);
    }

    public ViewTableHeader(TableColumnModel tableColumnModel) {
        super(tableColumnModel);
        this.createDefaultRenderer();
        ToolTipManager.sharedInstance().unregisterComponent(this);
        this.setHeaderManager(this.createDefaultHeaderManager());
        this.tempPreviousEnable = this.isEnabled();
    }

    public void setTable(JTable jTable) {
        JTable jTable2 = this.table;
        if (jTable != jTable2 && this.headerManager != null) {
            if (jTable2 != null) {
                this.table.removeMouseMotionListener(this.headerManager);
                this.table.removeMouseListener(this.headerManager);
            }
            super.setTable(jTable);
            if (jTable != null) {
                this.table.addMouseListener(this.headerManager);
                this.table.addMouseMotionListener(this.headerManager);
            }
        }
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public void setSortFilterModel(ViewTableSortFilterModel viewTableSortFilterModel) {
        ViewTableSortFilterModel viewTableSortFilterModel2 = this.sortFilterModel;
        if (viewTableSortFilterModel == null) {
            throw new IllegalArgumentException("Cannot set a null ViewTableSortFilterModel");
        }
        if (viewTableSortFilterModel != viewTableSortFilterModel2) {
            if (viewTableSortFilterModel2 != null) {
                viewTableSortFilterModel2.removeTableModelListener(this);
            }
            this.sortFilterModel = viewTableSortFilterModel;
            viewTableSortFilterModel.addTableModelListener(this);
            this.resizeAndRepaint();
        }
    }

    public ViewTableSortFilterModel getSortFilterModel() {
        return this.sortFilterModel;
    }

    public void setHeaderManager(ViewTableHeaderManager viewTableHeaderManager) {
        ViewTableHeaderManager viewTableHeaderManager2 = this.headerManager;
        if (viewTableHeaderManager == null) {
            throw new IllegalArgumentException("Cannot set a null ViewTableHeaderManager");
        }
        if (viewTableHeaderManager != viewTableHeaderManager2) {
            if (viewTableHeaderManager2 != null) {
                this.removeFocusListener(viewTableHeaderManager2);
                this.removeKeyListener(viewTableHeaderManager2);
                this.removeMouseListener(viewTableHeaderManager2);
            }
            this.headerManager = viewTableHeaderManager;
            this.addFocusListener(this.headerManager);
            this.addKeyListener(this.headerManager);
            this.addMouseListener(this.headerManager);
            this.resizeAndRepaint();
        }
    }

    public ViewTableHeaderManager getHeaderManager() {
        return this.headerManager;
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        this.repaint();
    }

    protected TableColumnModel createDefaultColumnModel() {
        return new ViewTableColumnModel();
    }

    protected TableCellRenderer createDefaultRenderer() {
        return ViewTableHeader.getDefaultHeaderRenderer();
    }

    protected static TableCellRenderer getDefaultHeaderRenderer() {
        AssistTableHeaderRenderer assistTableHeaderRenderer = new AssistTableHeaderRenderer(273, true){

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n2, int n3) {
                if (null != jTable) {
                    TableColumn tableColumn = jTable.getColumnModel().getColumn(n3);
                    if (tableColumn instanceof ViewTableColumn) {
                        this.indicators = ((ViewTableColumn)tableColumn).getSortableDirections();
                        this.showSortableIndicators(0 != this.indicators);
                        this.setSort(((ViewTableColumn)tableColumn).sortDirection);
                    }
                    this.setEnabled(jTable.isEnabled());
                    if (jTable.isEnabled() != ((ViewTableHeader)jTable.getTableHeader()).tempPreviousEnable) {
                        ((ViewTableHeader)jTable.getTableHeader()).tempPreviousEnable = jTable.isEnabled();
                        if (!jTable.isEnabled()) {
                            ((ViewTableHeader)jTable.getTableHeader()).tempReorderingAllowed = ((ViewTableHeader)jTable.getTableHeader()).getReorderingAllowed();
                            ((ViewTableHeader)jTable.getTableHeader()).tempResizingAllowed = ((ViewTableHeader)jTable.getTableHeader()).getResizingAllowed();
                            jTable.getTableHeader().setReorderingAllowed(false);
                            jTable.getTableHeader().setResizingAllowed(false);
                        } else {
                            jTable.getTableHeader().setReorderingAllowed(((ViewTableHeader)jTable.getTableHeader()).tempReorderingAllowed);
                            jTable.getTableHeader().setResizingAllowed(((ViewTableHeader)jTable.getTableHeader()).tempResizingAllowed);
                        }
                    }
                }
                return super.getTableCellRendererComponent(jTable, object, bl, bl2, n2, n3);
            }
        };
        return assistTableHeaderRenderer;
    }

    protected ViewTableHeaderManager createDefaultHeaderManager() {
        return new ViewTableHeaderManager(this);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.ui != null && this.getUIClassID().equals(uiClassID)) {
            this.ui.installUI(this);
        }
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public String getUAKey(int n2) {
        String string = null;
        TableColumn tableColumn = this.table.getColumnModel().getColumn(n2);
        if (tableColumn instanceof ViewTableColumn) {
            string = ((ViewTableColumn)tableColumn).getUAKey();
        }
        if (string == null) {
            string = (String)super.getClientProperty("UAKey");
            if (string != null) {
                if (this.sb == null) {
                    this.sb = new StringBuffer();
                } else {
                    this.sb.setLength(0);
                }
                this.sb.append(string).append("_").append(n2);
                string = this.sb.toString();
            } else {
                string = (String)this.table.getClientProperty("UAKey");
            }
        }
        return string;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleViewTableHeader();
        }
        return this.accessibleContext;
    }

    protected class AccessibleViewTableHeader
    extends JTableHeader.AccessibleJTableHeader {
        private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

        protected AccessibleViewTableHeader() {
            super(ViewTableHeader.this);
        }

        public String getAccessibleName() {
            String string = super.getAccessibleName();
            if (string == null) {
                string = ViewTableHeader.this.getTable().getAccessibleContext().getAccessibleName();
            }
            return string;
        }

        public String getAccessibleDescription() {
            String string = super.getAccessibleDescription();
            if (string == null) {
                string = ViewTableHeader.this.getTable().getAccessibleContext().getAccessibleDescription();
            }
            return string;
        }
    }
}

