/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.support;

import com.ibm.db2.tools.common.support.ViewTableColumnModelEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.event.SwingPropertyChangeSupport;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class ViewTableColumnModel
extends DefaultTableColumnModel {
    private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected Vector hiddenTableColumns = new Vector();
    protected boolean filterEnabled = true;
    private SwingPropertyChangeSupport changeSupport;
    protected boolean changeSupportEnabled = true;
    protected boolean overrideEvent = false;
    protected TableColumn tempColumn = null;
    protected int tempFromIndex;
    protected int tempToIndex;

    public void addColumn(TableColumn tableColumn) {
        int n2 = this.hiddenTableColumns.indexOf(tableColumn);
        if (n2 >= 0) {
            this.hiddenTableColumns.removeElement(tableColumn);
            this.overrideEvent = true;
            this.tempFromIndex = -n2 - 1;
            this.tempToIndex = this.getColumnCount() - 1;
        }
        this.tempColumn = tableColumn;
        super.addColumn(tableColumn);
    }

    public void hideColumn(TableColumn tableColumn) {
        int n2 = this.tableColumns.indexOf(tableColumn);
        this.hiddenTableColumns.addElement(tableColumn);
        if (n2 != -1) {
            this.overrideEvent = true;
            this.tempFromIndex = this.getColumnCount() - 1;
            this.tempToIndex = -this.hiddenTableColumns.size() - 1;
            this.tempColumn = tableColumn;
        }
        super.removeColumn(tableColumn);
    }

    public void removeColumn(TableColumn tableColumn) {
        int n2 = this.tableColumns.indexOf(tableColumn);
        if (n2 < 0) {
            this.hiddenTableColumns.removeElement(tableColumn);
        } else {
            this.tempColumn = tableColumn;
            super.removeColumn(tableColumn);
        }
    }

    public int getColumnIndex(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("Identifier is null");
        }
        Enumeration enumeration = this.getHiddenColumns();
        int n2 = -1;
        int n3 = 0;
        while (n3 < this.hiddenTableColumns.size()) {
            if (object.equals(((TableColumn)this.hiddenTableColumns.elementAt(n3)).getIdentifier())) {
                return -n3 - 1;
            }
            ++n3;
        }
        return super.getColumnIndex(object);
    }

    public TableColumn getColumn(int n2) {
        if (n2 >= 0) {
            return this.tableColumns.elementAt(n2);
        }
        return (TableColumn)this.hiddenTableColumns.elementAt(-n2 - 1);
    }

    public int getHiddenColumnCount() {
        return this.hiddenTableColumns.size();
    }

    public Enumeration getHiddenColumns() {
        return this.hiddenTableColumns.elements();
    }

    public int getAllColumnCount() {
        return this.hiddenTableColumns.size() + this.tableColumns.size();
    }

    public Enumeration getAllColumns() {
        Vector<TableColumn> vector = new Vector<TableColumn>(this.getColumnCount() + this.hiddenTableColumns.size());
        int n2 = 0;
        while (n2 < this.getColumnCount()) {
            vector.addElement(this.tableColumns.elementAt(n2));
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.hiddenTableColumns.size()) {
            vector.addElement((TableColumn)this.hiddenTableColumns.elementAt(n3));
            ++n3;
        }
        return vector.elements();
    }

    public boolean isFilterEnabled() {
        return this.filterEnabled;
    }

    public void setFilterEnabled(boolean bl) {
        boolean bl2 = this.filterEnabled;
        this.filterEnabled = bl;
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange("filterEnabled", new Boolean(bl2), new Boolean(this.filterEnabled));
        }
    }

    public boolean getChangeSupportEnabled() {
        return this.changeSupportEnabled;
    }

    public void setChangeSupportEnabled(boolean bl) {
        this.changeSupportEnabled = bl;
    }

    protected void fireColumnAdded(TableColumnModelEvent tableColumnModelEvent) {
        if (this.changeSupportEnabled) {
            tableColumnModelEvent = new ViewTableColumnModelEvent((TableColumnModel)tableColumnModelEvent.getSource(), this.overrideEvent ? this.tempFromIndex : tableColumnModelEvent.getFromIndex(), this.overrideEvent ? this.tempToIndex : tableColumnModelEvent.getToIndex(), this.tempColumn);
            this.overrideEvent = false;
            this.tempColumn = null;
            super.fireColumnAdded(tableColumnModelEvent);
        }
    }

    protected void fireColumnRemoved(TableColumnModelEvent tableColumnModelEvent) {
        if (this.changeSupportEnabled) {
            tableColumnModelEvent = new ViewTableColumnModelEvent((TableColumnModel)tableColumnModelEvent.getSource(), this.overrideEvent ? this.tempFromIndex : tableColumnModelEvent.getFromIndex(), this.overrideEvent ? this.tempToIndex : tableColumnModelEvent.getToIndex(), this.tempColumn);
            this.overrideEvent = false;
            this.tempColumn = null;
            super.fireColumnRemoved(tableColumnModelEvent);
        }
    }

    protected void fireColumnMoved(TableColumnModelEvent tableColumnModelEvent) {
        if (this.changeSupportEnabled) {
            super.fireColumnMoved(tableColumnModelEvent);
        }
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport == null) {
            this.changeSupport = new SwingPropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport != null) {
            this.changeSupport.removePropertyChangeListener(propertyChangeListener);
        }
    }
}

