/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.support;

import com.ibm.db2.tools.common.CommonTrace;
import com.ibm.db2.tools.common.support.ViewObjectColumnSettings;
import com.ibm.db2.tools.common.support.ViewTableHeader;
import java.awt.FontMetrics;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.swing.event.SwingPropertyChangeSupport;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class ViewTableColumn
extends TableColumn {
    private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected int sortableDirections = 273;
    protected int sortDirection = 1;
    protected int sortOrdinal = 0;
    protected boolean rollup = false;
    protected int operator;
    protected String[] filterValues;
    protected Class columnClass = null;
    protected TableCellRenderer rollupRenderer;
    private SwingPropertyChangeSupport changeSupport;
    protected boolean changeSupportEnabled = true;
    protected String uaKey;
    protected FontMetrics fontMetrics;
    boolean rollupRenderersUsed = false;
    public static final int IS_IN = 0;
    public static final int IS_NOT_IN = 1;
    public static final int IS_EQUAL = 2;
    public static final int IS_NOT_EQUAL = 3;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;

    public ViewTableColumn() {
        this(0);
    }

    public ViewTableColumn(int n2) {
        this(n2, 75, null, null);
    }

    public ViewTableColumn(int n2, int n3) {
        this(n2, n3, null, null);
    }

    public ViewTableColumn(int n2, int n3, TableCellRenderer tableCellRenderer, TableCellEditor tableCellEditor) {
        super(n2, n3, tableCellRenderer, tableCellEditor);
    }

    public void setIdentifier(Object object) {
        super.setIdentifier(object);
    }

    public void setMaxWidth(int n2) {
        super.setMaxWidth(n2);
    }

    public void setMinWidth(int n2) {
        super.setMinWidth(n2);
    }

    public void setModelIndex(int n2) {
        super.setModelIndex(n2);
    }

    public void setPreferredWidth(int n2) {
        super.setPreferredWidth(n2);
    }

    public void setResizable(boolean bl) {
        super.setResizable(bl);
    }

    public void setWidth(int n2) {
        super.setWidth(n2);
    }

    public void setSortableDirections(int n2) {
        this.sortableDirections = n2;
    }

    public int getSortableDirections() {
        return this.sortableDirections;
    }

    public void setSortDirection(int n2) {
        int n3 = this.sortDirection;
        if (n2 != n3) {
            this.sortDirection = n2;
            if (this.changeSupportEnabled && this.changeSupport != null) {
                this.changeSupport.firePropertyChange("sortDirection", new Integer(n3), new Integer(this.sortDirection));
            }
        }
    }

    public int getSortDirection() {
        return this.sortDirection;
    }

    public void setSortOrdinal(int n2) {
        int n3 = this.sortOrdinal;
        if (n2 != this.sortOrdinal) {
            this.sortOrdinal = n2;
            if (this.changeSupportEnabled && this.changeSupport != null) {
                this.changeSupport.firePropertyChange("sortOrdinal", new Integer(n3), new Integer(n2));
            }
        }
    }

    public int getSortOrdinal() {
        return this.sortOrdinal;
    }

    public void setRollup(boolean bl) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.support", "ViewTableColumn", this, "setRollup(boolean aRollup)", new Object[]{new Boolean(bl)});
        }
        boolean bl2 = this.rollup;
        if (bl && this.sortOrdinal <= 0) {
            throw (UnsupportedOperationException)CommonTrace.throwException(commonTrace, new UnsupportedOperationException("The parameter can be true only if the sortOrdinal field  is non-zero and positive. The current value is: \nsortOrdinal    = " + this.sortOrdinal));
        }
        this.rollup = bl;
        if (bl2 != bl) {
            this.rollup = bl;
            if (this.changeSupportEnabled && this.changeSupport != null) {
                this.changeSupport.firePropertyChange("rollup", new Boolean(bl2), new Boolean(this.rollup));
            }
        }
        CommonTrace.exit(commonTrace);
    }

    public boolean isRollup() {
        return this.rollup;
    }

    public int getOperator() {
        return this.operator;
    }

    public void setOperator(int n2) {
        int n3 = this.operator;
        if (n2 != n3) {
            this.operator = n2;
            if (this.changeSupportEnabled && this.changeSupport != null) {
                this.changeSupport.firePropertyChange("operator", new Integer(n3), new Integer(this.operator));
            }
        }
    }

    public String[] getFilterValues() {
        return this.filterValues;
    }

    public void setFilterValues(String[] stringArray) {
        String[] stringArray2 = this.filterValues;
        boolean bl = false;
        if (null != stringArray || null != stringArray2) {
            if (null != stringArray) {
                if (null == stringArray2) {
                    bl = true;
                } else if (stringArray.length != stringArray2.length) {
                    bl = true;
                } else {
                    int n2 = 0;
                    while (n2 < stringArray.length) {
                        if (!stringArray[n2].equals(stringArray2[n2])) {
                            bl = true;
                            break;
                        }
                        ++n2;
                    }
                }
            } else {
                bl = true;
            }
        }
        if (bl) {
            this.filterValues = stringArray;
            if (this.changeSupportEnabled && this.changeSupport != null) {
                this.changeSupport.firePropertyChange("filterValues", stringArray2, this.filterValues);
            }
        }
    }

    public Class getColumnClass() {
        return this.columnClass;
    }

    public void setColumnClass(Class clazz) {
        this.columnClass = clazz;
    }

    public TableCellRenderer getRollupRenderer() {
        return this.rollupRenderer;
    }

    public void setRollupRenderer(TableCellRenderer tableCellRenderer) {
        TableCellRenderer tableCellRenderer2 = this.rollupRenderer;
        if (null == tableCellRenderer) {
            throw new IllegalArgumentException("Object is null");
        }
        this.rollupRenderer = tableCellRenderer;
        if (this.changeSupportEnabled && this.changeSupport != null) {
            this.changeSupport.firePropertyChange("rollupRenderer", tableCellRenderer2, tableCellRenderer);
        }
    }

    public boolean getChangeSupportEnabled() {
        return this.changeSupportEnabled;
    }

    public void setChangeSupportEnabled(boolean bl) {
        this.changeSupportEnabled = bl;
    }

    public String getUAKey() {
        return this.uaKey;
    }

    public void setUAKey(String string) {
        this.uaKey = string;
    }

    public FontMetrics getFontMetrics() {
        return this.fontMetrics;
    }

    public void setFontMetrics(FontMetrics fontMetrics) {
        this.fontMetrics = fontMetrics;
    }

    public boolean getRollupRenderersUsed() {
        return this.rollupRenderersUsed;
    }

    public void setRollupRenderersUsed(boolean bl) {
        this.rollupRenderersUsed = bl;
    }

    public ViewObjectColumnSettings getColumnSettings() {
        ViewObjectColumnSettings viewObjectColumnSettings = new ViewObjectColumnSettings();
        if (null != this.columnClass) {
            viewObjectColumnSettings.setColumnClass(this.columnClass);
        }
        viewObjectColumnSettings.setWidth(this.getWidth());
        if (null != this.getCellRenderer()) {
            viewObjectColumnSettings.setCellRenderer(this.getCellRenderer());
        }
        if (null != this.getRollupRenderer()) {
            viewObjectColumnSettings.setRollupRenderer(this.getRollupRenderer());
        }
        if (null != this.getCellEditor()) {
            viewObjectColumnSettings.setCellEditor(this.getCellEditor());
        }
        viewObjectColumnSettings.setSortableDirections(this.getSortableDirections());
        viewObjectColumnSettings.setSortDirection(this.getSortDirection());
        viewObjectColumnSettings.setSortOrdinal(this.getSortOrdinal());
        if (this.isRollup()) {
            viewObjectColumnSettings.setVisibleOrdinal(this.getSortOrdinal());
        }
        viewObjectColumnSettings.setRollup(this.isRollup());
        viewObjectColumnSettings.setOperator(this.getOperator());
        if (null != this.getFilterValues()) {
            viewObjectColumnSettings.setFilterValues(this.getFilterValues());
        }
        if (null != this.getUAKey() && !this.getUAKey().trim().equals("")) {
            viewObjectColumnSettings.setUAKey(this.getUAKey());
        }
        return viewObjectColumnSettings;
    }

    public void setColumnSettings(ViewObjectColumnSettings viewObjectColumnSettings) {
        int n2;
        if (null != viewObjectColumnSettings) {
            if (null != viewObjectColumnSettings.getColumnClass()) {
                this.setColumnClass(viewObjectColumnSettings.getColumnClass());
            }
            if (null != viewObjectColumnSettings.getCellRenderer()) {
                this.setCellRenderer(viewObjectColumnSettings.getCellRenderer());
            }
            if (null != viewObjectColumnSettings.getRollupRenderer()) {
                this.setRollupRenderer(viewObjectColumnSettings.getRollupRenderer());
            }
            if (null != viewObjectColumnSettings.getCellEditor()) {
                this.setCellEditor(viewObjectColumnSettings.getCellEditor());
            }
            this.setSortableDirections(viewObjectColumnSettings.getSortableDirections());
            this.setSortDirection(viewObjectColumnSettings.getSortDirection());
            this.setSortOrdinal(viewObjectColumnSettings.getSortOrdinal());
            this.setRollup(viewObjectColumnSettings.isRollup());
            n2 = viewObjectColumnSettings.getWidth() < 0 ? this.getRealColumnWidth(viewObjectColumnSettings.getInitialWidth()) : viewObjectColumnSettings.getWidth();
            this.setOperator(viewObjectColumnSettings.getOperator());
            if (null != viewObjectColumnSettings.getFilterValues()) {
                this.setFilterValues(viewObjectColumnSettings.getFilterValues());
            }
            if (null != viewObjectColumnSettings.getUAKey() && !viewObjectColumnSettings.getUAKey().trim().equals("")) {
                this.setUAKey(viewObjectColumnSettings.getUAKey());
            }
        } else {
            n2 = this.getRealColumnWidth(0);
        }
        this.setPreferredWidth(n2);
        this.setWidth(n2);
    }

    public boolean test(String string) {
        if (this.filterValues != null) {
            int n2 = 0;
            while (n2 < this.filterValues.length) {
                if (null != string) {
                    string = string.trim();
                }
                switch (this.operator) {
                    case 0: 
                    case 2: {
                        if (this.found(this.filterValues, string)) break;
                        return false;
                    }
                    case 1: 
                    case 3: {
                        if (!this.found(this.filterValues, string)) break;
                        return false;
                    }
                }
                ++n2;
            }
        }
        return true;
    }

    private boolean found(String[] stringArray, String string) {
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (this.sourceMatchesMask(string, stringArray[n2])) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean sourceMatchesMask(String string, String string2) {
        if (null == string) {
            string = "";
        }
        if (string.equals(string2)) {
            return true;
        }
        if (string2.indexOf(42) >= 0 || string2.indexOf(37) >= 0) {
            boolean bl = string2.charAt(0) == '*' || string2.charAt(0) == '%';
            boolean bl2 = string2.charAt(string2.length() - 1) == '*' || string2.charAt(string2.length() - 1) == '%';
            Vector<String> vector = new Vector<String>();
            int n2 = -1;
            int n3 = 0;
            while (n3 < string2.length()) {
                char c2 = string2.charAt(n3);
                if (c2 == '*' || c2 == '%') {
                    if (n3 - n2 > 1) {
                        vector.addElement(string2.substring(n2 + 1, n3));
                    }
                    n2 = n3;
                }
                ++n3;
            }
            if (!bl2) {
                vector.addElement(string2.substring(n2 + 1));
            }
            if (!bl && !string.startsWith((String)vector.firstElement())) {
                return false;
            }
            if (!bl2 && !string.endsWith((String)vector.lastElement())) {
                return false;
            }
            int n4 = 0;
            int n5 = 0;
            while (n5 < vector.size()) {
                String string3 = (String)vector.elementAt(n5);
                n4 = string.indexOf(string3, n4);
                if (n4 == -1) {
                    return false;
                }
                n4 += string3.length();
                ++n5;
            }
            return true;
        }
        return false;
    }

    protected int getRealColumnWidth(int n2) {
        int n3;
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.support", "ViewTableColumn", this, "getRealColumnWidth(int settingsWidth)", new Object[]{new Integer(n2)});
        }
        int n4 = 6;
        int n5 = -1;
        if (this.isRollup() && !this.rollupRenderersUsed) {
            n3 = 19;
        } else {
            n3 = 75;
            if (null != this.getFontMetrics()) {
                int[] nArray = this.getFontMetrics().getWidths();
                int n6 = 0;
                int n7 = 0;
                int n8 = 0;
                while (n8 < nArray.length) {
                    if (nArray[n8] > 0) {
                        n6 += nArray[n8];
                        ++n7;
                    }
                    ++n8;
                }
                if (n7 > 0) {
                    n4 = n6 / n7;
                }
                n3 = 22 + this.getFontMetrics().stringWidth(this.getHeaderValue().toString());
            } else {
                CommonTrace.write(commonTrace, "getFontMetrics() returned 0, use an average width of 6 and a default width of 75");
            }
            n5 = this.columnClass == (class$java$lang$String == null ? (class$java$lang$String = ViewTableColumn.class$("java.lang.String")) : class$java$lang$String) ? n4 * n2 : (this.columnClass == (class$java$lang$Integer == null ? (class$java$lang$Integer = ViewTableColumn.class$("java.lang.Integer")) : class$java$lang$Integer) ? n4 * (n2 <= 0 ? 8 : n2) : n4 * (n2 <= 0 ? 17 : n2));
            if (n5 > n3) {
                n3 = n5;
            }
        }
        return CommonTrace.exit(commonTrace, n3);
    }

    public void setCellRenderer(TableCellRenderer tableCellRenderer) {
        super.setCellRenderer(tableCellRenderer);
    }

    public TableCellRenderer getCellRenderer() {
        return this.cellRenderer;
    }

    public void setCellEditor(TableCellEditor tableCellEditor) {
        super.setCellEditor(tableCellEditor);
    }

    public TableCellEditor getCellEditor() {
        if (this.isRollup() && this.getSortOrdinal() > 0) {
            return null;
        }
        return this.cellEditor;
    }

    public void setHeaderRenderer(TableCellRenderer tableCellRenderer) {
        super.setHeaderRenderer(tableCellRenderer);
    }

    protected TableCellRenderer createDefaultHeaderRenderer() {
        return ViewTableHeader.getDefaultHeaderRenderer();
    }

    public int getNextSortDirection() {
        return ViewTableColumn.getNextSortDirection(this.sortDirection, this.sortableDirections);
    }

    public static int getNextSortDirection(int n2, int n3) {
        int n4;
        if (0 == n3) {
            n4 = 1;
        } else if (16 == n3) {
            n4 = 16;
        } else if (256 == n3) {
            n4 = 256;
        } else {
            n4 = 1;
            if (1 == n2) {
                if ((0x10 | n3) > 0) {
                    n4 = 16;
                } else if ((0x100 | n3) > 0) {
                    n4 = 256;
                }
            } else if (16 == n2 && (0x100 | n3) > 0) {
                n4 = 256;
            }
        }
        return n4;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        super.addPropertyChangeListener(propertyChangeListener);
        if (this.changeSupport == null) {
            this.changeSupport = new SwingPropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        super.removePropertyChangeListener(propertyChangeListener);
        if (this.changeSupport != null) {
            this.changeSupport.removePropertyChangeListener(propertyChangeListener);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

