/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.support;

import com.ibm.db2.tools.common.CommonPopupMenu;
import com.ibm.db2.tools.common.CommonTrace;
import com.ibm.db2.tools.common.ViewTable;
import com.ibm.db2.tools.common.support.PopupAdapter;
import com.ibm.db2.tools.common.support.ViewObjectAction;
import com.ibm.db2.tools.common.support.ViewObjectInterface;
import com.ibm.db2.tools.common.support.ViewTableAbstractModel;
import com.ibm.db2.tools.common.support.ViewTableDefaultActionHandler;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;

public abstract class ViewTableAbstractPopupAdapter
implements PopupAdapter,
MouseListener,
KeyListener,
Serializable {
    private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected ViewTable table;
    protected Window ownerWindow;
    protected InputEvent popupEvent;
    protected boolean checkIntersectMode = false;
    protected ViewTableDefaultActionHandler defaultActionHandler;

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.support", "ViewTableAbstractPopupAdapter", this, "mousePressed(MouseEvent e)", new Object[]{mouseEvent});
        }
        this.handlePopup(mouseEvent);
        CommonTrace.exit(commonTrace);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.support", "ViewTableAbstractPopupAdapter", this, "mouseReleased(MouseEvent e)", new Object[]{mouseEvent});
        }
        this.handlePopup(mouseEvent);
        CommonTrace.exit(commonTrace);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.support", "ViewTableAbstractPopupAdapter", this, "keyPressed(KeyEvent e)", new Object[]{keyEvent});
        }
        this.popupEvent = keyEvent;
        Object object = keyEvent.getSource();
        if (keyEvent.getKeyCode() == 121 && keyEvent.getModifiers() == 1) {
            Component component = keyEvent.getComponent();
            if (component instanceof ViewTable) {
                this.table = (ViewTable)component;
                Rectangle rectangle = this.table.getCellRect(this.table.getSelectedRow(), this.table.getSelectedColumn(), false);
                JPopupMenu jPopupMenu = null;
                int[] nArray = this.table.getSelectedRows();
                jPopupMenu = (null == nArray || nArray.length == 0) && null != this.table.getWhiteSpacePopupProvider() ? this.table.getWhiteSpacePopupProvider().getPopup(new MouseEvent((Component)keyEvent.getSource(), keyEvent.getID(), keyEvent.getWhen(), keyEvent.getModifiers(), rectangle.x, rectangle.y, 1, true)) : this.getMenu();
                if (jPopupMenu != null && null != jPopupMenu.getSubElements() && jPopupMenu.getSubElements().length > 0) {
                    keyEvent.consume();
                    jPopupMenu.show(this.table, rectangle.x, rectangle.y);
                }
            }
        } else if (keyEvent.getKeyCode() == 10) {
            this.invokeDefaultAction(keyEvent);
        }
        this.popupEvent = null;
        CommonTrace.exit(commonTrace);
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void setInvoker(JComponent jComponent) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.support", "ViewTableAbstractPopupAdapter", this, "setInvoker(JComponent newTable)", new Object[]{jComponent});
        }
        if (null != jComponent) {
            if (!(jComponent instanceof ViewTable)) {
                throw CommonTrace.throwException(commonTrace, new IllegalArgumentException("Cannot use this class for an invoker other than a ViewTable"));
            }
            if (!(((ViewTable)jComponent).getModel() instanceof ViewTableAbstractModel)) {
                throw CommonTrace.throwException(commonTrace, new IllegalArgumentException("Cannot set a ViewTable that uses a model other than ViewTableAbstractModel"));
            }
        }
        if (jComponent != this.table) {
            JViewport jViewport;
            JScrollPane jScrollPane;
            if (null != this.table) {
                this.table.removeMouseListener(this);
                this.table.removeKeyListener(this);
                jScrollPane = this.getOwnerScrollPane();
                if (null != jScrollPane) {
                    jScrollPane.removeMouseListener(this);
                    jViewport = jScrollPane.getViewport();
                    jViewport.removeMouseListener(this);
                }
            }
            this.table = (ViewTable)jComponent;
            if (null != this.table) {
                this.table.addMouseListener(this);
                this.table.addKeyListener(this);
                jScrollPane = this.getOwnerScrollPane();
                if (null != jScrollPane) {
                    jScrollPane.addMouseListener(this);
                    jViewport = jScrollPane.getViewport();
                    jViewport.addMouseListener(this);
                }
            }
        }
        CommonTrace.exit(commonTrace);
    }

    public JPopupMenu getMenu() {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.support", "ViewTableAbstractPopupAdapter", this, "getMenu()");
        }
        CommonPopupMenu commonPopupMenu = new CommonPopupMenu();
        commonPopupMenu.add(this.getActions());
        return (JPopupMenu)CommonTrace.exit(commonTrace, commonPopupMenu);
    }

    public ViewObjectAction[] getActions() {
        int n2;
        Object object;
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.support", "ViewTableAbstractPopupAdapter", this, "getMenuActions()");
        }
        int[] nArray = this.table.getSelectedRows();
        int[] nArray2 = this.table.getSelectedModelRows();
        ViewObjectInterface[] viewObjectInterfaceArray = this.getObjectsAtIndices(nArray2);
        int[] nArray3 = new int[]{this.popupEvent instanceof MouseEvent ? this.table.rowAtPoint(new Point(((MouseEvent)this.popupEvent).getX(), ((MouseEvent)this.popupEvent).getY())) : this.table.getSelectionModel().getAnchorSelectionIndex()};
        ViewObjectAction[] viewObjectActionArray = null;
        ViewObjectInterface[] viewObjectInterfaceArray2 = new ViewObjectInterface[]{};
        if (nArray3[0] >= 0) {
            int[] nArray4;
            if (null != this.table.getRollupModel()) {
                nArray4 = this.table.getRollupModel().getModelIndices(nArray3);
            } else {
                nArray4 = new int[nArray3.length];
                int n3 = 0;
                while (n3 < nArray3.length) {
                    nArray4[n3] = this.table.getSortFilterModel().getRowIndex(nArray3[n3]);
                    ++n3;
                }
            }
            viewObjectInterfaceArray2 = this.getObjectsAtIndices(nArray4);
            if (null == viewObjectInterfaceArray || viewObjectInterfaceArray.length == 0 || nArray3[0] < nArray[0] || nArray3[nArray3.length - 1] > nArray[nArray.length - 1]) {
                this.table.clearSelection();
                this.table.setRowSelectionInterval(nArray3[0], nArray3[0]);
                viewObjectInterfaceArray = viewObjectInterfaceArray2;
            }
            object = (ViewTableAbstractModel)this.table.getModel();
            viewObjectActionArray = viewObjectInterfaceArray2[0].getActions(((ViewTableAbstractModel)object).getScope());
            if (viewObjectInterfaceArray.length > 1) {
                boolean bl = true;
                if (this.getCheckIntersectMode()) {
                    bl = ViewObjectAction.isIntersectEnabledFor(viewObjectActionArray);
                }
                if (bl) {
                    n2 = 0;
                    while (n2 < viewObjectInterfaceArray.length) {
                        viewObjectActionArray = ViewObjectAction.intersect(viewObjectActionArray, viewObjectInterfaceArray[n2].getActions(((ViewTableAbstractModel)object).getScope()));
                        ++n2;
                    }
                } else {
                    viewObjectActionArray = ViewObjectAction.filterMultiActions(viewObjectActionArray);
                }
            }
        }
        object = null;
        if (null != this.table.getGlobalActionsProvider()) {
            object = this.table.getGlobalActionsProvider().getActions(this.popupEvent);
        }
        ViewObjectAction[] viewObjectActionArray2 = new ViewObjectAction[]{};
        if (null == viewObjectActionArray) {
            viewObjectActionArray = new ViewObjectAction[]{};
        }
        viewObjectActionArray2 = viewObjectActionArray;
        if (null != object) {
            n2 = viewObjectActionArray.length > 0 ? 1 : 0;
            viewObjectActionArray2 = new ViewObjectAction[viewObjectActionArray.length + (n2 != 0 ? 1 : 0) + ((ViewObjectAction[])object).length];
            System.arraycopy(viewObjectActionArray, 0, viewObjectActionArray2, 0, viewObjectActionArray.length);
            if (n2 != 0) {
                viewObjectActionArray2[viewObjectActionArray.length] = new ViewObjectAction();
            }
            System.arraycopy(object, 0, viewObjectActionArray2, viewObjectActionArray.length + (n2 != 0 ? 1 : 0), ((Object)object).length);
        }
        n2 = 0;
        while (n2 < viewObjectActionArray2.length) {
            viewObjectActionArray2[n2].setSelectedObjects(viewObjectInterfaceArray);
            if (viewObjectInterfaceArray2.length > 0) {
                viewObjectActionArray2[n2].setFocusedObject(viewObjectInterfaceArray2[0]);
            }
            viewObjectActionArray2[n2].setOwnerWindow(this.getOwnerWindow());
            if (viewObjectActionArray2[n2].isCascade()) {
                this.updateCascade(viewObjectActionArray2[n2]);
            }
            ++n2;
        }
        return (ViewObjectAction[])CommonTrace.exit(commonTrace, viewObjectActionArray2);
    }

    public boolean getCheckIntersectMode() {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.support", "ViewTableAbstractPopupAdapter", this, "getCheckIntersectMode()");
        }
        return CommonTrace.exit(commonTrace, this.checkIntersectMode);
    }

    public void setCheckIntersectMode(boolean bl) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.support", "ViewTableAbstractPopupAdapter", this, "setCheckIntersectMode(boolean mode)", new Object[]{new Boolean(bl)});
        }
        this.checkIntersectMode = bl;
        CommonTrace.exit(commonTrace);
    }

    public void setDefaultActionHandler(ViewTableDefaultActionHandler viewTableDefaultActionHandler) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.support", "ViewTableAbstractPopupAdapter", this, "setDefaultActionHandler(ViewTableDefaultActionHandler aHandler)", new Object[]{viewTableDefaultActionHandler});
        }
        this.defaultActionHandler = viewTableDefaultActionHandler;
        CommonTrace.exit(commonTrace);
    }

    public ViewTableDefaultActionHandler getDefaultActionHandler() {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.support", "ViewTableAbstractPopupAdapter", this, "getDefaultActionHandler()");
        }
        return (ViewTableDefaultActionHandler)CommonTrace.exit(commonTrace, this.defaultActionHandler);
    }

    protected void handlePopup(MouseEvent mouseEvent) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.support", "ViewTableAbstractPopupAdapter", this, "handlePopup(MouseEvent anEvent)", new Object[]{mouseEvent});
        }
        this.popupEvent = mouseEvent;
        if (((MouseEvent)this.popupEvent).isPopupTrigger()) {
            int n2 = this.table.rowAtPoint(new Point(((MouseEvent)this.popupEvent).getX(), ((MouseEvent)this.popupEvent).getY()));
            JPopupMenu jPopupMenu = n2 >= 0 && n2 <= this.table.getRowCount() ? this.getMenu() : (null != this.table.getWhiteSpacePopupProvider() ? this.table.getWhiteSpacePopupProvider().getPopup((MouseEvent)this.popupEvent) : null);
            if (jPopupMenu != null && null != jPopupMenu.getSubElements() && jPopupMenu.getSubElements().length > 0) {
                jPopupMenu.show(this.popupEvent.getComponent(), ((MouseEvent)this.popupEvent).getX(), ((MouseEvent)this.popupEvent).getY());
            }
        } else if (502 == this.popupEvent.getID() && 2 == ((MouseEvent)this.popupEvent).getClickCount()) {
            this.invokeDefaultAction(this.popupEvent);
        }
        this.popupEvent = null;
        CommonTrace.exit(commonTrace);
    }

    protected void updateCascade(ViewObjectAction viewObjectAction) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.support", "ViewTableAbstractPopupAdapter", this, "updateCascade(ViewObjectAction parentAction)", new Object[]{viewObjectAction});
        }
        if (!viewObjectAction.isCascade()) {
            CommonTrace.exit(commonTrace);
            return;
        }
        ViewObjectInterface[] viewObjectInterfaceArray = viewObjectAction.getSelectedObjects();
        ViewObjectInterface viewObjectInterface = viewObjectAction.getFocusedObject();
        ViewObjectAction viewObjectAction2 = null;
        Vector vector = viewObjectAction.getCascade();
        int n2 = 0;
        while (n2 < vector.size()) {
            viewObjectAction2 = (ViewObjectAction)vector.elementAt(n2);
            viewObjectAction2.setSelectedObjects(viewObjectInterfaceArray);
            viewObjectAction2.setFocusedObject(viewObjectInterface);
            viewObjectAction2.setOwnerWindow(this.getOwnerWindow());
            if (viewObjectAction2.isCascade()) {
                this.updateCascade(viewObjectAction2);
            }
            ++n2;
        }
        CommonTrace.exit(commonTrace);
    }

    protected Window getOwnerWindow() {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.support", "ViewTableAbstractPopupAdapter", this, "getOwnerWindow()");
        }
        if (null == this.ownerWindow) {
            Container container = this.table.getParent();
            while (container != null && !(container instanceof Dialog) && !(container instanceof Frame)) {
                if ((container = container.getParent()) instanceof Dialog) {
                    this.ownerWindow = (Dialog)container;
                }
                if (!(container instanceof Frame)) continue;
                this.ownerWindow = (Window)container;
            }
        }
        return (Window)CommonTrace.exit(commonTrace, this.ownerWindow);
    }

    protected JScrollPane getOwnerScrollPane() {
        JViewport jViewport;
        Container container;
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.support", "ViewTableAbstractPopupAdapter", this, "getOwnerScrollPane()");
        }
        JScrollPane jScrollPane = null;
        Container container2 = this.table.getParent();
        if (container2 instanceof JViewport && (container = container2.getParent()) instanceof JScrollPane && ((jViewport = (jScrollPane = (JScrollPane)container).getViewport()) == null || jViewport.getView() != this.table)) {
            return (JScrollPane)CommonTrace.exit(commonTrace, null);
        }
        return (JScrollPane)CommonTrace.exit(commonTrace, jScrollPane);
    }

    protected ViewObjectAction getDefaultAction(ViewObjectAction[] viewObjectActionArray) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.support", "ViewTableAbstractPopupAdapter", this, "getDefaultAction(ViewObjectAction[] actions)", new Object[]{viewObjectActionArray});
        }
        ViewObjectAction viewObjectAction = null;
        int n2 = 0;
        while (n2 < viewObjectActionArray.length) {
            if (viewObjectActionArray[n2].isDefault()) {
                viewObjectAction = viewObjectActionArray[n2];
                if (null != viewObjectAction) {
                    break;
                }
            } else if (viewObjectActionArray[n2].isCascade()) {
                Vector vector = viewObjectActionArray[n2].getCascade();
                Object[] objectArray = new ViewObjectAction[vector.size()];
                vector.copyInto(objectArray);
                viewObjectAction = this.getDefaultAction((ViewObjectAction[])objectArray);
                if (null != viewObjectAction) break;
            }
            ++n2;
        }
        return (ViewObjectAction)CommonTrace.exit(commonTrace, viewObjectAction);
    }

    protected void invokeDefaultAction(InputEvent inputEvent) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.support", "ViewTableAbstractPopupAdapter", this, "invokeDefaultAction(InputEvent e)", new Object[]{inputEvent});
        }
        final InputEvent inputEvent2 = inputEvent;
        if (inputEvent.getComponent() instanceof ViewTable) {
            ViewObjectAction[] viewObjectActionArray;
            this.table = (ViewTable)inputEvent.getComponent();
            int n2 = this.table.getSelectedRow();
            int n3 = this.table.getSelectedColumn();
            if (!this.table.isUpdating() && n2 >= 0 && n3 >= 0 && !this.table.isCellEditable(n2, n3) && null != (viewObjectActionArray = this.getActions()) && viewObjectActionArray.length > 0) {
                final ViewObjectAction viewObjectAction = this.getDefaultAction(viewObjectActionArray);
                if (null != viewObjectAction) {
                    inputEvent.consume();
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            CommonTrace commonTrace = null;
                            if (CommonTrace.isTrace()) {
                                commonTrace = CommonTrace.create("com.ibm.db2.tools.common.support", "ViewTableAbstractPopupAdapter", "run()");
                            }
                            viewObjectAction.actionPerformed(new ActionEvent(inputEvent2.getComponent(), 1001, viewObjectAction.getName()));
                            CommonTrace.exit(commonTrace);
                        }
                    });
                } else if (null != this.defaultActionHandler) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            CommonTrace commonTrace = null;
                            if (CommonTrace.isTrace()) {
                                commonTrace = CommonTrace.create("com.ibm.db2.tools.common.support", "ViewTableAbstractPopupAdapter", "run()");
                            }
                            ViewTableAbstractPopupAdapter.this.defaultActionHandler.handleDefaultAction(inputEvent2);
                            CommonTrace.exit(commonTrace);
                        }
                    });
                } else {
                    CommonTrace.write(commonTrace, "No default action defined for the clicked object");
                }
            }
        }
        CommonTrace.exit(commonTrace);
    }

    protected abstract ViewObjectInterface[] getObjectsAtIndices(int[] var1);
}

