/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.support;

import com.ibm.db2.tools.common.CommonTrace;
import com.ibm.db2.tools.common.support.ViewObjectColumnSettings;
import com.ibm.db2.tools.common.support.ViewObjectColumnsInterface;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

public abstract class ViewTableAbstractModel
extends AbstractTableModel {
    private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected Vector columnInterfaces;
    protected Vector columnIdentifiers;
    protected ViewObjectColumnSettings[] columnSettings;
    protected Object scope;

    public void setColumnIdentifiers(Vector vector) {
        this.setColumnIdentifiers(vector, this.getScope());
    }

    public void setColumnIdentifiers(ViewObjectColumnsInterface[] viewObjectColumnsInterfaceArray) {
        this.setColumnIdentifiers(ViewTableAbstractModel.convertToVector(viewObjectColumnsInterfaceArray), this.getScope());
    }

    public void setColumnIdentifiers(Vector vector, Object object) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.support", "ViewTableAbstractModel", this, "setColumnIdentifiers(Vector newColumnInterfaces, Object newScope)", new Object[]{vector, object});
        }
        if (null == vector) {
            throw (IllegalArgumentException)CommonTrace.throwException(commonTrace, new IllegalArgumentException("setColumnIdentifiers() - ViewObjectColumnsInterface[] parameter null"));
        }
        if (vector.size() < 1) {
            throw (IllegalArgumentException)CommonTrace.throwException(commonTrace, new IllegalArgumentException("setColumnIdentifiers() - ViewObjectColumnsInterface[].length < 1"));
        }
        Object object2 = this.scope;
        if (!vector.equals(this.columnInterfaces) || null != this.scope && !this.scope.equals(object) || null != object && !object.equals(this.scope)) {
            this.columnInterfaces = vector;
            this.scope = object;
            Object[] objectArray = ((ViewObjectColumnsInterface)this.columnInterfaces.elementAt(0)).getColumnNames(this.scope);
            if (null == objectArray) {
                throw (IllegalArgumentException)CommonTrace.throwException(commonTrace, new IllegalArgumentException("setColumnIdentifiers() - getColumnNames() on the supplied ViewObjectColumnsInterface cannot return null"));
            }
            this.columnIdentifiers = ViewTableAbstractModel.convertToVector(objectArray);
            ViewObjectColumnSettings[] viewObjectColumnSettingsArray = ((ViewObjectColumnsInterface)this.columnInterfaces.elementAt(0)).getColumnSettings(this.scope);
            if (null != viewObjectColumnSettingsArray && viewObjectColumnSettingsArray.length != this.columnIdentifiers.size()) {
                throw (IllegalArgumentException)CommonTrace.throwException(commonTrace, new IllegalArgumentException("getColumnSettings from ViewObjectColumnsInterface returned a different size ( " + viewObjectColumnSettingsArray.length + " ) than " + "getColumnNames ( " + this.columnIdentifiers.size() + " ). "));
            }
            this.columnSettings = viewObjectColumnSettingsArray;
            this.fireTableStructureChanged();
        }
        CommonTrace.exit(commonTrace);
    }

    public int getColumnCount() {
        return this.columnIdentifiers.size();
    }

    public String getColumnName(int n2) {
        if (this.columnIdentifiers == null || this.columnIdentifiers.size() <= n2) {
            return super.getColumnName(n2);
        }
        Object e2 = this.columnIdentifiers.elementAt(n2);
        if (e2 == null) {
            return super.getColumnName(n2);
        }
        return e2.toString();
    }

    public final ViewObjectColumnSettings[] getColumnSettings() {
        return this.columnSettings;
    }

    public ViewObjectColumnSettings getColumnSettings(int n2) {
        if (this.columnSettings != null && n2 < this.columnSettings.length) {
            return this.columnSettings[n2];
        }
        return null;
    }

    public void setScope(Object object) {
        this.setColumnIdentifiers(this.columnInterfaces, object);
    }

    public final Object getScope() {
        return this.scope;
    }

    protected static Vector convertToVector(Object[] objectArray) {
        if (objectArray == null) {
            return new Vector();
        }
        Vector<Object> vector = new Vector<Object>(objectArray.length);
        int n2 = 0;
        while (n2 < objectArray.length) {
            vector.addElement(objectArray[n2]);
            ++n2;
        }
        return vector;
    }

    protected ViewObjectColumnsInterface[] getColumnsInterfacesArray(ViewObjectColumnsInterface viewObjectColumnsInterface) {
        ViewObjectColumnsInterface[] viewObjectColumnsInterfaceArray = new ViewObjectColumnsInterface[]{viewObjectColumnsInterface};
        return viewObjectColumnsInterfaceArray;
    }
}

