/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.support;

import com.ibm.db2.tools.common.CmStringPool;
import com.ibm.db2.tools.common.CommonDialog;
import com.ibm.db2.tools.common.SloshBucketDefaultList;
import com.ibm.db2.tools.common.SloshBucketListDefaultCellRenderer;
import com.ibm.db2.tools.common.SloshBucketOrderInterface;
import com.ibm.db2.tools.common.SloshBucketPanel;
import com.ibm.db2.tools.common.ViewTable;
import com.ibm.db2.tools.common.support.SloshBucketColumnPanel;
import com.ibm.db2.tools.common.support.ViewColumnWrapper;
import com.ibm.db2.tools.common.support.ViewObjectInterface;
import com.ibm.db2.tools.common.support.ViewTableColumn;
import com.ibm.db2.tools.common.support.ViewTableColumnModel;
import com.ibm.db2.tools.common.support.ViewTableModel;
import com.ibm.db2.tools.common.support.ViewVector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableColumn;

public class ViewSortDialog
extends CommonDialog
implements SloshBucketOrderInterface {
    protected SloshBucketPanel sb;
    protected ViewTable table;
    protected int rollupColumnsCount;

    public ViewSortDialog(JFrame jFrame, ViewTable viewTable) {
        super(jFrame, CmStringPool.get(176), true, 14L);
        this.init(viewTable);
    }

    public ViewSortDialog(CommonDialog commonDialog, ViewTable viewTable) {
        super(commonDialog, CmStringPool.get(176), true, 14L);
        this.init(viewTable);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand() == "OK") {
            this.processOkEvent();
            this.close();
        }
        super.actionPerformed(actionEvent);
    }

    public boolean getIsAscending(Object object) {
        return ((ViewColumnWrapper)object).isAscending();
    }

    public void setIsAscending(Object object, boolean bl) {
        ((ViewColumnWrapper)object).setAscending(bl);
    }

    protected void init(ViewTable viewTable) {
        this.table = viewTable;
        this.makeLayout();
        this.setupSloshBucket();
        this.addButtonsActionListener(this);
        this.pack();
        ((Component)this).setSize(this.getPreferredSize());
        this.setVisible(true);
    }

    private void processOkEvent() {
        ViewColumnWrapper viewColumnWrapper = null;
        ViewTableColumn viewTableColumn = null;
        ViewTableColumn viewTableColumn2 = null;
        ViewTableColumn viewTableColumn3 = null;
        Vector vector = ((SloshBucketColumnPanel)this.sb.getRightPanel(0)).getAllItems();
        int n2 = 0;
        ViewTableColumnModel viewTableColumnModel = (ViewTableColumnModel)this.table.getColumnModel();
        int n3 = 0;
        while (n3 < vector.size()) {
            viewColumnWrapper = (ViewColumnWrapper)vector.elementAt(n3);
            viewTableColumn = viewColumnWrapper.getColumn();
            viewTableColumn.setChangeSupportEnabled(false);
            viewTableColumn.setSortDirection(viewColumnWrapper.isAscending() ? 16 : 256);
            viewTableColumn.setSortOrdinal(n3 + 1);
            viewTableColumn.setRollup(viewColumnWrapper.isRollup());
            if (viewColumnWrapper.isRollup()) {
                ++n2;
            }
            Enumeration<TableColumn> enumeration = viewTableColumnModel.getColumns();
            int n4 = -1;
            boolean bl = false;
            while (enumeration.hasMoreElements()) {
                viewTableColumn2 = (ViewTableColumn)enumeration.nextElement();
                if (viewTableColumn2.getModelIndex() != viewTableColumn.getModelIndex()) continue;
                n4 = viewTableColumnModel.getColumnIndex(viewTableColumn2.getHeaderValue());
                bl = true;
                break;
            }
            if (!bl) {
                viewTableColumnModel.addColumn(viewTableColumn);
                n4 = viewTableColumnModel.getColumnIndex(viewTableColumn.getHeaderValue());
            }
            if (n3 < n4 && viewTableColumn.isRollup()) {
                viewTableColumnModel.moveColumn(n4, n3);
            }
            viewTableColumn.setChangeSupportEnabled(true);
            if (null == viewTableColumn3) {
                viewTableColumn3 = viewTableColumn;
            }
            ++n3;
        }
        vector = ((SloshBucketDefaultList)this.sb.getLeftPanel()).getAllItems();
        int n5 = 0;
        while (n5 < vector.size()) {
            viewTableColumn = (ViewTableColumn)vector.elementAt(n5);
            viewTableColumn.setChangeSupportEnabled(false);
            viewTableColumn.setSortDirection(1);
            viewTableColumn.setSortOrdinal(0);
            viewTableColumn.setRollup(false);
            viewTableColumn.setChangeSupportEnabled(true);
            if (null == viewTableColumn3) {
                viewTableColumn3 = viewTableColumn;
            }
            ++n5;
        }
        if (null != viewTableColumn3) {
            int n6 = viewTableColumn3.getSortDirection();
            viewTableColumn3.setChangeSupportEnabled(false);
            viewTableColumn3.setSortDirection(viewTableColumn3.getNextSortDirection());
            viewTableColumn3.setChangeSupportEnabled(true);
            viewTableColumn3.setSortDirection(n6);
        }
    }

    private void makeLayout() {
        JPanel jPanel = this.getPanel();
        this.makeMainPanel(jPanel);
        this.setClient(jPanel);
    }

    private JPanel makeMainPanel(JPanel jPanel) {
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        SloshBucketListDefaultCellRenderer sloshBucketListDefaultCellRenderer = new SloshBucketListDefaultCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n2, boolean bl, boolean bl2) {
                super.getListCellRendererComponent(jList, object, n2, bl, bl2);
                this.setText(((TableColumn)object).getHeaderValue().toString());
                return this;
            }
        };
        SloshBucketDefaultList sloshBucketDefaultList = new SloshBucketDefaultList(CmStringPool.get(173), false);
        sloshBucketDefaultList.getList().setCellRenderer(sloshBucketListDefaultCellRenderer);
        SloshBucketColumnPanel sloshBucketColumnPanel = new SloshBucketColumnPanel(CmStringPool.get(177), (CommonDialog)this, (SloshBucketOrderInterface)this);
        sloshBucketColumnPanel.getCommonView().getTable().setModel(new ViewTableModel((Vector)new ViewVector(), (ViewObjectInterface)ViewColumnWrapper.getSharedInstance(), null));
        this.sb = new SloshBucketPanel(sloshBucketDefaultList, sloshBucketColumnPanel);
        jPanel.add("Center", this.sb);
        Dimension dimension = new Dimension(700, 200);
        this.sb.setSize(dimension);
        this.sb.setPreferredSize(dimension);
        this.sb.putClientProperty("UAKey", "ViewSortDialog");
        return jPanel;
    }

    private void setupSloshBucket() {
        ViewTableColumnModel viewTableColumnModel = (ViewTableColumnModel)this.table.getColumnModel();
        Enumeration enumeration = viewTableColumnModel.getAllColumns();
        int n2 = viewTableColumnModel.getAllColumnCount();
        ViewTableColumn[] viewTableColumnArray = new ViewTableColumn[n2 + 1];
        ViewColumnWrapper[] viewColumnWrapperArray = new ViewColumnWrapper[n2 + 1];
        while (enumeration.hasMoreElements()) {
            ViewTableColumn viewTableColumn = (ViewTableColumn)enumeration.nextElement();
            if (viewTableColumn.getSortDirection() != 1) {
                if (viewTableColumn.getSortOrdinal() <= 0) continue;
                viewColumnWrapperArray[viewTableColumn.getSortOrdinal()] = new ViewColumnWrapper(viewTableColumn);
                continue;
            }
            viewTableColumnArray[viewTableColumn.getModelIndex()] = viewTableColumn;
        }
        Vector<ViewColumnWrapper> vector = new Vector<ViewColumnWrapper>();
        int n3 = 0;
        while (n3 < viewColumnWrapperArray.length) {
            if (null != viewColumnWrapperArray[n3]) {
                vector.add(viewColumnWrapperArray[n3]);
            }
            ++n3;
        }
        Vector<ViewTableColumn> vector2 = new Vector<ViewTableColumn>();
        int n4 = 0;
        while (n4 < viewTableColumnArray.length) {
            if (null != viewTableColumnArray[n4]) {
                vector2.add(viewTableColumnArray[n4]);
            }
            ++n4;
        }
        ((SloshBucketDefaultList)this.sb.getLeftPanel()).addItems(vector2, true);
        ((SloshBucketColumnPanel)this.sb.getRightPanel(0)).loadItems(vector);
    }
}

