/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.support;

import com.ibm.db2.tools.common.CmStringPool;
import com.ibm.db2.tools.common.CommonPrintDriver;
import com.ibm.db2.tools.common.CommonView;
import com.ibm.db2.tools.common.ViewTable;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Window;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import javax.swing.JDialog;
import javax.swing.JFrame;

public class ViewPrintDriver
extends CommonPrintDriver {
    private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected CommonView commonView;
    protected Frame frame;

    public ViewPrintDriver(CommonView commonView) {
        this.commonView = commonView;
    }

    public Frame getFrame() {
        Window window = this.commonView.getOwner();
        while (window != null && !(window instanceof JFrame)) {
            window = window.getOwner();
        }
        this.frame = (JFrame)window;
        return this.frame;
    }

    public PageFormat getPageFormat() {
        return CommonView.getPageFormat();
    }

    public void setPageFormat(PageFormat pageFormat) {
        CommonView.setPageFormat(pageFormat);
    }

    public String getTitle() {
        String string = null;
        if (this.commonView.getOwner() instanceof JDialog && null != ((JDialog)this.commonView.getOwner()).getTitle() && !((JDialog)this.commonView.getOwner()).getTitle().trim().equals("")) {
            string = ((JDialog)this.commonView.getOwner()).getTitle();
        }
        if (null == string && null != this.frame.getTitle() && !this.frame.getTitle().trim().equals("")) {
            string = this.frame.getTitle();
        }
        if (null != this.commonView.getInfoAreaText()) {
            string = null != string ? string + " - " + this.commonView.getInfoAreaText() : this.commonView.getInfoAreaText();
        }
        return string;
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n2) throws PrinterException {
        ViewTable viewTable = this.commonView.getTable();
        double d2 = viewTable.getColumnModel().getTotalColumnWidth();
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setColor(Color.black);
        int n3 = graphics2D.getFontMetrics().getHeight();
        int n4 = graphics2D.getFontMetrics().getDescent();
        double d3 = pageFormat.getImageableHeight();
        double d4 = pageFormat.getImageableWidth();
        double d5 = 1.0;
        if (d2 >= d4) {
            d5 = d4 / d2;
        }
        double d6 = (double)viewTable.getTableHeader().getHeight() * d5;
        double d7 = d2 * d5;
        double d8 = (double)(viewTable.getRowHeight() + 2 * viewTable.getRowMargin()) * d5;
        int n5 = (int)((d3 - (double)(4 * n3) - d6) / d8);
        double d9 = d8 * (double)n5;
        int n6 = (int)Math.ceil((double)viewTable.getRowCount() / (double)n5);
        if (n2 >= n6) {
            return 1;
        }
        graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        graphics2D.drawString(this.getTitle(), 0, n3);
        graphics2D.drawString(CmStringPool.get(123, Integer.toString(n2 + 1)), 0, (int)(d3 - (double)n4));
        graphics2D.translate(0.0, d6 + (double)(2 * n3));
        graphics2D.translate(0.0, (double)(-n2) * d9);
        graphics2D.setClip(0, (int)(d9 * (double)n2), (int)Math.ceil(d7), (int)Math.ceil(d9));
        graphics2D.scale(d5, d5);
        viewTable.paint(graphics2D);
        graphics2D.scale(1.0 / d5, 1.0 / d5);
        graphics2D.translate(0.0, (double)n2 * d9);
        graphics2D.translate(0.0, -d6);
        graphics2D.setClip(0, 0, (int)Math.ceil(d7), (int)Math.ceil(d6));
        graphics2D.scale(d5, d5);
        viewTable.getTableHeader().paint(graphics2D);
        return 0;
    }
}

