/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.support;

import com.ibm.db2.tools.common.CommonTrace;
import com.ibm.db2.tools.common.support.ViewObjectNamedSettings;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.event.SwingPropertyChangeSupport;

public class ViewObjectNamedSettingsSet
implements Cloneable,
Serializable {
    private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    static final long serialVersionUID = -7862655845057615328L;
    private transient SwingPropertyChangeSupport changeSupport;
    protected int currentSettingsIndex = -1;
    protected int firstCustomSettingsIndex = 1;
    protected ViewObjectNamedSettings[] namedSettings = new ViewObjectNamedSettings[0];

    public Object clone() {
        ViewObjectNamedSettingsSet viewObjectNamedSettingsSet;
        try {
            viewObjectNamedSettingsSet = (ViewObjectNamedSettingsSet)super.clone();
            viewObjectNamedSettingsSet.currentSettingsIndex = this.currentSettingsIndex;
            viewObjectNamedSettingsSet.firstCustomSettingsIndex = this.firstCustomSettingsIndex;
            if (null != this.namedSettings) {
                viewObjectNamedSettingsSet.namedSettings = new ViewObjectNamedSettings[this.namedSettings.length];
                int n2 = 0;
                while (n2 < this.namedSettings.length) {
                    if (null != this.namedSettings[n2]) {
                        viewObjectNamedSettingsSet.namedSettings[n2] = (ViewObjectNamedSettings)this.namedSettings[n2].clone();
                    }
                    ++n2;
                }
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        return viewObjectNamedSettingsSet;
    }

    public final int getCurrentSettingsIndex() {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.support", "ViewObjectNamedSettingsSet", "public final int getCurrentSettingsIndex()");
        }
        if (null == this.namedSettings) {
            if (CommonTrace.isTrace()) {
                CommonTrace.write(commonTrace, "No named settings, returning -1.");
            }
        } else if (this.currentSettingsIndex < 0 || this.currentSettingsIndex >= this.namedSettings.length) {
            if (CommonTrace.isTrace()) {
                CommonTrace.write(commonTrace, "No named settings at the specified index, returning the last value.");
            }
            this.currentSettingsIndex = this.namedSettings.length - 1;
        }
        return CommonTrace.exit(commonTrace, this.currentSettingsIndex);
    }

    public void setCurrentSettingsIndex(int n2) {
        this.setCurrentSettingsIndex(n2, false);
    }

    public void setCurrentSettingsIndex(int n2, boolean bl) {
        ViewObjectNamedSettings viewObjectNamedSettings;
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.support", "ViewObjectNamedSettingsSet", "public void setCurrentSettingsIndex( int aSettingsIndex, boolean fromTable )", new Object[]{new Integer(n2), new Boolean(bl)});
        }
        int n3 = this.currentSettingsIndex;
        ViewObjectNamedSettings viewObjectNamedSettings2 = viewObjectNamedSettings = this.currentSettingsIndex >= 0 ? this.getNamedSettings(this.currentSettingsIndex) : null;
        if (n3 != n2) {
            this.currentSettingsIndex = n2;
            ViewObjectNamedSettings viewObjectNamedSettings3 = this.currentSettingsIndex >= 0 ? this.getNamedSettings(this.currentSettingsIndex) : null;
            this.getChangeSupport().firePropertyChange("currentSettings", viewObjectNamedSettings, viewObjectNamedSettings3);
            if (!bl) {
                this.getChangeSupport().firePropertyChange("currentSettings_notFromTable", viewObjectNamedSettings, viewObjectNamedSettings3);
            }
        }
        CommonTrace.exit(commonTrace);
    }

    public final int getFirstCustomSettingsIndex() {
        return this.firstCustomSettingsIndex;
    }

    public void setFirstCustomSettingsIndex(int n2) {
        this.firstCustomSettingsIndex = n2;
    }

    public ViewObjectNamedSettings[] getNamedSettings() {
        return this.namedSettings;
    }

    public void setNamedSettings(ViewObjectNamedSettings[] viewObjectNamedSettingsArray) {
        ViewObjectNamedSettings viewObjectNamedSettings = this.currentSettingsIndex >= 0 ? this.getNamedSettings(this.currentSettingsIndex) : null;
        this.namedSettings = viewObjectNamedSettingsArray;
        this.getChangeSupport().firePropertyChange("currentSettings", viewObjectNamedSettings, this.currentSettingsIndex >= 0 ? this.getNamedSettings(this.currentSettingsIndex) : null);
        this.getChangeSupport().firePropertyChange("currentSettings_notFromTable", viewObjectNamedSettings, this.currentSettingsIndex >= 0 ? this.getNamedSettings(this.currentSettingsIndex) : null);
    }

    public ViewObjectNamedSettings getNamedSettings(int n2) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.support", "ViewObjectNamedSettingsSet", "public ViewObjectColumnSettings getNamedSettings( int index )", new Object[]{new Integer(n2)});
        }
        ViewObjectNamedSettings viewObjectNamedSettings = null;
        if (null == this.namedSettings || n2 >= this.namedSettings.length) {
            if (CommonTrace.isTrace()) {
                CommonTrace.write(commonTrace, "No named settings at the specified index, returning null.");
            }
        } else {
            viewObjectNamedSettings = this.namedSettings[n2];
        }
        return (ViewObjectNamedSettings)CommonTrace.exit(commonTrace, viewObjectNamedSettings);
    }

    public void setNamedSettings(int n2, ViewObjectNamedSettings viewObjectNamedSettings) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.support", "ViewObjectNamedSettingsSet", "public void setNamedSettings( int index, ViewObjectNamedSettings aNamedSettings ", new Object[]{new Integer(n2), viewObjectNamedSettings});
        }
        if (null == this.namedSettings || n2 >= this.namedSettings.length) {
            if (CommonTrace.isTrace()) {
                CommonTrace.write(commonTrace, "No named settings at the specified index, doing nothing.");
            }
        } else {
            ViewObjectNamedSettings viewObjectNamedSettings2 = this.getNamedSettings(n2);
            if (viewObjectNamedSettings2 != viewObjectNamedSettings) {
                this.namedSettings[n2] = viewObjectNamedSettings;
                if (this.getCurrentSettingsIndex() == n2) {
                    this.getChangeSupport().firePropertyChange("currentSettings", viewObjectNamedSettings2, viewObjectNamedSettings);
                    this.getChangeSupport().firePropertyChange("currentSettings_notFromTable", viewObjectNamedSettings2, viewObjectNamedSettings);
                }
            }
        }
        CommonTrace.exit(commonTrace);
    }

    public boolean setCurrentSettings(String string) {
        if (null == string || string.trim().equals("")) {
            throw new IllegalArgumentException("The aSettingsName parameter cannot be a null or an empty string");
        }
        if (null != this.namedSettings) {
            int n2 = 0;
            while (n2 < this.namedSettings.length) {
                if (null != this.namedSettings[n2] && this.namedSettings[n2].getName().equals(string.trim())) {
                    this.setCurrentSettingsIndex(n2);
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public void addNamedSettings(ViewObjectNamedSettings viewObjectNamedSettings) {
        if (null == this.namedSettings) {
            this.namedSettings = new ViewObjectNamedSettings[1];
        } else {
            ViewObjectNamedSettings[] viewObjectNamedSettingsArray = this.namedSettings;
            this.namedSettings = new ViewObjectNamedSettings[viewObjectNamedSettingsArray.length + 1];
            System.arraycopy(viewObjectNamedSettingsArray, 0, this.namedSettings, 0, viewObjectNamedSettingsArray.length);
            this.namedSettings[viewObjectNamedSettingsArray.length] = viewObjectNamedSettings;
        }
    }

    public ViewObjectNamedSettings removeCurrentSettings() {
        if (this.currentSettingsIndex > 0 && this.currentSettingsIndex < this.firstCustomSettingsIndex) {
            throw new IllegalArgumentException("Cannot remove initial named settings");
        }
        ViewObjectNamedSettings viewObjectNamedSettings = null;
        if (null != this.namedSettings) {
            viewObjectNamedSettings = this.namedSettings[this.currentSettingsIndex];
            int n2 = this.currentSettingsIndex;
            if (0 == this.currentSettingsIndex) {
                if (this.namedSettings.length > 1) {
                    n2 = this.currentSettingsIndex + 1;
                }
                this.namedSettings[0] = null;
            } else if (this.currentSettingsIndex > 0) {
                if (this.namedSettings.length - 1 == this.currentSettingsIndex) {
                    n2 = this.currentSettingsIndex - 1;
                }
                ViewObjectNamedSettings[] viewObjectNamedSettingsArray = this.namedSettings;
                this.namedSettings = new ViewObjectNamedSettings[viewObjectNamedSettingsArray.length - 1];
                System.arraycopy(viewObjectNamedSettingsArray, 0, this.namedSettings, 0, this.currentSettingsIndex);
                System.arraycopy(viewObjectNamedSettingsArray, this.currentSettingsIndex + 1, this.namedSettings, this.currentSettingsIndex, this.namedSettings.length - this.currentSettingsIndex);
            }
            this.currentSettingsIndex = n2;
            this.getChangeSupport().firePropertyChange("currentSettings", viewObjectNamedSettings, this.namedSettings[this.currentSettingsIndex]);
            this.getChangeSupport().firePropertyChange("currentSettings_notFromTable", viewObjectNamedSettings, this.namedSettings[this.currentSettingsIndex]);
        }
        return viewObjectNamedSettings;
    }

    public void saveTempSettings() {
        ViewObjectNamedSettings viewObjectNamedSettings = null;
        if (null != this.namedSettings) {
            viewObjectNamedSettings = this.namedSettings[0];
            if (null == viewObjectNamedSettings) {
                throw new RuntimeException("Cannot save the temporary settings at index 0 are they are null.");
            }
            String string = viewObjectNamedSettings.getName().substring(0, viewObjectNamedSettings.getName().length() - 1);
            int n2 = this.indexOf(string);
            viewObjectNamedSettings.setName(string);
            this.namedSettings[0] = null;
            if (n2 < 0) {
                this.addNamedSettings(viewObjectNamedSettings);
                this.setCurrentSettingsIndex(this.namedSettings.length - 1);
            } else {
                this.setNamedSettings(n2, viewObjectNamedSettings);
                this.setCurrentSettingsIndex(n2);
            }
        }
    }

    public int indexOf(String string) {
        int n2 = -1;
        if (null != this.namedSettings) {
            int n3 = 0;
            while (n3 < this.namedSettings.length) {
                if ((0 != n3 || null != this.namedSettings[n3]) && this.namedSettings[n3].getName().equals(string)) {
                    n2 = n3;
                    break;
                }
                ++n3;
            }
        }
        return n2;
    }

    public String toString() {
        String string = "[" + this.currentSettingsIndex + ":";
        if (null != this.namedSettings) {
            int n2 = 0;
            while (n2 < this.namedSettings.length) {
                string = string + "[" + n2 + ":" + this.namedSettings[n2] + "]";
                ++n2;
            }
        }
        string = string + "]";
        return string;
    }

    private SwingPropertyChangeSupport getChangeSupport() {
        if (null == this.changeSupport) {
            this.changeSupport = new SwingPropertyChangeSupport(this);
        }
        return this.changeSupport;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.getChangeSupport().addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.getChangeSupport().removePropertyChangeListener(propertyChangeListener);
    }
}

