/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.support;

import com.ibm.db2.tools.common.CommonTrace;
import com.ibm.db2.tools.common.support.ViewObjectColumnSettings;
import java.io.Serializable;

public class ViewObjectNamedSettings
implements Cloneable,
Serializable {
    private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected String name = "";
    protected ViewObjectColumnSettings[] columnSettings;
    protected boolean filterEnabled = true;

    protected Object clone() {
        ViewObjectNamedSettings viewObjectNamedSettings;
        try {
            viewObjectNamedSettings = (ViewObjectNamedSettings)super.clone();
            if (null != this.name) {
                viewObjectNamedSettings.name = new String(this.name);
            }
            if (null != this.columnSettings) {
                viewObjectNamedSettings.columnSettings = (ViewObjectColumnSettings[])this.columnSettings.clone();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        return viewObjectNamedSettings;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public ViewObjectColumnSettings[] getColumnSettings() {
        return this.columnSettings;
    }

    public void setColumnSettings(ViewObjectColumnSettings[] viewObjectColumnSettingsArray) {
        this.columnSettings = viewObjectColumnSettingsArray;
    }

    public ViewObjectColumnSettings getColumnSettings(int n2) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.support", "ViewObjectNamedSettings", "public ViewObjectColumnSettings getColumnSettings( int index )", new Object[]{new Integer(n2)});
        }
        if (null == this.columnSettings || n2 >= this.columnSettings.length) {
            if (CommonTrace.isTrace()) {
                CommonTrace.write(commonTrace, "No settings at the specified index, building new array");
            }
            ViewObjectColumnSettings[] viewObjectColumnSettingsArray = new ViewObjectColumnSettings[n2 + 1];
            if (null != this.columnSettings) {
                System.arraycopy(this.columnSettings, 0, viewObjectColumnSettingsArray, 0, this.columnSettings.length);
            }
            this.columnSettings = viewObjectColumnSettingsArray;
        }
        return (ViewObjectColumnSettings)CommonTrace.exit(commonTrace, this.columnSettings[n2]);
    }

    public void setColumnSettings(int n2, ViewObjectColumnSettings viewObjectColumnSettings) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.support", "ViewObjectNamedSettings", "public void setColumnSettings(  int index, ViewObjectColumnSettings objectSettings )", new Object[]{new Integer(n2), viewObjectColumnSettings});
        }
        if (null == this.columnSettings || n2 >= this.columnSettings.length) {
            if (CommonTrace.isTrace()) {
                CommonTrace.write(commonTrace, "Cannot set settings at the specified index, building new array");
            }
            ViewObjectColumnSettings[] viewObjectColumnSettingsArray = new ViewObjectColumnSettings[n2 + 1];
            if (null != this.columnSettings) {
                System.arraycopy(this.columnSettings, 0, viewObjectColumnSettingsArray, 0, this.columnSettings.length);
            }
            this.columnSettings = viewObjectColumnSettingsArray;
        }
        this.columnSettings[n2] = viewObjectColumnSettings;
        if (CommonTrace.isTrace()) {
            CommonTrace.exit(commonTrace);
        }
    }

    public boolean isFilterEnabled() {
        return this.filterEnabled;
    }

    public void setFilterEnabled(boolean bl) {
        this.filterEnabled = bl;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (null == object || !(object instanceof ViewObjectNamedSettings)) {
            return false;
        }
        ViewObjectNamedSettings viewObjectNamedSettings = (ViewObjectNamedSettings)object;
        if (!this.name.equals(viewObjectNamedSettings.getName())) {
            return false;
        }
        ViewObjectColumnSettings[] viewObjectColumnSettingsArray = viewObjectNamedSettings.getColumnSettings();
        if (null != this.columnSettings && this.columnSettings.length > 0) {
            if (null != viewObjectColumnSettingsArray) {
                if (viewObjectColumnSettingsArray.length != this.columnSettings.length) {
                    return false;
                }
                int n2 = 0;
                while (n2 < this.columnSettings.length) {
                    if (!(null == this.columnSettings[n2] && null == viewObjectColumnSettingsArray[n2] || null != this.columnSettings[n2] && this.columnSettings[n2].equals(viewObjectColumnSettingsArray[n2]))) {
                        return false;
                    }
                    ++n2;
                }
            }
        } else if (null != viewObjectColumnSettingsArray && viewObjectColumnSettingsArray.length > 0) {
            return false;
        }
        return true;
    }

    public String toString() {
        String string = "[" + this.name + ":";
        if (null != this.columnSettings) {
            int n2 = 0;
            while (n2 < this.columnSettings.length) {
                string = string + "[" + n2 + ": " + this.columnSettings[n2] + "]";
                ++n2;
            }
        } else {
            string = string + "";
        }
        string = string + "]";
        return string;
    }
}

