/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.support;

import com.ibm.db2.tools.common.CommonTrace;
import java.io.Serializable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class ViewObjectColumnSettings
implements Cloneable,
Serializable {
    private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected int initialWidth = -1;
    protected int width = -1;
    protected transient Class columnClass = null;
    protected transient TableCellRenderer cellRenderer = null;
    protected transient TableCellRenderer rollupRenderer = null;
    protected transient TableCellEditor cellEditor = null;
    protected int visibleOrdinal = 0;
    protected int sortableDirections = 273;
    protected int sortDirection = 1;
    protected int sortOrdinal = 0;
    protected boolean rollup = false;
    protected int operator = 0;
    protected String[] filterValues;
    protected String UAKey;

    public Object clone() {
        ViewObjectColumnSettings viewObjectColumnSettings;
        try {
            viewObjectColumnSettings = (ViewObjectColumnSettings)super.clone();
            viewObjectColumnSettings.initialWidth = this.initialWidth;
            viewObjectColumnSettings.width = this.width;
            viewObjectColumnSettings.columnClass = this.columnClass;
            viewObjectColumnSettings.cellRenderer = this.cellRenderer;
            viewObjectColumnSettings.rollupRenderer = this.rollupRenderer;
            viewObjectColumnSettings.cellEditor = this.cellEditor;
            viewObjectColumnSettings.visibleOrdinal = this.visibleOrdinal;
            viewObjectColumnSettings.sortableDirections = this.sortableDirections;
            viewObjectColumnSettings.sortDirection = this.sortDirection;
            viewObjectColumnSettings.sortOrdinal = this.sortOrdinal;
            viewObjectColumnSettings.rollup = this.rollup;
            viewObjectColumnSettings.operator = this.operator;
            if (null != this.filterValues) {
                viewObjectColumnSettings.filterValues = (String[])this.filterValues.clone();
            }
            if (null != this.UAKey) {
                viewObjectColumnSettings.UAKey = new String(this.UAKey);
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        return viewObjectColumnSettings;
    }

    public int getInitialWidth() {
        return this.initialWidth;
    }

    public void setInitialWidth(int n2) {
        this.initialWidth = n2;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int n2) {
        this.width = n2;
    }

    public Class getColumnClass() {
        return this.columnClass;
    }

    public void setColumnClass(Class clazz) {
        this.columnClass = clazz;
    }

    public TableCellRenderer getCellRenderer() {
        return this.cellRenderer;
    }

    public void setCellRenderer(TableCellRenderer tableCellRenderer) {
        this.cellRenderer = tableCellRenderer;
    }

    public TableCellRenderer getRollupRenderer() {
        return this.rollupRenderer;
    }

    public void setRollupRenderer(TableCellRenderer tableCellRenderer) {
        this.rollupRenderer = tableCellRenderer;
    }

    public TableCellEditor getCellEditor() {
        return this.cellEditor;
    }

    public void setCellEditor(TableCellEditor tableCellEditor) {
        this.cellEditor = tableCellEditor;
    }

    public void setVisibleOrdinal(int n2) {
        this.visibleOrdinal = n2;
    }

    public int getVisibleOrdinal() {
        return this.visibleOrdinal;
    }

    public void setSortableDirections(int n2) {
        this.sortableDirections = n2;
    }

    public int getSortableDirections() {
        return this.sortableDirections;
    }

    public void setSortDirection(int n2) {
        this.sortDirection = n2;
    }

    public int getSortDirection() {
        return this.sortDirection;
    }

    public void setSortOrdinal(int n2) {
        this.sortOrdinal = n2;
    }

    public int getSortOrdinal() {
        return this.sortOrdinal;
    }

    public void setRollup(boolean bl) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.support", "ViewObjectColumnSettings", this, "setRollup(boolean aRollup)", new Object[]{new Boolean(bl)});
        }
        if (bl && (this.visibleOrdinal <= 0 || this.sortOrdinal <= 0 || this.sortOrdinal != this.visibleOrdinal)) {
            throw (UnsupportedOperationException)CommonTrace.throwException(commonTrace, new UnsupportedOperationException("The parameter can be true only if the visibleOrdinal and the sortOrdinal fields are equal, non-zero and positive. The current values are: \nvisibleOrdinal = " + this.visibleOrdinal + "\n" + "sortOrdinal    = " + this.sortOrdinal));
        }
        this.rollup = bl;
        CommonTrace.exit(commonTrace);
    }

    public boolean isRollup() {
        return this.rollup;
    }

    public int getOperator() {
        return this.operator;
    }

    public void setOperator(int n2) {
        this.operator = n2;
    }

    public String[] getFilterValues() {
        return this.filterValues;
    }

    public void setFilterValues(String[] stringArray) {
        this.filterValues = stringArray;
    }

    public String getUAKey() {
        return this.UAKey;
    }

    public void setUAKey(String string) {
        this.UAKey = string;
    }

    public void override(ViewObjectColumnSettings viewObjectColumnSettings) {
        if (null != viewObjectColumnSettings) {
            if (viewObjectColumnSettings.getInitialWidth() != -1) {
                this.setInitialWidth(viewObjectColumnSettings.getInitialWidth());
            }
            if (viewObjectColumnSettings.getWidth() != -1) {
                this.setWidth(viewObjectColumnSettings.getWidth());
            }
            if (viewObjectColumnSettings.getColumnClass() != null) {
                this.setColumnClass(viewObjectColumnSettings.getColumnClass());
            }
            if (viewObjectColumnSettings.getCellRenderer() != null) {
                this.setCellRenderer(viewObjectColumnSettings.getCellRenderer());
            }
            if (viewObjectColumnSettings.getRollupRenderer() != null) {
                this.setRollupRenderer(viewObjectColumnSettings.getRollupRenderer());
            }
            if (viewObjectColumnSettings.getCellEditor() != null) {
                this.setCellEditor(viewObjectColumnSettings.getCellEditor());
            }
            this.setVisibleOrdinal(viewObjectColumnSettings.getVisibleOrdinal());
            this.setSortableDirections(viewObjectColumnSettings.getSortableDirections());
            this.setSortDirection(viewObjectColumnSettings.getSortDirection());
            this.setSortOrdinal(viewObjectColumnSettings.getSortOrdinal());
            this.setRollup(viewObjectColumnSettings.isRollup());
            this.setOperator(viewObjectColumnSettings.getOperator());
            this.setFilterValues(viewObjectColumnSettings.getFilterValues());
            if (viewObjectColumnSettings.getUAKey() != null && !viewObjectColumnSettings.getUAKey().trim().equals("")) {
                this.setUAKey(viewObjectColumnSettings.getUAKey());
            }
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (null == object || !(object instanceof ViewObjectColumnSettings)) {
            return false;
        }
        ViewObjectColumnSettings viewObjectColumnSettings = (ViewObjectColumnSettings)object;
        if (viewObjectColumnSettings.getWidth() != this.width) {
            return false;
        }
        if (viewObjectColumnSettings.getVisibleOrdinal() != this.visibleOrdinal) {
            return false;
        }
        if (viewObjectColumnSettings.getSortableDirections() != this.sortableDirections) {
            return false;
        }
        if (viewObjectColumnSettings.getSortDirection() != this.sortDirection) {
            return false;
        }
        if (viewObjectColumnSettings.getSortOrdinal() != this.sortOrdinal) {
            return false;
        }
        if (viewObjectColumnSettings.isRollup() != this.rollup) {
            return false;
        }
        if (viewObjectColumnSettings.getOperator() != this.operator) {
            return false;
        }
        if (null == this.filterValues && null != viewObjectColumnSettings.getFilterValues() && viewObjectColumnSettings.getFilterValues().length != 0) {
            return false;
        }
        return null == this.filterValues || this.filterValues.equals(viewObjectColumnSettings.getFilterValues());
    }

    public String toString() {
        String string = "[";
        string = string + (-1 != this.initialWidth ? Integer.toString(this.initialWidth) : "");
        string = string + ",";
        string = string + (-1 != this.width ? Integer.toString(this.width) : "");
        string = string + ",";
        string = string + (null != this.columnClass ? this.columnClass.toString() : "");
        string = string + ",";
        string = string + (null != this.cellRenderer ? this.cellRenderer.toString() : "");
        string = string + ",";
        string = string + (null != this.rollupRenderer ? this.rollupRenderer.toString() : "");
        string = string + ",";
        string = string + (null != this.cellEditor ? this.cellEditor.toString() : "");
        string = string + ",";
        string = string + (0 != this.visibleOrdinal ? Integer.toString(this.visibleOrdinal) : "");
        string = string + ",";
        string = string + (273 != this.sortableDirections ? Integer.toString(this.sortableDirections) : "");
        string = string + ",";
        string = string + (1 != this.sortDirection ? Integer.toString(this.sortDirection) : "");
        string = string + ",";
        string = string + (0 != this.sortOrdinal ? Integer.toString(this.sortOrdinal) : "");
        string = string + ",";
        string = string + (false != this.rollup ? new Boolean(this.rollup).toString() : "");
        string = string + ",";
        string = string + (0 != this.operator ? Integer.toString(this.operator) : "");
        string = string + ",";
        string = string + (null != this.filterValues ? this.filterValues.toString() : "");
        string = string + ",";
        string = string + (null != this.UAKey ? this.UAKey : "");
        return string;
    }
}

