/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.support;

import com.ibm.db2.tools.common.CommonAction;
import com.ibm.db2.tools.common.CommonTrace;
import com.ibm.db2.tools.common.support.ViewObjectInterface;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.Icon;

public class ViewObjectAction
extends CommonAction {
    private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final int MULTI_HANDLE_NONE = 0;
    public static final int MULTI_HANDLE_ONE = 1;
    public static final int MULTI_HANDLE_MULTI = 2;
    public static final int MULTI_HANDLE_FOCUSED = 3;
    public static final int INTERSECT_MODE_OFF = 0;
    public static final int INTERSECT_MODE_ON = 1;
    public static final String FOCUSED_OBJECT = "FocusedObject";
    public static final String MULTI_MODE = "MultiMode";
    public static final String SELECTED_OBJECTS = "SelectedObjects";
    public static final String INTERSECT_MODE = "IntersectMode";

    public ViewObjectAction() {
    }

    public ViewObjectAction(String string) {
        super(string);
    }

    public ViewObjectAction(String string, Icon icon) {
        super(string, icon);
    }

    public boolean equals(Object object) {
        if (null == object) {
            return false;
        }
        if (super.equals(object)) {
            return true;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ViewObjectAction viewObjectAction = (ViewObjectAction)object;
        if (this.getMultiMode() != viewObjectAction.getMultiMode()) {
            return false;
        }
        ViewObjectInterface viewObjectInterface = this.getFocusedObject();
        ViewObjectInterface viewObjectInterface2 = viewObjectAction.getFocusedObject();
        if (null == viewObjectInterface ? null != viewObjectInterface2 : !viewObjectInterface.equals(viewObjectInterface2)) {
            return false;
        }
        return Arrays.equals(this.getSelectedObjects(), viewObjectAction.getSelectedObjects());
    }

    public void actionPerformed(ActionEvent actionEvent) {
    }

    public ViewObjectInterface getFocusedObject() {
        return (ViewObjectInterface)this.getValue(FOCUSED_OBJECT);
    }

    public void setFocusedObject(ViewObjectInterface viewObjectInterface) {
        this.putValue(FOCUSED_OBJECT, viewObjectInterface);
        if (this.isCascade()) {
            Vector vector = this.getCascade();
            int n2 = 0;
            while (n2 < vector.size()) {
                ((ViewObjectAction)vector.elementAt(n2)).setFocusedObject(viewObjectInterface);
                ++n2;
            }
        }
    }

    public int getMultiMode() {
        int n2 = 0;
        Object object = this.getValue(MULTI_MODE);
        if (object != null) {
            n2 = (Integer)object;
        }
        return n2;
    }

    public void setMultiMode(int n2) {
        if (n2 < 0 || n2 > 3) {
            throw new IllegalArgumentException("Invalid MULTI_MODE.");
        }
        this.putValue(MULTI_MODE, new Integer(n2));
    }

    public ViewObjectInterface[] getSelectedObjects() {
        return (ViewObjectInterface[])this.getValue(SELECTED_OBJECTS);
    }

    public void setSelectedObjects(ViewObjectInterface[] viewObjectInterfaceArray) {
        this.putValue(SELECTED_OBJECTS, viewObjectInterfaceArray);
        if (this.isCascade()) {
            Vector vector = this.getCascade();
            int n2 = 0;
            while (n2 < vector.size()) {
                ((ViewObjectAction)vector.elementAt(n2)).setSelectedObjects(viewObjectInterfaceArray);
                ++n2;
            }
        }
    }

    public int getIntersectMode() {
        int n2 = 1;
        Object object = this.getValue(INTERSECT_MODE);
        if (object != null) {
            n2 = (Integer)object;
        }
        return n2;
    }

    public void setIntersectMode(int n2) {
        if (n2 < 0 || n2 > 1) {
            throw new IllegalArgumentException("Invalid INTERSECT_MODE.");
        }
        this.putValue(INTERSECT_MODE, new Integer(n2));
    }

    public void add(ViewObjectAction viewObjectAction) {
        super.add(viewObjectAction);
    }

    public static ViewObjectAction[] intersect(ViewObjectAction[] viewObjectActionArray, ViewObjectAction[] viewObjectActionArray2) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.support", "ViewObjectAction", "intersect(ViewObjectAction[] actions1, ViewObjectAction[] actions2)", new Object[]{viewObjectActionArray, viewObjectActionArray2});
        }
        int n2 = 0;
        int n3 = 0;
        if (viewObjectActionArray != null) {
            n2 = viewObjectActionArray.length;
        }
        if (viewObjectActionArray2 != null) {
            n3 = viewObjectActionArray2.length;
        }
        Vector<ViewObjectAction> vector = new Vector<ViewObjectAction>();
        int n4 = 0;
        while (n4 < n2) {
            ViewObjectAction viewObjectAction = null;
            int n5 = 0;
            while (n5 < n3) {
                viewObjectAction = viewObjectActionArray[n4].intersect(viewObjectActionArray2[n5]);
                if (null != viewObjectAction) break;
                ++n5;
            }
            if (viewObjectAction != null) {
                vector.addElement(viewObjectAction);
            }
            ++n4;
        }
        return (ViewObjectAction[])CommonTrace.exit(commonTrace, vector.toArray(new ViewObjectAction[vector.size()]));
    }

    public ViewObjectAction intersect(ViewObjectAction viewObjectAction) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.support", "ViewObjectAction", this, "intersect(ViewObjectAction anAction)", new Object[]{viewObjectAction});
        }
        ViewObjectAction viewObjectAction2 = null;
        if (this.getMultiMode() > 0 && this.equals(viewObjectAction)) {
            if (this.isCascade() && viewObjectAction.isCascade()) {
                Vector vector = this.getCascade();
                Vector vector2 = viewObjectAction.getCascade();
                ViewObjectAction[] viewObjectActionArray = ViewObjectAction.intersect(vector.toArray(new ViewObjectAction[vector.size()]), vector2.toArray(new ViewObjectAction[vector2.size()]));
                if (viewObjectActionArray.length > 0) {
                    try {
                        viewObjectAction2 = (ViewObjectAction)super.clone();
                    }
                    catch (CloneNotSupportedException cloneNotSupportedException) {
                        CommonTrace.catchBlock(commonTrace);
                        throw (InternalError)CommonTrace.throwException(commonTrace, new InternalError());
                    }
                    viewObjectAction2.putValue("Cascade", null);
                    int n2 = 0;
                    while (n2 < viewObjectActionArray.length) {
                        viewObjectAction2.add(viewObjectActionArray[n2]);
                        ++n2;
                    }
                }
            } else if (!this.isCascade() && !viewObjectAction.isCascade()) {
                if (this.isCheckBox() && !viewObjectAction.isCheckBox()) {
                    this.setCheckBox(false);
                }
                viewObjectAction2 = this;
            }
        }
        return (ViewObjectAction)CommonTrace.exit(commonTrace, viewObjectAction2);
    }

    public static boolean isIntersectEnabledFor(ViewObjectAction[] viewObjectActionArray) {
        return viewObjectActionArray[0].getIntersectMode() == 1;
    }

    public static ViewObjectAction[] filterMultiActions(ViewObjectAction[] viewObjectActionArray) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.support", "ViewObjectAction", "filterMultiActions(ViewObjectAction[] actions)", new Object[]{viewObjectActionArray});
        }
        Vector<ViewObjectAction> vector = new Vector<ViewObjectAction>();
        int n2 = 0;
        while (n2 < viewObjectActionArray.length) {
            if (viewObjectActionArray[n2].isDivider() && vector.size() > 0 && !((CommonAction)vector.elementAt(vector.size() - 1)).isDivider()) {
                vector.addElement(viewObjectActionArray[n2]);
            } else if (viewObjectActionArray[n2].isCascade()) {
                Vector vector2 = viewObjectActionArray[n2].getCascade();
                ViewObjectAction[] viewObjectActionArray2 = vector2.toArray(new ViewObjectAction[vector2.size()]);
                vector2.removeAllElements();
                ViewObjectAction[] viewObjectActionArray3 = ViewObjectAction.filterMultiActions(viewObjectActionArray2);
                int n3 = 0;
                while (n3 < viewObjectActionArray3.length) {
                    viewObjectActionArray[n2].add(viewObjectActionArray3[n3]);
                    ++n3;
                }
                vector.addElement(viewObjectActionArray[n2]);
            } else if (viewObjectActionArray[n2].getMultiMode() > 0) {
                vector.addElement(viewObjectActionArray[n2]);
            }
            ++n2;
        }
        return (ViewObjectAction[])CommonTrace.exit(commonTrace, vector.toArray(new ViewObjectAction[vector.size()]));
    }
}

