/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.support;

import com.ibm.db2.tools.common.ViewTable;
import com.ibm.db2.tools.common.support.ViewJLabelBaseRenderer;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.util.Enumeration;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class ViewJLabelExpanderRenderer
extends ViewJLabelBaseRenderer {
    private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected static ViewJLabelExpanderRenderer singleInstance = null;
    protected int modelRowI;
    protected int modelRollupColumnI;
    protected int rollupColumnI;

    protected void setValue(Object object) {
        this.modelRowI = ((ViewTable)this.table).convertRowIndexToModel(this.row);
        this.modelRollupColumnI = -this.modelRowI - 1;
        this.rollupColumnI = this.table.convertColumnIndexToView(this.modelRollupColumnI);
        TableCellRenderer tableCellRenderer = this.table.getCellRenderer(this.row, this.rollupColumnI);
        Component component = this.table.prepareRenderer(tableCellRenderer, this.row, this.rollupColumnI);
        if (component instanceof JLabel) {
            this.setText(((JLabel)component).getText());
            this.setIcon(((JLabel)component).getIcon());
            this.setFont(((JLabel)component).getFont());
        }
    }

    public void setBounds(int n2, int n3, int n4, int n5) {
        if (null != this.table && this.column < this.table.getColumnCount() - 1 && this.table.getCellRenderer(this.row, this.column + 1) instanceof ViewJLabelExpanderRenderer) {
            n4 = this.table.getColumnModel().getTotalColumnWidth();
        }
        super.setBounds(n2, n3, n4, n5);
    }

    public void paint(Graphics graphics) {
        ViewTable viewTable = (ViewTable)this.table;
        int n2 = 0;
        Enumeration<TableColumn> enumeration = viewTable.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            if (this.modelRollupColumnI == tableColumn.getModelIndex()) break;
            n2 += tableColumn.getWidth();
        }
        int n3 = SwingUtilities.convertPoint((Component)this, (Point)new Point((int)0, (int)0), (Component)this.table).x;
        graphics.translate(n2 - n3 + viewTable.getColumnModel().getColumnMargin() / 2, 0);
        super.paint(graphics);
    }
}

