/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.support;

import com.ibm.db2.tools.common.CmStringPool;
import com.ibm.db2.tools.common.CommonDialog;
import com.ibm.db2.tools.common.CommonMessage;
import com.ibm.db2.tools.common.CommonTrace;
import com.ibm.db2.tools.common.ResultProcessor;
import com.ibm.db2.tools.common.ViewTable;
import com.ibm.db2.tools.common.filesystem.FileChooser;
import com.ibm.db2.tools.common.plaf.FileChooserUI;
import com.ibm.db2.tools.common.support.ViewExportDELFilter;
import com.ibm.db2.tools.common.support.ViewExportFileFilter;
import com.ibm.db2.tools.common.support.ViewExportHTMLFilter;
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Time;
import java.sql.Timestamp;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.basic.BasicFileChooserUI;

public class ViewExportDialog
extends CommonDialog
implements PropertyChangeListener,
ResultProcessor,
DocumentListener {
    private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected ViewTable viewTable;
    protected JFrame parentFrame;
    protected CommonDialog parentDialog;
    protected File outFile;
    protected JPanel client;
    protected FileChooser chooser;
    protected JPanel options;
    protected ViewExportFileFilter curFileFilter;

    public ViewExportDialog(JFrame jFrame, ViewTable viewTable) {
        super(jFrame, CmStringPool.get(204), true, 6L);
        this.parentFrame = jFrame;
        this.init(viewTable);
    }

    public ViewExportDialog(CommonDialog commonDialog, ViewTable viewTable) {
        super(commonDialog, CmStringPool.get(204), true, 6L);
        this.parentDialog = commonDialog;
        this.init(viewTable);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string;
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.support", "ViewExportAction", "public void propertyChange(PropertyChangeEvent evt)", new Object[]{propertyChangeEvent});
        }
        if ((string = propertyChangeEvent.getPropertyName()).equals("fileFilterChanged")) {
            if (null != propertyChangeEvent.getNewValue()) {
                if (CmStringPool.get(209).equals(((FileFilter)propertyChangeEvent.getNewValue()).getDescription())) {
                    if (this.options != null) {
                        this.client.remove(this.options);
                    }
                    this.curFileFilter = (ViewExportFileFilter)this.chooser.getFileFilter();
                    this.options = this.curFileFilter.makeOptionPanel(this.viewTable);
                    this.client.add("South", this.options);
                    this.validate();
                } else if (CmStringPool.get(370).equals(((FileFilter)propertyChangeEvent.getNewValue()).getDescription())) {
                    if (this.options != null) {
                        this.client.remove(this.options);
                    }
                    this.curFileFilter = (ViewExportFileFilter)this.chooser.getFileFilter();
                    this.options = this.curFileFilter.makeOptionPanel(this.viewTable);
                    this.client.add("South", this.options);
                    this.validate();
                } else if (null != propertyChangeEvent.getOldValue()) {
                    JComponent jComponent = (JComponent)propertyChangeEvent.getOldValue();
                    jComponent.removePropertyChangeListener(this);
                    this.client.remove(jComponent);
                }
            }
        } else if (propertyChangeEvent.getSource() == this.options) {
            this.curFileFilter.updateOptions();
        }
        if (this.curFileFilter != null) {
            this.curFileFilter.setDataFormat();
        }
        CommonTrace.exit(commonTrace);
    }

    public void processResult(Object object, Object object2) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.support", "ViewExportAction", "public void processResult( Object handler, Object returnValue )", new Object[]{object, object2});
        }
        ((CommonMessage)object).close();
        if ("Yes".equals(object2)) {
            try {
                this.outFile.delete();
                this.outFile.createNewFile();
                this.curFileFilter.export(this.viewTable, this.outFile);
                this.close();
            }
            catch (Exception exception) {
                CommonTrace.write(commonTrace, exception);
                this.showMessage(CmStringPool.get(216), 512, null);
            }
        }
        CommonTrace.exit(commonTrace);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        block10: {
            CommonTrace commonTrace = null;
            if (CommonTrace.isTrace()) {
                commonTrace = CommonTrace.create("com.ibm.db2.tools.common.support", "ViewExportDialog", "public void actionPerformed( ActionEvent anActionEvent )", new Object[]{actionEvent});
            }
            if (actionEvent.getActionCommand() == "OK") {
                javax.swing.plaf.FileChooserUI fileChooserUI = this.chooser.getUI();
                if (fileChooserUI instanceof FileChooserUI) {
                    ((FileChooserUI)fileChooserUI).getApproveSelectionAction().actionPerformed(actionEvent);
                } else {
                    CommonTrace.write(commonTrace, "The JFileChooser is not a BasicFileChooserUI class. Being a " + fileChooserUI.getClass() + " just call " + " chooser.approveSelection().");
                    this.chooser.approveSelection();
                }
                this.outFile = this.chooser.getSelectedFile();
                try {
                    if (!this.outFile.createNewFile()) {
                        if (this.outFile.exists()) {
                            if (this.outFile.canWrite()) {
                                this.showMessage(CmStringPool.get(214), 16, this);
                                break block10;
                            }
                            throw new Exception(CmStringPool.get(215));
                        }
                        throw new Exception(CmStringPool.get(216));
                    }
                    this.curFileFilter.export(this.viewTable, this.outFile);
                    this.close();
                }
                catch (Exception exception) {
                    CommonTrace.write(commonTrace, exception);
                    this.showMessage(CmStringPool.get(216), 512, null);
                }
            } else {
                super.actionPerformed(actionEvent);
            }
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateButtonState();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateButtonState();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    private void updateButtonState() {
        FileChooserUI fileChooserUI = (FileChooserUI)this.chooser.getUI();
        if (fileChooserUI.getFileName() != null && fileChooserUI.getFileName().trim().length() > 0) {
            this.getButton(2L).setEnabled(true);
        } else {
            this.getButton(2L).setEnabled(false);
        }
    }

    protected void init(ViewTable viewTable) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.support", "ViewExportDialog", "protected void init( ViewTable aViewTable )", new Object[]{viewTable});
        }
        ViewExportDELFilter viewExportDELFilter = new ViewExportDELFilter(this);
        ViewExportHTMLFilter viewExportHTMLFilter = new ViewExportHTMLFilter(this);
        this.viewTable = viewTable;
        this.client = this.getPanel();
        this.client.setLayout(new BorderLayout());
        this.chooser = new FileChooser();
        this.chooser.setDialogTitle(CmStringPool.get(204));
        this.chooser.setDialogType(1);
        this.chooser.setControlButtonsAreShown(false);
        this.chooser.removeBasicFileFilters();
        this.chooser.addPropertyChangeListener("fileFilterChanged", this);
        this.chooser.setAcceptAllFileFilterUsed(false);
        this.chooser.addChoosableFileFilter(viewExportDELFilter);
        this.chooser.addChoosableFileFilter(viewExportHTMLFilter);
        this.chooser.setFileFilter(viewExportDELFilter);
        if (this.chooser.getUI() instanceof BasicFileChooserUI) {
            ((BasicFileChooserUI)this.chooser.getUI()).setFileName(this.viewTable.getSettingsCache().getCurrentSettings().getName());
        }
        this.client.add("Center", this.chooser);
        this.setClient(this.client);
        this.addButtonsActionListener(this);
        this.getButton(2L).setEnabled(false);
        this.chooser.addFileNameDocumentListener(this);
        this.pack();
        this.chooser.rescanCurrentDirectory();
        this.setVisible(true);
        CommonTrace.exit(commonTrace);
    }

    protected void showMessage(String string, int n2, ResultProcessor resultProcessor) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.support", "ViewExportAction", "protected void showMessage( String aMessage, int buttons, ResultProcessor rp )", new Object[]{string, new Integer(n2), resultProcessor});
        }
        if (null != this.parentFrame) {
            CommonMessage commonMessage = new CommonMessage(this.parentFrame, CmStringPool.get(4), string, 0, "", null, n2, resultProcessor, true);
        } else if (null != this.parentDialog) {
            CommonMessage commonMessage = new CommonMessage(this.parentDialog, CmStringPool.get(4), string, 0, "", null, n2, resultProcessor, true);
        } else {
            throw new IllegalArgumentException("Cannot display child dialog as this dialog was instantiated with  a null parent. ");
        }
        CommonTrace.exit(commonTrace);
    }

    public static boolean isNumericColumn(Object object) {
        return object != null && (object instanceof Float || object instanceof Double || object instanceof Short || object instanceof Integer || object instanceof Long || object instanceof BigDecimal || object instanceof BigInteger || object instanceof Time || object instanceof Timestamp);
    }
}

