/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.support;

import com.ibm.db2.tools.common.CmStringPool;
import com.ibm.db2.tools.common.CommonTrace;
import com.ibm.db2.tools.common.ViewTable;
import com.ibm.db2.tools.common.support.AssistManager;
import com.ibm.db2.tools.common.support.ExportDELOptionsPanel;
import com.ibm.db2.tools.common.support.ViewExportDialog;
import com.ibm.db2.tools.common.support.ViewExportFileFilter;
import com.ibm.db2.tools.common.support.ViewTableColumn;
import com.ibm.db2.tools.common.uamanager.UAManager;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.StringTokenizer;
import javax.accessibility.AccessibleTable;
import javax.swing.JPanel;

public class ViewExportDELFilter
extends ViewExportFileFilter {
    protected String COLDEL;
    protected String CHARDEL;
    protected String DECPT;
    protected boolean DECPLUSBLANK;
    protected boolean DATEISO;
    protected boolean NODOUBLEDEL;
    protected ExportDELOptionsPanel optionsPanel;

    public ViewExportDELFilter(ViewExportDialog viewExportDialog) {
        super(viewExportDialog);
    }

    public JPanel makeOptionPanel(ViewTable viewTable) {
        this.optionsPanel = new ExportDELOptionsPanel();
        this.optionsPanel.getCheckBoxPanel().remove(this.optionsPanel.getStripLZerosCB());
        this.optionsPanel.getComboBoxPanel().remove(this.optionsPanel.getTimestampFormatCB());
        this.optionsPanel.getLabelPanel().remove(this.optionsPanel.getTimestampLabel());
        this.optionsPanel.putClientProperty("UAKey", viewTable.getClientProperty("UAKey") + "_DELoptions");
        this.optionsPanel.addPropertyChangeListener(this.parent);
        this.updateOptions();
        UAManager.updateUAMClient(this.optionsPanel, this.parent);
        return this.optionsPanel;
    }

    public void export(ViewTable viewTable, File file) throws Exception {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.support", "ViewExportDELFilter", "protected void export()");
        }
        OutputStreamWriter outputStreamWriter = null;
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
        outputStreamWriter = new OutputStreamWriter(bufferedOutputStream);
        int n2 = viewTable.getRowCount();
        int n3 = viewTable.getColumnCount();
        int n4 = 0;
        while (n4 < n2) {
            int n5 = viewTable.convertRowIndexToModel(n4);
            if (n5 >= 0) {
                int n6 = 0;
                while (n6 < n3) {
                    String string = null;
                    String string2 = "";
                    int n7 = viewTable.convertColumnIndexToModel(n6);
                    Object object = viewTable.getModel().getValueAt(n5, n7);
                    ViewTableColumn viewTableColumn = (ViewTableColumn)viewTable.getColumnModel().getColumn(n6);
                    String string3 = viewTableColumn.getSortDirection() == 1 || !viewTableColumn.isRollup() ? ((AccessibleTable)((Object)viewTable.getAccessibleContext())).getAccessibleAt(n4, n6).getAccessibleContext().getAccessibleName() : null;
                    Class<?> clazz = viewTable.getColumnClass(n6);
                    if (!(null == string3 || null != object && string3.equals(object.toString()))) {
                        string2 = string3;
                    } else if (null != object) {
                        string2 = object.toString();
                    }
                    string = this.getDisplayString(object, clazz, string3);
                    if (null != string) {
                        outputStreamWriter.write(string);
                    } else {
                        outputStreamWriter.write(this.CHARDEL);
                        if (!this.NODOUBLEDEL) {
                            StringTokenizer stringTokenizer = new StringTokenizer(string2, this.CHARDEL);
                            StringBuffer stringBuffer = new StringBuffer();
                            boolean bl = true;
                            while (stringTokenizer.hasMoreTokens()) {
                                if (bl) {
                                    bl = false;
                                } else {
                                    stringBuffer.append(this.CHARDEL);
                                    stringBuffer.append(this.CHARDEL);
                                }
                                stringBuffer.append(stringTokenizer.nextToken());
                            }
                            string2 = stringBuffer.toString();
                        }
                        outputStreamWriter.write(string2);
                        outputStreamWriter.write(this.CHARDEL);
                    }
                    if (n6 < n3 - 1) {
                        outputStreamWriter.write(this.COLDEL);
                    }
                    ++n6;
                }
                outputStreamWriter.write(this.lineSeparator);
            }
            ++n4;
        }
        if (null != outputStreamWriter) {
            outputStreamWriter.close();
        }
        CommonTrace.exit(commonTrace);
    }

    public void updateOptions() {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.support", "ViewExportAction", "protected void updateOptions()");
        }
        this.COLDEL = (String)this.optionsPanel.getColumnCB().getSelectedItem();
        String string = (String)this.optionsPanel.getCharStringsCB().getSelectedItem();
        this.CHARDEL = string != CmStringPool.get(156) ? string : "";
        this.DECPT = (String)this.optionsPanel.getDecPointCB().getSelectedItem();
        this.DECPLUSBLANK = this.optionsPanel.getDecPlusBlankCB().isSelected();
        this.DATEISO = this.optionsPanel.getUseISODateCB().isSelected();
        this.NODOUBLEDEL = this.optionsPanel.getNoDoubleDelCB().isSelected();
        this.updateDataFormat();
        CommonTrace.exit(commonTrace);
    }

    protected void setFloatFormat() {
        this.floatFormat = new DecimalFormat();
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(AssistManager.getPreferredLocale());
        if (this.DECPT != null) {
            decimalFormatSymbols.setDecimalSeparator(this.DECPT.charAt(0));
        }
        this.floatFormat.setDecimalFormatSymbols(decimalFormatSymbols);
        ((NumberFormat)this.floatFormat).setGroupingUsed(false);
    }

    protected void setDecimalFormat() {
        this.decimalFormat = new DecimalFormat();
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(AssistManager.getPreferredLocale());
        if (this.DECPT != null) {
            decimalFormatSymbols.setDecimalSeparator(this.DECPT.charAt(0));
        }
        this.decimalFormat.setDecimalFormatSymbols(decimalFormatSymbols);
        ((NumberFormat)this.decimalFormat).setGroupingUsed(false);
        if (this.DECPLUSBLANK) {
            this.decimalFormat.setPositivePrefix(" ");
        } else {
            this.decimalFormat.setPositivePrefix("+");
        }
    }

    private void updateDataFormat() {
        this.setFloatFormat();
        this.setDecimalFormat();
    }

    protected boolean isISODateFormat() {
        return this.DATEISO;
    }

    public boolean accept(File file) {
        return true;
    }

    public String getDescription() {
        return CmStringPool.get(209);
    }
}

