/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.support;

import com.ibm.db2.tools.common.CmStringPool;
import com.ibm.db2.tools.common.CommonAction;
import com.ibm.db2.tools.common.CommonDialog;
import com.ibm.db2.tools.common.CommonTrace;
import com.ibm.db2.tools.common.CommonView;
import com.ibm.db2.tools.common.ViewTable;
import com.ibm.db2.tools.common.support.ViewExportDialog;
import java.awt.event.ActionEvent;
import javax.swing.JFrame;
import javax.swing.KeyStroke;

public class ViewExportAction
extends CommonAction {
    private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected ViewTable viewTable;
    protected JFrame parentFrame;
    protected CommonDialog parentDialog;

    public ViewExportAction(CommonView commonView) {
        super(CmStringPool.get(125));
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.support", "ViewExportAction", this, "ViewExportAction(CommonView aCommonView)", new Object[]{commonView});
        }
        this.viewTable = commonView.getTable();
        if (commonView.getOwner() instanceof JFrame) {
            this.parentFrame = (JFrame)commonView.getOwner();
        } else if (commonView.getOwner() instanceof CommonDialog) {
            this.parentDialog = (CommonDialog)commonView.getOwner();
        } else {
            throw new IllegalArgumentException("The CommonView whose content is being exported has no valid owner. The owner has to be a CommonDialog or a JFrame. The current owner is " + commonView.getOwner() + " .");
        }
        this.initialize();
        CommonTrace.exit(commonTrace);
    }

    public ViewExportAction(ViewTable viewTable, JFrame jFrame) {
        super(CmStringPool.get(125));
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.support", "ViewExportAction", this, "ViewExportAction(ViewTable aViewTable, JFrame aParentFrame)", new Object[]{viewTable});
        }
        this.viewTable = viewTable;
        this.parentFrame = jFrame;
        this.initialize();
        CommonTrace.exit(commonTrace);
    }

    public ViewExportAction(ViewTable viewTable, CommonDialog commonDialog) {
        super(CmStringPool.get(125));
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.support", "ViewExportAction", this, "ViewExportAction(ViewTable aViewTable, CommonDialog aParentDialog)", new Object[]{viewTable});
        }
        this.viewTable = viewTable;
        this.parentDialog = commonDialog;
        this.initialize();
        CommonTrace.exit(commonTrace);
    }

    private void initialize() {
        this.setToolTipText(CmStringPool.get(126));
        this.setAccelerator(KeyStroke.getKeyStroke(CmStringPool.getAcceleratorCode(125), CmStringPool.getAcceleratorModifierMask(125)));
        this.setMnemonic(CmStringPool.getMnemonicCode(125));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.support", "ViewExportAction", this, "actionPerformed(ActionEvent aActionEvent)", new Object[]{actionEvent});
        }
        if (this.parentFrame != null) {
            new ViewExportDialog(this.parentFrame, this.viewTable);
        } else if (this.parentDialog != null) {
            new ViewExportDialog(this.parentDialog, this.viewTable);
        }
        CommonTrace.exit(commonTrace);
    }
}

