/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.support;

import com.ibm.db2.tools.common.support.AssistManager;
import com.ibm.db2.tools.common.support.AssistValidityProvider;
import com.ibm.db2.tools.common.support.ViewJLabelBaseRenderer;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.JTable;

public class ViewDateRenderer
extends ViewJLabelBaseRenderer
implements AssistValidityProvider {
    private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected DateFormat formatter;
    protected boolean valueRequired = false;
    protected boolean ignoreNullValues = false;

    public ViewDateRenderer() {
        this.setValidityProvider(this);
    }

    protected void setValue(Object object) {
        this.valueRequired = false;
        if (object != null) {
            if (this.formatter == null) {
                this.formatter = DateFormat.getDateInstance(2, AssistManager.getPreferredLocale());
            }
            if (object instanceof Date) {
                this.setText(this.formatter.format(object));
            } else if (object instanceof String) {
                try {
                    Date date = this.formatter.parse((String)object);
                    this.setText(this.formatter.format(date));
                }
                catch (Exception exception) {
                    this.setText(object.toString());
                    this.valueRequired = true;
                }
            }
        } else {
            this.setText("");
            if (!this.ignoreNullValues) {
                this.valueRequired = true;
            }
        }
        this.setHorizontalAlignment(4);
    }

    public boolean isValueRequired(JTable jTable, Object object, int n2, int n3) {
        return this.valueRequired;
    }

    public void setIgnoreNullValues(boolean bl) {
        this.ignoreNullValues = bl;
    }
}

