/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.support;

import com.ibm.db2.tools.common.CmStringPool;
import com.ibm.db2.tools.common.CommonImageRepository;
import com.ibm.db2.tools.common.support.ViewIconNameObjectInterface;
import com.ibm.db2.tools.common.support.ViewObjectAction;
import com.ibm.db2.tools.common.support.ViewObjectColumnSettings;
import com.ibm.db2.tools.common.support.ViewObjectInterface;
import com.ibm.db2.tools.common.support.ViewTableColumn;
import javax.swing.Icon;

public class ViewColumnWrapper
implements ViewIconNameObjectInterface,
ViewObjectInterface {
    private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static ViewColumnWrapper sharedInstance;
    protected ViewTableColumn column;
    protected boolean ascending = true;
    protected boolean rollup;
    protected String[] columns;
    protected ViewObjectColumnSettings[] columnSettings;

    public static ViewColumnWrapper getSharedInstance() {
        if (null == sharedInstance) {
            sharedInstance = new ViewColumnWrapper();
        }
        return sharedInstance;
    }

    protected ViewColumnWrapper() {
    }

    protected ViewColumnWrapper(ViewTableColumn viewTableColumn) {
        this.setObject(viewTableColumn);
    }

    public void setObject(Object object) {
        if (null != this.column) {
            throw new UnsupportedOperationException("This method should be called only once.");
        }
        if (null == object) {
            throw new IllegalArgumentException("The aColumn parameter is null");
        }
        if (!(object instanceof ViewTableColumn)) {
            throw new IllegalArgumentException("The aColumn parameter should be a ViewTableColumn");
        }
        this.column = (ViewTableColumn)object;
        this.ascending = 256 != this.column.getSortDirection();
        this.rollup = this.column.isRollup();
    }

    public Icon getIcon() {
        return this.ascending ? CommonImageRepository.getCommonIcon(CommonImageRepository.INDEX_UP_IMAGE) : CommonImageRepository.getCommonIcon(CommonImageRepository.INDEX_DOWN_IMAGE);
    }

    public String getName() {
        return this.column.getHeaderValue().toString();
    }

    public Object getData(int n2, Object object) {
        switch (n2) {
            case 0: {
                return this;
            }
            case 1: {
                return this.rollup ? Boolean.TRUE : Boolean.FALSE;
            }
        }
        throw new IllegalArgumentException("columnIndex " + n2 + " out of bounds");
    }

    public void setData(Object object, int n2, Object object2) {
        switch (n2) {
            case 0: {
                throw new UnsupportedOperationException("The column " + n2 + " is Read Only");
            }
            case 1: {
                boolean bl = this.rollup;
                if (object instanceof Boolean && Boolean.TRUE.equals(object)) {
                    this.rollup = true;
                    break;
                }
                this.rollup = false;
                break;
            }
            default: {
                throw new IllegalArgumentException("columnIndex " + n2 + " out of bounds");
            }
        }
    }

    public boolean isEditable(int n2, Object object) {
        switch (n2) {
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
        }
        throw new IllegalArgumentException("columnIndex " + n2 + " out of bounds");
    }

    public String[] getColumnNames(Object object) {
        if (null == this.columns) {
            this.columns = new String[2];
            this.columns[0] = CmStringPool.get(164);
            this.columns[1] = CmStringPool.get(174);
        }
        return this.columns;
    }

    public ViewObjectColumnSettings[] getColumnSettings(Object object) {
        if (null == this.columnSettings) {
            this.columnSettings = new ViewObjectColumnSettings[2];
            this.columnSettings[0] = new ViewObjectColumnSettings();
            this.columnSettings[0].setSortableDirections(0);
            this.columnSettings[1] = new ViewObjectColumnSettings();
            this.columnSettings[1].setSortableDirections(0);
        }
        return this.columnSettings;
    }

    public ViewObjectAction[] getActions(Object object) {
        return null;
    }

    public ViewTableColumn getColumn() {
        return this.column;
    }

    public void setAscending(boolean bl) {
        this.ascending = bl;
    }

    public boolean isAscending() {
        return this.ascending;
    }

    public void setRollup(boolean bl) {
        this.rollup = bl;
    }

    public boolean isRollup() {
        return this.rollup;
    }
}

