/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.support;

import com.ibm.db2.tools.common.AssistField;
import com.ibm.db2.tools.common.ViewTable;
import com.ibm.db2.tools.common.smartx.support.DiagnosisRenderer;
import com.ibm.db2.tools.common.support.AssistManager;
import com.ibm.db2.tools.common.support.CellExpander;
import com.ibm.db2.tools.common.support.CellExpanderManager;
import com.ibm.db2.tools.common.support.CellExpanderRenderer;
import com.ibm.db2.tools.common.support.ViewTableTipProvider;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.TextComponent;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.font.LineMetrics;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.text.JTextComponent;

public class TableCellExpanderProvider
implements ViewTableTipProvider,
Serializable {
    private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected ViewTable table;
    protected CellExpander cellExpander;
    static /* synthetic */ Class class$javax$swing$JPasswordField;
    static /* synthetic */ Class class$com$ibm$db2$tools$common$AssistPassword;

    public TableCellExpanderProvider(ViewTable viewTable) {
        this.table = viewTable;
    }

    public void registerComponent(final ViewTable viewTable) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                CellExpanderManager.sharedInstance().registerComponent(viewTable);
            }
        });
    }

    protected int getIconWidth(int n2, int n3) {
        TableColumn tableColumn = this.table.getColumnModel().getColumn(n3);
        if (tableColumn != null) {
            return this.getIconWidth(tableColumn.getCellRenderer(), this.table.getValueAt(n2, n3), n2, n3);
        }
        return 0;
    }

    protected int getIconWidth(TableCellRenderer tableCellRenderer, Object object, int n2, int n3) {
        Component component;
        if (tableCellRenderer == null) {
            tableCellRenderer = this.table.getCellRenderer(n2, n3);
        }
        if ((component = this.getRenderingComponent(tableCellRenderer, object, n2, n3)) instanceof CellExpanderRenderer) {
            return ((CellExpanderRenderer)((Object)component)).getTextOffset();
        }
        if (component instanceof JLabel) {
            Icon icon = ((JLabel)component).getIcon();
            if (icon == null) {
                return 0;
            }
            return icon.getIconWidth() + ((JLabel)component).getIconTextGap();
        }
        return 0;
    }

    protected Component getRenderingComponent(TableCellRenderer tableCellRenderer, Object object, int n2, int n3) {
        boolean bl = this.table.isCellSelected(n2, n3);
        return tableCellRenderer.getTableCellRendererComponent(this.table, object, bl, false, n2, n3);
    }

    public JScrollPane getScrollPane() {
        if (this.table.getParent() != null && this.table.getParent().getParent() != null && this.table.getParent().getParent() instanceof JScrollPane) {
            return (JScrollPane)this.table.getParent().getParent();
        }
        return new JScrollPane(this.table);
    }

    protected int getValueWidth(TableCellRenderer tableCellRenderer, Object object, int n2, int n3) {
        Object object2;
        if (this.table.getGraphics() == null) {
            return 0;
        }
        int n4 = 0;
        if (tableCellRenderer == null) {
            tableCellRenderer = this.table.getCellRenderer(n2, n3);
        }
        Component component = this.getRenderingComponent(tableCellRenderer, this.table.getValueAt(n2, n3), n2, n3);
        Font font = component.getFont();
        String string = null;
        if (component instanceof CellExpanderRenderer) {
            string = ((CellExpanderRenderer)((Object)component)).getText();
            if (string.length() == 0) {
                n4 = 0;
            } else {
                n4 = ((CellExpanderRenderer)((Object)component)).getTextOffset();
                n4 += AssistManager.getStringWidth(string, this.table, font);
            }
        } else if (component instanceof JLabel) {
            string = ((JLabel)component).getText();
            if (string.length() == 0) {
                n4 = 0;
            } else {
                object2 = ((JLabel)component).getIcon();
                if (object2 != null) {
                    n4 = object2.getIconWidth() + ((JLabel)component).getIconTextGap();
                }
                n4 += AssistManager.getStringWidth(string, this.table, font);
            }
        } else {
            if (component instanceof AssistField) {
                string = this.table.getValueAt(n2, n3).toString();
            } else if (component instanceof JTextComponent) {
                string = ((JTextComponent)component).getText();
            } else if (component instanceof Label) {
                string = ((Label)component).getText();
            } else if (component instanceof TextComponent) {
                string = ((TextComponent)component).getText();
            }
            n4 = string == null || string.length() == 0 ? 0 : AssistManager.getStringWidth(string, this.table, font);
        }
        if (n4 != 0) {
            object2 = ((JComponent)component).getInsets();
            n4 += ((Insets)object2).right + ((Insets)object2).left;
        }
        return n4;
    }

    private boolean parentWindowActive(Component component) {
        Window window = SwingUtilities.windowForComponent(component);
        return window.getFocusOwner() != null;
    }

    public Point getCellExpanderLocation(MouseEvent mouseEvent) {
        if (!this.parentWindowActive(this.table)) {
            return null;
        }
        Point point = mouseEvent.getPoint();
        int n2 = this.table.rowAtPoint(point);
        int n3 = this.table.columnAtPoint(point);
        if (this.table.isEditing() && this.table.getEditingRow() == n2 && this.table.getEditingColumn() == n3 || n2 < 0 || n3 < 0) {
            return null;
        }
        Class<?> clazz = this.table.getColumnClass(n3);
        if (clazz == AssistManager.getClass("char[]") || clazz == (class$javax$swing$JPasswordField == null ? (class$javax$swing$JPasswordField = TableCellExpanderProvider.class$("javax.swing.JPasswordField")) : class$javax$swing$JPasswordField) || clazz == (class$com$ibm$db2$tools$common$AssistPassword == null ? (class$com$ibm$db2$tools$common$AssistPassword = TableCellExpanderProvider.class$("com.ibm.db2.tools.common.AssistPassword")) : class$com$ibm$db2$tools$common$AssistPassword) || clazz == AssistManager.getClass("Boolean")) {
            return null;
        }
        Object object = this.table.getValueAt(n2, n3);
        if (object != null) {
            TableColumn tableColumn = this.table.getColumnModel().getColumn(n3);
            if (tableColumn != null) {
                int n4;
                Dimension dimension = this.table.getIntercellSpacing();
                TableCellRenderer tableCellRenderer = this.table.getCellRenderer(n2, n3);
                int n5 = this.getValueWidth(tableCellRenderer, object, n2, n3);
                int n6 = tableColumn.getWidth() - 2 * dimension.width;
                JScrollPane jScrollPane = this.getScrollPane();
                Rectangle rectangle = this.table.getCellRect(n2, n3, false);
                boolean bl = false;
                if (jScrollPane != null && n5 < n6) {
                    n4 = jScrollPane.getSize(null).width;
                    int n7 = jScrollPane.getHorizontalScrollBar().getValue();
                    int n8 = jScrollPane.getVerticalScrollBar().getSize(null).width;
                    if (rectangle.x < n7 || rectangle.x + n5 - n7 > n4 - n8 + 5) {
                        bl = true;
                    }
                }
                if (n5 > n6 || bl) {
                    n4 = 0;
                    if (tableCellRenderer instanceof CellExpanderRenderer) {
                        n4 = ((CellExpanderRenderer)((Object)tableCellRenderer)).getTextOffset();
                    }
                    return new Point(rectangle.x - dimension.width + n4, rectangle.y - dimension.height);
                }
                return null;
            }
            return null;
        }
        return null;
    }

    public CellExpander createCellExpander(MouseEvent mouseEvent) {
        Object object;
        Object object2;
        int n2;
        Point point;
        int n3;
        boolean bl;
        if (this.cellExpander == null) {
            this.cellExpander = new CellExpander(this.table);
            this.cellExpander.putClientProperty("UAKey", this.table.getClientProperty("UAKey"));
        }
        boolean bl2 = (bl = this.table.isCellSelected(n3 = this.table.rowAtPoint(point = mouseEvent.getPoint()), n2 = this.table.columnAtPoint(point))) && this.table.isColumnSelected(n2);
        TableColumn tableColumn = this.table.getColumnModel().getColumn(n2);
        if (tableColumn == null) {
            return null;
        }
        Object object3 = this.table.getValueAt(n3, n2);
        TableCellRenderer tableCellRenderer = this.table.getCellRenderer(n3, n2);
        Component component = tableCellRenderer.getTableCellRendererComponent(this.table, object3, bl, bl2, n3, n2);
        this.cellExpander.setForeground(component.getForeground());
        this.cellExpander.setBackground(component.getBackground());
        this.cellExpander.setAlignmentX(((JComponent)component).getAlignmentX());
        this.cellExpander.setAlignmentY(((JComponent)component).getAlignmentY());
        this.cellExpander.setFont(component.getFont());
        Insets insets = ((JComponent)component).getInsets();
        Border border = ((JComponent)component).getBorder();
        this.cellExpander.setBorder(BorderFactory.createCompoundBorder(AssistManager.getBorder("Cell.expansion.border"), border));
        Point point2 = new Point(-1, -1);
        if (component instanceof CellExpanderRenderer) {
            this.cellExpander.setTipText(CellExpanderManager.untag(((CellExpanderRenderer)((Object)component)).getText()));
        } else if (component instanceof JLabel) {
            object2 = ((JLabel)component).getIcon();
            if (object2 != null) {
                switch (((JLabel)component).getVerticalAlignment()) {
                    case 1: {
                        object = "TOP";
                        break;
                    }
                    case 0: {
                        object = "MIDDLE";
                        break;
                    }
                    default: {
                        object = "BOTTOM";
                    }
                }
                StringBuffer stringBuffer = new StringBuffer();
                DiagnosisRenderer.putIcon("CellExpander", (Icon)object2);
                stringBuffer.append("<img align=").append((String)object).append(" src=\"").append("CellExpander").append("\"").append(" hspace=").append(((JLabel)component).getIconTextGap()).append(">").append(CellExpanderManager.untag(((JLabel)component).getText()));
                this.cellExpander.setTipText(stringBuffer.toString());
                --point2.x;
            } else {
                this.cellExpander.setTipText(CellExpanderManager.untag(((JLabel)component).getText()));
            }
        } else if (component instanceof JTextComponent) {
            this.cellExpander.setTipText(CellExpanderManager.untag(object3.toString()));
        } else if (component instanceof JCheckBox) {
            object2 = ((JCheckBox)component).getSelectedObjects();
            if (object2 != null && object2[0] != null) {
                this.cellExpander.setTipText(CellExpanderManager.untag(object2[0].toString()));
            } else {
                this.cellExpander.setTipText(CellExpanderManager.untag(""));
            }
        } else {
            this.cellExpander.setTipText(CellExpanderManager.untag(component.toString()));
        }
        object2 = new Dimension(this.cellExpander.getMinimumSize());
        object = this.table.getIntercellSpacing();
        int n4 = this.table.getRowHeight();
        LineMetrics lineMetrics = AssistManager.getLineMetrics(this.cellExpander.getTipText(), this.cellExpander, this.cellExpander.getFont());
        int n5 = Math.round(lineMetrics.getHeight());
        point2.x -= insets.left;
        point2.y = (n4 - n5) / 2 - insets.top + n4 % 2;
        point2.x -= ((Dimension)object).width;
        this.cellExpander.putClientProperty("translate.point", point2);
        if (object2.height < n4 * 2) {
            object2.height = n4 + ((Dimension)object).height;
            this.cellExpander.setPreferredSize((Dimension)object2);
        }
        return this.cellExpander;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

