/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.support;

import com.ibm.db2.tools.common.support.AssistManager;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Set;

public class SQLIdentifier {
    public static final int PLATFORM_LUWO = 1;
    public static final int PLATFORM_390 = 2;
    public static final int PLATFORM_400 = 4;
    public static final int PLATFORM_ALL = 7;
    public static final int PLATFORM_OTHER = 16;
    public static final String DB2390 = "DB2";
    public static final String DB2400 = "AS";
    public static final String DB2400SQL = "DB2/400 SQL";
    public static final int TRIM_LEFT = 1;
    public static final int TRIM_RIGHT = 2;
    public static final int TRIM_BOTH = 3;
    public static final int TRIM_INSIDE = 4;
    public static final int TRIM_ALL = 7;
    protected static StringBuffer sb = new StringBuffer();
    protected static StringBuffer sb2 = new StringBuffer();
    protected static Set schemaReserved;
    protected static Set luwoReserved;
    protected static Set os390Reserved;
    protected static Set os400Reserved;
    protected static HashSet otherOrdinaryFlags;
    protected static Hashtable ordinaryFlagsSet;
    protected static String ordinaryDigits;
    protected static String ordinaryWideDigits;

    private SQLIdentifier() {
    }

    public static char getDelimiter(Connection connection) {
        try {
            return connection.getMetaData().getIdentifierQuoteString().charAt(0);
        }
        catch (SQLException sQLException) {
            return '\"';
        }
    }

    public static int getPlatform(Connection connection) {
        try {
            String string = connection.getMetaData().getDatabaseProductName();
            if (string.equalsIgnoreCase(DB2390)) {
                return 2;
            }
            if (string.equalsIgnoreCase(DB2400) || string.equalsIgnoreCase(DB2400SQL)) {
                return 4;
            }
            if (string.startsWith(DB2390)) {
                return 1;
            }
            return 16;
        }
        catch (SQLException sQLException) {
            return 1;
        }
    }

    public static void setExtraOrdinaryChars(Connection connection) {
        otherOrdinaryFlags = null;
        if (connection != null) {
            String string = null;
            try {
                string = connection.getMetaData().getDatabaseProductName();
            }
            catch (SQLException sQLException) {
                string = "PLATFORM_OTHER";
            }
            otherOrdinaryFlags = (HashSet)ordinaryFlagsSet.get(string);
            if (otherOrdinaryFlags == null) {
                String string2 = null;
                try {
                    string2 = connection.getMetaData().getExtraNameCharacters();
                }
                catch (SQLException sQLException) {
                    return;
                }
                otherOrdinaryFlags = new HashSet(59);
                ordinaryFlagsSet.put(string, otherOrdinaryFlags);
                if (string2 != null) {
                    int n2 = string2.length();
                    int n3 = 0;
                    while (n3 < n2) {
                        char c2 = string2.charAt(n3);
                        otherOrdinaryFlags.add(new Character(c2));
                        ++n3;
                    }
                }
                otherOrdinaryFlags.add(new Character('A'));
                otherOrdinaryFlags.add(new Character('B'));
                otherOrdinaryFlags.add(new Character('C'));
                otherOrdinaryFlags.add(new Character('D'));
                otherOrdinaryFlags.add(new Character('E'));
                otherOrdinaryFlags.add(new Character('F'));
                otherOrdinaryFlags.add(new Character('G'));
                otherOrdinaryFlags.add(new Character('H'));
                otherOrdinaryFlags.add(new Character('I'));
                otherOrdinaryFlags.add(new Character('J'));
                otherOrdinaryFlags.add(new Character('K'));
                otherOrdinaryFlags.add(new Character('L'));
                otherOrdinaryFlags.add(new Character('M'));
                otherOrdinaryFlags.add(new Character('N'));
                otherOrdinaryFlags.add(new Character('O'));
                otherOrdinaryFlags.add(new Character('P'));
                otherOrdinaryFlags.add(new Character('Q'));
                otherOrdinaryFlags.add(new Character('R'));
                otherOrdinaryFlags.add(new Character('S'));
                otherOrdinaryFlags.add(new Character('T'));
                otherOrdinaryFlags.add(new Character('U'));
                otherOrdinaryFlags.add(new Character('V'));
                otherOrdinaryFlags.add(new Character('W'));
                otherOrdinaryFlags.add(new Character('X'));
                otherOrdinaryFlags.add(new Character('Y'));
                otherOrdinaryFlags.add(new Character('Z'));
                otherOrdinaryFlags.add(new Character('_'));
                otherOrdinaryFlags.add(new Character('a'));
                otherOrdinaryFlags.add(new Character('b'));
                otherOrdinaryFlags.add(new Character('c'));
                otherOrdinaryFlags.add(new Character('d'));
                otherOrdinaryFlags.add(new Character('e'));
                otherOrdinaryFlags.add(new Character('f'));
                otherOrdinaryFlags.add(new Character('g'));
                otherOrdinaryFlags.add(new Character('h'));
                otherOrdinaryFlags.add(new Character('i'));
                otherOrdinaryFlags.add(new Character('j'));
                otherOrdinaryFlags.add(new Character('k'));
                otherOrdinaryFlags.add(new Character('l'));
                otherOrdinaryFlags.add(new Character('m'));
                otherOrdinaryFlags.add(new Character('n'));
                otherOrdinaryFlags.add(new Character('o'));
                otherOrdinaryFlags.add(new Character('p'));
                otherOrdinaryFlags.add(new Character('q'));
                otherOrdinaryFlags.add(new Character('r'));
                otherOrdinaryFlags.add(new Character('s'));
                otherOrdinaryFlags.add(new Character('t'));
                otherOrdinaryFlags.add(new Character('u'));
                otherOrdinaryFlags.add(new Character('v'));
                otherOrdinaryFlags.add(new Character('w'));
                otherOrdinaryFlags.add(new Character('x'));
                otherOrdinaryFlags.add(new Character('y'));
                otherOrdinaryFlags.add(new Character('z'));
            }
        }
    }

    public static boolean isDBIDOrdinary(String string) {
        return SQLIdentifier.isDBIDOrdinary(string, 1);
    }

    public static boolean isDBIDOrdinary(String string, int n2) {
        if (string == null || string.length() == 0) {
            return true;
        }
        char c2 = string.charAt(0);
        if (!SQLIdentifier.isOrdinaryUpperChar(c2, n2)) {
            return false;
        }
        String string2 = SQLIdentifier.trim(string, 2, '\"');
        int n3 = string2.length() - 2;
        if (n3 > -1) {
            int n4 = 1;
            while (n4 < n3) {
                c2 = string2.charAt(n4);
                if (!SQLIdentifier.isOrdinaryUpperChar(c2, n2) && !SQLIdentifier.isOrdinaryDigit(c2) && c2 != '_') {
                    return false;
                }
                ++n4;
            }
            c2 = string2.charAt(n3 + 1);
            if (!SQLIdentifier.isOrdinaryUpperChar(c2, n2)) {
                return false;
            }
            if (SQLIdentifier.isReservedIdentifier(string2, '\"', n2)) {
                return false;
            }
        }
        return true;
    }

    public static boolean isUserInputOrdinary(String string) {
        return SQLIdentifier.isUserInputOrdinary(string, 1);
    }

    public static boolean isUserInputOrdinary(String string, int n2) {
        return SQLIdentifier.isUserInputOrdinary(string, '\"', n2);
    }

    public static boolean isUserInputOrdinary(String string, char c2, int n2) {
        int n3;
        if (string == null || string.length() == 0) {
            return true;
        }
        boolean bl = false;
        String string2 = string;
        if (string2.charAt(0) == c2) {
            bl = true;
            if ((string2 = string2.substring(1)).charAt(n3 = string2.length() - 1) == c2) {
                string2 = string2.substring(0, n3);
            }
        }
        char c3 = string2.charAt(0);
        if (bl && Character.toUpperCase(c3) != c3 || !SQLIdentifier.isOrdinaryChar(c3, n2)) {
            return false;
        }
        string2 = SQLIdentifier.trim(string2, 2, c2);
        n3 = string2.length();
        int n4 = 1;
        while (n4 < n3) {
            c3 = string2.charAt(n4);
            if (bl && Character.toUpperCase(c3) != c3 || !SQLIdentifier.isOrdinaryChar(c3, n2) && !SQLIdentifier.isOrdinaryDigit(c3) && c3 != '_') {
                return false;
            }
            ++n4;
        }
        return !SQLIdentifier.isReservedIdentifier(string2, c2, n2);
    }

    public static boolean isDB2SpecialChar(char c2) {
        switch (c2) {
            case ' ': 
            case '!': 
            case '\"': 
            case '%': 
            case '&': 
            case '\'': 
            case '(': 
            case ')': 
            case '*': 
            case '+': 
            case ',': 
            case '-': 
            case '.': 
            case '/': 
            case ':': 
            case ';': 
            case '<': 
            case '=': 
            case '>': 
            case '?': 
            case '^': 
            case '_': 
            case '|': {
                return true;
            }
        }
        return false;
    }

    public static String convertDBID(String string, char c2) {
        return SQLIdentifier.convertDBID(string, c2, 1);
    }

    public static String convertDBID(String string, char c2, int n2) {
        return SQLIdentifier.convertDBID(string, c2, n2, true);
    }

    public static String convertDBID(String string, char c2, int n2, boolean bl) {
        if (string == null || string.length() == 0) {
            return string;
        }
        boolean bl2 = true;
        sb.setLength(0);
        char c3 = string.charAt(0);
        if (c3 == c2 && (n2 & 4) == 0) {
            sb.append(c3);
            bl2 = false;
        } else if (!SQLIdentifier.isOrdinaryUpperChar(c3, n2)) {
            bl2 = false;
        }
        sb.append(c3);
        int n3 = string.length();
        int n4 = 1;
        while (n4 < n3) {
            c3 = string.charAt(n4);
            if (c3 == c2 && (n2 & 4) == 0) {
                sb.append(c3);
                bl2 = false;
            } else if (!SQLIdentifier.isOrdinaryUpperChar(c3, n2) && !SQLIdentifier.isOrdinaryDigit(c3) && c3 != '_') {
                bl2 = false;
            }
            sb.append(c3);
            ++n4;
        }
        if (bl && SQLIdentifier.isReservedIdentifier(sb.toString(), c2, n2)) {
            bl2 = false;
        }
        if (!bl2) {
            sb.insert(0, c2).append(c2);
            return sb.toString();
        }
        return string;
    }

    public static String convertUserInput(String string, char c2) {
        return SQLIdentifier.convertUserInput(string, c2, 1);
    }

    public static String convertUserInput(String string, char c2, int n2) {
        if (string == null || string.length() == 0) {
            return string;
        }
        if (SQLIdentifier.trim(string, 1, c2).length() == 0) {
            return "";
        }
        if (SQLIdentifier.trim(string, 1, c2).charAt(0) == c2) {
            char c3;
            sb.setLength(0);
            string = SQLIdentifier.trim(string, 7, c2);
            int n3 = string.length() - 1;
            if (string.charAt(n3) == c2) {
                int n4 = 1;
                while (n4 < n3) {
                    c3 = string.charAt(n4);
                    if (c3 == c2) {
                        ++n4;
                    }
                    sb.append(c3);
                    ++n4;
                }
            } else {
                int n5 = 1;
                while (n5 <= n3) {
                    c3 = string.charAt(n5);
                    if (c3 == c2) {
                        ++n5;
                    }
                    sb.append(c3);
                    ++n5;
                }
            }
            c3 = string.charAt(n3);
            return sb.toString();
        }
        return AssistManager.toUpperCase(SQLIdentifier.trim(string, 3, c2));
    }

    public static boolean isReservedSchema(String string, char c2) {
        return schemaReserved.contains(SQLIdentifier.convertUserInput(string, c2));
    }

    public static boolean isReservedIdentifier(String string, char c2) {
        return SQLIdentifier.isReservedIdentifier(string, c2, 1);
    }

    public static boolean isReservedIdentifier(String string, char c2, int n2) {
        String string2 = SQLIdentifier.convertUserInput(string, c2, n2);
        boolean bl = false;
        if ((n2 & 1) > 0) {
            bl = luwoReserved.contains(string2);
        }
        if (!bl && (n2 & 2) > 0) {
            bl = os390Reserved.contains(string2);
        }
        if (!bl && (n2 & 4) > 0) {
            bl = os400Reserved.contains(string2);
        }
        return bl;
    }

    public static String concatIdentifier(String string, Object object, char c2) {
        int n2;
        String string2 = SQLIdentifier.trim(string, 7, c2);
        if (string2.charAt(n2 = string2.length() - 1) == c2) {
            sb.setLength(0);
            sb.append(string2.substring(0, n2)).append(object.toString()).append(c2);
            return sb.toString();
        }
        sb.setLength(0);
        sb.append(string2).append(object.toString());
        return sb.toString();
    }

    public static boolean beginsWith(String string, String string2, char c2) {
        int n2;
        String string3 = SQLIdentifier.trim(string, 7, c2);
        String string4 = SQLIdentifier.trim(string2, 7, c2);
        boolean bl = false;
        string4 = string4.charAt(0) == c2 ? (string4.charAt((n2 = string4.length()) - 1) == c2 ? string4.substring(1, n2 - 2) : string4.substring(1)) : AssistManager.toUpperCase(string4);
        if (string3.charAt(0) == c2) {
            bl = true;
            if (string3.length() + 1 < string4.length()) {
                return false;
            }
            string3 = string3.substring(1, string4.length() + 1);
        } else {
            if (string3.length() < string4.length()) {
                return false;
            }
            string3 = AssistManager.toUpperCase(string3.substring(0, string4.length()));
        }
        return string4.equals(string3);
    }

    public static boolean equals(String string, String string2, char c2) {
        return SQLIdentifier.equals(string, string2, c2, 1);
    }

    public static boolean equals(String string, String string2, char c2, int n2) {
        return SQLIdentifier.convertUserInput(string, c2, n2).equals(SQLIdentifier.convertUserInput(string2, c2, n2));
    }

    public static boolean checkName(Enumeration enumeration, String string, char c2) {
        while (enumeration.hasMoreElements()) {
            if (!SQLIdentifier.equals((String)enumeration.nextElement(), string, c2)) continue;
            return true;
        }
        return false;
    }

    private static boolean isDBCSLanguage() {
        Locale locale = AssistManager.getPreferredLanguage();
        String string = locale.getLanguage();
        return string.equals("zh") || string.equals("ja") || string.equals("ko");
    }

    public static boolean isOrdinaryChar(char c2, int n2) {
        boolean bl = false;
        if (otherOrdinaryFlags != null) {
            bl = SQLIdentifier.isOrdinaryOtherChar(c2);
        } else {
            if ((n2 & 1) > 0) {
                bl = SQLIdentifier.isOrdinaryLUWOChar(c2);
            }
            if (!bl && (n2 & 2) > 0) {
                bl = SQLIdentifier.isOrdinary390Char(c2);
            }
            if (!bl && (n2 & 4) > 0) {
                bl = SQLIdentifier.isOrdinary400Char(c2);
            }
        }
        return bl;
    }

    public static boolean isOrdinaryUpperChar(char c2, int n2) {
        boolean bl = false;
        if (otherOrdinaryFlags != null) {
            bl = SQLIdentifier.isOrdinaryOtherChar(c2);
        } else {
            if ((n2 & 1) > 0) {
                bl = SQLIdentifier.isOrdinaryLUWOChar(c2);
            }
            if (!bl && (n2 & 2) > 0) {
                bl = SQLIdentifier.isOrdinary390Char(c2);
            }
            if (!bl && (n2 & 4) > 0) {
                bl = SQLIdentifier.isOrdinary400Char(c2);
            }
        }
        if (bl) {
            bl = !Character.isLowerCase(c2);
        }
        return bl;
    }

    public static boolean isOrdinaryLUWOChar(char c2) {
        boolean bl = false;
        HashSet hashSet = (HashSet)ordinaryFlagsSet.get("PLATFORM_LUWO");
        bl = hashSet.contains(new Character(c2));
        if (!bl && SQLIdentifier.isDBCSLanguage()) {
            bl = Character.isUnicodeIdentifierStart(c2);
        }
        return bl;
    }

    public static boolean isOrdinary390Char(char c2) {
        boolean bl = false;
        HashSet hashSet = (HashSet)ordinaryFlagsSet.get("PLATFORM_390");
        bl = hashSet.contains(new Character(c2));
        if (!bl && SQLIdentifier.isDBCSLanguage()) {
            bl = Character.isUnicodeIdentifierStart(c2);
        }
        return bl;
    }

    public static boolean isOrdinary400Char(char c2) {
        boolean bl = false;
        HashSet hashSet = (HashSet)ordinaryFlagsSet.get("PLATFORM_400");
        bl = hashSet.contains(new Character(c2));
        return bl;
    }

    public static boolean isOrdinaryOtherChar(char c2) {
        if (otherOrdinaryFlags == null) {
            return SQLIdentifier.isOrdinaryLUWOChar(c2);
        }
        return otherOrdinaryFlags.contains(new Character(c2));
    }

    public static boolean isOrdinaryDigit(char c2) {
        boolean bl = false;
        boolean bl2 = bl = ordinaryDigits.indexOf(c2) > -1;
        if (!bl && SQLIdentifier.isDBCSLanguage()) {
            bl = ordinaryWideDigits.indexOf(c2) > -1;
        }
        return bl;
    }

    public static String trim(String string, int n2, char c2) {
        int n3;
        char c3;
        if (string == null || string.length() == 0) {
            return string;
        }
        int n4 = 0;
        if ((n2 & 1) > 0) {
            c3 = string.charAt(n4);
            while (c3 == ' ' && n4 < string.length()) {
                if (++n4 >= string.length()) continue;
                c3 = string.charAt(n4);
            }
        }
        if ((n3 = string.length() - 1) > 0 && (n2 & 2) > 0) {
            c3 = string.charAt(n3);
            while (c3 == ' ' && n3 > -1 && n3 < string.length()) {
                if (--n3 <= -1 || n3 >= string.length()) continue;
                c3 = string.charAt(n3);
            }
        }
        if (n3 > -1) {
            c3 = string.charAt(n3);
            int n5 = -1;
            if ((n2 & 4) > 0 && (n2 & 2) == 0) {
                while (n3 > -1 && c3 == ' ' && c3 != c2) {
                    if (--n3 <= -1) continue;
                    c3 = string.charAt(n3);
                }
                if (n3 > -1 && n3 < string.length() - 1) {
                    n5 = n3 + 1;
                }
            }
            if ((n2 & 4) > 0 && n3 > -1 && c3 == c2) {
                c3 = string.charAt(--n3);
                while (c3 == ' ' && n3 < string.length() && n3 > -1) {
                    if (--n3 >= string.length() || n3 <= -1) continue;
                    c3 = string.charAt(n3);
                }
                sb2.setLength(0);
                if (n3 < string.length() && n3 >= n4) {
                    sb2.append(string.substring(n4, n3 + 1)).append(c2);
                    if (n5 > -1) {
                        sb2.append(string.substring(n5));
                    }
                } else {
                    sb2.append(string.substring(n4)).append(c2);
                }
                return sb2.toString();
            }
            if (n3 < string.length() && n3 >= n4) {
                if ((n2 & 4) > 0 && (n2 & 2) == 0) {
                    return string;
                }
                return string.substring(n4, n3 + 1);
            }
            return string.substring(n4);
        }
        return "";
    }

    static {
        ordinaryFlagsSet = new Hashtable(37);
        HashSet<Character> hashSet = new HashSet<Character>(349);
        ordinaryFlagsSet.put("PLATFORM_LUWO", hashSet);
        hashSet.add(new Character('#'));
        hashSet.add(new Character('$'));
        hashSet.add(new Character('@'));
        hashSet.add(new Character('A'));
        hashSet.add(new Character('B'));
        hashSet.add(new Character('C'));
        hashSet.add(new Character('D'));
        hashSet.add(new Character('E'));
        hashSet.add(new Character('F'));
        hashSet.add(new Character('G'));
        hashSet.add(new Character('H'));
        hashSet.add(new Character('I'));
        hashSet.add(new Character('J'));
        hashSet.add(new Character('K'));
        hashSet.add(new Character('L'));
        hashSet.add(new Character('M'));
        hashSet.add(new Character('N'));
        hashSet.add(new Character('O'));
        hashSet.add(new Character('P'));
        hashSet.add(new Character('Q'));
        hashSet.add(new Character('R'));
        hashSet.add(new Character('S'));
        hashSet.add(new Character('T'));
        hashSet.add(new Character('U'));
        hashSet.add(new Character('V'));
        hashSet.add(new Character('W'));
        hashSet.add(new Character('X'));
        hashSet.add(new Character('Y'));
        hashSet.add(new Character('Z'));
        hashSet.add(new Character('a'));
        hashSet.add(new Character('b'));
        hashSet.add(new Character('c'));
        hashSet.add(new Character('d'));
        hashSet.add(new Character('e'));
        hashSet.add(new Character('f'));
        hashSet.add(new Character('g'));
        hashSet.add(new Character('h'));
        hashSet.add(new Character('i'));
        hashSet.add(new Character('j'));
        hashSet.add(new Character('k'));
        hashSet.add(new Character('l'));
        hashSet.add(new Character('m'));
        hashSet.add(new Character('n'));
        hashSet.add(new Character('o'));
        hashSet.add(new Character('p'));
        hashSet.add(new Character('q'));
        hashSet.add(new Character('r'));
        hashSet.add(new Character('s'));
        hashSet.add(new Character('t'));
        hashSet.add(new Character('u'));
        hashSet.add(new Character('v'));
        hashSet.add(new Character('w'));
        hashSet.add(new Character('x'));
        hashSet.add(new Character('y'));
        hashSet.add(new Character('z'));
        hashSet.add(new Character('\u00aa'));
        hashSet.add(new Character('\u00ba'));
        hashSet.add(new Character('\u00c0'));
        hashSet.add(new Character('\u00c1'));
        hashSet.add(new Character('\u00c2'));
        hashSet.add(new Character('\u00c3'));
        hashSet.add(new Character('\u00c4'));
        hashSet.add(new Character('\u00c5'));
        hashSet.add(new Character('\u00c6'));
        hashSet.add(new Character('\u00c7'));
        hashSet.add(new Character('\u00c8'));
        hashSet.add(new Character('\u00c9'));
        hashSet.add(new Character('\u00ca'));
        hashSet.add(new Character('\u00cb'));
        hashSet.add(new Character('\u00cc'));
        hashSet.add(new Character('\u00cd'));
        hashSet.add(new Character('\u00ce'));
        hashSet.add(new Character('\u00cf'));
        hashSet.add(new Character('\u00d0'));
        hashSet.add(new Character('\u00d1'));
        hashSet.add(new Character('\u00d2'));
        hashSet.add(new Character('\u00d3'));
        hashSet.add(new Character('\u00d4'));
        hashSet.add(new Character('\u00d5'));
        hashSet.add(new Character('\u00d6'));
        hashSet.add(new Character('\u00d8'));
        hashSet.add(new Character('\u00d9'));
        hashSet.add(new Character('\u00da'));
        hashSet.add(new Character('\u00db'));
        hashSet.add(new Character('\u00dc'));
        hashSet.add(new Character('\u00dd'));
        hashSet.add(new Character('\u00de'));
        hashSet.add(new Character('\u00df'));
        hashSet.add(new Character('\u00e0'));
        hashSet.add(new Character('\u00e1'));
        hashSet.add(new Character('\u00e2'));
        hashSet.add(new Character('\u00e3'));
        hashSet.add(new Character('\u00e4'));
        hashSet.add(new Character('\u00e5'));
        hashSet.add(new Character('\u00e6'));
        hashSet.add(new Character('\u00e7'));
        hashSet.add(new Character('\u00e8'));
        hashSet.add(new Character('\u00e9'));
        hashSet.add(new Character('\u00ea'));
        hashSet.add(new Character('\u00eb'));
        hashSet.add(new Character('\u00ec'));
        hashSet.add(new Character('\u00ed'));
        hashSet.add(new Character('\u00ee'));
        hashSet.add(new Character('\u00ef'));
        hashSet.add(new Character('\u00f0'));
        hashSet.add(new Character('\u00f1'));
        hashSet.add(new Character('\u00f2'));
        hashSet.add(new Character('\u00f3'));
        hashSet.add(new Character('\u00f4'));
        hashSet.add(new Character('\u00f5'));
        hashSet.add(new Character('\u00f6'));
        hashSet.add(new Character('\u00f8'));
        hashSet.add(new Character('\u00f9'));
        hashSet.add(new Character('\u00fa'));
        hashSet.add(new Character('\u00fb'));
        hashSet.add(new Character('\u00fc'));
        hashSet.add(new Character('\u00fd'));
        hashSet.add(new Character('\u00fe'));
        hashSet.add(new Character('\u00ff'));
        hashSet.add(new Character('\u0152'));
        hashSet.add(new Character('\u0153'));
        hashSet.add(new Character('\u0160'));
        hashSet.add(new Character('\u0161'));
        hashSet.add(new Character('\u0178'));
        hashSet.add(new Character('\uff03'));
        hashSet.add(new Character('\uff04'));
        hashSet.add(new Character('\uff20'));
        hashSet.add(new Character('\uff21'));
        hashSet.add(new Character('\uff22'));
        hashSet.add(new Character('\uff23'));
        hashSet.add(new Character('\uff24'));
        hashSet.add(new Character('\uff25'));
        hashSet.add(new Character('\uff26'));
        hashSet.add(new Character('\uff27'));
        hashSet.add(new Character('\uff28'));
        hashSet.add(new Character('\uff29'));
        hashSet.add(new Character('\uff2a'));
        hashSet.add(new Character('\uff2b'));
        hashSet.add(new Character('\uff2c'));
        hashSet.add(new Character('\uff2d'));
        hashSet.add(new Character('\uff2e'));
        hashSet.add(new Character('\uff2f'));
        hashSet.add(new Character('\uff30'));
        hashSet.add(new Character('\uff31'));
        hashSet.add(new Character('\uff32'));
        hashSet.add(new Character('\uff33'));
        hashSet.add(new Character('\uff34'));
        hashSet.add(new Character('\uff35'));
        hashSet.add(new Character('\uff36'));
        hashSet.add(new Character('\uff37'));
        hashSet.add(new Character('\uff38'));
        hashSet.add(new Character('\uff39'));
        hashSet.add(new Character('\uff3a'));
        hashSet.add(new Character('\uff41'));
        hashSet.add(new Character('\uff42'));
        hashSet.add(new Character('\uff43'));
        hashSet.add(new Character('\uff44'));
        hashSet.add(new Character('\uff45'));
        hashSet.add(new Character('\uff46'));
        hashSet.add(new Character('\uff47'));
        hashSet.add(new Character('\uff48'));
        hashSet.add(new Character('\uff49'));
        hashSet.add(new Character('\uff4a'));
        hashSet.add(new Character('\uff4b'));
        hashSet.add(new Character('\uff4c'));
        hashSet.add(new Character('\uff4d'));
        hashSet.add(new Character('\uff4e'));
        hashSet.add(new Character('\uff4f'));
        hashSet.add(new Character('\uff50'));
        hashSet.add(new Character('\uff51'));
        hashSet.add(new Character('\uff52'));
        hashSet.add(new Character('\uff53'));
        hashSet.add(new Character('\uff54'));
        hashSet.add(new Character('\uff55'));
        hashSet.add(new Character('\uff56'));
        hashSet.add(new Character('\uff57'));
        hashSet.add(new Character('\uff58'));
        hashSet.add(new Character('\uff59'));
        hashSet.add(new Character('\uff5a'));
        hashSet = new HashSet(349);
        ordinaryFlagsSet.put("PLATFORM_390", hashSet);
        hashSet.add(new Character('#'));
        hashSet.add(new Character('$'));
        hashSet.add(new Character('@'));
        hashSet.add(new Character('A'));
        hashSet.add(new Character('B'));
        hashSet.add(new Character('C'));
        hashSet.add(new Character('D'));
        hashSet.add(new Character('E'));
        hashSet.add(new Character('F'));
        hashSet.add(new Character('G'));
        hashSet.add(new Character('H'));
        hashSet.add(new Character('I'));
        hashSet.add(new Character('J'));
        hashSet.add(new Character('K'));
        hashSet.add(new Character('L'));
        hashSet.add(new Character('M'));
        hashSet.add(new Character('N'));
        hashSet.add(new Character('O'));
        hashSet.add(new Character('P'));
        hashSet.add(new Character('Q'));
        hashSet.add(new Character('R'));
        hashSet.add(new Character('S'));
        hashSet.add(new Character('T'));
        hashSet.add(new Character('U'));
        hashSet.add(new Character('V'));
        hashSet.add(new Character('W'));
        hashSet.add(new Character('X'));
        hashSet.add(new Character('Y'));
        hashSet.add(new Character('Z'));
        hashSet.add(new Character('a'));
        hashSet.add(new Character('b'));
        hashSet.add(new Character('c'));
        hashSet.add(new Character('d'));
        hashSet.add(new Character('e'));
        hashSet.add(new Character('f'));
        hashSet.add(new Character('g'));
        hashSet.add(new Character('h'));
        hashSet.add(new Character('i'));
        hashSet.add(new Character('j'));
        hashSet.add(new Character('k'));
        hashSet.add(new Character('l'));
        hashSet.add(new Character('m'));
        hashSet.add(new Character('n'));
        hashSet.add(new Character('o'));
        hashSet.add(new Character('p'));
        hashSet.add(new Character('q'));
        hashSet.add(new Character('r'));
        hashSet.add(new Character('s'));
        hashSet.add(new Character('t'));
        hashSet.add(new Character('u'));
        hashSet.add(new Character('v'));
        hashSet.add(new Character('w'));
        hashSet.add(new Character('x'));
        hashSet.add(new Character('y'));
        hashSet.add(new Character('z'));
        hashSet = new HashSet(349);
        ordinaryFlagsSet.put("PLATFORM_400", hashSet);
        hashSet.add(new Character('#'));
        hashSet.add(new Character('$'));
        hashSet.add(new Character('@'));
        hashSet.add(new Character('A'));
        hashSet.add(new Character('B'));
        hashSet.add(new Character('C'));
        hashSet.add(new Character('D'));
        hashSet.add(new Character('E'));
        hashSet.add(new Character('F'));
        hashSet.add(new Character('G'));
        hashSet.add(new Character('H'));
        hashSet.add(new Character('I'));
        hashSet.add(new Character('J'));
        hashSet.add(new Character('K'));
        hashSet.add(new Character('L'));
        hashSet.add(new Character('M'));
        hashSet.add(new Character('N'));
        hashSet.add(new Character('O'));
        hashSet.add(new Character('P'));
        hashSet.add(new Character('Q'));
        hashSet.add(new Character('R'));
        hashSet.add(new Character('S'));
        hashSet.add(new Character('T'));
        hashSet.add(new Character('U'));
        hashSet.add(new Character('V'));
        hashSet.add(new Character('W'));
        hashSet.add(new Character('X'));
        hashSet.add(new Character('Y'));
        hashSet.add(new Character('Z'));
        hashSet.add(new Character('a'));
        hashSet.add(new Character('b'));
        hashSet.add(new Character('c'));
        hashSet.add(new Character('d'));
        hashSet.add(new Character('e'));
        hashSet.add(new Character('f'));
        hashSet.add(new Character('g'));
        hashSet.add(new Character('h'));
        hashSet.add(new Character('i'));
        hashSet.add(new Character('j'));
        hashSet.add(new Character('k'));
        hashSet.add(new Character('l'));
        hashSet.add(new Character('m'));
        hashSet.add(new Character('n'));
        hashSet.add(new Character('o'));
        hashSet.add(new Character('p'));
        hashSet.add(new Character('q'));
        hashSet.add(new Character('r'));
        hashSet.add(new Character('s'));
        hashSet.add(new Character('t'));
        hashSet.add(new Character('u'));
        hashSet.add(new Character('v'));
        hashSet.add(new Character('w'));
        hashSet.add(new Character('x'));
        hashSet.add(new Character('y'));
        hashSet.add(new Character('z'));
        ordinaryDigits = "0123456789";
        ordinaryWideDigits = "\uff10\uff11\uff12\uff13\uff14\uff15\uff16\uff17\uff18\uff19";
        schemaReserved = new HashSet(6);
        schemaReserved.add("SYSCAT");
        schemaReserved.add("SYSFUN");
        schemaReserved.add("SYSIBM");
        schemaReserved.add("SYSSTAT");
        luwoReserved = new HashSet(400);
        luwoReserved.add("ABSOLUTE");
        luwoReserved.add("ACQUIRE");
        luwoReserved.add("ACTION");
        luwoReserved.add("ADD");
        luwoReserved.add("AFTER");
        luwoReserved.add("ALIAS");
        luwoReserved.add("ALL");
        luwoReserved.add("ALLOCATE");
        luwoReserved.add("ALLOW");
        luwoReserved.add("ALTER");
        luwoReserved.add("AND");
        luwoReserved.add("ANY");
        luwoReserved.add("ARE");
        luwoReserved.add(DB2400);
        luwoReserved.add("ASC");
        luwoReserved.add("ASSERTION");
        luwoReserved.add("ASUTIME");
        luwoReserved.add("AT");
        luwoReserved.add("AUDIT");
        luwoReserved.add("AUTHORIZATION");
        luwoReserved.add("AUX");
        luwoReserved.add("AUXILIARY");
        luwoReserved.add("AVG");
        luwoReserved.add("BEFORE");
        luwoReserved.add("BEGIN");
        luwoReserved.add("BETWEEN");
        luwoReserved.add("BINARY");
        luwoReserved.add("BIT_LENGTH");
        luwoReserved.add("BOTH");
        luwoReserved.add("BUFFERPOOL");
        luwoReserved.add("BY");
        luwoReserved.add("CALL");
        luwoReserved.add("CALLED");
        luwoReserved.add("CAPTURE");
        luwoReserved.add("CASCADED");
        luwoReserved.add("CASE");
        luwoReserved.add("CAST");
        luwoReserved.add("CATALOG");
        luwoReserved.add("CCSID");
        luwoReserved.add("CHAR");
        luwoReserved.add("CHARACTER");
        luwoReserved.add("CHARACTER_LENGTH");
        luwoReserved.add("CHAR_LENGTH");
        luwoReserved.add("CHECK");
        luwoReserved.add("CLOSE");
        luwoReserved.add("CLUSTER");
        luwoReserved.add("COALESCE");
        luwoReserved.add("COLLATE");
        luwoReserved.add("COLLATION");
        luwoReserved.add("COLLECTION");
        luwoReserved.add("COLLID");
        luwoReserved.add("COLUMN");
        luwoReserved.add("COMMENT");
        luwoReserved.add("COMMIT");
        luwoReserved.add("CONCAT");
        luwoReserved.add("CONDITION");
        luwoReserved.add("CONNECT");
        luwoReserved.add("CONNECTION");
        luwoReserved.add("CONSTRAINT");
        luwoReserved.add("CONSTRAINTS");
        luwoReserved.add("CONTAINS");
        luwoReserved.add("CONTINUE");
        luwoReserved.add("CONVERT");
        luwoReserved.add("CORRESPONDING");
        luwoReserved.add("COUNT");
        luwoReserved.add("COUNT_BIG");
        luwoReserved.add("CREATE");
        luwoReserved.add("CROSS");
        luwoReserved.add("CURRENT");
        luwoReserved.add("CURRENT_DATE");
        luwoReserved.add("CURRENT_LC_PATH");
        luwoReserved.add("CURRENT_PATH");
        luwoReserved.add("CURRENT_SERVER");
        luwoReserved.add("CURRENT_TIME");
        luwoReserved.add("CURRENT_TIMESTAMP");
        luwoReserved.add("CURRENT_TIMEZONE");
        luwoReserved.add("CURRENT_USER");
        luwoReserved.add("CURSOR");
        luwoReserved.add("DATA");
        luwoReserved.add("DATABASE");
        luwoReserved.add("DATE");
        luwoReserved.add("DAY");
        luwoReserved.add("DAYS");
        luwoReserved.add("DB2GENERAL");
        luwoReserved.add("DB2SQL");
        luwoReserved.add("DBA");
        luwoReserved.add("DBINFO");
        luwoReserved.add("DBSPACE");
        luwoReserved.add("DEALLOCATE");
        luwoReserved.add("DEC");
        luwoReserved.add("DECIMAL");
        luwoReserved.add("DECLARE");
        luwoReserved.add("DEFAULT");
        luwoReserved.add("DEFERRABLE");
        luwoReserved.add("DEFERRED");
        luwoReserved.add("DELETE");
        luwoReserved.add("DESC");
        luwoReserved.add("DESCRIBE");
        luwoReserved.add("DESCRIPTOR");
        luwoReserved.add("DETERMINISTIC");
        luwoReserved.add("DIAGNOSTICS");
        luwoReserved.add("DISALLOW");
        luwoReserved.add("DISCONNECT");
        luwoReserved.add("DISTINCT");
        luwoReserved.add("DO");
        luwoReserved.add("DOMAIN");
        luwoReserved.add("DOUBLE");
        luwoReserved.add("DROP");
        luwoReserved.add("DSSIZE");
        luwoReserved.add("DYNAMIC");
        luwoReserved.add("EDITPROC");
        luwoReserved.add("ELSE");
        luwoReserved.add("ELSEIF");
        luwoReserved.add("END");
        luwoReserved.add("END-EXEC");
        luwoReserved.add("ERASE");
        luwoReserved.add("ESCAPE");
        luwoReserved.add("EXCEPT");
        luwoReserved.add("EXCEPTION");
        luwoReserved.add("EXCLUSIVE");
        luwoReserved.add("EXEC");
        luwoReserved.add("EXECUTE");
        luwoReserved.add("EXISTS");
        luwoReserved.add("EXIT");
        luwoReserved.add("EXPLAIN");
        luwoReserved.add("EXTERNAL");
        luwoReserved.add("EXTRACT");
        luwoReserved.add("FALSE");
        luwoReserved.add("FENCED");
        luwoReserved.add("FETCH");
        luwoReserved.add("FIELDPROC");
        luwoReserved.add("FILE");
        luwoReserved.add("FINAL");
        luwoReserved.add("FIRST");
        luwoReserved.add("FLOAT");
        luwoReserved.add("FOR");
        luwoReserved.add("FOREIGN");
        luwoReserved.add("FOUND");
        luwoReserved.add("FREE");
        luwoReserved.add("FROM");
        luwoReserved.add("FULL");
        luwoReserved.add("FULL");
        luwoReserved.add("FUNCTION");
        luwoReserved.add("GENERAL");
        luwoReserved.add("GENERATED");
        luwoReserved.add("GET");
        luwoReserved.add("GLOBAL");
        luwoReserved.add("GO");
        luwoReserved.add("GOTO");
        luwoReserved.add("GRANT");
        luwoReserved.add("GRAPHIC");
        luwoReserved.add("GROUP");
        luwoReserved.add("HANDLER");
        luwoReserved.add("HAVING");
        luwoReserved.add("HOUR");
        luwoReserved.add("HOURS");
        luwoReserved.add("IDENTIFIED");
        luwoReserved.add("IDENTITY");
        luwoReserved.add("IF");
        luwoReserved.add("IMMEDIATE");
        luwoReserved.add("IN");
        luwoReserved.add("INDEX");
        luwoReserved.add("INDICATOR");
        luwoReserved.add("INITIALLY");
        luwoReserved.add("INNER");
        luwoReserved.add("INOUT");
        luwoReserved.add("INPUT");
        luwoReserved.add("INSENSITIVE");
        luwoReserved.add("INSERT");
        luwoReserved.add("INTEGRITY");
        luwoReserved.add("INTERSECT");
        luwoReserved.add("INTERVAL");
        luwoReserved.add("INTO");
        luwoReserved.add("IS");
        luwoReserved.add("ISOBID");
        luwoReserved.add("ISOLATION");
        luwoReserved.add("JAVA");
        luwoReserved.add("JOIN");
        luwoReserved.add("KEY");
        luwoReserved.add("LABEL");
        luwoReserved.add("LANGUAGE");
        luwoReserved.add("LAST");
        luwoReserved.add("LC_CTYPE");
        luwoReserved.add("LEADING");
        luwoReserved.add("LEAVE");
        luwoReserved.add("LEFT");
        luwoReserved.add("LEVEL");
        luwoReserved.add("LIKE");
        luwoReserved.add("LINKTYPE");
        luwoReserved.add("LOCAL");
        luwoReserved.add("LOCALE");
        luwoReserved.add("LOCATOR");
        luwoReserved.add("LOCATORS");
        luwoReserved.add("LOCK");
        luwoReserved.add("LOCKSIZE");
        luwoReserved.add("LONG");
        luwoReserved.add("LOOP");
        luwoReserved.add("LOWER");
        luwoReserved.add("MATCH");
        luwoReserved.add("MAX");
        luwoReserved.add("MICROSECOND");
        luwoReserved.add("MICROSECONDS");
        luwoReserved.add("MIN");
        luwoReserved.add("MINUTE");
        luwoReserved.add("MINUTES");
        luwoReserved.add("MODE");
        luwoReserved.add("MODIFIES");
        luwoReserved.add("MODULE");
        luwoReserved.add("MONTH");
        luwoReserved.add("MONTHS");
        luwoReserved.add("NAME");
        luwoReserved.add("NAMED");
        luwoReserved.add("NAMES");
        luwoReserved.add("NATIONAL");
        luwoReserved.add("NATURAL");
        luwoReserved.add("NCHAR");
        luwoReserved.add("NEXT");
        luwoReserved.add("NHEADER");
        luwoReserved.add("NO");
        luwoReserved.add("NODENAME");
        luwoReserved.add("NODENUMBER");
        luwoReserved.add("NOT");
        luwoReserved.add("NULL");
        luwoReserved.add("NULLIF");
        luwoReserved.add("NULLS");
        luwoReserved.add("NUMERIC");
        luwoReserved.add("NUMPARTS");
        luwoReserved.add("OBID");
        luwoReserved.add("OCTET_LENGTH");
        luwoReserved.add("OF");
        luwoReserved.add("ON");
        luwoReserved.add("ONLY");
        luwoReserved.add("OPEN");
        luwoReserved.add("OPTIMIZATION");
        luwoReserved.add("OPTIMIZE");
        luwoReserved.add("OPTION");
        luwoReserved.add("OR");
        luwoReserved.add("ORDER");
        luwoReserved.add("OUT");
        luwoReserved.add("OUTER");
        luwoReserved.add("OUTPUT");
        luwoReserved.add("OVERLAPS");
        luwoReserved.add("PACKAGE");
        luwoReserved.add("PAD");
        luwoReserved.add("PAGE");
        luwoReserved.add("PAGES");
        luwoReserved.add("PARAMETER");
        luwoReserved.add("PART");
        luwoReserved.add("PARTIAL");
        luwoReserved.add("PARTITION");
        luwoReserved.add("PATH");
        luwoReserved.add("PCTFREE");
        luwoReserved.add("PCTINDEX");
        luwoReserved.add("PIECESIZE");
        luwoReserved.add("PLAN");
        luwoReserved.add("POSITION");
        luwoReserved.add("PRECISION");
        luwoReserved.add("PREPARE");
        luwoReserved.add("PRESERVE");
        luwoReserved.add("PRIMARY");
        luwoReserved.add("PRIOR");
        luwoReserved.add("PRIQTY");
        luwoReserved.add("PRIVATE");
        luwoReserved.add("PRIVILEGES");
        luwoReserved.add("PROCEDURE");
        luwoReserved.add("PROGRAM");
        luwoReserved.add("PSID");
        luwoReserved.add("PUBLIC");
        luwoReserved.add("QUERYNO");
        luwoReserved.add("READ");
        luwoReserved.add("READS");
        luwoReserved.add("REAL");
        luwoReserved.add("RECOVERY");
        luwoReserved.add("REFERENCES");
        luwoReserved.add("RELATIVE");
        luwoReserved.add("RELEASE");
        luwoReserved.add("RENAME");
        luwoReserved.add("REPEAT");
        luwoReserved.add("RESET");
        luwoReserved.add("RESOURCE");
        luwoReserved.add("RESTRICT");
        luwoReserved.add("RESULT");
        luwoReserved.add("RETURN");
        luwoReserved.add("RETURNS");
        luwoReserved.add("REVOKE");
        luwoReserved.add("RIGHT");
        luwoReserved.add("ROLLBACK");
        luwoReserved.add("ROW");
        luwoReserved.add("ROWS");
        luwoReserved.add("RRN");
        luwoReserved.add("RUN");
        luwoReserved.add("SCHEDULE");
        luwoReserved.add("SCHEMA");
        luwoReserved.add("SCRATCHPAD");
        luwoReserved.add("SCROLL");
        luwoReserved.add("SECOND");
        luwoReserved.add("SECONDS");
        luwoReserved.add("SECQTY");
        luwoReserved.add("SECTION");
        luwoReserved.add("SECURITY");
        luwoReserved.add("SELECT");
        luwoReserved.add("SESSION");
        luwoReserved.add("SESSION_USER");
        luwoReserved.add("SET");
        luwoReserved.add("SHARE");
        luwoReserved.add("SIMPLE");
        luwoReserved.add("SIZE");
        luwoReserved.add("SMALLINT");
        luwoReserved.add("SOME");
        luwoReserved.add("SOURCE");
        luwoReserved.add("SPACE");
        luwoReserved.add("SPECIFIC");
        luwoReserved.add("SQL");
        luwoReserved.add("SQLCODE");
        luwoReserved.add("SQLERROR");
        luwoReserved.add("SQLSTATE");
        luwoReserved.add("STANDARD");
        luwoReserved.add("STATIC");
        luwoReserved.add("STATISTICS");
        luwoReserved.add("STAY");
        luwoReserved.add("STOGROUP");
        luwoReserved.add("STORES");
        luwoReserved.add("STORPOOL");
        luwoReserved.add("STYLE");
        luwoReserved.add("SUBPAGES");
        luwoReserved.add("SUBSTRING");
        luwoReserved.add("SUM");
        luwoReserved.add("SYNONYM");
        luwoReserved.add("SYSTEM_USER");
        luwoReserved.add("TABLE");
        luwoReserved.add("TABLESPACE");
        luwoReserved.add("TEMPORARY");
        luwoReserved.add("THEN");
        luwoReserved.add("TIMEZONE_HOUR");
        luwoReserved.add("TIMEZONE_MINUTE");
        luwoReserved.add("TO");
        luwoReserved.add("TRAILING");
        luwoReserved.add("TRANSACTION");
        luwoReserved.add("TRANSLATION");
        luwoReserved.add("TRIGGER");
        luwoReserved.add("TRIM");
        luwoReserved.add("TRUE");
        luwoReserved.add("TYPE");
        luwoReserved.add("UNDO");
        luwoReserved.add("UNION");
        luwoReserved.add("UNIQUE");
        luwoReserved.add("UNKNOWN");
        luwoReserved.add("UNTIL");
        luwoReserved.add("UPDATE");
        luwoReserved.add("UPPER");
        luwoReserved.add("USAGE");
        luwoReserved.add("USER");
        luwoReserved.add("USING");
        luwoReserved.add("VALIDPROC");
        luwoReserved.add("VALUE");
        luwoReserved.add("VALUES");
        luwoReserved.add("VARCHAR");
        luwoReserved.add("VARIABLE");
        luwoReserved.add("VARIANT");
        luwoReserved.add("VARYING");
        luwoReserved.add("VCAT");
        luwoReserved.add("VIEW");
        luwoReserved.add("VOLUMES");
        luwoReserved.add("WHEN");
        luwoReserved.add("WHENEVER");
        luwoReserved.add("WHERE");
        luwoReserved.add("WHILE");
        luwoReserved.add("WITH");
        luwoReserved.add("WLM");
        luwoReserved.add("WORK");
        luwoReserved.add("WRITE");
        luwoReserved.add("YEAR");
        luwoReserved.add("YEARS");
        luwoReserved.add("ZONE");
        os390Reserved = new HashSet(300);
        os390Reserved.add("ADD");
        os390Reserved.add("AFTER");
        os390Reserved.add("ALL");
        os390Reserved.add("ALLOW");
        os390Reserved.add("ALTER");
        os390Reserved.add("AND");
        os390Reserved.add("ANY");
        os390Reserved.add(DB2400);
        os390Reserved.add("ASUTIME");
        os390Reserved.add("AUDIT");
        os390Reserved.add("AUX");
        os390Reserved.add("AUXILIARY");
        os390Reserved.add("BEFORE");
        os390Reserved.add("BEGIN");
        os390Reserved.add("BETWEEN");
        os390Reserved.add("BUFFERPOOL");
        os390Reserved.add("BY");
        os390Reserved.add("CALL");
        os390Reserved.add("CAPTURE");
        os390Reserved.add("CASCADED");
        os390Reserved.add("CASE");
        os390Reserved.add("CAST");
        os390Reserved.add("CCSID");
        os390Reserved.add("CHAR");
        os390Reserved.add("CHARACTER");
        os390Reserved.add("CHECK");
        os390Reserved.add("CLOSE");
        os390Reserved.add("CLUSTER");
        os390Reserved.add("COLLECTION");
        os390Reserved.add("COLLID");
        os390Reserved.add("COLUMN");
        os390Reserved.add("COMMENT");
        os390Reserved.add("COMMIT");
        os390Reserved.add("CONCAT");
        os390Reserved.add("CONDITION");
        os390Reserved.add("CONNECT");
        os390Reserved.add("CONNECTION");
        os390Reserved.add("CONSTRAINT");
        os390Reserved.add("CONTAINS");
        os390Reserved.add("CONTINUE");
        os390Reserved.add("CREATE");
        os390Reserved.add("CURRENT");
        os390Reserved.add("CURRENT_");
        os390Reserved.add("CURRENT_DATE");
        os390Reserved.add("CURRENT_TIME");
        os390Reserved.add("CURRENT_TIMESTAMP");
        os390Reserved.add("CURSOR");
        os390Reserved.add("DATA");
        os390Reserved.add("DATABASE");
        os390Reserved.add("DAY");
        os390Reserved.add("DAYS");
        os390Reserved.add("DB2SQL");
        os390Reserved.add("DBINFO");
        os390Reserved.add("DECLARE");
        os390Reserved.add("DEFAULT");
        os390Reserved.add("DELETE");
        os390Reserved.add("DESCRIPTOR");
        os390Reserved.add("DETERMINISTIC");
        os390Reserved.add("DISALLOW");
        os390Reserved.add("DISTINCT");
        os390Reserved.add("DO");
        os390Reserved.add("DOUBLE");
        os390Reserved.add("DROP");
        os390Reserved.add("DSSIZE");
        os390Reserved.add("DYNAMIC");
        os390Reserved.add("EDITPROC");
        os390Reserved.add("ELSE");
        os390Reserved.add("ELSEIF");
        os390Reserved.add("END");
        os390Reserved.add("END-EXEC");
        os390Reserved.add("ERASE");
        os390Reserved.add("ESCAPE");
        os390Reserved.add("EXCEPT");
        os390Reserved.add("EXECUTE");
        os390Reserved.add("EXISTS");
        os390Reserved.add("EXIT");
        os390Reserved.add("EXTERNAL");
        os390Reserved.add("FENCED");
        os390Reserved.add("FETCH");
        os390Reserved.add("FIELDPROC");
        os390Reserved.add("FINAL");
        os390Reserved.add("FOR");
        os390Reserved.add("FROM");
        os390Reserved.add("FULL");
        os390Reserved.add("FUNCTION");
        os390Reserved.add("GENERAL");
        os390Reserved.add("GENERATED");
        os390Reserved.add("GET");
        os390Reserved.add("GLOBAL");
        os390Reserved.add("GO");
        os390Reserved.add("GOTONULL");
        os390Reserved.add("GRANT");
        os390Reserved.add("GROUP");
        os390Reserved.add("HANDLER");
        os390Reserved.add("HAVING");
        os390Reserved.add("HOUR");
        os390Reserved.add("HOURS");
        os390Reserved.add("IF");
        os390Reserved.add("IMMEDIATE");
        os390Reserved.add("IN");
        os390Reserved.add("INDEX");
        os390Reserved.add("INNER");
        os390Reserved.add("INOUT");
        os390Reserved.add("INSERT");
        os390Reserved.add("INTO");
        os390Reserved.add("IS");
        os390Reserved.add("ISOBID");
        os390Reserved.add("JAVA");
        os390Reserved.add("JOIN");
        os390Reserved.add("KEY");
        os390Reserved.add("LABEL");
        os390Reserved.add("LANGUAGE");
        os390Reserved.add("LC_CTYPE");
        os390Reserved.add("LC_CTYPE");
        os390Reserved.add("LEAVE");
        os390Reserved.add("LEFT");
        os390Reserved.add("LIKE");
        os390Reserved.add("LOCAL");
        os390Reserved.add("LOCALE");
        os390Reserved.add("LOCATOR");
        os390Reserved.add("LOCATORS");
        os390Reserved.add("LOCK");
        os390Reserved.add("LOCKMAX");
        os390Reserved.add("LOCKSIZE");
        os390Reserved.add("LONG");
        os390Reserved.add("LOOP");
        os390Reserved.add("MICROSECOND");
        os390Reserved.add("MICROSECONDS");
        os390Reserved.add("MINUTE");
        os390Reserved.add("MINUTES");
        os390Reserved.add("MODIFIES");
        os390Reserved.add("MONTH");
        os390Reserved.add("MONTHS");
        os390Reserved.add("NAME");
        os390Reserved.add("NO");
        os390Reserved.add("NOT");
        os390Reserved.add("NULLS");
        os390Reserved.add("NUMPARTS");
        os390Reserved.add("OBID");
        os390Reserved.add("OF");
        os390Reserved.add("ON");
        os390Reserved.add("OPEN");
        os390Reserved.add("OPTIMIZATION");
        os390Reserved.add("OPTIMIZE");
        os390Reserved.add("OR");
        os390Reserved.add("ORDER");
        os390Reserved.add("OUT");
        os390Reserved.add("OUTER");
        os390Reserved.add("PACKAGE");
        os390Reserved.add("PARAMETER");
        os390Reserved.add("PART");
        os390Reserved.add("PATH");
        os390Reserved.add("PATH");
        os390Reserved.add("PIECESIZE");
        os390Reserved.add("PLAN");
        os390Reserved.add("PRECISION");
        os390Reserved.add("PREPARE");
        os390Reserved.add("PRIQTY");
        os390Reserved.add("PRIVILEGES");
        os390Reserved.add("PROCEDURE");
        os390Reserved.add("PROGRAM");
        os390Reserved.add("PSID");
        os390Reserved.add("QUERYNO");
        os390Reserved.add("READS");
        os390Reserved.add("REFERENCES");
        os390Reserved.add("RELEASE");
        os390Reserved.add("RENAME");
        os390Reserved.add("REPEAT");
        os390Reserved.add("RESTRICT");
        os390Reserved.add("RESULT");
        os390Reserved.add("RETURN");
        os390Reserved.add("RETURNS");
        os390Reserved.add("REVOKE");
        os390Reserved.add("RIGHT");
        os390Reserved.add("ROLLBACK");
        os390Reserved.add("RUN");
        os390Reserved.add("SAVEPOINT");
        os390Reserved.add("SCHEMA");
        os390Reserved.add("SCRATCHPAD");
        os390Reserved.add("SECOND");
        os390Reserved.add("SECONDS");
        os390Reserved.add("SECQTY");
        os390Reserved.add("SECURITY");
        os390Reserved.add("SELECT");
        os390Reserved.add("SET");
        os390Reserved.add("SIMPLE");
        os390Reserved.add("SOME");
        os390Reserved.add("SOURCE");
        os390Reserved.add("SPECIFIC");
        os390Reserved.add("STANDARD");
        os390Reserved.add("STAY");
        os390Reserved.add("STOGROUP");
        os390Reserved.add("STORES");
        os390Reserved.add("STYLE");
        os390Reserved.add("SUBPAGES");
        os390Reserved.add("SYNONYM");
        os390Reserved.add("SYSFUN");
        os390Reserved.add("SYSIBM");
        os390Reserved.add("SYSPROC");
        os390Reserved.add("SYSTEM");
        os390Reserved.add("TABLE");
        os390Reserved.add("TABLESPACE");
        os390Reserved.add("THEN");
        os390Reserved.add("TO");
        os390Reserved.add("TRIGGER");
        os390Reserved.add("TYPE");
        os390Reserved.add("UNDO");
        os390Reserved.add("UNION");
        os390Reserved.add("UNIQUE");
        os390Reserved.add("UNTIL");
        os390Reserved.add("UPDATE");
        os390Reserved.add("USER");
        os390Reserved.add("USING");
        os390Reserved.add("VALIDPROC");
        os390Reserved.add("VALUES");
        os390Reserved.add("VARIANT");
        os390Reserved.add("VCAT");
        os390Reserved.add("VIEW");
        os390Reserved.add("VOLUMES");
        os390Reserved.add("WHEN");
        os390Reserved.add("WHERE");
        os390Reserved.add("WHILE");
        os390Reserved.add("WITH");
        os390Reserved.add("WLM");
        os390Reserved.add("YEAR");
        os390Reserved.add("YEARS");
        os400Reserved = new HashSet(250);
        os400Reserved.add("ADD");
        os400Reserved.add("ALIAS");
        os400Reserved.add("ALL");
        os400Reserved.add("ALLOCATE");
        os400Reserved.add("ALLOW");
        os400Reserved.add("ALTER");
        os400Reserved.add("AND");
        os400Reserved.add("ANY");
        os400Reserved.add(DB2400);
        os400Reserved.add("AUTHORIZATION");
        os400Reserved.add("BEGIN");
        os400Reserved.add("BETWEEN");
        os400Reserved.add("BINARY");
        os400Reserved.add("BY");
        os400Reserved.add("CALL");
        os400Reserved.add("CALLED");
        os400Reserved.add("CASE");
        os400Reserved.add("CAST");
        os400Reserved.add("CCSID");
        os400Reserved.add("CHAR");
        os400Reserved.add("CHARACTER");
        os400Reserved.add("CHECK");
        os400Reserved.add("CLOSE");
        os400Reserved.add("COLLECTION");
        os400Reserved.add("COLUMN");
        os400Reserved.add("COMMENT");
        os400Reserved.add("COMMIT");
        os400Reserved.add("CONCAT");
        os400Reserved.add("CONDITION");
        os400Reserved.add("CONNECT");
        os400Reserved.add("CONNECTION");
        os400Reserved.add("CONSTRAINT");
        os400Reserved.add("CONTAINS");
        os400Reserved.add("CONTINUE");
        os400Reserved.add("COUNT");
        os400Reserved.add("CREATE");
        os400Reserved.add("CROSS");
        os400Reserved.add("CURRENT");
        os400Reserved.add("CURRENT_DATE");
        os400Reserved.add("CURRENT_PATH");
        os400Reserved.add("CURRENT_SERVER");
        os400Reserved.add("CURRENT_TIME");
        os400Reserved.add("CURRENT_TIMESTAMP");
        os400Reserved.add("CURRENT_TIMEZONE");
        os400Reserved.add("CURRENT_USER");
        os400Reserved.add("CURSOR");
        os400Reserved.add("DATABASE");
        os400Reserved.add("DAY");
        os400Reserved.add("DAYS");
        os400Reserved.add("DB2GENERAL");
        os400Reserved.add("DB2SQL");
        os400Reserved.add("DBINFO");
        os400Reserved.add("DECLARE");
        os400Reserved.add("DEFAULT");
        os400Reserved.add("DELETE");
        os400Reserved.add("DESCRIPTOR");
        os400Reserved.add("DETERMINISTIC");
        os400Reserved.add("DISALLOW");
        os400Reserved.add("DISCONNECT");
        os400Reserved.add("DISTINCT");
        os400Reserved.add("DO");
        os400Reserved.add("DOUBLE");
        os400Reserved.add("DROP");
        os400Reserved.add("DYNAMIC");
        os400Reserved.add("ELSE");
        os400Reserved.add("ELSEIF");
        os400Reserved.add("END");
        os400Reserved.add("ESCAPE");
        os400Reserved.add("EXCEPTION");
        os400Reserved.add("EXECUTE");
        os400Reserved.add("EXISTS");
        os400Reserved.add("EXIT");
        os400Reserved.add("EXTERNAL");
        os400Reserved.add("FENCED");
        os400Reserved.add("FETCH");
        os400Reserved.add("FILE");
        os400Reserved.add("FINAL");
        os400Reserved.add("FOR");
        os400Reserved.add("FOREIGN");
        os400Reserved.add("FREE");
        os400Reserved.add("FROM");
        os400Reserved.add("FUNCTION");
        os400Reserved.add("GENERAL");
        os400Reserved.add("GO");
        os400Reserved.add("GOTO");
        os400Reserved.add("GRANT");
        os400Reserved.add("GRAPHIC");
        os400Reserved.add("GROUP");
        os400Reserved.add("HANDLER");
        os400Reserved.add("HAVING");
        os400Reserved.add("HOUR");
        os400Reserved.add("HOURS");
        os400Reserved.add("IF");
        os400Reserved.add("IMMEDIATE");
        os400Reserved.add("IN");
        os400Reserved.add("INDEX");
        os400Reserved.add("INDICATOR");
        os400Reserved.add("INNER");
        os400Reserved.add("INOUT");
        os400Reserved.add("INSENSITIVE");
        os400Reserved.add("INSERT");
        os400Reserved.add("INTEGRITY");
        os400Reserved.add("INTO");
        os400Reserved.add("IS");
        os400Reserved.add("ISOLATION");
        os400Reserved.add("JOIN");
        os400Reserved.add("KEY");
        os400Reserved.add("LABEL");
        os400Reserved.add("LANGUAGE");
        os400Reserved.add("LEAVE");
        os400Reserved.add("LEFT");
        os400Reserved.add("LIKE");
        os400Reserved.add("LINKTYPE");
        os400Reserved.add("LOCK");
        os400Reserved.add("LONG");
        os400Reserved.add("LOOP");
        os400Reserved.add("MICROSECOND");
        os400Reserved.add("MICROSECONDS");
        os400Reserved.add("MINUTE");
        os400Reserved.add("MINUTES");
        os400Reserved.add("MODIFIES");
        os400Reserved.add("MONTH");
        os400Reserved.add("MONTHS");
        os400Reserved.add("NO");
        os400Reserved.add("NODENAME");
        os400Reserved.add("NODENUMBER");
        os400Reserved.add("NOT");
        os400Reserved.add("NULL");
        os400Reserved.add("OF");
        os400Reserved.add("ON");
        os400Reserved.add("OPEN");
        os400Reserved.add("OPTIMIZE");
        os400Reserved.add("OPTION");
        os400Reserved.add("OR");
        os400Reserved.add("ORDER");
        os400Reserved.add("OUT");
        os400Reserved.add("OUTER");
        os400Reserved.add("PACKAGE");
        os400Reserved.add("PARAMETER");
        os400Reserved.add("PARTITION");
        os400Reserved.add("PATH");
        os400Reserved.add("POSITION");
        os400Reserved.add("PREPARE");
        os400Reserved.add("PRIMARY");
        os400Reserved.add("PRIVILEGES");
        os400Reserved.add("PROCEDURE");
        os400Reserved.add("PROGRAM");
        os400Reserved.add("READ");
        os400Reserved.add("READS");
        os400Reserved.add("RECOVERY");
        os400Reserved.add("REFERENCES");
        os400Reserved.add("RELEASE");
        os400Reserved.add("RENAME");
        os400Reserved.add("REPEAT");
        os400Reserved.add("RESET");
        os400Reserved.add("RESULT");
        os400Reserved.add("RETURN");
        os400Reserved.add("RETURNS");
        os400Reserved.add("REVOKE");
        os400Reserved.add("ROLLBACK");
        os400Reserved.add("ROUTINE");
        os400Reserved.add("ROW");
        os400Reserved.add("ROWS");
        os400Reserved.add("RRN");
        os400Reserved.add("RUN");
        os400Reserved.add("SCHEMA");
        os400Reserved.add("SCRATCHPAD");
        os400Reserved.add("SECOND");
        os400Reserved.add("SECONDS");
        os400Reserved.add("SELECT");
        os400Reserved.add("SET");
        os400Reserved.add("SIMPLE");
        os400Reserved.add("SOME");
        os400Reserved.add("SOURCE");
        os400Reserved.add("SPECIFIC");
        os400Reserved.add("SQL");
        os400Reserved.add("STATIC");
        os400Reserved.add("SUBSTRING");
        os400Reserved.add("SYNONYM");
        os400Reserved.add("TABLE");
        os400Reserved.add("THEN");
        os400Reserved.add("TO");
        os400Reserved.add("TRANSACTION");
        os400Reserved.add("TRIM");
        os400Reserved.add("TYPE");
        os400Reserved.add("UNDO");
        os400Reserved.add("UNION");
        os400Reserved.add("UNIQUE");
        os400Reserved.add("UNTIL");
        os400Reserved.add("UPDATE");
        os400Reserved.add("USAGE");
        os400Reserved.add("USER");
        os400Reserved.add("USING");
        os400Reserved.add("VALUES");
        os400Reserved.add("VARIABLE");
        os400Reserved.add("VARIANT");
        os400Reserved.add("VIEW");
        os400Reserved.add("WHEN");
        os400Reserved.add("WHERE");
        os400Reserved.add("WHILE");
        os400Reserved.add("WITH");
        os400Reserved.add("WRITE");
        os400Reserved.add("YEAR");
        os400Reserved.add("YEARS");
    }
}

