/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.support;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Stack;

public class ReuseStringBuffer {
    private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected static Stack buffers;
    protected char[] value;
    protected int count;
    protected float expansionFactor;

    public static ReuseStringBuffer getBuffer() {
        return ReuseStringBuffer.getBuffer(128);
    }

    public static ReuseStringBuffer getBuffer(String string) {
        ReuseStringBuffer reuseStringBuffer = ReuseStringBuffer.getBuffer(string.length() + 128);
        reuseStringBuffer.append(string);
        return reuseStringBuffer;
    }

    public static ReuseStringBuffer getBuffer(int n2) {
        if (buffers == null) {
            buffers = new Stack();
        }
        if (!buffers.empty()) {
            int n3 = buffers.size() - 1;
            while (n3 > -1) {
                ReuseStringBuffer reuseStringBuffer = (ReuseStringBuffer)buffers.elementAt(n3);
                if (reuseStringBuffer.capacity() >= n2) {
                    buffers.removeElementAt(n3);
                    return reuseStringBuffer;
                }
                --n3;
            }
        }
        return new ReuseStringBuffer(n2, 1.5f);
    }

    public static String toString(ReuseStringBuffer reuseStringBuffer) {
        if (buffers == null) {
            buffers = new Stack();
        }
        String string = reuseStringBuffer.toString();
        reuseStringBuffer.setLength(0);
        buffers.push(reuseStringBuffer);
        return string;
    }

    public static void freeBuffer(ReuseStringBuffer reuseStringBuffer) {
        if (buffers == null) {
            buffers = new Stack();
        }
        reuseStringBuffer.setLength(0);
        buffers.push(reuseStringBuffer);
    }

    public ReuseStringBuffer() {
        this(128, 1.5f);
    }

    public ReuseStringBuffer(int n2) {
        this(n2, 1.5f);
    }

    public ReuseStringBuffer(String string) {
        this(string.length() + 128, 1.5f);
        this.append(string);
    }

    public ReuseStringBuffer(float f2) {
        this(128, f2);
    }

    public ReuseStringBuffer(int n2, float f2) {
        this.value = new char[n2];
        this.expansionFactor = f2;
    }

    public ReuseStringBuffer(String string, float f2) {
        this(string.length() + 128, f2);
        this.append(string);
    }

    public int length() {
        return this.count;
    }

    public int capacity() {
        return this.value.length;
    }

    public synchronized void ensureCapacity(int n2) {
        if (n2 > this.value.length) {
            this.expandCapacity(n2);
        }
    }

    protected void expandCapacity(int n2) {
        int n3 = (int)((float)this.value.length * this.expansionFactor);
        if (n3 < 0) {
            n3 = Integer.MAX_VALUE;
        } else if (n2 > n3) {
            n3 = n2;
        }
        char[] cArray = new char[n3];
        System.arraycopy(this.value, 0, cArray, 0, this.count);
        this.value = cArray;
    }

    public synchronized void setLength(int n2) {
        if (n2 < 0) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n2 > this.value.length) {
            this.expandCapacity(n2);
        }
        this.count = n2;
    }

    public synchronized char charAt(int n2) {
        if (n2 < 0 || n2 >= this.count) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        return this.value[n2];
    }

    public synchronized void getChars(int n2, int n3, char[] cArray, int n4) {
        if (n2 < 0) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n3 < 0 || n3 > this.count) {
            throw new StringIndexOutOfBoundsException(n3);
        }
        if (n2 > n3) {
            throw new StringIndexOutOfBoundsException("srcBegin > srcEnd");
        }
        System.arraycopy(this.value, n2, cArray, n4, n3 - n2);
    }

    public synchronized void setCharAt(int n2, char c2) {
        if (n2 < 0 || n2 >= this.count) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        this.value[n2] = c2;
    }

    public synchronized ReuseStringBuffer append(Object object) {
        return this.append(String.valueOf(object));
    }

    public synchronized ReuseStringBuffer append(String string) {
        int n2;
        int n3;
        if (string == null) {
            string = String.valueOf(string);
        }
        if ((n3 = this.count + (n2 = string.length())) > this.value.length) {
            this.expandCapacity(n3);
        }
        string.getChars(0, n2, this.value, this.count);
        this.count = n3;
        return this;
    }

    public synchronized ReuseStringBuffer append(char[] cArray) {
        int n2 = cArray.length;
        int n3 = this.count + n2;
        if (n3 > this.value.length) {
            this.expandCapacity(n3);
        }
        System.arraycopy(cArray, 0, this.value, this.count, n2);
        this.count = n3;
        return this;
    }

    public synchronized ReuseStringBuffer append(char[] cArray, int n2, int n3) {
        int n4 = this.count + n3;
        if (n4 > this.value.length) {
            this.expandCapacity(n4);
        }
        System.arraycopy(cArray, n2, this.value, this.count, n3);
        this.count = n4;
        return this;
    }

    public ReuseStringBuffer append(boolean bl) {
        return this.append(String.valueOf(bl));
    }

    public synchronized ReuseStringBuffer append(char c2) {
        int n2 = this.count + 1;
        if (n2 > this.value.length) {
            this.expandCapacity(n2);
        }
        this.value[this.count++] = c2;
        return this;
    }

    public ReuseStringBuffer append(int n2) {
        return this.append(String.valueOf(n2));
    }

    public ReuseStringBuffer append(long l2) {
        return this.append(String.valueOf(l2));
    }

    public ReuseStringBuffer append(float f2) {
        return this.append(String.valueOf(f2));
    }

    public ReuseStringBuffer append(double d2) {
        return this.append(String.valueOf(d2));
    }

    public synchronized ReuseStringBuffer delete(int n2, int n3) {
        if (n2 < 0) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n3 > this.count) {
            n3 = this.count;
        }
        if (n2 > n3) {
            throw new StringIndexOutOfBoundsException();
        }
        int n4 = n3 - n2;
        if (n4 > 0) {
            System.arraycopy(this.value, n2 + n4, this.value, n2, this.count - n3);
            this.count -= n4;
        }
        return this;
    }

    public synchronized ReuseStringBuffer deleteCharAt(int n2) {
        if (n2 < 0 || n2 >= this.count) {
            throw new StringIndexOutOfBoundsException();
        }
        System.arraycopy(this.value, n2 + 1, this.value, n2, this.count - n2 - 1);
        --this.count;
        return this;
    }

    public synchronized ReuseStringBuffer replace(int n2, int n3, String string) {
        if (n2 < 0) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n3 > this.count) {
            n3 = this.count;
        }
        if (n2 > n3) {
            throw new StringIndexOutOfBoundsException();
        }
        int n4 = string.length();
        int n5 = this.count + n4 - (n3 - n2);
        if (n5 > this.value.length) {
            this.expandCapacity(n5);
        }
        System.arraycopy(this.value, n3, this.value, n2 + n4, this.count - n3);
        string.getChars(0, n4, this.value, n2);
        this.count = n5;
        return this;
    }

    public String substring(int n2) {
        return this.substring(n2, this.count);
    }

    public synchronized String substring(int n2, int n3) {
        if (n2 < 0) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n3 > this.count) {
            throw new StringIndexOutOfBoundsException(n3);
        }
        if (n2 > n3) {
            throw new StringIndexOutOfBoundsException(n3 - n2);
        }
        return new String(this.value, n2, n3 - n2);
    }

    public synchronized ReuseStringBuffer insert(int n2, char[] cArray, int n3, int n4) {
        if (n2 < 0 || n2 > this.count) {
            throw new StringIndexOutOfBoundsException();
        }
        if (n3 < 0 || n3 + n4 < 0 || n3 + n4 > cArray.length) {
            throw new StringIndexOutOfBoundsException(n3);
        }
        if (n4 < 0) {
            throw new StringIndexOutOfBoundsException(n4);
        }
        int n5 = this.count + n4;
        if (n5 > this.value.length) {
            this.expandCapacity(n5);
        }
        System.arraycopy(this.value, n2, this.value, n2 + n4, this.count - n2);
        System.arraycopy(cArray, n3, this.value, n2, n4);
        this.count = n5;
        return this;
    }

    public synchronized ReuseStringBuffer insert(int n2, Object object) {
        return this.insert(n2, String.valueOf(object));
    }

    public synchronized ReuseStringBuffer insert(int n2, String string) {
        int n3;
        int n4;
        if (n2 < 0 || n2 > this.count) {
            throw new StringIndexOutOfBoundsException();
        }
        if (string == null) {
            string = String.valueOf(string);
        }
        if ((n4 = this.count + (n3 = string.length())) > this.value.length) {
            this.expandCapacity(n4);
        }
        System.arraycopy(this.value, n2, this.value, n2 + n3, this.count - n2);
        string.getChars(0, n3, this.value, n2);
        this.count = n4;
        return this;
    }

    public synchronized ReuseStringBuffer insert(int n2, char[] cArray) {
        if (n2 < 0 || n2 > this.count) {
            throw new StringIndexOutOfBoundsException();
        }
        int n3 = cArray.length;
        int n4 = this.count + n3;
        if (n4 > this.value.length) {
            this.expandCapacity(n4);
        }
        System.arraycopy(this.value, n2, this.value, n2 + n3, this.count - n2);
        System.arraycopy(cArray, 0, this.value, n2, n3);
        this.count = n4;
        return this;
    }

    public ReuseStringBuffer insert(int n2, boolean bl) {
        return this.insert(n2, String.valueOf(bl));
    }

    public synchronized ReuseStringBuffer insert(int n2, char c2) {
        int n3 = this.count + 1;
        if (n3 > this.value.length) {
            this.expandCapacity(n3);
        }
        System.arraycopy(this.value, n2, this.value, n2 + 1, this.count - n2);
        this.value[n2] = c2;
        this.count = n3;
        return this;
    }

    public ReuseStringBuffer insert(int n2, int n3) {
        return this.insert(n2, String.valueOf(n3));
    }

    public ReuseStringBuffer insert(int n2, long l2) {
        return this.insert(n2, String.valueOf(l2));
    }

    public ReuseStringBuffer insert(int n2, float f2) {
        return this.insert(n2, String.valueOf(f2));
    }

    public ReuseStringBuffer insert(int n2, double d2) {
        return this.insert(n2, String.valueOf(d2));
    }

    public synchronized ReuseStringBuffer reverse() {
        int n2 = this.count - 1;
        int n3 = n2 - 1 >> 1;
        while (n3 >= 0) {
            char c2 = this.value[n3];
            this.value[n3] = this.value[n2 - n3];
            this.value[n2 - n3] = c2;
            --n3;
        }
        return this;
    }

    public String toString() {
        return new String(this.value, 0, this.count);
    }

    protected synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.value = (char[])this.value.clone();
    }
}

