/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.support;

import com.ibm.db2.tools.common.support.Popup;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;

public class PanelPopup
extends Panel
implements Popup {
    private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected JComponent invoker;
    protected int desiredLocationX;
    protected int desiredLocationY;

    public PanelPopup() {
        super.setLayout(new BorderLayout());
        super.disableEvents(4L);
    }

    public void addComponent(Component component, Object object) {
        super.add(component, object);
    }

    public void removeComponent(Component component) {
        super.remove(component);
    }

    public JComponent getInvoker() {
        return this.invoker;
    }

    public Rectangle getBounds() {
        return super.getBounds();
    }

    public int getHeight() {
        return this.getBounds().height;
    }

    public int getWidth() {
        return this.getBounds().width;
    }

    public void appear(JComponent jComponent) {
        this.invoker = jComponent;
        Container container = jComponent.getParent();
        Window window = null;
        Container container2 = container;
        while (container2 != null) {
            if (container2 instanceof JRootPane) {
                container = ((JRootPane)container2).getLayeredPane();
                container2 = container.getParent();
                while (container2 != null && !(container2 instanceof Window)) {
                    container2 = container2.getParent();
                }
                window = (Window)container2;
                break;
            }
            if (container2 instanceof Window) {
                container = container2;
                window = (Window)container2;
                break;
            }
            container2 = container2.getParent();
        }
        Point point = this.convertScreenLocationToParent(container, this.desiredLocationX, this.desiredLocationY);
        this.setLocation(point.x, point.y);
        if (container instanceof JLayeredPane) {
            ((JLayeredPane)container).add(this, JLayeredPane.POPUP_LAYER, 0);
        } else {
            container.add(this);
        }
    }

    public void appear(JComponent jComponent, Dimension dimension, JComponent jComponent2, int n2, int n3) {
        if (this.getComponentCount() > 0) {
            this.removeAll();
        }
        this.add((Component)jComponent, "Center");
        this.setSize(dimension);
        Point point = new Point(n2, n3);
        SwingUtilities.convertPointFromScreen(point, jComponent2.getRootPane().getLayeredPane());
        this.setBounds(point.x, point.y, this.getSize().width, this.getSize().height);
        jComponent2.getRootPane().getLayeredPane().add(this, JLayeredPane.PALETTE_LAYER, 0);
    }

    public void dispose() {
    }

    public void disappear() {
        if (this.getComponentCount() > 0) {
            this.removeAll();
        }
        Container container = this.getParent();
        Rectangle rectangle = this.getBounds();
        if (container != null) {
            container.remove(this);
            container.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        this.invoker = null;
    }

    public Rectangle getBoundsOnScreen() {
        Container container = this.getParent();
        if (container != null) {
            Rectangle rectangle = this.getBounds();
            Point point = this.convertParentLocationToScreen(container, rectangle.x, rectangle.y);
            rectangle.x = point.x;
            rectangle.y = point.y;
            return rectangle;
        }
        throw new Error("getBoundsOnScreen called on an invisible popup");
    }

    public void pack() {
    }

    public void setLocationOnScreen(int n2, int n3) {
        Container container = this.getParent();
        if (container != null) {
            Point point = this.convertScreenLocationToParent(container, n2, n3);
            this.setLocation(point.x, point.y);
        } else {
            this.desiredLocationX = n2;
            this.desiredLocationY = n3;
        }
    }

    protected Point convertParentLocationToScreen(Container container, int n2, int n3) {
        Component component = null;
        Container container2 = this;
        while (container2 != null) {
            if (container2 instanceof Window) {
                component = (Window)container2;
                break;
            }
            container2 = container2.getParent();
        }
        if (component != null) {
            Rectangle rectangle = component.getBounds();
            Point point = new Point(n2, n3);
            point = SwingUtilities.convertPoint(container, point, null);
            point.x += rectangle.x;
            point.y += rectangle.y;
            return point;
        }
        throw new Error("convertParentLocationToScreen: no window ancestor found");
    }

    protected Point convertScreenLocationToParent(Container container, int n2, int n3) {
        Window window = null;
        Container container2 = container;
        while (container2 != null) {
            if (container2 instanceof Window) {
                window = (Window)container2;
                break;
            }
            container2 = container2.getParent();
        }
        if (window != null) {
            Point point = new Point(n2, n3);
            SwingUtilities.convertPointFromScreen(point, container);
            return point;
        }
        throw new Error("convertScreenLocationToParent: no window ancestor found");
    }
}

