/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.support;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.IllegalComponentStateException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Locale;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleIcon;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.UIManager;

public class MotifCheckBoxIcon
implements Icon,
Serializable,
Accessible {
    private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected boolean isFlat;
    protected boolean isSelected;
    protected int csize;
    protected String description;
    protected static transient Color editColor;
    protected static transient Color control;
    protected static transient Color foreground;
    protected static transient Color shadow;
    protected static transient Color highlight;
    protected static transient Color lightShadow;
    protected AccessibleMotifCheckBoxIcon accessibleContext = null;

    public MotifCheckBoxIcon() {
        this(true, false, 13);
    }

    public MotifCheckBoxIcon(boolean bl) {
        this(bl, false, 13);
    }

    public MotifCheckBoxIcon(boolean bl, int n2) {
        this(bl, false, n2);
    }

    public MotifCheckBoxIcon(boolean bl, boolean bl2, int n2) {
        this.isSelected = bl;
        this.isFlat = bl2;
        this.csize = n2;
        this.description = null;
        if (editColor == null) {
            editColor = Color.white;
            control = UIManager.getColor("control");
            foreground = UIManager.getColor("CheckBox.foreground");
            highlight = UIManager.getColor("controlHighlight");
            lightShadow = UIManager.getColor("controlShadow");
            shadow = lightShadow.darker();
        }
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public void setSelected(boolean bl) {
        this.isSelected = bl;
    }

    public boolean isFlat() {
        return this.isFlat;
    }

    public void setFlat(boolean bl) {
        this.isFlat = bl;
    }

    public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
        boolean bl;
        AbstractButton abstractButton = (AbstractButton)component;
        ButtonModel buttonModel = abstractButton.getModel();
        boolean bl2 = this.isFlat;
        if (abstractButton instanceof JCheckBox) {
            bl2 = ((JCheckBox)abstractButton).isBorderPaintedFlat();
        }
        boolean bl3 = buttonModel.isPressed();
        boolean bl4 = buttonModel.isArmed();
        boolean bl5 = buttonModel.isEnabled();
        boolean bl6 = buttonModel.isSelected();
        boolean bl7 = bl3 && !bl4 && bl6 || bl3 && bl4 && !bl6;
        boolean bl8 = bl3 && !bl4 && !bl6 || bl3 && bl4 && bl6;
        boolean bl9 = bl = !bl3 && bl4 && bl6 || !bl3 && !bl4 && bl6;
        if (bl2) {
            graphics.setColor(shadow);
            graphics.drawRect(n2 + 2, n3, this.csize - 1, this.csize - 1);
            if (bl8 || bl7) {
                if (bl5) {
                    graphics.setColor(editColor);
                } else {
                    graphics.setColor(control);
                }
                graphics.fillRect(n2 + 3, n3 + 1, this.csize - 2, this.csize - 2);
            }
        }
        n2 += component.getComponentOrientation().isLeftToRight() ? 2 : -3;
        if (bl7) {
            this.drawCheckBezel(graphics, n2, n3, this.csize, true, false, false, bl2, bl5);
        } else if (bl8) {
            this.drawCheckBezel(graphics, n2, n3, this.csize, true, true, false, bl2, bl5);
        } else if (bl) {
            this.drawCheckBezel(graphics, n2, n3, this.csize, false, false, true, bl2, bl5);
        } else if (!bl2) {
            this.drawCheckBezelOut(graphics, n2, n3, this.csize, bl5);
        }
    }

    public void drawCheckBezelOut(Graphics graphics, int n2, int n3, int n4, boolean bl) {
        int n5 = n4;
        int n6 = n4;
        Color color = graphics.getColor();
        graphics.translate(n2, n3);
        if (bl) {
            graphics.setColor(editColor);
            graphics.fillRect(1, 1, n4 - 1, n4 - 1);
        }
        graphics.setColor(highlight);
        graphics.drawLine(0, 0, 0, n6 - 1);
        graphics.drawLine(1, 0, n5 - 1, 0);
        graphics.setColor(shadow);
        graphics.drawLine(1, n6 - 1, n5 - 1, n6 - 1);
        graphics.drawLine(n5 - 1, n6 - 1, n5 - 1, 1);
        graphics.translate(-n2, -n3);
        graphics.setColor(color);
    }

    public void drawCheckBezel(Graphics graphics, int n2, int n3, int n4, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        Color color = graphics.getColor();
        graphics.translate(n2, n3);
        if (!bl4) {
            if (bl2) {
                if (bl5) {
                    graphics.setColor(editColor);
                } else {
                    graphics.setColor(control);
                }
                graphics.fillRect(1, 1, n4 - 2, n4 - 2);
                graphics.setColor(shadow);
            } else {
                if (bl5) {
                    graphics.setColor(editColor);
                    graphics.fillRect(1, 1, n4 - 1, n4 - 1);
                } else {
                    graphics.setColor(lightShadow);
                    graphics.fillRect(0, 0, n4, n4);
                }
                graphics.setColor(highlight);
            }
            graphics.drawLine(1, n4 - 1, n4 - 2, n4 - 1);
            if (bl) {
                graphics.drawLine(2, n4 - 2, n4 - 3, n4 - 2);
                graphics.drawLine(n4 - 2, 2, n4 - 2, n4 - 1);
                if (bl2) {
                    graphics.setColor(highlight);
                } else {
                    graphics.setColor(shadow);
                }
                graphics.drawLine(1, 2, 1, n4 - 2);
                graphics.drawLine(1, 1, n4 - 3, 1);
                if (bl2) {
                    graphics.setColor(shadow);
                } else {
                    graphics.setColor(highlight);
                }
            }
            graphics.drawLine(n4 - 1, 1, n4 - 1, n4 - 1);
            if (bl2) {
                graphics.setColor(highlight);
            } else {
                graphics.setColor(shadow);
            }
            graphics.drawLine(0, 1, 0, n4 - 1);
            graphics.drawLine(0, 0, n4 - 1, 0);
        }
        if (bl3) {
            if (bl5) {
                graphics.translate(1, 0);
                graphics.setColor(foreground);
            } else {
                graphics.setColor(shadow);
            }
            graphics.drawLine(n4 - 2, 1, n4 - 2, 2);
            graphics.drawLine(n4 - 3, 2, n4 - 3, 3);
            graphics.drawLine(n4 - 4, 3, n4 - 4, 4);
            graphics.drawLine(n4 - 5, 4, n4 - 5, 6);
            graphics.drawLine(n4 - 6, 5, n4 - 6, 8);
            graphics.drawLine(n4 - 7, 6, n4 - 7, 10);
            graphics.drawLine(n4 - 8, 7, n4 - 8, 10);
            graphics.drawLine(n4 - 9, 6, n4 - 9, 9);
            graphics.drawLine(n4 - 10, 5, n4 - 10, 8);
            graphics.drawLine(n4 - 11, 5, n4 - 11, 7);
            graphics.drawLine(n4 - 12, 6, n4 - 12, 6);
            if (bl5) {
                graphics.translate(-1, 0);
            }
        }
        graphics.translate(-n2, -n3);
        graphics.setColor(color);
    }

    public int getIconWidth() {
        return this.csize;
    }

    public int getIconHeight() {
        return this.csize;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleMotifCheckBoxIcon();
        }
        return this.accessibleContext;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    protected class AccessibleMotifCheckBoxIcon
    extends AccessibleContext
    implements AccessibleIcon,
    Serializable {
        private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

        protected AccessibleMotifCheckBoxIcon() {
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.ICON;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = new AccessibleStateSet();
            if (MotifCheckBoxIcon.this.isSelected) {
                accessibleStateSet.add(AccessibleState.CHECKED);
            }
            return accessibleStateSet;
        }

        public Accessible getAccessibleParent() {
            return null;
        }

        public int getAccessibleIndexInParent() {
            return -1;
        }

        public int getAccessibleChildrenCount() {
            return 0;
        }

        public Accessible getAccessibleChild(int n2) {
            return null;
        }

        public Locale getLocale() throws IllegalComponentStateException {
            return null;
        }

        public String getAccessibleIconDescription() {
            return MotifCheckBoxIcon.this.getDescription();
        }

        public void setAccessibleIconDescription(String string) {
            MotifCheckBoxIcon.this.setDescription(string);
        }

        public int getAccessibleIconHeight() {
            return MotifCheckBoxIcon.this.getIconHeight();
        }

        public int getAccessibleIconWidth() {
            return MotifCheckBoxIcon.this.getIconWidth();
        }

        private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
            objectInputStream.defaultReadObject();
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.defaultWriteObject();
        }
    }
}

