/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.support;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.io.Serializable;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.metal.MetalBorders;

public class MinimalButtonBorder
extends AbstractBorder
implements Serializable,
UIResource {
    private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected static Color shadow;
    protected static Color darkShadow;
    protected static Color highlight;
    protected static Color lightHighlight;
    protected static Color focus;
    protected static MinimalButtonBorder singleton;
    protected static Border metalSingleton;
    protected static String uiname;

    protected MinimalButtonBorder() {
        shadow = UIManager.getColor("controlShadow");
        darkShadow = UIManager.getColor("controlDkShadow");
        highlight = UIManager.getColor("controlHighlight");
        lightHighlight = UIManager.getColor("controlLtHighlight");
        focus = UIManager.getColor("activeCaptionBorder");
    }

    public static Border getInstance() {
        uiname = UIManager.getLookAndFeel().getName();
        if (uiname.equals("Metal")) {
            if (metalSingleton == null) {
                metalSingleton = new MetalBorders.ButtonBorder();
            }
            return metalSingleton;
        }
        if (singleton == null) {
            singleton = new MinimalButtonBorder();
        }
        return singleton;
    }

    public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (component instanceof AbstractButton) {
            AbstractButton abstractButton = (AbstractButton)component;
            ButtonModel buttonModel = abstractButton.getModel();
            bl = buttonModel.isPressed() && buttonModel.isArmed();
            boolean bl4 = bl3 = buttonModel.isArmed() && bl || abstractButton.isFocusPainted() && abstractButton.hasFocus();
            if (component instanceof JButton) {
                bl2 = ((JButton)component).isDefaultButton();
            }
        }
        if (uiname.equals("CDE/Motif")) {
            int n6 = n2 + 1;
            int n7 = n3 + 1;
            int n8 = n2 + n4 - 2;
            int n9 = n3 + n5 - 2;
            if (bl3) {
                graphics.setColor(focus);
                if (bl2) {
                    graphics.drawRect(n2, n3, n4 - 1, n5 - 1);
                } else {
                    graphics.drawRect(n6 - 1, n7 - 1, n8 - n6 + 2, n9 - n7 + 2);
                }
            }
            graphics.setColor(bl ? shadow : highlight);
            graphics.drawLine(n6, n7, n8, n7);
            graphics.drawLine(n6, n7, n6, n9);
            graphics.setColor(bl ? highlight : shadow);
            graphics.drawLine(n8, n7 + 1, n8, n9);
            graphics.drawLine(n6 + 1, n9, n8, n9);
        } else {
            BasicGraphicsUtils.drawBezel(graphics, n2, n3, n4, n5, bl, bl2, shadow, darkShadow, highlight, lightHighlight);
        }
    }

    public Insets getBorderInsets(Component component) {
        return new Insets(0, 3, 0, 3);
    }
}

