/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.support;

import com.ibm.db2.tools.common.support.Popup;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;

public class JPanelPopup
extends JPanel
implements Popup {
    private final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected JComponent invoker;
    protected int desiredLocationX;
    protected int desiredLocationY;

    public JPanelPopup() {
        super.setLayout(new BorderLayout());
        super.setDoubleBuffered(true);
        this.setOpaque(true);
    }

    public void addComponent(Component component, Object object) {
        if (this.getComponentCount() > 0) {
            this.removeAll();
        }
        this.add(component, object);
    }

    public void removeComponent(Component component) {
        super.remove(component);
    }

    public JComponent getInvoker() {
        return this.invoker;
    }

    public void update(Graphics graphics) {
        super.paint(graphics);
    }

    public Rectangle getBounds() {
        return super.getBounds();
    }

    public void dispose() {
    }

    public void appear(JComponent jComponent) {
        this.invoker = jComponent;
        Container container = jComponent.getParent();
        Window window = null;
        Container container2 = container;
        while (container2 != null) {
            if (container2 instanceof JRootPane) {
                container = ((JRootPane)container2).getLayeredPane();
                container2 = container.getParent();
                while (container2 != null && !(container2 instanceof Window)) {
                    container2 = container2.getParent();
                }
                window = (Window)container2;
                break;
            }
            if (container2 instanceof Window) {
                container = container2;
                window = (Window)container2;
                break;
            }
            container2 = container2.getParent();
        }
        Point point = this.convertScreenLocationToParent(container, this.desiredLocationX, this.desiredLocationY);
        super.setLocation(point.x, point.y);
        if (container instanceof JLayeredPane) {
            ((JLayeredPane)container).add(this, JLayeredPane.POPUP_LAYER, 0);
        } else if (container instanceof JFrame) {
            ((JFrame)container).getContentPane().add(this);
        } else {
            container.add(this);
        }
    }

    public void appear(JComponent jComponent, Dimension dimension, JComponent jComponent2, int n2, int n3) {
        this.invoker = jComponent2;
        if (this.getComponentCount() > 0) {
            this.removeAll();
        }
        this.add((Component)jComponent, "Center");
        this.setSize(dimension);
        Container container = null;
        if (jComponent2 != null) {
            container = jComponent2.getParent();
        }
        Window window = null;
        Container container2 = container;
        while (container2 != null) {
            if (container2 instanceof JRootPane) {
                if (!(container2.getParent() instanceof JInternalFrame)) {
                    container = ((JRootPane)container2).getLayeredPane();
                    container2 = container.getParent();
                    while (container2 != null && !(container2 instanceof Window)) {
                        container2 = container2.getParent();
                    }
                    window = (Window)container2;
                    break;
                }
            } else if (container2 instanceof Window) {
                container = container2;
                window = (Window)container2;
                break;
            }
            container2 = container2.getParent();
        }
        if (container instanceof JLayeredPane) {
            ((JLayeredPane)container).add(this, JLayeredPane.POPUP_LAYER, 0);
        } else if (container instanceof JFrame) {
            container = ((JFrame)container).getContentPane();
            container.add(this);
        } else {
            container.add(this);
        }
        Point point = this.convertScreenLocationToParent(container, n2, n3);
        super.setLocation(point.x, point.y);
    }

    public void disappear() {
        if (this.getComponentCount() > 0) {
            this.removeAll();
        }
        Container container = this.getParent();
        Rectangle rectangle = this.getBounds();
        if (container != null) {
            container.remove(this);
            container.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        this.invoker = null;
    }

    public Rectangle getBoundsOnScreen() {
        Container container = this.getParent();
        if (container != null) {
            Rectangle rectangle = this.getBounds();
            Point point = this.convertParentLocationToScreen(container, rectangle.x, rectangle.y);
            rectangle.x = point.x;
            rectangle.y = point.y;
            return rectangle;
        }
        throw new Error("getBoundsOnScreen called on an invisible popup");
    }

    public void pack() {
        super.setSize(this.getPreferredSize());
    }

    public void setLocationOnScreen(int n2, int n3) {
        Container container = this.getParent();
        if (container != null) {
            Point point = this.convertScreenLocationToParent(container, n2, n3);
            super.setLocation(point.x, point.y);
        } else {
            this.desiredLocationX = n2;
            this.desiredLocationY = n3;
        }
    }

    protected Point convertParentLocationToScreen(Container container, int n2, int n3) {
        Component component = null;
        Container container2 = this;
        while (container2 != null) {
            if (container2 instanceof Window) {
                component = (Window)container2;
                break;
            }
            container2 = container2.getParent();
        }
        if (component != null) {
            Rectangle rectangle = component.getBounds();
            Point point = new Point(n2, n3);
            point = SwingUtilities.convertPoint(container, point, null);
            point.x += rectangle.x;
            point.y += rectangle.y;
            return point;
        }
        throw new Error("convertParentLocationToScreen: no window ancestor found");
    }

    protected Point convertScreenLocationToParent(Container container, int n2, int n3) {
        Window window = null;
        Container container2 = container;
        while (container2 != null) {
            if (container2 instanceof Window) {
                window = (Window)container2;
                break;
            }
            container2 = container2.getParent();
        }
        if (window != null) {
            Point point = new Point(n2, n3);
            SwingUtilities.convertPointFromScreen(point, container);
            return point;
        }
        throw new Error("convertScreenLocationToParent: no window ancestor found");
    }

    public boolean isFocusTraversable() {
        return false;
    }
}

