/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.support;

import com.ibm.db2.tools.common.support.HueFilter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.FilteredImageSource;
import java.awt.image.MemoryImageSource;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class ImageUtil
implements Serializable {
    private static final String kCBIBMCopyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected static MediaTracker tracker;
    protected static Component component;
    protected static HueFilter imgf;
    static Class relative;
    static /* synthetic */ Class class$com$ibm$db2$tools$common$support$ImageUtil;

    public static Icon loadIcon(Class clazz, String string) {
        Image image = ImageUtil.loadImageImpl(clazz, string);
        if (image == null) {
            return null;
        }
        return new ImageIcon(image);
    }

    public static Icon loadIcon(String string) {
        return ImageUtil.loadIcon(relative, string);
    }

    public static Image loadImage(String string) {
        return ImageUtil.loadImage(relative, string);
    }

    public static Image loadImage(Class clazz, String string) {
        Image image = ImageUtil.loadImageImpl(clazz, string);
        MediaTracker mediaTracker = tracker;
        synchronized (mediaTracker) {
            tracker.addImage(image, 0);
            try {
                tracker.waitForID(0, 5000L);
            }
            catch (InterruptedException interruptedException) {
                System.out.println("Interrupted while loading Image");
            }
            tracker.removeImage(image, 0);
        }
        return image;
    }

    static Image loadImageImpl(Class clazz, String string) {
        byte[] byArray = null;
        try {
            int n2;
            InputStream inputStream = clazz.getResourceAsStream(string);
            if (inputStream == null) {
                System.err.println("ImageUtil error: " + clazz.getName() + "/" + string + " not found.");
                return null;
            }
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
            byArray = new byte[1024];
            while ((n2 = bufferedInputStream.read(byArray)) > 0) {
                byteArrayOutputStream.write(byArray, 0, n2);
            }
            bufferedInputStream.close();
            byteArrayOutputStream.flush();
            byArray = byteArrayOutputStream.toByteArray();
            if (byArray.length == 0) {
                System.err.println("warning: " + string + " is zero-length");
                return null;
            }
        }
        catch (IOException iOException) {
            System.err.println("ImageUtil error: " + iOException.toString());
            return null;
        }
        return Toolkit.getDefaultToolkit().createImage(byArray);
    }

    public static boolean isFilteringNeeded(Color color) {
        return color.getRed() != 192 || color.getGreen() != 192 || color.getBlue() != 192;
    }

    public static Image filterImage(Image image, Color color) {
        if (imgf == null) {
            imgf = new HueFilter(color);
        } else {
            imgf.setReferenceColor(color);
        }
        FilteredImageSource filteredImageSource = new FilteredImageSource(image.getSource(), imgf);
        Image image2 = Toolkit.getDefaultToolkit().createImage(filteredImageSource);
        tracker.addImage(image2, 0);
        try {
            tracker.waitForID(0, 5000L);
        }
        catch (InterruptedException interruptedException) {
            System.out.println("Interrupted while filtering image");
        }
        tracker.removeImage(image2, 0);
        return image2;
    }

    public static Image createGradientBanner(int n2, int n3, Color color, Color color2) {
        int[] nArray = new int[n2 * n3];
        int n4 = 0;
        Color color3 = color;
        int n5 = color3.getRed() + 1;
        int n6 = color3.getGreen() + 1;
        int n7 = color3.getBlue() + 1;
        int n8 = color2.getRed();
        int n9 = color2.getGreen();
        int n10 = color2.getBlue();
        int n11 = 112;
        int n12 = n8 - n5;
        int n13 = n9 - n6;
        int n14 = n10 - n7;
        int n15 = n11 - n5;
        int n16 = n11 - n6;
        int n17 = n11 - n7;
        double d2 = n2 * n2;
        int n18 = 0;
        while (n18 < n3) {
            int n19 = 0;
            while (n19 < n2) {
                int n20;
                int n21;
                int n22;
                double d3 = n19 * n19;
                double d4 = d3 / d2;
                int n23 = 3;
                if ((n18 + n19) % 2 == 0) {
                    n22 = (int)(d4 * (double)n12) + n5;
                    n21 = (int)(d4 * (double)n13) + n6;
                    n20 = (int)(d4 * (double)n14) + n7;
                } else {
                    n22 = (int)(d4 * (double)n12) + n5;
                    n21 = (int)(d4 * (double)n13) + n6;
                    n20 = (int)(d4 * (double)n14) + n7;
                }
                int n24 = n23 + n23;
                nArray[n4++] = 0xFF000000 | (n22 += (int)((double)n24 * Math.random() - (double)n23)) << 16 | (n21 += (int)((double)n24 * Math.random() - (double)n23)) << 8 | (n20 += (int)((double)n24 * Math.random() - (double)n23));
                ++n19;
            }
            ++n18;
        }
        Image image = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(n2, n3, nArray, 0, n2));
        tracker.addImage(image, 0);
        try {
            tracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        tracker.removeImage(image, 0);
        return image;
    }

    public static void setRelativeClass(Class clazz) {
        relative = clazz;
    }

    public static Class getRelativeClass() {
        return relative;
    }

    public static void tileImage(Graphics graphics, Image image, Rectangle rectangle) {
        ImageUtil.tileImage(graphics, image, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public static void tileImage(Graphics graphics, Image image, int n2, int n3, int n4, int n5) {
        Graphics graphics2 = graphics.create();
        graphics2.setClip(n2, n3, n4, n5);
        graphics2.translate(n2, n3);
        int n6 = image.getWidth(null);
        int n7 = image.getHeight(null);
        int n8 = 0;
        while (n5 - n8 > 0) {
            int n9 = 0;
            while (n4 - n9 > 0) {
                graphics2.drawImage(image, n9, n8, null);
                n9 += n6;
            }
            n8 += n7;
        }
        graphics2.dispose();
    }

    public static void tileLargeArea(Component component, Graphics graphics, Image image, int n2, int n3, int n4, int n5) {
        int n6;
        int n7;
        int n8 = image.getWidth(null);
        int n9 = image.getHeight(null);
        int n10 = n4 / n8;
        int n11 = n5 / n9;
        int n12 = n10 > 1 ? (n10 > 9 ? 3 : 2) : (n7 = 1);
        int n13 = n11 > 1 ? (n11 > 9 ? 3 : 2) : (n6 = 1);
        if (n7 <= 1 && n6 <= 1) {
            ImageUtil.tileImage(graphics, image, n2, n3, n4, n5);
        } else {
            int n14 = n8 * n7;
            int n15 = n9 * n6;
            Image image2 = component.createImage(n14, n15);
            if (image2 == null) {
                return;
            }
            Graphics graphics2 = image2.getGraphics();
            ImageUtil.tileImage(graphics2, image, 0, 0, n14, n15);
            graphics2.dispose();
            ImageUtil.tileImage(graphics, image2, n2, n3, n4, n5);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        component = new Component(){};
        tracker = new MediaTracker(component);
        relative = class$com$ibm$db2$tools$common$support$ImageUtil == null ? (class$com$ibm$db2$tools$common$support$ImageUtil = ImageUtil.class$("com.ibm.db2.tools.common.support.ImageUtil")) : class$com$ibm$db2$tools$common$support$ImageUtil;
    }
}

