/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.support;

import com.ibm.db2.tools.common.support.ResourceProperties;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class GenerateResources {
    private static boolean areKeysSeparate = false;
    private static boolean isCompareFlagOn = false;
    private static boolean isCompareModeOn = false;
    private static boolean ignoreMissingNLV = false;
    protected static final String HEXDIGITS = "0123456789ABCDEFabcdef";
    private static boolean showStringIndicesSupport = false;
    private static final String DOUBLE_QUOTE = "\"";
    private static final char QUOTE = '\'';

    private GenerateResources() {
    }

    public static void main(String[] stringArray) {
        int n2 = stringArray.length;
        int n3 = 0;
        if (n2 > 0) {
            if (stringArray[0].equalsIgnoreCase("-k")) {
                areKeysSeparate = true;
                ++n3;
            } else if (stringArray[0].equalsIgnoreCase("-c")) {
                isCompareFlagOn = true;
                ++n3;
            } else if (stringArray[0].equalsIgnoreCase("-i")) {
                ignoreMissingNLV = true;
                ++n3;
            } else if (stringArray[0].equalsIgnoreCase("-mri")) {
                showStringIndicesSupport = true;
                ++n3;
            } else if (stringArray[0].startsWith("-")) {
                System.err.println("GenerateResources: Invalid flag! The only valid flags are -c, -mri or -i");
                System.exit(1);
            }
        }
        if (n2 < n3 + 1) {
            System.err.println("Usage: java GenerateResources <-mri> <[parent].properties> [child].properties");
            System.err.println("-mri is optional. It enables the support to append the string indices to the strings.");
            System.err.println("[parent].properties is optional. Specify a parent if and only");
            System.err.println("if you want the child to inherit from the parent.");
            System.err.println("-k generates keys in a separate *Keys file.");
            System.err.println("-c reports differences between NLV strings and the English.");
            System.err.println("-i silently replaces the missing NLV strings with the English equivalents.");
            System.exit(1);
        }
        int n4 = n3;
        while (n4 < n2) {
            if (!stringArray[n4].endsWith(".properties")) {
                System.err.println("Properties files must end in .properties!");
                System.exit(1);
            }
            ++n4;
        }
        if (!isCompareFlagOn) {
            if (n2 == n3 + 2) {
                ResourceProperties resourceProperties = new ResourceProperties();
                ResourceProperties resourceProperties2 = GenerateResources.parseProperties(stringArray[n3], true, resourceProperties);
                GenerateResources.generateJavaSrc(stringArray[n3], true, resourceProperties2);
                ResourceProperties resourceProperties3 = GenerateResources.parseProperties(stringArray[n3 + 1], false, resourceProperties2);
                GenerateResources.generateJavaSrc(stringArray[n3 + 1], false, resourceProperties3);
            } else {
                ResourceProperties resourceProperties = new ResourceProperties();
                String string = stringArray[n3];
                ResourceProperties resourceProperties4 = GenerateResources.parseProperties(string, true, resourceProperties);
                String string2 = File.separator;
                int n5 = string.lastIndexOf(string2);
                if (n5 < 0 && (n5 = string.lastIndexOf(string2 = "\\\\")) < 0 && (n5 = string.lastIndexOf(string2 = "//")) < 0 && (n5 = string.lastIndexOf(string2 = "\\")) < 0) {
                    string2 = "/";
                    n5 = string.lastIndexOf(string2);
                }
                if (n5 < 0) {
                    throw new Error("Cannot identify the separator");
                }
                String string3 = string.substring(n5 + 1, string.length());
                int n6 = string.indexOf("_", n5);
                if (n5 < n6) {
                    String string4 = string.substring(n5 + 1, n6);
                    String string5 = string.substring(0, n5);
                    String string6 = stringArray[n3];
                    String string7 = resourceProperties.fullName;
                    String string8 = resourceProperties.className;
                    Vector vector = (Vector)resourceProperties.keys.clone();
                    Vector vector2 = (Vector)resourceProperties.generatedKeys.clone();
                    Vector vector3 = (Vector)resourceProperties.values.clone();
                    Hashtable hashtable = resourceProperties.allkeys;
                    resourceProperties4.keys = new Vector();
                    resourceProperties4.generatedKeys = new Vector();
                    resourceProperties4.values = new Vector();
                    resourceProperties4.allkeys = new Hashtable();
                    StringBuffer stringBuffer = new StringBuffer(string5);
                    if (!string5.endsWith("mri") && !string5.endsWith("mri\\")) {
                        stringBuffer.append(string2).append("mri");
                    }
                    stringBuffer.append(string2).append("en_US").append(string2).append(string4).append(".properties");
                    String string9 = stringBuffer.toString();
                    ResourceProperties resourceProperties5 = GenerateResources.parseProperties(string9, true, resourceProperties4);
                    int n7 = 0;
                    while (n7 < resourceProperties5.keys.size()) {
                        int n8 = vector.indexOf(resourceProperties5.keys.elementAt(n7));
                        if (n8 >= 0) {
                            resourceProperties5.values.setElementAt(vector3.elementAt(n8), n7);
                        } else if (!ignoreMissingNLV) {
                            System.out.println("Warning !!! The key " + resourceProperties5.keys.elementAt(n7) + " has not been defined in the " + stringArray[n3] + " file");
                        }
                        ++n7;
                    }
                    stringArray[n3] = string6;
                    resourceProperties5.fullName = string7;
                    resourceProperties5.className = string8;
                    resourceProperties5.classToInherit = string4;
                    resourceProperties5.isBase = false;
                    GenerateResources.generateJavaSrc(stringArray[n3], false, resourceProperties5);
                } else {
                    GenerateResources.generateJavaSrc(stringArray[n3], true, resourceProperties4);
                }
            }
        } else {
            System.out.print("\n\nComparing keys between ");
            System.out.print(stringArray[1]);
            System.out.print("\nand ");
            System.out.print(stringArray[2]);
            System.out.println(" ...\n");
            ResourceProperties resourceProperties = new ResourceProperties();
            ResourceProperties resourceProperties6 = GenerateResources.parseProperties(stringArray[1], true, resourceProperties);
            isCompareModeOn = true;
            resourceProperties6.resourceName1 = stringArray[1];
            ResourceProperties resourceProperties7 = GenerateResources.parseProperties(stringArray[2], true, resourceProperties6);
            Enumeration enumeration = resourceProperties7.allkeys.keys();
            Enumeration enumeration2 = resourceProperties7.allkeys.elements();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration2.nextElement();
                String string10 = (String)enumeration.nextElement();
                if (!string.equals("Missing")) continue;
                System.out.println("Missing key " + string10);
            }
        }
    }

    private static ResourceProperties parseProperties(String string, boolean bl, ResourceProperties resourceProperties) {
        if (!isCompareFlagOn) {
            System.out.println("Parsing " + string);
        }
        int n2 = string.lastIndexOf(".");
        resourceProperties.fullName = string.substring(0, n2);
        n2 = resourceProperties.fullName.lastIndexOf("/");
        if (n2 == -1) {
            n2 = resourceProperties.fullName.lastIndexOf(File.separator);
        }
        resourceProperties.className = n2 >= 0 ? resourceProperties.fullName.substring(n2 + 1, resourceProperties.fullName.length()) : resourceProperties.fullName;
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
            int n3 = 0;
            int n4 = 0;
            String string2 = null;
            String string3 = null;
            String string4 = null;
            boolean bl2 = false;
            if (!bl) {
                resourceProperties.keys.removeAllElements();
                resourceProperties.values.removeAllElements();
                resourceProperties.isStringFlags.removeAllElements();
                n4 = Integer.parseInt((String)resourceProperties.generatedKeys.lastElement()) + 1;
                resourceProperties.generatedKeys.removeAllElements();
            }
            while ((string2 = bufferedReader.readLine()) != null) {
                ++n3;
                if ((string2 = string2.trim()).startsWith("#")) continue;
                if (string2.startsWith("/")) {
                    if (string2.indexOf("PACKAGE_NAME") >= 0) {
                        n2 = string2.indexOf(61);
                        resourceProperties.PACKAGE_NAME = string2.substring(n2 + 1).trim();
                        if (bl) {
                            resourceProperties.PARENT_PACKAGE_NAME = resourceProperties.PACKAGE_NAME;
                        }
                        if (isCompareFlagOn) continue;
                        System.out.println("Package: " + resourceProperties.PACKAGE_NAME);
                        continue;
                    }
                    if (string2.indexOf("MNEMONIC_SUFFIX") >= 0) {
                        n2 = string2.indexOf(61);
                        resourceProperties.MNEMONIC_SUFFIX = string2.substring(n2 + 1).trim();
                        continue;
                    }
                    if (string2.indexOf("ACCELERATOR_SUFFIX") >= 0) {
                        n2 = string2.indexOf(61);
                        resourceProperties.ACCELERATOR_SUFFIX = string2.substring(n2 + 1).trim();
                        continue;
                    }
                    if (string2.indexOf("IMAGE_BEGIN") >= 0 || string2.indexOf("IMAGES_ONLY") >= 0) {
                        bl2 = true;
                        resourceProperties.doesImagesExist = true;
                        if (string2.indexOf("IMAGES_ONLY") < 0) continue;
                        resourceProperties.isImagesOnly = true;
                        continue;
                    }
                    if (string2.indexOf("IMAGE_END") >= 0) {
                        bl2 = false;
                        continue;
                    }
                    if (string2.indexOf("BASE") >= 0) {
                        resourceProperties.isBase = true;
                        continue;
                    }
                    System.err.println("Invalid escape key sequence found on line " + n3 + "!");
                    System.exit(1);
                    continue;
                }
                n2 = string2.indexOf(61);
                if (n2 >= 0) {
                    int n5;
                    string3 = string2.substring(0, n2).trim();
                    int n6 = string2.indexOf(35);
                    string4 = n6 >= 0 ? string2.substring(n2 + 1, n6).trim() : string2.substring(n2 + 1).trim();
                    if (string4.endsWith("\\")) {
                        resourceProperties.temp.setLength(0);
                        resourceProperties.temp.append(string4);
                        while ((string2 = bufferedReader.readLine()) != null) {
                            resourceProperties.temp.setLength(resourceProperties.temp.length() - 1);
                            n6 = string2.indexOf(35);
                            if (n6 >= 0) {
                                resourceProperties.temp.append(string2.substring(0, n6).trim());
                            } else {
                                resourceProperties.temp.append(string2.trim());
                            }
                            if (!string2.endsWith("\\")) break;
                        }
                        string4 = resourceProperties.temp.toString();
                    }
                    if ((n5 = (string4 = GenerateResources.addEscapeSequences(string4)).indexOf(39)) >= 0 && string4.indexOf(123) >= 0 && string4.indexOf(125) >= 0) {
                        resourceProperties.temp.setLength(0);
                        int n7 = string4.length();
                        int n8 = 0;
                        while (n8 < n7) {
                            char c2 = string4.charAt(n8);
                            resourceProperties.temp.append(c2);
                            if (c2 == '\'') {
                                resourceProperties.temp.append('\'');
                                if (n8 + 1 == n7) break;
                                if (string4.charAt(n8 + 1) == '\'') {
                                    ++n8;
                                }
                            }
                            ++n8;
                        }
                        string4 = resourceProperties.temp.toString();
                    }
                    if (!isCompareModeOn) {
                        if (bl2 && !string3.endsWith(resourceProperties.ACCELERATOR_SUFFIX)) {
                            n2 = string3.lastIndexOf(resourceProperties.MNEMONIC_SUFFIX);
                            if (n2 > -1) {
                                string3 = string3.substring(0, n2);
                            }
                            if ((n2 = resourceProperties.keys.indexOf(string3)) > -1) {
                                resourceProperties.val = resourceProperties.values.elementAt(n2);
                                ((String[])resourceProperties.val)[1] = "\"images/" + string4 + DOUBLE_QUOTE;
                            } else {
                                resourceProperties.isStringFlags.addElement(Boolean.FALSE);
                                resourceProperties.keys.addElement(string3);
                                resourceProperties.values.addElement(new String[]{"\"images/" + string4 + DOUBLE_QUOTE, "", ""});
                            }
                        } else if (string3.endsWith(resourceProperties.MNEMONIC_SUFFIX)) {
                            n2 = string3.lastIndexOf(resourceProperties.MNEMONIC_SUFFIX);
                            if ((n2 = resourceProperties.keys.indexOf(string3 = string3.substring(0, n2))) > -1) {
                                resourceProperties.val = resourceProperties.values.elementAt(n2);
                                ((String[])resourceProperties.val)[1] = string4;
                            } else {
                                resourceProperties.isStringFlags.addElement(Boolean.TRUE);
                                resourceProperties.keys.addElement(string3);
                                resourceProperties.values.addElement(new String[]{"", string4, ""});
                            }
                        } else if (string3.endsWith(resourceProperties.ACCELERATOR_SUFFIX)) {
                            n2 = string3.lastIndexOf(resourceProperties.ACCELERATOR_SUFFIX);
                            if ((n2 = resourceProperties.keys.indexOf(string3 = string3.substring(0, n2))) > -1) {
                                resourceProperties.val = resourceProperties.values.elementAt(n2);
                                ((String[])resourceProperties.val)[2] = string4;
                            } else {
                                resourceProperties.isStringFlags.addElement(Boolean.TRUE);
                                resourceProperties.keys.addElement(string3);
                                resourceProperties.values.addElement(new String[]{"", "", string4});
                            }
                        } else {
                            n2 = resourceProperties.keys.indexOf(string3);
                            if (n2 > -1) {
                                ((String[])resourceProperties.values.elementAt((int)n2))[0] = string4;
                            } else {
                                resourceProperties.isStringFlags.addElement(Boolean.TRUE);
                                resourceProperties.keys.addElement(string3);
                                resourceProperties.values.addElement(new String[]{string4, "", ""});
                            }
                            if (resourceProperties.allkeys.get(string3) != null) {
                                System.err.println("Key: " + string3 + " on line " + n3 + " is a duplicate key!");
                                System.exit(1);
                            }
                        }
                        if (resourceProperties.allkeys.get(String.valueOf(n4)) != null) {
                            System.err.println("Fatal Error: Internal error occurred while processing " + string3 + " on line " + n3);
                            System.exit(1);
                        }
                        if (isCompareFlagOn) {
                            resourceProperties.allkeys.put(string3, "Missing");
                            continue;
                        }
                        resourceProperties.allkeys.put(String.valueOf(n4), "For internal error checking");
                        resourceProperties.allkeys.put(string3, "For user duplicate key error checking");
                        resourceProperties.generatedKeys.addElement(new String(String.valueOf(n4++)));
                        continue;
                    }
                    String string5 = (String)resourceProperties.allkeys.get(string3);
                    if (string5 == null) {
                        System.out.println(resourceProperties.resourceName1 + " : Key " + string3 + " missing!");
                        continue;
                    }
                    resourceProperties.allkeys.put(string3, "Found");
                    continue;
                }
                if (string2.trim().equals("")) continue;
                System.err.println("Syntax error detected on line " + n3 + ": " + string2);
                System.exit(1);
            }
            bufferedReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println(string + " could not be found!");
            System.exit(1);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return resourceProperties;
    }

    protected static boolean isHex(String string) {
        if (string == null) {
            return false;
        }
        int n2 = string.length();
        if (n2 == 0) {
            return false;
        }
        int n3 = 0;
        while (n3 < n2) {
            char c2 = string.charAt(n3);
            if (HEXDIGITS.indexOf(c2) == -1) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    public static String addEscapeSequences(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n2 = 0;
        while (n2 < string.length()) {
            char c2 = string.charAt(n2);
            switch (c2) {
                case '\n': {
                    stringBuffer.append("\\n");
                    break;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    break;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    break;
                }
                case '\"': {
                    stringBuffer.append("\\").append(c2);
                    break;
                }
                case '\\': {
                    char c3 = string.charAt(n2 + 1);
                    if (c3 == 'n' || c3 == 't' || c3 == 'r') {
                        stringBuffer.append(c2);
                        break;
                    }
                    if (c3 == 'u' && GenerateResources.isHex(string.substring(n2 + 2, n2 + 6))) {
                        stringBuffer.append(c2);
                        break;
                    }
                    stringBuffer.append("\\").append(c2);
                    break;
                }
                default: {
                    stringBuffer.append(c2);
                }
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    private static void generateJavaSrc(String string, boolean bl, ResourceProperties resourceProperties) {
        PrintWriter printWriter;
        String string2 = null;
        String string3 = resourceProperties.fullName + ".java";
        String string4 = null;
        if (areKeysSeparate) {
            string4 = resourceProperties.fullName + "Keys.java";
        }
        int n2 = resourceProperties.keys.size();
        int n3 = 0;
        System.out.println("Generating " + string3);
        try {
            printWriter = new PrintWriter(new FileOutputStream(string3));
            printWriter.print("/**********************************************************************");
            printWriter.print("\n* IBM CONFIDENTIAL");
            printWriter.print("\n* OCO SOURCE MATERIALS");
            printWriter.print("\n*");
            printWriter.print("\n* COPYRIGHT:  P#2 P#1");
            printWriter.print("\n*   (C) COPYRIGHT IBM CORPORATION 2000, 2003");
            printWriter.print("\n*");
            printWriter.print("\n* The source code for this program is not published or otherwise divested of");
            printWriter.print("\n* its trade secrets, irrespective of what has been deposited with the U.S.");
            printWriter.print("\n* Copyright Office.");
            printWriter.print("\n*");
            printWriter.print("\n* Source File Name = (%W%)");
            printWriter.print("\n* Last Changed = %E% %U%");
            printWriter.print("\n*");
            printWriter.print("\n* Descriptive Name = " + resourceProperties.className + ".java");
            printWriter.print("\n*");
            printWriter.print("\n* Function:  Provides access to resources.");
            printWriter.print("\n*");
            printWriter.print("\n* Dependencies:  See imports.");
            printWriter.print("\n*");
            printWriter.print("\n* Restrictions: This file is generated using GenerateResources from a ");
            printWriter.print("\n* corresponding properties file. Do not edit or translate this file.");
            printWriter.print("\n*");
            printWriter.print("\n**********************************************************************/\n");
            if (resourceProperties.PACKAGE_NAME != null) {
                printWriter.print("package " + resourceProperties.PACKAGE_NAME + ";\n");
            }
            if (resourceProperties.isBase) {
                printWriter.print("\nimport java.awt.event.KeyEvent;");
            }
            if (resourceProperties.isBase) {
                printWriter.print("\nimport java.util.ResourceBundle;");
                printWriter.print("\nimport com.ibm.db2.tools.common.support.ArrayResourceBundle;");
            }
            printWriter.print("\nimport com.ibm.db2.tools.common.support.AssistConstants;");
            if (resourceProperties.isBase) {
                printWriter.print("\nimport com.ibm.db2.tools.common.support.AssistManager;");
            }
            if (!bl) {
                printWriter.print("\nimport " + resourceProperties.PARENT_PACKAGE_NAME + "." + resourceProperties.classToInherit + ";");
            }
            if (resourceProperties.isBase && !resourceProperties.isImagesOnly) {
                printWriter.print("\nimport java.text.MessageFormat;");
                printWriter.print("\nimport java.util.Locale;");
            }
            if (resourceProperties.doesImagesExist) {
                printWriter.print("\nimport javax.swing.ImageIcon;");
                printWriter.print("\nimport java.awt.Image;");
                printWriter.print("\nimport java.util.WeakHashMap;");
                printWriter.print("\nimport com.ibm.db2.tools.common.support.ImageUtil;");
            }
            printWriter.print("\n\n/**");
            printWriter.print("\n* @author  Automatically generated by GenerateResources.");
            printWriter.print("\n* Edit or translate the corresponding properties file, not this file.");
            printWriter.print("\n* @version  %I%, %G%");
            printWriter.print("\n*/");
            printWriter.print("\npublic class " + resourceProperties.className + " extends " + resourceProperties.classToInherit);
            printWriter.print("\n{");
            printWriter.print("\n  private static final java.lang.String copyright = AssistConstants.copyright;\n");
            if (showStringIndicesSupport) {
                printWriter.print("\n  static { showStringIndicesSupport = true; };");
            }
            if (!areKeysSeparate) {
                if (resourceProperties.isBase) {
                    printWriter.print("\n  /*");
                    printWriter.print("\n  * Use the following static constants as keys for the resources.");
                    printWriter.print("\n  */");
                }
                n3 = 0;
                while (n3 < n2) {
                    if (!bl && n3 == 0) {
                        string2 = (String)resourceProperties.generatedKeys.elementAt(n3);
                    }
                    if (resourceProperties.isBase) {
                        printWriter.print("\n  public static final int " + resourceProperties.keys.elementAt(n3) + " = " + resourceProperties.generatedKeys.elementAt(n3) + ";");
                    }
                    ++n3;
                }
                if (resourceProperties.isBase) {
                    printWriter.print("\n");
                    printWriter.print("\n  public static final int COUNT = " + n2 + ";");
                    printWriter.print("\n");
                }
            }
            if (resourceProperties.isBase) {
                printWriter.print("\n");
                printWriter.print("\n  public static ArrayResourceBundle bundle = null;");
                printWriter.print("\n");
            }
            if (string2 != null) {
                printWriter.print("  private static final int baseOffset = " + string2 + ";\n");
            }
            if (resourceProperties.isBase) {
                if (resourceProperties.isImagesOnly) {
                    printWriter.print("\n  protected static Object[][] contents = null;\n");
                } else if (!resourceProperties.doesImagesExist) {
                    printWriter.print("\n  protected static String[][] contents = null;\n");
                } else {
                    printWriter.print("\n  protected static Object[][] contents = null;\n");
                }
                if (resourceProperties.doesImagesExist) {
                    printWriter.print("  protected static WeakHashMap imageMap = null;\n");
                }
            }
            if (resourceProperties.isBase) {
                if (!resourceProperties.isImagesOnly) {
                    printWriter.print("\n  private static Locale locale = null;");
                    printWriter.print("\n  protected static void init()");
                    printWriter.print("\n  {");
                    printWriter.print("\n    if (contents == null)");
                    printWriter.print("\n      setLanguage(AssistManager.getPreferredLanguage());");
                    printWriter.print("\n  }");
                    printWriter.print("\n  public static void setLanguage(String lang)");
                    printWriter.print("\n  {");
                    printWriter.print("\n    AssistManager.setLanguagePolicy(lang);");
                    printWriter.print("\n    setLanguage(AssistManager.getPreferredLanguage());");
                    printWriter.print("\n  }");
                    printWriter.print("\n  public static void setLanguage(Locale loc)");
                    printWriter.print("\n  {");
                    printWriter.print("\n    if ((AssistManager.getSupportsServerLangsOnly() && !AssistManager.isServerLanguage()) ||");
                    printWriter.print("\n        (!AssistManager.isSkipsCurrentLangInstalledCheck() && !AssistManager.isCurrentLangInstalledLocally()) )");
                    printWriter.print("\n    {");
                    printWriter.print("\n      loc = new Locale(\"en\",\"US\");");
                    printWriter.print("\n    }");
                    printWriter.print("\n    if (locale == null || !locale.equals(loc))");
                    printWriter.print("\n    {");
                    printWriter.print("\n      Locale defaultLocale = Locale.getDefault();");
                    printWriter.print("\n      Locale.setDefault( new Locale( \"en\", \"US\" ) );");
                    printWriter.print("\n      bundle = (ArrayResourceBundle)ResourceBundle.getBundle(" + resourceProperties.className + ".class.getName(), loc);");
                    printWriter.print("\n      Locale.setDefault( defaultLocale );");
                    if (!resourceProperties.doesImagesExist) {
                        printWriter.print("\n      contents = new String[");
                    } else {
                        printWriter.print("\n      contents = new Object[");
                    }
                    if (areKeysSeparate) {
                        printWriter.print(resourceProperties.className);
                        printWriter.print("Keys.");
                    }
                    printWriter.print("COUNT][];");
                    printWriter.print("\n      locale = loc;");
                    printWriter.print("\n    }");
                } else {
                    printWriter.print("\n  protected static void init()");
                    printWriter.print("\n  {");
                    printWriter.print("\n    if (contents == null) {");
                    printWriter.print("\n      contents = new Object[");
                    if (areKeysSeparate) {
                        printWriter.print(resourceProperties.className);
                        printWriter.print("Keys.");
                    }
                    printWriter.print("COUNT][];");
                    printWriter.print("\n      bundle = (ArrayResourceBundle)ResourceBundle.getBundle(" + resourceProperties.className + ".class.getName());");
                    if (resourceProperties.doesImagesExist) {
                        printWriter.print("\n      imageMap = new WeakHashMap(" + n2 + ");");
                    }
                    printWriter.print("\n    }");
                }
                printWriter.print("\n  }");
            }
            n3 = 0;
            int n4 = 0;
            int n5 = 500;
            while (n3 < n2) {
                if (n3 > 0 && n3 % n5 == 0) {
                    printWriter.print("\n        default: return getContents" + n4 + "( index );");
                    printWriter.print("\n      }");
                    printWriter.print("\n    }");
                    printWriter.print("\n    return contents[index];");
                    printWriter.print("\n  }\n");
                }
                if (n3 == 0 || n3 % n5 == 0) {
                    if (n4 == 0) {
                        printWriter.print("\n  public Object[] getContents( int index )\n  {");
                    } else {
                        printWriter.print("\n  private Object[] getContents" + n4 + "( int index )\n  {");
                    }
                    printWriter.print("\n    if( null == contents[index] ) {");
                    printWriter.print("\n      switch(index) { ");
                    ++n4;
                }
                printWriter.print("\n        case " + n3 + ":  contents[index] = new ");
                if (resourceProperties.isImagesOnly) {
                    printWriter.print("Object[] ");
                } else if (!resourceProperties.doesImagesExist) {
                    printWriter.print("String[] ");
                } else {
                    printWriter.print("Object[] ");
                }
                if (((Boolean)resourceProperties.isStringFlags.elementAt(n3)).booleanValue()) {
                    resourceProperties.val = resourceProperties.values.elementAt(n3);
                    if (resourceProperties.val instanceof String) {
                        printWriter.print(DOUBLE_QUOTE + (String)resourceProperties.val + DOUBLE_QUOTE);
                    } else {
                        printWriter.print("{");
                        printWriter.print(DOUBLE_QUOTE + ((String[])resourceProperties.val)[0] + DOUBLE_QUOTE);
                        printWriter.print("," + (((String[])resourceProperties.val)[1].length() > 0 ? DOUBLE_QUOTE + ((String[])resourceProperties.val)[1] + DOUBLE_QUOTE : "null"));
                        printWriter.print("," + (((String[])resourceProperties.val)[2].length() > 0 ? DOUBLE_QUOTE + ((String[])resourceProperties.val)[2] + DOUBLE_QUOTE : "null"));
                        if (showStringIndicesSupport) {
                            printWriter.print(",\"" + (String)resourceProperties.keys.elementAt(n3) + DOUBLE_QUOTE);
                        }
                        printWriter.print("}");
                    }
                } else {
                    resourceProperties.val = resourceProperties.values.elementAt(n3);
                    printWriter.print("{");
                    printWriter.print(((Object[])resourceProperties.val)[0] + ",");
                    printWriter.print((((String[])resourceProperties.val)[1].toString().length() > 0 ? DOUBLE_QUOTE + ((String[])resourceProperties.val)[1] + DOUBLE_QUOTE : "null") + ",");
                    printWriter.print((((String[])resourceProperties.val)[2].toString().length() > 0 ? DOUBLE_QUOTE + ((String[])resourceProperties.val)[2] + DOUBLE_QUOTE : "null") + ",");
                    printWriter.print("}");
                }
                printWriter.print(";");
                printWriter.print("\n                  break;");
                ++n3;
            }
            printWriter.print("\n      }");
            printWriter.print("\n    }");
            printWriter.print("\n    return contents[index];");
            printWriter.print("\n  }\n");
            if (resourceProperties.doesImagesExist) {
                if (bl) {
                    printWriter.print("\n  /**");
                    printWriter.print("\n  * Gets an ImageIcon given its index.");
                    printWriter.print("\n  * @param key    Index of the image.");
                    printWriter.print("\n  * @return An ImageIcon.");
                    printWriter.print("\n  */");
                    printWriter.print("\n  public static ImageIcon getImage(int key)");
                    printWriter.print("\n  {");
                    printWriter.print("\n    init();");
                    printWriter.print("\n    Object value = imageMap.get(bundle.getContents(key)[0]);");
                    printWriter.print("\n    if (value == null) {");
                    printWriter.print("\n      //System.out.println(\"DCImages.getImage(DCImages.\" + (String)(bundle.getContents(key)[0]) + \");\t//  \" + key);");
                    printWriter.print("\n      value = ImageUtil.loadIcon(DCImages.class, (String)(bundle.getContents(key)[0]));");
                    printWriter.print("\n      imageMap.put(bundle.getContents(key)[0], value);");
                    printWriter.print("\n    }");
                    printWriter.print("\n    return (ImageIcon)value;");
                    printWriter.print("\n  }\n");
                    printWriter.print("\n  /**");
                    printWriter.print("\n  * Releases an ImageIcon given its index.");
                    printWriter.print("\n  * @param key    Index of the image.");
                    printWriter.print("\n  */");
                    printWriter.print("\n  public static void releaseImage(int key)");
                    printWriter.print("\n  {");
                    printWriter.print("\n    init();");
                    printWriter.print("\n    imageMap.remove(bundle.getContents(key)[0]);");
                    printWriter.print("\n  }\n");
                } else {
                    printWriter.print("\n  /**");
                    printWriter.print("\n  * Gets an ImageIcon given its index, whether the index");
                    printWriter.print("\n  * is in the parent class or this class.");
                    printWriter.print("\n  * @param key    Index of the image.");
                    printWriter.print("\n  * @return An ImageIcon.");
                    printWriter.print("\n  */");
                    printWriter.print("\n  public static ImageIcon getImage(int key)");
                    printWriter.print("\n  {");
                    printWriter.print("\n    init();");
                    printWriter.print("\n    if(key < baseOffset)");
                    printWriter.print("\n      return super.getImage(key);");
                    printWriter.print("\n    else");
                    printWriter.print("\n      return (ImageIcon)contents[key - baseOffset][0];");
                    printWriter.print("\n  }\n");
                }
                printWriter.print("\n  /**");
                printWriter.print("\n  * Gets an ImageIcon whose Image is scaled to the desired width and height.");
                printWriter.print("\n  * @param key      Index of the image to be scaled.");
                printWriter.print("\n  * @param width    Desired width.");
                printWriter.print("\n  * @param height  Desired height.");
                printWriter.print("\n  * @return An ImageIcon whose Image is scaled to the desired width and height");
                printWriter.print("\n  * and using the Image.SCALE_SMOOTH scaling method.");
                printWriter.print("\n  */");
                printWriter.print("\n  public static ImageIcon getScaledImage(int key, int width, int height)");
                printWriter.print("\n  {");
                printWriter.print("\n    return new ImageIcon(getImage(key).getImage().getScaledInstance(width, height, Image.SCALE_SMOOTH));");
                printWriter.print("\n  }\n");
            }
            if (resourceProperties.isBase && !resourceProperties.isImagesOnly) {
                if (bl) {
                    printWriter.print("\n  /**");
                    printWriter.print("\n  * Gets a resource, given a String key.");
                    printWriter.print("\n  * This key must be parsable as an int.");
                    printWriter.print("\n  * @param key    String format of the index of the resource.");
                    printWriter.print("\n  * @return A resource Object.");
                    printWriter.print("\n  */");
                    printWriter.print("\n  public Object handleGetObject(String key)");
                    printWriter.print("\n  {");
                    printWriter.print("\n    init();");
                    printWriter.print("\n    return contents[Integer.parseInt(key)][0];");
                    printWriter.print("\n  }\n");
                    printWriter.print("\n  /**");
                    printWriter.print("\n  * Gets a String resource, given its index.");
                    printWriter.print("\n  * @param key    The index of the resource.");
                    printWriter.print("\n  * @return A resource String.");
                    printWriter.print("\n  */");
                    printWriter.print("\n  public static String getString(int key)");
                    printWriter.print("\n  {");
                    printWriter.print("\n    init();");
                    printWriter.print("\n    return (String)(bundle.getContents(key)[0])");
                    if (showStringIndicesSupport) {
                        printWriter.print(" + ( getShowStringIndices() ? ( \" [\" + (String)(bundle.getContents(key)[3]) + \"]\" ) : \"\" )");
                    }
                    printWriter.print(";");
                    printWriter.print("\n  }\n");
                    printWriter.print("\n  /**");
                    printWriter.print("\n  * Gets a String resource, given its index,");
                    printWriter.print("\n  * and uses MessageFormat to do argument substitution.");
                    printWriter.print("\n  * @param key    The index of the resource.");
                    printWriter.print("\n  * @param argument Object for substitution.");
                    printWriter.print("\n  * @return A resource String.");
                    printWriter.print("\n  */");
                    printWriter.print("\n  public static String getString(int key, Object argument)");
                    printWriter.print("\n  {");
                    printWriter.print("\n    return get(key, argument);");
                    printWriter.print("\n  }\n");
                    printWriter.print("\n  /**");
                    printWriter.print("\n  * Gets a String resource, given its index,");
                    printWriter.print("\n  * and uses MessageFormat to do argument substitution.");
                    printWriter.print("\n  * @param key    The index of the resource.");
                    printWriter.print("\n  * @param arguments Objects for substitution.");
                    printWriter.print("\n  * @return A resource String.");
                    printWriter.print("\n  */");
                    printWriter.print("\n  public static String getString(int key, Object[] arguments)");
                    printWriter.print("\n  {");
                    printWriter.print("\n    return get(key, arguments);");
                    printWriter.print("\n  }\n");
                    printWriter.print("\n  /**");
                    printWriter.print("\n  * Gets a String resource, given its index.");
                    printWriter.print("\n  * @param key    The index of the resource.");
                    printWriter.print("\n  * @return A resource String.");
                    printWriter.print("\n  */");
                    printWriter.print("\n  public static String get(int key)");
                    printWriter.print("\n  {");
                    printWriter.print("\n    init();");
                    printWriter.print("\n    return (String)(bundle.getContents(key)[0])");
                    if (showStringIndicesSupport) {
                        printWriter.print(" + ( getShowStringIndices() ? ( \" [\" + (String)(bundle.getContents(key)[3]) + \"]\" ) : \"\" )");
                    }
                    printWriter.print(";");
                    printWriter.print("\n  }\n");
                    printWriter.print("\n  /**");
                    printWriter.print("\n  * Gets a String resource, given its index,");
                    printWriter.print("\n  * and uses MessageFormat to do argument substitution.");
                    printWriter.print("\n  * @param key    The index of the resource.");
                    printWriter.print("\n  * @param argument Object for substitution.");
                    printWriter.print("\n  * @return A resource String.");
                    printWriter.print("\n  */");
                    printWriter.print("\n  public static String get(int key, Object argument)");
                    printWriter.print("\n  {");
                    printWriter.print("\n    Object[] arguments = new Object[1];");
                    printWriter.print("\n    arguments[0] = argument;");
                    printWriter.print("\n    return get(key, arguments);");
                    printWriter.print("\n  }\n");
                    printWriter.print("\n  /**");
                    printWriter.print("\n  * Gets a String resource, given its index,");
                    printWriter.print("\n  * and uses MessageFormat to do argument substitution.");
                    printWriter.print("\n  * @param key    The index of the resource.");
                    printWriter.print("\n  * @param arguments Objects for substitution.");
                    printWriter.print("\n  * @return A resource String.");
                    printWriter.print("\n  */");
                    printWriter.print("\n  public static String get(int key, Object[] arguments)");
                    printWriter.print("\n  {");
                    printWriter.print("\n    init();");
                    printWriter.print("\n    String pattern = (String)(bundle.getContents(key)[0]);");
                    printWriter.print("\n    return MessageFormat.format(pattern, arguments)");
                    if (showStringIndicesSupport) {
                        printWriter.print(" + ( getShowStringIndices() ? ( \" [\" + (String)(bundle.getContents(key)[3]) + \"]\" ) : \"\" )");
                    }
                    printWriter.print(";");
                    printWriter.print("\n  }\n");
                    printWriter.print("\n  /**");
                    printWriter.print("\n  * Gets the char mnemonic for a String resource, given its index.");
                    printWriter.print("\n  * @param key    The index of the resource.");
                    printWriter.print("\n  * @return The mnemonic as a char.");
                    printWriter.print("\n  */");
                    printWriter.print("\n  public static char getMnemonic (int key)");
                    printWriter.print("\n  {");
                    printWriter.print("\n    init();");
                    printWriter.print("\n    String val = (String)(bundle.getContents(key)[1]);");
                    printWriter.print("\n    if (val != null && val.length() > 0)");
                    printWriter.print("\n      return toUpperCase(val.charAt(0));");
                    printWriter.print("\n    else");
                    printWriter.print("\n      return '\u0001';");
                    printWriter.print("\n  }\n");
                    printWriter.print("\n  /**");
                    printWriter.print("\n  * Gets the int mnemonic for a String resource, given its index.");
                    printWriter.print("\n  * @param key    The index of the resource.");
                    printWriter.print("\n  * @return The mnemonic as an int.");
                    printWriter.print("\n  */");
                    printWriter.print("\n  public static int getMnemonicCode(int key)");
                    printWriter.print("\n  {");
                    printWriter.print("\n    init();");
                    printWriter.print("\n    String val = (String)(bundle.getContents(key)[1]);");
                    printWriter.print("\n    if (val != null && val.length() > 0)");
                    printWriter.print("\n      return (int)toUpperCase(val.charAt(0));");
                    printWriter.print("\n    else");
                    printWriter.print("\n      return 0;");
                    printWriter.print("\n  }\n");
                } else {
                    printWriter.print("\n  /**");
                    printWriter.print("\n  * Gets a resource, given a String key.");
                    printWriter.print("\n  * This key must be parsable as an int");
                    printWriter.print("\n  * that is an index in the parent class or this class.");
                    printWriter.print("\n  * @param key    String format of the index of the resource.");
                    printWriter.print("\n  * @return A resource Object.");
                    printWriter.print("\n  */");
                    printWriter.print("\n  public static Object handleGetObject(String key)");
                    printWriter.print("\n  {");
                    printWriter.print("\n    init();");
                    printWriter.print("\n    int intKey = Integer.parseInt(key);");
                    printWriter.print("\n    if(intKey < baseOffset)");
                    printWriter.print("\n      return super.handleGetObject(key);");
                    printWriter.print("\n    else");
                    printWriter.print("\n      return contents[intKey - baseOffset][0];");
                    printWriter.print("\n  }\n");
                    printWriter.print("\n  /**");
                    printWriter.print("\n  * Gets a String resource, given an index");
                    printWriter.print("\n  * in the parent class or this class.");
                    printWriter.print("\n  * @param key    The index of the resource.");
                    printWriter.print("\n  * @return A resource String.");
                    printWriter.print("\n  */");
                    printWriter.print("\n  public static String getString(int key)");
                    printWriter.print("\n  {");
                    printWriter.print("\n    return (String)get(key);");
                    printWriter.print("\n  }\n");
                    printWriter.print("\n  /**");
                    printWriter.print("\n  * Gets a String resource, given an index");
                    printWriter.print("\n  * in the parent class or this class,");
                    printWriter.print("\n  * and uses MessageFormat to do argument substitution.");
                    printWriter.print("\n  * @param key    The index of the resource.");
                    printWriter.print("\n  * @param argument Object for substitution.");
                    printWriter.print("\n  * @return A resource String.");
                    printWriter.print("\n  */");
                    printWriter.print("\n  public static String getString(int key, Object argument)");
                    printWriter.print("\n  {");
                    printWriter.print("\n    Object[] arguments = new Object[1];");
                    printWriter.print("\n    arguments[0] = argument;");
                    printWriter.print("\n    return getString(key, arguments);");
                    printWriter.print("\n  }\n");
                    printWriter.print("\n  /**");
                    printWriter.print("\n  * Gets a String resource, given an index");
                    printWriter.print("\n  * in the parent class or this class,");
                    printWriter.print("\n  * and uses MessageFormat to do argument substitution.");
                    printWriter.print("\n  * @param key    The index of the resource.");
                    printWriter.print("\n  * @param arguments Objects for substitution.");
                    printWriter.print("\n  * @return A resource String.");
                    printWriter.print("\n  */");
                    printWriter.print("\n  public static String getString(int key, Object[] arguments)");
                    printWriter.print("\n  {");
                    printWriter.print("\n    init();");
                    printWriter.print("\n    String pattern = null;");
                    printWriter.print("\n    if(key < baseOffset)");
                    printWriter.print("\n      pattern = super.getString(key);");
                    printWriter.print("\n    else");
                    printWriter.print("\n      pattern = (String)contents[key - baseOffset][0]");
                    if (showStringIndicesSupport) {
                        printWriter.print(" + ( getShowStringIndices() ? ( \" [\" + (String)contents[key - baseOffset][3] + \"]\" ) : \"\" )");
                    }
                    printWriter.print(";");
                    printWriter.print("\n    return MessageFormat.format(pattern, arguments)");
                    if (showStringIndicesSupport) {
                        printWriter.print(" + ( getShowStringIndices() ? ( \" [\" + (String)(bundle.getContents(key)[3]) + \"]\" ) : \"\" )");
                    }
                    printWriter.print(" + ( getShowStringIndices() ? (String)(bundle.getContents(key)[3]) : null )");
                    printWriter.print(";");
                    printWriter.print("\n  }\n");
                    printWriter.print("\n  /**");
                    printWriter.print("\n  * Gets a String resource, given an index");
                    printWriter.print("\n  * in the parent class or this class.");
                    printWriter.print("\n  * @param key    The index of the resource.");
                    printWriter.print("\n  * @return A resource String.");
                    printWriter.print("\n  */");
                    printWriter.print("\n  public static String get(int key)");
                    printWriter.print("\n  {");
                    printWriter.print("\n    init();");
                    printWriter.print("\n    if(key < baseOffset)");
                    printWriter.print("\n      return super.getString(key);");
                    printWriter.print("\n    else");
                    printWriter.print("\n      return (String)contents[key - baseOffset][0]");
                    if (showStringIndicesSupport) {
                        printWriter.print(" + ( getShowStringIndices() ? ( \" [\" + (String)contents[key - baseOffset][3] + \"]\" ) : \"\" )");
                    }
                    printWriter.print(";");
                    printWriter.print("\n  }\n");
                    printWriter.print("\n  /**");
                    printWriter.print("\n  * Gets a String resource, given an index");
                    printWriter.print("\n  * in the parent class or this class,");
                    printWriter.print("\n  * and uses MessageFormat to do argument substitution.");
                    printWriter.print("\n  * @param key    The index of the resource.");
                    printWriter.print("\n  * @param argument Object for substitution.");
                    printWriter.print("\n  * @return A resource String.");
                    printWriter.print("\n  */");
                    printWriter.print("\n  public static String get(int key, Object argument)");
                    printWriter.print("\n  {");
                    printWriter.print("\n    Object[] arguments = new Object[1];");
                    printWriter.print("\n    arguments[0] = argument;");
                    printWriter.print("\n    return get(key, arguments);");
                    printWriter.print("\n  }\n");
                    printWriter.print("\n  /**");
                    printWriter.print("\n  * Gets a String resource, given an index");
                    printWriter.print("\n  * in the parent class or this class,");
                    printWriter.print("\n  * and uses MessageFormat to do argument substitution.");
                    printWriter.print("\n  * @param key    The index of the resource.");
                    printWriter.print("\n  * @param arguments Objects for substitution.");
                    printWriter.print("\n  * @return A resource String.");
                    printWriter.print("\n  */");
                    printWriter.print("\n  public static String get(int key, Object[] arguments)");
                    printWriter.print("\n  {");
                    printWriter.print("\n    String pattern = get(key);");
                    printWriter.print("\n    return MessageFormat.format(pattern, arguments);");
                    printWriter.print("\n  }\n");
                    printWriter.print("\n  /**");
                    printWriter.print("\n  * Gets the char mnemonic for a String resource, given an index");
                    printWriter.print("\n  * in the parent class or this class.");
                    printWriter.print("\n  * @param key    The index of the resource.");
                    printWriter.print("\n  * @return The mnemonic as a char.");
                    printWriter.print("\n  */");
                    printWriter.print("\n  public static char getMnemonic (int key)");
                    printWriter.print("\n  {");
                    printWriter.print("\n    init();");
                    printWriter.print("\n    String val = null;");
                    printWriter.print("\n    if(key < baseOffset)");
                    printWriter.print("\n      val = (String)(bundle.getContents(key)[1]);");
                    printWriter.print("\n    else");
                    printWriter.print("\n      val = (String)contents[key - baseOffset][1];");
                    printWriter.print("\n    if (val != null && val.length() > 0)");
                    printWriter.print("\n      return toUpperCase(val.charAt(0));");
                    printWriter.print("\n    else");
                    printWriter.print("\n      return '\u0000';");
                    printWriter.print("\n  }\n");
                    printWriter.print("\n  /**");
                    printWriter.print("\n  * Gets the int mnemonic for a String resource, given an index");
                    printWriter.print("\n  * in the parent class or this class.");
                    printWriter.print("\n  * @param key    The index of the resource.");
                    printWriter.print("\n  * @return The mnemonic as an int.");
                    printWriter.print("\n  */");
                    printWriter.print("\n  public static int getMnemonicCode(int key)");
                    printWriter.print("\n  {");
                    printWriter.print("\n    init();");
                    printWriter.print("\n    String val = null;");
                    printWriter.print("\n    if(key < baseOffset)");
                    printWriter.print("\n      val = (String)(bundle.getContents(key)[1]);");
                    printWriter.print("\n    else");
                    printWriter.print("\n      val = (String)contents[key - baseOffset][1];");
                    printWriter.print("\n    if (val != null && val.length() > 0)");
                    printWriter.print("\n      return (int)toUpperCase(val.charAt(0));");
                    printWriter.print("\n    else");
                    printWriter.print("\n      return 0;");
                    printWriter.print("\n  }\n");
                }
            }
            if (resourceProperties.isBase) {
                if (bl) {
                    printWriter.print("\n  /**");
                    printWriter.print("\n  * Gets the accelerator for a resource, given its index.");
                    printWriter.print("\n  * @param key    The index of the resource.");
                    printWriter.print("\n  * @return The accelerator as an int.");
                    printWriter.print("\n  */");
                    printWriter.print("\n  public static int getAcceleratorCode(int key)");
                    printWriter.print("\n  {");
                    printWriter.print("\n    init();");
                    printWriter.print("\n    String val = (String)(bundle.getContents(key)[2]);");
                    printWriter.print("\n    if (val != null && val.length() > 0)");
                    printWriter.print("\n      return AssistManager.getVirtualKeyCode(val);");
                    printWriter.print("\n    else");
                    printWriter.print("\n      return 0;");
                    printWriter.print("\n  }\n");
                    printWriter.print("\n  /**");
                    printWriter.print("\n  * Gets the accelerator modifier code, given its index.");
                    printWriter.print("\n  * @param key    The index of the resource.");
                    printWriter.print("\n  * @return The accelerator modifier code");
                    printWriter.print("\n  */");
                    printWriter.print("\n  public static int getAcceleratorModifierMask(int key)");
                    printWriter.print("\n  {");
                    printWriter.print("\n    init();");
                    printWriter.print("\n    String val = (String)(bundle.getContents(key)[2]);");
                    printWriter.print("\n    if (val != null && val.length() > 0)");
                    printWriter.print("\n      return AssistManager.getAcceleratorModifierMask(val);");
                    printWriter.print("\n    else");
                    printWriter.print("\n      return 0;");
                    printWriter.print("\n  }\n");
                    printWriter.print("\n  /**");
                    printWriter.print("\n  * Gets the accelerator modifier code, given an index");
                    printWriter.print("\n  * in the parent class or this class.");
                    printWriter.print("\n  * @param key    The index of the resource.");
                    printWriter.print("\n  * @return The accelerator modifier code");
                    printWriter.print("\n  * @deprecated use getAcceleratorModifierMask");
                    printWriter.print("\n  */");
                    printWriter.print("\n  public static int getAcceleratorModifierCode(int key)");
                    printWriter.print("\n  {");
                    printWriter.print("\n    return getAcceleratorModifierMask(key);");
                    printWriter.print("\n  }\n");
                } else {
                    printWriter.print("\n  /**");
                    printWriter.print("\n  * Gets the accelerator for a resource, given an index");
                    printWriter.print("\n  * in the parent class or this class.");
                    printWriter.print("\n  * @param key    The index of the resource.");
                    printWriter.print("\n  * @return The accelerator as an int.");
                    printWriter.print("\n  */");
                    printWriter.print("\n  public static int getAcceleratorCode(int key)");
                    printWriter.print("\n  {");
                    printWriter.print("\n    init();");
                    printWriter.print("\n    String val = ''");
                    printWriter.print("\n    if(key < baseOffset)");
                    printWriter.print("\n      val = (String)(bundle.getContents(key)[2]));");
                    printWriter.print("\n    else");
                    printWriter.print("\n      val = (String)contents[key - baseOffset][2]);");
                    printWriter.print("\n    return AssistManager.getVirtualKeyCode(val);");
                    printWriter.print("\n  }\n");
                    printWriter.print("\n  /**");
                    printWriter.print("\n  * Gets the accelerator modifier code, given an index");
                    printWriter.print("\n  * in the parent class or this class.");
                    printWriter.print("\n  * @param key    The index of the resource.");
                    printWriter.print("\n  * @return The accelerator modifier code");
                    printWriter.print("\n  */");
                    printWriter.print("\n  public static int getAcceleratorModifierMask(int key)");
                    printWriter.print("\n  {");
                    printWriter.print("\n    init();");
                    printWriter.print("\n    String val = ''");
                    printWriter.print("\n    if(key < baseOffset)");
                    printWriter.print("\n      val = (String)(bundle.getContents(key)[2]));");
                    printWriter.print("\n    else");
                    printWriter.print("\n      val = (String)contents[key - baseOffset][2]);");
                    printWriter.print("\n    return AssistManager.getAcceleratorModifierMask(val);");
                    printWriter.print("\n  }\n");
                    printWriter.print("\n  /**");
                    printWriter.print("\n  * Gets the accelerator modifier code, given an index");
                    printWriter.print("\n  * in the parent class or this class.");
                    printWriter.print("\n  * @param key    The index of the resource.");
                    printWriter.print("\n  * @return The accelerator modifier code");
                    printWriter.print("\n  * @deprecated use getAcceleratorModifierMask");
                    printWriter.print("\n  */");
                    printWriter.print("\n  public static int getAcceleratorModifierCode(int key)");
                    printWriter.print("\n  {");
                    printWriter.print("\n    return getAcceleratorModifierMask(key);");
                    printWriter.print("\n  }\n");
                }
            }
            printWriter.print("\n}");
            printWriter.flush();
            printWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (areKeysSeparate) {
            System.out.println("Generating " + string4);
            try {
                printWriter = new PrintWriter(new FileOutputStream(string4));
                printWriter.print("/**********************************************************************");
                printWriter.print("\n* IBM CONFIDENTIAL");
                printWriter.print("\n* OCO SOURCE MATERIALS");
                printWriter.print("\n*");
                printWriter.print("\n* COPYRIGHT:  P#2 P#1");
                printWriter.print("\n*   (C) COPYRIGHT IBM CORPORATION 2000, 2003");
                printWriter.print("\n*");
                printWriter.print("\n* The source code for this program is not published or otherwise divested of");
                printWriter.print("\n* its trade secrets, irrespective of what has been deposited with the U.S.");
                printWriter.print("\n* Copyright Office.");
                printWriter.print("\n*");
                printWriter.print("\n* Source File Name = (%W%)");
                printWriter.print("\n* Last Changed = %E% %U%");
                printWriter.print("\n*");
                printWriter.print("\n* Descriptive Name = " + resourceProperties.className + "Keys.java");
                printWriter.print("\n*");
                printWriter.print("\n* Function:  Provides access to resources.");
                printWriter.print("\n*");
                printWriter.print("\n* Dependencies:  See imports.");
                printWriter.print("\n*");
                printWriter.print("\n* Restrictions: This file is generated using GenerateResources from a ");
                printWriter.print("\n* corresponding properties file. Do not edit or translate this file.");
                printWriter.print("\n*");
                printWriter.print("\n**********************************************************************/\n");
                if (resourceProperties.PACKAGE_NAME != null) {
                    printWriter.print("package " + resourceProperties.PACKAGE_NAME + ";\n");
                }
                printWriter.print("\nimport com.ibm.db2.tools.common.support.AssistConstants;");
                printWriter.print("\n\n/**");
                printWriter.print("\n* @author Automatically generated by GenerateResources.");
                printWriter.print("\n* Edit or translate the corresponding properties file, not this file.");
                printWriter.print("\n* @version %I%, %G%");
                printWriter.print("\n*/");
                printWriter.print("\npublic class " + resourceProperties.className + "Keys");
                printWriter.print("\n{");
                printWriter.print("\n  private static final java.lang.String copyright = AssistConstants.copyright;\n");
                if (resourceProperties.isBase) {
                    printWriter.print("\n  /*");
                    printWriter.print("\n  * Use the following static constants as keys for the resources.");
                    printWriter.print("\n  */");
                }
                n3 = 0;
                while (n3 < n2) {
                    if (!bl && n3 == 0) {
                        string2 = (String)resourceProperties.generatedKeys.elementAt(n3);
                    }
                    if (resourceProperties.isBase) {
                        printWriter.print("\n  public static final int " + resourceProperties.keys.elementAt(n3) + " = " + resourceProperties.generatedKeys.elementAt(n3) + ";");
                    }
                    ++n3;
                }
                if (resourceProperties.isBase) {
                    printWriter.print("\n");
                    printWriter.print("\n  public static final int COUNT = " + n2 + ";");
                    printWriter.print("\n");
                }
                printWriter.print("\n}");
                printWriter.flush();
                printWriter.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        resourceProperties.classToInherit = resourceProperties.className;
        resourceProperties.doesImagesExist = false;
        resourceProperties.isBase = false;
    }
}

