/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.support;

import com.ibm.db2.tools.common.CmStringPool;
import com.ibm.db2.tools.common.CommonPanel;
import com.ibm.db2.tools.common.CommonTrace;
import com.ibm.db2.tools.common.support.AssistManager;
import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormatSymbols;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class ExportDELOptionsPanel
extends CommonPanel
implements ActionListener,
PropertyChangeListener {
    private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String TIMESTAMPFORMAT = "TimestampFormat";
    public static final String COLDEL = "ColDel";
    public static final String CHARDEL = "CharDel";
    public static final String DECPT = "DecPt";
    public static final String DECPLUSBLANK = "DecPlusBlank";
    public static final String DATEISO = "DateIso";
    public static final String STRIPLZEROS = "StripLZeros";
    public static final String NODOUBLEDEL = "NoDoubleDel";
    protected JComboBox timestampFormatCB;
    protected JComboBox columnCB;
    protected JComboBox charStringsCB;
    protected JComboBox decPointCB;
    protected JLabel timestampLabel;
    protected JLabel coldelLabel;
    protected JLabel chardelLabel;
    protected JLabel decptLabel;
    protected JCheckBox decPlusBlankCB;
    protected JCheckBox useISODateCB;
    protected JCheckBox noDoubleDelCB;
    protected JCheckBox stripLZerosCB;
    protected final String delColumn = ",";
    protected final String delCharString = "\"";
    protected final String delDecPoint = ".";
    protected JPanel checkBoxPanel;
    protected JPanel comboBoxPanel;
    protected JPanel labelPanel;

    public ExportDELOptionsPanel() {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.support", "ExportDELOptionsPanel", this, "ExportDELOptionsPanel()");
        }
        this.init();
        CommonTrace.exit(commonTrace);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.support", "ExportDELOptionsPanel", this, "actionPerformed(ActionEvent a)", new Object[]{actionEvent});
        }
        if (actionEvent.getSource() == this.timestampFormatCB) {
            this.firePropertyChange(TIMESTAMPFORMAT, null, this.timestampFormatCB.getSelectedItem());
        }
        if (actionEvent.getSource() == this.columnCB) {
            this.firePropertyChange(COLDEL, null, this.columnCB.getSelectedItem());
        }
        if (actionEvent.getSource() == this.charStringsCB) {
            this.firePropertyChange(CHARDEL, null, this.charStringsCB.getSelectedItem());
        }
        if (actionEvent.getSource() == this.decPointCB) {
            this.firePropertyChange(DECPT, null, this.decPointCB.getSelectedItem());
        }
        if (actionEvent.getSource() == this.decPlusBlankCB) {
            this.firePropertyChange(DECPLUSBLANK, !this.decPlusBlankCB.isSelected(), this.decPlusBlankCB.isSelected());
        }
        if (actionEvent.getSource() == this.useISODateCB) {
            this.firePropertyChange(DATEISO, !this.useISODateCB.isSelected(), this.useISODateCB.isSelected());
        }
        if (actionEvent.getSource() == this.noDoubleDelCB) {
            this.firePropertyChange(NODOUBLEDEL, !this.noDoubleDelCB.isSelected(), this.noDoubleDelCB.isSelected());
        }
        if (actionEvent.getSource() == this.stripLZerosCB) {
            this.firePropertyChange(STRIPLZEROS, !this.stripLZerosCB.isSelected(), this.stripLZerosCB.isSelected());
        }
        CommonTrace.exit(commonTrace);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string;
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.support", "ExportDELOptionsPanel", this, "propertyChange(PropertyChangeEvent evt)", new Object[]{propertyChangeEvent});
        }
        if ((string = propertyChangeEvent.getPropertyName()).equals("UAKey")) {
            String string2 = "";
            if (null != this.getClientProperty("UAKey")) {
                string2 = (String)this.getClientProperty("UAKey");
            }
            if (null != this.timestampFormatCB) {
                this.timestampFormatCB.putClientProperty("UAKey", string2 + "_timestampFormatCB");
            }
            if (null != this.columnCB) {
                this.columnCB.putClientProperty("UAKey", string2 + "_columnCB");
            }
            if (null != this.charStringsCB) {
                this.charStringsCB.putClientProperty("UAKey", string2 + "_charStringsCB");
            }
            if (null != this.decPointCB) {
                this.decPointCB.putClientProperty("UAKey", string2 + "_decPointCB");
            }
            if (null != this.decPlusBlankCB) {
                this.decPlusBlankCB.putClientProperty("UAKey", string2 + "_decPlusBlankCB");
            }
            if (null != this.useISODateCB) {
                this.useISODateCB.putClientProperty("UAKey", string2 + "_useISODateCB");
            }
            if (null != this.noDoubleDelCB) {
                this.noDoubleDelCB.putClientProperty("UAKey", string2 + "_noDoubleDelCB");
            }
            if (null != this.stripLZerosCB) {
                this.stripLZerosCB.putClientProperty("UAKey", string2 + "_stripLZerosCB");
            }
        }
        CommonTrace.exit(commonTrace);
    }

    public JComboBox getColumnCB() {
        return this.columnCB;
    }

    public JComboBox getTimestampFormatCB() {
        return this.timestampFormatCB;
    }

    public JLabel getTimestampLabel() {
        return this.timestampLabel;
    }

    public JComboBox getCharStringsCB() {
        return this.charStringsCB;
    }

    public JComboBox getDecPointCB() {
        return this.decPointCB;
    }

    public JCheckBox getDecPlusBlankCB() {
        return this.decPlusBlankCB;
    }

    public JCheckBox getUseISODateCB() {
        return this.useISODateCB;
    }

    public JCheckBox getNoDoubleDelCB() {
        return this.noDoubleDelCB;
    }

    public JCheckBox getStripLZerosCB() {
        return this.stripLZerosCB;
    }

    protected void init() {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.support", "ExportDELOptionsPanel", this, "init()");
        }
        this.setLayout(new BorderLayout(5, 5));
        this.setBorder(new EmptyBorder(8, 8, 8, 8));
        this.add("Center", this.makeCenterPanel(this.getPanel()));
        this.addPropertyChangeListener("UAKey", this);
        CommonTrace.exit(commonTrace);
    }

    private JPanel makeCenterPanel(JPanel jPanel) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.support", "ExportDELOptionsPanel", this, "makeCenterPanel(JPanel p)", new Object[]{jPanel});
        }
        jPanel.setLayout(new BorderLayout(5, 5));
        JPanel jPanel2 = new JPanel();
        this.makeChoicePanel(jPanel2);
        this.checkBoxPanel = this.getPanel();
        this.makeCheckBoxPanel(this.checkBoxPanel);
        jPanel.add("North", this.checkBoxPanel);
        jPanel.add("Center", jPanel2);
        return (JPanel)CommonTrace.exit(commonTrace, jPanel);
    }

    protected void makeChoicePanel(JPanel jPanel) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.support", "ExportDELOptionsPanel", this, "makeChoicePanel(JPanel p)", new Object[]{jPanel});
        }
        JPanel jPanel2 = this.getPanel();
        this.makeComboBoxPanel(jPanel2);
        jPanel.setLayout(new BorderLayout(5, 5));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(5, 5));
        jPanel3.add("West", jPanel2);
        jPanel.add("North", jPanel3);
        CommonTrace.exit(commonTrace);
    }

    protected void makeComboBoxPanel(JPanel jPanel) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.support", "ExportDELOptionsPanel", this, "makeComboBoxPanel(JPanel p)", new Object[]{jPanel});
        }
        jPanel.setLayout(new BorderLayout(5, 5));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(5, 5));
        this.labelPanel = new JPanel();
        this.labelPanel.setLayout(new GridLayout(4, 1, 5, 5));
        this.timestampLabel = new JLabel();
        this.labelPanel.add(this.timestampLabel);
        this.coldelLabel = new JLabel();
        this.labelPanel.add(this.coldelLabel);
        this.chardelLabel = new JLabel();
        this.labelPanel.add(this.chardelLabel);
        this.decptLabel = new JLabel();
        this.labelPanel.add(this.decptLabel);
        this.initComboBoxLabels();
        this.comboBoxPanel = new JPanel();
        this.comboBoxPanel.setLayout(new GridLayout(4, 1, 5, 5));
        Vector<String> vector = new Vector<String>();
        vector.addElement(" ");
        vector.addElement(CmStringPool.get(157));
        vector.addElement(CmStringPool.get(158));
        vector.addElement(CmStringPool.get(159));
        vector.addElement(CmStringPool.get(160));
        vector.addElement(CmStringPool.get(161));
        this.timestampFormatCB = new JComboBox(vector);
        this.comboBoxPanel.add(this.timestampFormatCB);
        this.timestampFormatCB.setEditable(true);
        this.columnCB = new JComboBox();
        this.comboBoxPanel.add(this.columnCB);
        this.columnCB.setEditable(true);
        this.charStringsCB = new JComboBox();
        this.comboBoxPanel.add(this.charStringsCB);
        this.charStringsCB.setEditable(true);
        this.decPointCB = new JComboBox();
        this.comboBoxPanel.add(this.decPointCB);
        this.decPointCB.setEditable(true);
        this.timestampLabel.setLabelFor(this.timestampFormatCB);
        this.coldelLabel.setLabelFor(this.columnCB);
        this.chardelLabel.setLabelFor(this.charStringsCB);
        this.decptLabel.setLabelFor(this.decPointCB);
        jPanel2.add("Center", this.labelPanel);
        jPanel2.add("East", this.comboBoxPanel);
        jPanel.add("West", jPanel2);
        this.initChoiceItems(this.columnCB);
        this.initChoiceItems(this.charStringsCB);
        this.initChoiceItems(this.decPointCB);
        this.columnCB.setSelectedItem(",");
        this.charStringsCB.setSelectedItem("\"");
        this.decPointCB.setSelectedItem(".");
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(AssistManager.getPreferredLocale());
        String string = String.valueOf(decimalFormatSymbols.getDecimalSeparator());
        this.decPointCB.setSelectedItem(string);
        if (",".equals(string)) {
            String string2 = String.valueOf(decimalFormatSymbols.getPatternSeparator());
            this.columnCB.setSelectedItem(string2);
        }
        this.columnCB.addActionListener(this);
        this.charStringsCB.addActionListener(this);
        this.decPointCB.addActionListener(this);
        CommonTrace.exit(commonTrace);
    }

    protected void initComboBoxLabels() {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.support", "ExportDELOptionsPanel", this, "initComboBoxLabels()");
        }
        this.timestampLabel.setText(CmStringPool.get(154));
        this.coldelLabel.setText(CmStringPool.get(221));
        this.coldelLabel.setDisplayedMnemonic(CmStringPool.getMnemonic(221));
        this.chardelLabel.setText(CmStringPool.get(222));
        this.chardelLabel.setDisplayedMnemonic(CmStringPool.getMnemonic(222));
        this.decptLabel.setText(CmStringPool.get(223));
        this.decptLabel.setDisplayedMnemonic(CmStringPool.getMnemonic(223));
        CommonTrace.exit(commonTrace);
    }

    protected JComboBox initChoiceItems(JComboBox jComboBox) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.support", "ExportDELOptionsPanel", this, "initChoiceItems(JComboBox cb)", new Object[]{jComboBox});
        }
        if (jComboBox.equals(this.charStringsCB)) {
            jComboBox.addItem(CmStringPool.get(156));
        }
        jComboBox.addItem("\"");
        jComboBox.addItem("%");
        jComboBox.addItem("&");
        jComboBox.addItem("'");
        jComboBox.addItem("(");
        jComboBox.addItem(")");
        jComboBox.addItem("*");
        jComboBox.addItem(",");
        jComboBox.addItem(".");
        jComboBox.addItem("/");
        jComboBox.addItem(":");
        jComboBox.addItem(";");
        jComboBox.addItem("<");
        jComboBox.addItem("=");
        jComboBox.addItem(">");
        jComboBox.addItem("?");
        jComboBox.addItem("|");
        jComboBox.addItem("_");
        return (JComboBox)CommonTrace.exit(commonTrace, jComboBox);
    }

    protected void makeCheckBoxPanel(JPanel jPanel) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.support", "ExportDELOptionsPanel", this, "makeCheckBoxPanel(JPanel p)", new Object[]{jPanel});
        }
        jPanel.setLayout(new GridLayout(5, 1, 5, 5));
        jPanel.setBorder(new EmptyBorder(8, 0, 0, 0));
        this.decPlusBlankCB = new JCheckBox();
        jPanel.add(this.decPlusBlankCB);
        this.useISODateCB = new JCheckBox();
        jPanel.add(this.useISODateCB);
        this.noDoubleDelCB = new JCheckBox();
        jPanel.add(this.noDoubleDelCB);
        this.stripLZerosCB = new JCheckBox();
        jPanel.add(this.stripLZerosCB);
        this.initComboBoxNames();
        this.stripLZerosCB.addActionListener(this);
        this.decPlusBlankCB.addActionListener(this);
        this.useISODateCB.addActionListener(this);
        this.noDoubleDelCB.addActionListener(this);
        CommonTrace.exit(commonTrace);
    }

    protected void initComboBoxNames() {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.support", "ExportDELOptionsPanel", this, "initComboBoxNames()");
        }
        this.stripLZerosCB.setText(CmStringPool.get(155));
        this.stripLZerosCB.setMnemonic(CmStringPool.getMnemonic(155));
        this.decPlusBlankCB.setText(CmStringPool.get(224));
        this.decPlusBlankCB.setMnemonic(CmStringPool.getMnemonic(224));
        this.useISODateCB.setText(CmStringPool.get(225));
        this.useISODateCB.setMnemonic(CmStringPool.getMnemonic(225));
        this.noDoubleDelCB.setText(CmStringPool.get(226));
        this.noDoubleDelCB.setMnemonic(CmStringPool.getMnemonic(226));
        CommonTrace.exit(commonTrace);
    }

    public JPanel getCheckBoxPanel() {
        return this.checkBoxPanel;
    }

    public JPanel getComboBoxPanel() {
        return this.comboBoxPanel;
    }

    public JPanel getLabelPanel() {
        return this.labelPanel;
    }
}

