/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.support;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.IllegalComponentStateException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Locale;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleIcon;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleStateSet;
import javax.swing.Icon;
import javax.swing.UIManager;

public class EllipsisIcon
implements Icon,
Serializable,
Accessible {
    private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected int diameter;
    protected String description;
    protected AccessibleEllipsisIcon accessibleContext = null;

    public EllipsisIcon() {
        this(2);
    }

    public EllipsisIcon(int n2) {
        this.diameter = n2;
        this.description = null;
    }

    public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
        if (component.isEnabled()) {
            graphics.setColor(UIManager.getColor("Button.foreground"));
            this.drawDots(graphics, n2, n3);
        } else {
            Color color = component.getBackground();
            graphics.setColor(color.brighter());
            this.drawDots(graphics, n2 + 1, n3 + 1);
            graphics.setColor(color.darker());
            this.drawDots(graphics, n2, n3);
        }
    }

    protected void drawDots(Graphics graphics, int n2, int n3) {
        int n4 = this.diameter + 1;
        int n5 = 3;
        int n6 = this.getIconHeight() / 2 - n4 / 2;
        graphics.translate(n2, n3);
        graphics.fillOval(n5, n6, n4, n4);
        graphics.fillOval(n5 += n4 + 2, n6, n4, n4);
        graphics.fillOval(n5 += n4 + 2, n6, n4, n4);
        graphics.translate(-n2, -n3);
    }

    public int getIconWidth() {
        return (this.diameter + 1) * 3 + 9;
    }

    public int getIconHeight() {
        int n2 = this.diameter + 1;
        return n2 > 10 ? n2 : 10;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleEllipsisIcon();
        }
        return this.accessibleContext;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    protected class AccessibleEllipsisIcon
    extends AccessibleContext
    implements AccessibleIcon,
    Serializable {
        private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

        protected AccessibleEllipsisIcon() {
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.ICON;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            return null;
        }

        public Accessible getAccessibleParent() {
            return null;
        }

        public int getAccessibleIndexInParent() {
            return -1;
        }

        public int getAccessibleChildrenCount() {
            return 0;
        }

        public Accessible getAccessibleChild(int n2) {
            return null;
        }

        public Locale getLocale() throws IllegalComponentStateException {
            return null;
        }

        public String getAccessibleIconDescription() {
            return EllipsisIcon.this.getDescription();
        }

        public void setAccessibleIconDescription(String string) {
            EllipsisIcon.this.setDescription(string);
        }

        public int getAccessibleIconHeight() {
            return EllipsisIcon.this.getIconHeight();
        }

        public int getAccessibleIconWidth() {
            return EllipsisIcon.this.getIconWidth();
        }

        private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
            objectInputStream.defaultReadObject();
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.defaultWriteObject();
        }
    }
}

