/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.support;

import com.ibm.db2.tools.common.DockingPane;
import com.ibm.db2.tools.common.support.AssistManager;
import com.ibm.db2.tools.common.support.DockingTitle;
import com.ibm.db2.tools.common.support.MinimalButtonBorder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.EventListenerList;

public class DockingTitleBar
extends JPanel
implements Serializable {
    public static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final int CLOSE_BUTTON = 1;
    public static final int COLLAPSE_BUTTON = 2;
    public static final int MAXRESTORE_BUTTON = 4;
    public static final int DISABLED = -1;
    public static final int HIDDEN = 0;
    public static final int MAXIMIZE = 1;
    public static final int RESTORE = 2;
    public static final int MINIMIZE = 3;
    public static final String CLOSE_COMMAND = "Close";
    public static final String MAXRESTORE_COMMAND = "Max_restore";
    public static final String MAXIMIZE_COMMAND = "Maximize";
    public static final String RESTORE_COMMAND = "Restore";
    public static final String MINIMIZE_COMMAND = "Minimize";
    protected static final int BUTTON_SIZE = 14;
    protected static Dimension minButtonSize;
    protected CollapseIcon collapseIcon;
    protected DockingTitle title;
    protected boolean activeTitle;
    protected NoFocusButton bCollapse;
    protected NoFocusButton bMaxRestore;
    protected NoFocusButton bClose;
    protected static GridBagConstraints gbtH;
    protected static GridBagConstraints gbtV;
    protected static GridBagConstraints gbcH1;
    protected static GridBagConstraints gbcH2;
    protected static GridBagConstraints gbcV1;
    protected static GridBagConstraints gbcV2;
    protected Object actionSource;
    protected int buttons;

    public DockingTitleBar() {
        this(null, 0, " ", null, 10);
    }

    public DockingTitleBar(Icon icon) {
        this(null, 0, null, icon, 0);
    }

    public DockingTitleBar(Icon icon, int n2) {
        this(null, 0, null, icon, n2);
    }

    public DockingTitleBar(String string) {
        this(null, 0, string, null, 10);
    }

    public DockingTitleBar(String string, int n2) {
        this(null, 0, string, null, n2);
    }

    public DockingTitleBar(String string, Icon icon, int n2) {
        this(null, 0, string, icon, n2);
    }

    public DockingTitleBar(int n2, Icon icon) {
        this(null, n2, null, icon, 0);
    }

    public DockingTitleBar(int n2, Icon icon, int n3) {
        this(null, n2, null, icon, n3);
    }

    public DockingTitleBar(int n2, String string) {
        this(null, n2, string, 10);
    }

    public DockingTitleBar(int n2, String string, int n3) {
        this(null, n2, string, null, n3);
    }

    public DockingTitleBar(int n2, String string, Icon icon, int n3) {
        this(null, n2, string, icon, n3);
    }

    public DockingTitleBar(String string, int n2, Icon icon) {
        this(string, n2, null, icon, 0);
    }

    public DockingTitleBar(String string, int n2, Icon icon, int n3) {
        this(string, n2, null, icon, n3);
    }

    public DockingTitleBar(String string, int n2, String string2) {
        this(string, n2, string2, 10);
    }

    public DockingTitleBar(String string, int n2, String string2, int n3) {
        this(string, n2, string2, null, n3);
    }

    public DockingTitleBar(String string, int n2, String string2, Icon icon, int n3) {
        this(null, 4 + (string == null ? 0 : 1), n2, string2, icon, n3);
        if (string != null) {
            this.setCloseCommand(string);
        }
    }

    public DockingTitleBar(Object object, int n2, int n3, String string, Icon icon, int n4) {
        this.actionSource = object;
        this.buttons = n2;
        this.setLayout(new GridBagLayout());
        if (minButtonSize == null) {
            minButtonSize = new Dimension(14, 14);
        }
        if (gbtV == null) {
            gbtV = new GridBagConstraints();
            gbtH = new GridBagConstraints();
            AssistManager.setGridBagConstraints(gbtH, 0, 0, 1, 1, 2, new Insets(0, 2, 0, 0), -1, 1.0, 0.0);
            AssistManager.setGridBagConstraints(gbtV, 0, 2, 0, 1, 3, new Insets(0, 0, 2, 0), -1, 0.0, 1.0);
            gbcV1 = new GridBagConstraints();
            gbcV2 = new GridBagConstraints();
            gbcH1 = new GridBagConstraints();
            gbcH2 = new GridBagConstraints();
            Insets insets = new Insets(1, 0, 0, 0);
            Insets insets2 = new Insets(0, 1, 0, 0);
            AssistManager.setGridBagConstraints(gbcH1, 1, 0, 1, 1, 0, insets, 10, 0.0, 0.0);
            AssistManager.setGridBagConstraints(gbcH2, 2, 0, 1, 1, 0, insets, 10, 0.0, 0.0);
            AssistManager.setGridBagConstraints(gbcV1, 0, 0, 1, 1, 0, insets2, 10, 0.0, 0.0);
            AssistManager.setGridBagConstraints(gbcV2, 0, 1, 1, 1, 0, insets2, 10, 0.0, 0.0);
        }
        this.title = new DockingTitle(string, icon, n4);
        this.setOpaque(true);
        this.setBackground(this.title.getBackground());
        if ((n2 & 2) > 0) {
            this.collapseIcon = new CollapseIcon(1, n3);
            this.bCollapse = new NoFocusButton((Icon)this.collapseIcon);
            this.bCollapse.setActionCommand(MAXIMIZE_COMMAND);
            this.bCollapse.setPreferredSize(new Dimension(14, 14));
        }
        if ((n2 & 4) > 0) {
            this.bMaxRestore = new NoFocusButton(UIManager.getIcon("DockingTitleBar.maxRestoreIcon"));
            this.bMaxRestore.setActionCommand(MAXRESTORE_COMMAND);
            this.bMaxRestore.setPreferredSize(new Dimension(14, 14));
        }
        if ((n2 & 1) > 0) {
            this.bClose = new NoFocusButton(UIManager.getIcon("DockingTitleBar.closeIcon"));
            this.bClose.setActionCommand(CLOSE_COMMAND);
            this.bClose.setPreferredSize(new Dimension(14, 14));
        }
        if (this.title.getRotation() == 0) {
            this.add((Component)this.title, gbtH);
            if (this.bCollapse != null) {
                this.add((Component)this.bCollapse, gbcH1);
            }
            if (this.bMaxRestore != null) {
                this.add((Component)this.bMaxRestore, gbcH1);
            }
            if (this.bClose != null) {
                this.add((Component)this.bClose, gbcH2);
            }
        } else {
            if (this.bClose != null) {
                this.add((Component)this.bClose, gbcV1);
            }
            if (this.bMaxRestore != null) {
                this.add((Component)this.bMaxRestore, gbcV2);
            }
            if (this.bCollapse != null) {
                this.add((Component)this.bCollapse, gbcV2);
            }
            this.add((Component)this.title, gbtV);
        }
    }

    public void setActionSource(Component component) {
        this.actionSource = component;
    }

    public int getRotation() {
        return this.title.getRotation();
    }

    public void setRotation(int n2) {
        this.title.setRotation(n2);
        GridBagLayout gridBagLayout = (GridBagLayout)this.getLayout();
        if (this.bCollapse != null) {
            this.collapseIcon.setRotation(n2);
        }
        if (n2 == 0) {
            gridBagLayout.setConstraints(this.title, gbtH);
            if (this.bCollapse != null) {
                gridBagLayout.setConstraints(this.bCollapse, gbcH1);
            }
            if (this.bMaxRestore != null) {
                gridBagLayout.setConstraints(this.bMaxRestore, gbcH1);
            }
            if (this.bClose != null) {
                gridBagLayout.setConstraints(this.bClose, gbcH2);
            }
        } else {
            if (this.bClose != null) {
                gridBagLayout.setConstraints(this.bClose, gbcV1);
            }
            if (this.bMaxRestore != null) {
                gridBagLayout.setConstraints(this.bMaxRestore, gbcV2);
            }
            if (this.bCollapse != null) {
                gridBagLayout.setConstraints(this.bCollapse, gbcV2);
            }
            gridBagLayout.setConstraints(this.title, gbtV);
        }
        this.doLayout();
    }

    public Dimension getMinimumSize() {
        Dimension dimension = super.getMinimumSize();
        if (this.getRotation() == 0) {
            dimension.height = 15;
        } else {
            dimension.width = 15;
        }
        return dimension;
    }

    public int getButtonFlags() {
        return this.buttons;
    }

    public EventListenerList getListeners() {
        if (this.bClose == null) {
            return null;
        }
        return this.bClose.getListeners();
    }

    public void setCloseCommand(String string) {
        this.bClose.setActionCommand(string);
    }

    public ActionEvent getCloseActionEvent() {
        return new ActionEvent(this.actionSource == null ? this.bClose : this.actionSource, 1001, this.bClose.getActionCommand(), 0);
    }

    public int getCollapseState() {
        return this.collapseIcon.getState();
    }

    public void setCollapseState(int n2) {
        if (this.collapseIcon == null) {
            return;
        }
        this.collapseIcon.setState(n2);
        this.bCollapse.setEnabled(true);
        switch (n2) {
            case -1: {
                this.bCollapse.setActionCommand(MAXIMIZE_COMMAND);
                this.bCollapse.setVisible(true);
                this.bCollapse.setEnabled(false);
                break;
            }
            case 1: {
                this.bCollapse.setActionCommand(MAXIMIZE_COMMAND);
                this.bCollapse.setVisible(true);
                break;
            }
            case 3: {
                this.bCollapse.setActionCommand(MINIMIZE_COMMAND);
                this.bCollapse.setVisible(true);
                break;
            }
            case 2: {
                this.bCollapse.setActionCommand(RESTORE_COMMAND);
                this.bCollapse.setVisible(true);
                break;
            }
            default: {
                this.bCollapse.setVisible(false);
            }
        }
    }

    public void updateMaxRestoreState() {
        if (this.bMaxRestore == null) {
            return;
        }
        this.bMaxRestore.setEnabled(true);
        this.bMaxRestore.repaint();
    }

    public void addMouseListener(MouseListener mouseListener) {
        this.title.addMouseListener(mouseListener);
    }

    public void removeMouseListener(MouseListener mouseListener) {
        this.title.removeMouseListener(mouseListener);
    }

    public void addMouseMotionListener(MouseMotionListener mouseMotionListener) {
        this.title.addMouseMotionListener(mouseMotionListener);
    }

    public void removeMouseMotionListener(MouseMotionListener mouseMotionListener) {
        this.title.removeMouseMotionListener(mouseMotionListener);
    }

    public void addActionListener(ActionListener actionListener) {
        if (this.bCollapse != null) {
            this.bCollapse.addActionListener(actionListener);
        }
        if (this.bMaxRestore != null) {
            this.bMaxRestore.addActionListener(actionListener);
        }
        if (this.bClose != null) {
            this.bClose.addActionListener(actionListener);
        }
    }

    public void removeActionListener(ActionListener actionListener) {
        if (this.bCollapse != null) {
            this.bCollapse.removeActionListener(actionListener);
        }
        if (this.bMaxRestore != null) {
            this.bMaxRestore.removeActionListener(actionListener);
        }
        if (this.bClose != null) {
            this.bClose.removeActionListener(actionListener);
        }
    }

    public String getText() {
        return this.title.getText();
    }

    public void setText(String string) {
        this.title.setText(string);
    }

    public void setActive(boolean bl) {
        this.title.setActive(bl);
        this.activeTitle = bl;
        this.repaint();
    }

    public boolean isActive() {
        return this.activeTitle;
    }

    private class NoFocusButton
    extends JButton
    implements Serializable {
        public static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

        public NoFocusButton(Icon icon) {
            this.setFocusPainted(false);
            this.setIcon(icon);
            super.setBorder(MinimalButtonBorder.getInstance());
        }

        public boolean isFocusTraversable() {
            return false;
        }

        public void requestFocus() {
        }

        public boolean isOpaque() {
            return true;
        }

        public EventListenerList getListeners() {
            return this.listenerList;
        }

        public Dimension getMinimumSize() {
            return minButtonSize;
        }
    }

    public static class CloseIcon
    implements Icon,
    Serializable {
        private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
        protected static Icon icon;
        protected int size = 14;

        public static Icon getInstance() {
            if (icon == null) {
                icon = new CloseIcon();
            }
            return icon;
        }

        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
            graphics.translate(n2, n3);
            Color color = graphics.getColor();
            graphics.setColor(UIManager.getColor("TextField.foreground"));
            graphics.drawLine(3, 4, this.size - 6, this.size - 5);
            graphics.drawLine(this.size - 6, 4, 3, this.size - 5);
            graphics.drawLine(4, 4, this.size - 5, this.size - 5);
            graphics.drawLine(this.size - 5, 4, 4, this.size - 5);
            graphics.setColor(color);
            graphics.translate(-n2, -n3);
        }

        public int getIconWidth() {
            return this.size;
        }

        public int getIconHeight() {
            return this.size;
        }
    }

    public static class MotifCloseIcon
    implements Icon,
    Serializable {
        private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
        protected static Icon icon;
        protected int size = 14;
        static /* synthetic */ Class class$com$ibm$db2$tools$common$support$DockingTitleBar;

        public static Icon getInstance() {
            if (icon == null) {
                icon = new MotifCloseIcon();
            }
            return icon;
        }

        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
            DockingTitleBar dockingTitleBar = (DockingTitleBar)SwingUtilities.getAncestorOfClass(class$com$ibm$db2$tools$common$support$DockingTitleBar == null ? (class$com$ibm$db2$tools$common$support$DockingTitleBar = MotifCloseIcon.class$("com.ibm.db2.tools.common.support.DockingTitleBar")) : class$com$ibm$db2$tools$common$support$DockingTitleBar, component);
            Color color = UIManager.getColor("InternalFrame.inactiveTitleBackground");
            Color color2 = color.brighter();
            Color color3 = color.darker().darker();
            color = graphics.getColor();
            graphics.translate(n2 + 1, n3);
            graphics.setColor(color2);
            graphics.drawLine(4, 4, this.size - 5, this.size - 5);
            graphics.drawLine(this.size - 5, 4, 4, this.size - 5);
            graphics.setColor(color3);
            graphics.drawLine(3, 4, this.size - 6, this.size - 5);
            graphics.drawLine(this.size - 6, 4, 3, this.size - 5);
            graphics.translate(-n2 - 1, -n3);
            graphics.setColor(color);
        }

        public int getIconWidth() {
            return this.size;
        }

        public int getIconHeight() {
            return this.size;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    public static class MaximizeRestoreIcon
    implements Icon,
    Serializable {
        private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
        protected static Icon icon;
        int size = 14;
        static /* synthetic */ Class class$com$ibm$db2$tools$common$DockingPane;

        public static Icon getInstance() {
            if (icon == null) {
                icon = new MaximizeRestoreIcon();
            }
            return icon;
        }

        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
            Color color = graphics.getColor();
            graphics.setColor(UIManager.getColor("TextField.foreground"));
            DockingPane dockingPane = (DockingPane)SwingUtilities.getAncestorOfClass(class$com$ibm$db2$tools$common$DockingPane == null ? (class$com$ibm$db2$tools$common$DockingPane = MaximizeRestoreIcon.class$("com.ibm.db2.tools.common.DockingPane")) : class$com$ibm$db2$tools$common$DockingPane, component);
            if (dockingPane.isMaximized()) {
                graphics.drawRect(5, 3, 4, 4);
                graphics.drawLine(5, 4, 9, 4);
                graphics.drawRect(3, 6, 4, 4);
                graphics.drawLine(3, 7, 7, 6);
            } else {
                int n4 = this.size - 8;
                graphics.drawRect(3, 3, n4, n4);
                graphics.drawLine(3, 4, 3 + n4, 4);
            }
            graphics.setColor(color);
        }

        public int getIconWidth() {
            return this.size;
        }

        public int getIconHeight() {
            return this.size;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    public static class MotifMaximizeRestoreIcon
    implements Icon,
    Serializable {
        private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
        protected static Icon icon;
        int size = 14;
        static /* synthetic */ Class class$com$ibm$db2$tools$common$DockingPane;

        public static Icon getInstance() {
            if (icon == null) {
                icon = new MotifMaximizeRestoreIcon();
            }
            return icon;
        }

        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
            int n4 = this.size - 4;
            Color color = UIManager.getColor("InternalFrame.inactiveTitleBackground");
            Color color2 = color.brighter();
            Color color3 = color.darker().darker();
            color = graphics.getColor();
            DockingPane dockingPane = (DockingPane)SwingUtilities.getAncestorOfClass(class$com$ibm$db2$tools$common$DockingPane == null ? (class$com$ibm$db2$tools$common$DockingPane = MotifMaximizeRestoreIcon.class$("com.ibm.db2.tools.common.DockingPane")) : class$com$ibm$db2$tools$common$DockingPane, component);
            boolean bl = dockingPane.isMaximized();
            graphics.setColor(bl ? color3 : color2);
            graphics.drawLine(3, 3, 3, n4);
            graphics.drawLine(3, 3, n4, 3);
            graphics.setColor(bl ? color2 : color3);
            graphics.drawLine(4, n4, n4, n4);
            graphics.drawLine(n4, 4, n4, n4);
            graphics.setColor(color);
        }

        public int getIconWidth() {
            return this.size;
        }

        public int getIconHeight() {
            return this.size;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    protected static class CollapseIcon
    implements Icon,
    Serializable {
        private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
        protected int size = 14;
        protected int state;
        protected int rotation;

        public CollapseIcon(int n2, int n3) {
            this.state = n2;
            this.rotation = n3;
        }

        public void setState(int n2) {
            this.state = n2;
        }

        public int getState() {
            return this.state;
        }

        public void setRotation(int n2) {
            this.rotation = n2;
        }

        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
            graphics.translate(n2, n3);
            Color color = component.getBackground();
            graphics.setColor(Color.black);
            Polygon polygon = new Polygon();
            switch (this.state) {
                case -1: {
                    if (this.rotation == 0) {
                        graphics.translate(1, 1);
                        graphics.setColor(color.brighter());
                        polygon.addPoint(6, 3);
                        polygon.addPoint(this.size - 6, this.size - 6);
                        polygon.addPoint(3, this.size - 6);
                        graphics.drawPolygon(polygon);
                        graphics.translate(-1, -1);
                        graphics.setColor(color.darker());
                        break;
                    }
                    graphics.translate(1, 1);
                    graphics.setColor(color.brighter());
                    polygon.addPoint(3, 6);
                    polygon.addPoint(this.size - 6, 3);
                    polygon.addPoint(this.size - 6, this.size - 6);
                    graphics.drawPolygon(polygon);
                    graphics.translate(-1, -1);
                    graphics.setColor(color.darker());
                    break;
                }
                case 1: {
                    if (this.rotation == 0) {
                        polygon.addPoint(6, 3);
                        polygon.addPoint(this.size - 6, this.size - 6);
                        polygon.addPoint(3, this.size - 6);
                        break;
                    }
                    polygon.addPoint(3, 6);
                    polygon.addPoint(this.size - 6, 3);
                    polygon.addPoint(this.size - 6, this.size - 6);
                    break;
                }
                case 3: {
                    if (this.rotation == 0) {
                        polygon.addPoint(3, 3);
                        polygon.addPoint(this.size - 6, 3);
                        polygon.addPoint(6, this.size - 6);
                        break;
                    }
                    polygon.addPoint(3, 3);
                    polygon.addPoint(this.size - 6, 6);
                    polygon.addPoint(3, this.size - 6);
                    break;
                }
                default: {
                    polygon.addPoint(3, 3);
                    polygon.addPoint(this.size - 6, 3);
                    polygon.addPoint(this.size - 6, this.size - 6);
                    polygon.addPoint(3, this.size - 6);
                }
            }
            graphics.drawPolygon(polygon);
            graphics.setColor(color.darker());
            graphics.fillPolygon(polygon);
            graphics.setColor(color);
            graphics.translate(-n2, -n3);
        }

        public int getIconWidth() {
            return this.size;
        }

        public int getIconHeight() {
            return this.size;
        }
    }
}

