/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.support;

import com.ibm.db2.tools.common.plaf.DockingTitleUI;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.io.Serializable;
import javax.accessibility.AccessibleContext;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.plaf.LabelUI;

public class DockingTitle
extends JLabel
implements Serializable {
    public static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected boolean activeTitle;
    protected int rotation;

    public DockingTitle() {
        this(0, "", null, 10);
    }

    public DockingTitle(Icon icon) {
        this(0, null, icon, 0);
    }

    public DockingTitle(Icon icon, int n2) {
        this(0, null, icon, n2);
    }

    public DockingTitle(String string) {
        this(0, string, null, 10);
    }

    public DockingTitle(String string, int n2) {
        this(0, string, null, n2);
    }

    public DockingTitle(String string, Icon icon, int n2) {
        this(0, string, icon, n2);
    }

    public DockingTitle(int n2, Icon icon) {
        this(n2, null, icon, 0);
    }

    public DockingTitle(int n2, Icon icon, int n3) {
        this(n2, null, icon, n3);
    }

    public DockingTitle(int n2, String string) {
        this(n2, string, 10);
    }

    public DockingTitle(int n2, String string, int n3) {
        this(n2, string, null, n3);
    }

    public DockingTitle(int n2, String string, Icon icon, int n3) {
        super(string, icon, n3);
        this.setUI(new DockingTitleUI());
        this.rotation = n2;
        this.setOpaque(true);
        this.activeTitle = false;
        this.enableEvents(48L);
    }

    public int getRotation() {
        return this.rotation;
    }

    public void setRotation(int n2) {
        this.rotation = n2;
    }

    public void setActive(boolean bl) {
        this.activeTitle = bl;
        this.repaint();
    }

    public boolean isActive() {
        return this.activeTitle;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (this.rotation == 1) {
            int n2 = dimension.height;
            dimension.height = dimension.width;
            dimension.width = n2;
        }
        return dimension;
    }

    public int getWidth() {
        if (this.rotation == 1) {
            Dimension dimension = super.getPreferredSize();
            return dimension.height;
        }
        return super.getWidth();
    }

    protected void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        if (this.rotation == 1) {
            graphics2D.rotate(-1.5707963267948966);
            graphics2D.translate(-1 * this.getHeight(), 0);
        }
        try {
            super.paintComponent(graphics2D);
            Object var4_3 = null;
            graphics2D.dispose();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            graphics2D.dispose();
            throw throwable;
        }
    }

    public LabelUI getUI() {
        return (DockingTitleUI)this.ui;
    }

    public void setUI(DockingTitleUI dockingTitleUI) {
        super.setUI(dockingTitleUI);
        this.setFont(UIManager.getFont("ToolBar.font"));
    }

    public void updateUI() {
        this.setUI(new DockingTitleUI());
    }

    public String getUIClassID() {
        return "DockingTitleUI";
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleDockingTitle();
        }
        return this.accessibleContext;
    }

    protected class AccessibleDockingTitle
    extends JLabel.AccessibleJLabel {
        private static final String kCBIBMCopyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

        protected AccessibleDockingTitle() {
            super(DockingTitle.this);
        }

        public String getAccessibleDescription() {
            String string = super.getAccessibleDescription();
            if (string == null) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(super.getAccessibleRole().toString()).append(" - ");
                stringBuffer.append(super.getAccessibleName());
                string = stringBuffer.toString();
            }
            return string;
        }
    }
}

