/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.support;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.io.Serializable;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicGraphicsUtils;

public class DashedBorder
extends AbstractBorder
implements Serializable {
    private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected static Border blackBorder;
    protected static Border colorBorder;
    protected static Border blackRoundedBorder;
    protected static Border colorRoundedBorder;
    protected Color lineColor;
    protected boolean rounded;

    public static Border createBlackDashedBorder() {
        if (blackBorder == null) {
            blackBorder = new DashedBorder(Color.black);
        }
        return blackBorder;
    }

    public static Border createColoredDashedBorder(Color color) {
        if (colorBorder == null) {
            colorBorder = new DashedBorder(color);
        }
        return colorBorder;
    }

    public static Border createRoundedDashedBorder(Color color) {
        if (color == null || color == Color.black) {
            if (blackRoundedBorder == null) {
                blackRoundedBorder = new DashedBorder(Color.black, true);
            }
            return blackRoundedBorder;
        }
        if (colorRoundedBorder == null) {
            colorRoundedBorder = new DashedBorder(color, true);
        }
        return colorRoundedBorder;
    }

    public DashedBorder(Color color) {
        this.lineColor = color;
        this.rounded = false;
    }

    public DashedBorder(Color color, boolean bl) {
        this.lineColor = color;
        this.rounded = bl;
    }

    public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
        Color color = graphics.getColor();
        if (this.rounded) {
            graphics.setColor(this.lineColor);
            float f2 = n4 / 2;
            float f3 = n5 / 2;
            int n6 = 0;
            while (n6 < 360) {
                float f4 = f2 * (float)Math.sin(n6);
                float f5 = f3 * (float)Math.cos(n6);
                float f6 = 135.0f / (float)Math.sqrt(f4 * f4 + f5 * f5);
                int n7 = Math.max(Math.round(f6), 1);
                graphics.drawArc(n2, n3, n4, n5, n6, n7);
                n6 += n7 * 2;
            }
        } else {
            graphics.setColor(this.getComplementaryColor(this.lineColor));
            graphics.drawRect(n2, n3, n4 - 1, n5 - 1);
            graphics.setColor(this.lineColor);
            BasicGraphicsUtils.drawDashedRect(graphics, n2, n3, n4, n5);
        }
        graphics.setColor(color);
    }

    public Color getComplementaryColor(Color color) {
        return new Color(255 - color.getRed(), 255 - color.getGreen(), 255 - color.getBlue());
    }

    public Insets getBorderInsets(Component component) {
        return new Insets(1, 1, 1, 1);
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public void getLineColor(Color color) {
        this.lineColor = color;
    }

    public boolean isBorderOpaque() {
        return true;
    }
}

