/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.support;

import com.ibm.db2.tools.common.support.AssistManager;
import com.ibm.db2.tools.common.support.CellExpander;
import com.ibm.db2.tools.common.support.CellExpanderComponent;
import com.ibm.db2.tools.common.support.JPanelPopup;
import com.ibm.db2.tools.common.support.PanelPopup;
import com.ibm.db2.tools.common.support.Popup;
import com.ibm.db2.tools.common.support.ReuseStringBuffer;
import com.ibm.db2.tools.common.support.WindowPopup;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class CellExpanderManager
extends MouseAdapter
implements ActionListener,
MouseMotionListener,
AncestorListener,
Serializable {
    private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected Point cellLocation;
    protected WeakReference ttipComp;
    protected static CellExpanderManager sharedInstance = new CellExpanderManager();
    protected Popup tipWindow;
    protected CellExpander tip;
    protected JPanelPopup jpanelPopup;
    protected PanelPopup panelPopup;
    protected WindowPopup windowPopup;
    protected Rectangle popupRect = null;
    protected Dimension size = new Dimension();
    protected boolean enabled = true;
    protected boolean tipShowing = false;
    protected boolean lightWeightPopupEnabled = true;
    protected long releasedStamp;
    protected boolean simDouble;
    static /* synthetic */ Class class$java$awt$Window;
    static /* synthetic */ Class class$com$ibm$db2$tools$common$support$CellExpanderComponent;

    public void setEnabled(boolean bl) {
        this.enabled = bl;
        if (!bl) {
            this.hideTipWindow();
            this.cellLocation = null;
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setLightWeightPopupEnabled(boolean bl) {
        this.lightWeightPopupEnabled = bl;
    }

    public boolean isLightWeightPopupEnabled() {
        return this.lightWeightPopupEnabled;
    }

    protected void showTipWindow(MouseEvent mouseEvent) {
        CellExpanderComponent cellExpanderComponent = null;
        if (this.ttipComp != null) {
            cellExpanderComponent = (CellExpanderComponent)this.ttipComp.get();
        }
        if (cellExpanderComponent != null && this.parentWindowActive(cellExpanderComponent) && ((JComponent)((Object)cellExpanderComponent)).isShowing() && (((JComponent)((Object)cellExpanderComponent)).getRootPane() == null || ((JComponent)((Object)cellExpanderComponent)).getRootPane() != null && ((JComponent)((Object)cellExpanderComponent)).getRootPane().getLayeredPane() != null && ((JComponent)((Object)cellExpanderComponent)).getRootPane().getLayeredPane().getComponentCountInLayer(JLayeredPane.POPUP_LAYER) == 0) && this.enabled) {
            Serializable serializable;
            Point point = null;
            if (!((Component)((Object)cellExpanderComponent)).isShowing()) {
                return;
            }
            point = ((Component)((Object)cellExpanderComponent)).getLocationOnScreen();
            int n2 = 0;
            int n3 = 0;
            if (this.cellLocation != null) {
                n2 = point.x + this.cellLocation.x;
                n3 = point.y + this.cellLocation.y;
            }
            this.tip = cellExpanderComponent.createCellExpander(mouseEvent);
            Dimension dimension = this.tip.getPreferredSize();
            this.size.width = dimension.width + 5;
            this.size.height = dimension.height;
            Dimension dimension2 = this.tip.getToolkit().getScreenSize();
            if (n2 < 0) {
                n2 = 0;
            }
            if (n2 + this.size.width > dimension2.width - 10) {
                Point point2;
                int n4 = dimension2.width - n2 - 10;
                this.tip.setWidth(n4);
                serializable = this.tip.getPreferredSize();
                if (this.size.width < serializable.width) {
                    this.size.width = serializable.width;
                }
                if (this.size.height < serializable.height) {
                    this.size.height = serializable.height;
                }
                if ((point2 = (Point)this.tip.getClientProperty("translate.point")) != null && point2.y > 0) {
                    this.size.height += point2.y;
                }
            }
            this.tip.setSize(this.size);
            if (this.lightWeightPopupEnabled) {
                if (this.jpanelPopup == null) {
                    this.jpanelPopup = new JPanelPopup();
                }
                this.tipWindow = this.jpanelPopup;
            } else {
                if (this.panelPopup == null) {
                    this.panelPopup = new PanelPopup();
                }
                this.tipWindow = this.panelPopup;
            }
            if (this.popupRect == null) {
                this.popupRect = new Rectangle(n2, n3, this.size.width, this.size.height);
            } else {
                this.popupRect.setBounds(n2, n3, this.size.width, this.size.height);
            }
            if (!AssistManager.popupFit(this.popupRect, (Component)((Object)cellExpanderComponent))) {
                Window window = (Window)SwingUtilities.getAncestorOfClass(class$java$awt$Window == null ? (class$java$awt$Window = CellExpanderManager.class$("java.awt.Window")) : class$java$awt$Window, (Component)((Object)cellExpanderComponent));
                serializable = (Window)SwingUtilities.getAncestorOfClass(class$java$awt$Window == null ? (class$java$awt$Window = CellExpanderManager.class$("java.awt.Window")) : class$java$awt$Window, this.windowPopup);
                if (this.windowPopup == null || window != serializable) {
                    this.windowPopup = new WindowPopup(window);
                }
                this.tipWindow = this.windowPopup;
            }
            if (this.jpanelPopup != null && this.jpanelPopup.isVisible() && this.jpanelPopup != this.tipWindow) {
                this.jpanelPopup.disappear();
            }
            if (this.panelPopup != null && this.panelPopup.isVisible() && this.panelPopup != this.tipWindow) {
                this.panelPopup.disappear();
            }
            if (this.windowPopup != null && this.windowPopup.isVisible() && this.windowPopup != this.tipWindow) {
                this.windowPopup.disappear();
            }
            this.tip.setVisible(true);
            this.tip.removeMouseListener(this);
            this.tip.addMouseListener(this);
            this.tipWindow.appear(this.tip, this.size, (JComponent)((Object)cellExpanderComponent), n2, n3);
            this.tipShowing = true;
        }
    }

    protected void hideTipWindow() {
        if (this.tipWindow != null && this.tip != null && this.tipWindow.isVisible()) {
            this.tip.removeMouseListener(this);
            this.tipWindow.disappear();
            this.tipWindow = null;
            this.tipShowing = false;
            this.tip = null;
        }
        this.cellLocation = null;
    }

    public static CellExpanderManager sharedInstance() {
        return sharedInstance;
    }

    public void registerComponent(CellExpanderComponent cellExpanderComponent) {
        this.removeListenersDescending((Component)((Object)cellExpanderComponent));
        ((JComponent)((Object)cellExpanderComponent)).removeAncestorListener(this);
        this.addListenersDescending((Component)((Object)cellExpanderComponent));
        ((JComponent)((Object)cellExpanderComponent)).addAncestorListener(this);
    }

    public void unregisterComponent(CellExpanderComponent cellExpanderComponent) {
        this.removeListenersDescending((Component)((Object)cellExpanderComponent));
        ((JComponent)((Object)cellExpanderComponent)).removeAncestorListener(this);
        CellExpanderComponent cellExpanderComponent2 = null;
        if (this.ttipComp != null) {
            cellExpanderComponent2 = (CellExpanderComponent)this.ttipComp.get();
        }
        if (cellExpanderComponent == cellExpanderComponent2) {
            this.ttipComp = null;
        }
    }

    protected void addListenersDescending(Component component) {
        component.addMouseListener(this);
        if (component instanceof AbstractButton) {
            ((AbstractButton)component).addActionListener(this);
        }
        if (component instanceof Container) {
            Component[] componentArray = ((Container)component).getComponents();
            int n2 = componentArray.length;
            int n3 = 0;
            while (n3 < n2) {
                this.addListenersDescending(componentArray[n3]);
                ++n3;
            }
        }
    }

    protected void removeListenersDescending(Component component) {
        component.removeMouseListener(this);
        if (component instanceof AbstractButton) {
            ((AbstractButton)component).removeActionListener(this);
        }
        if (component instanceof Container) {
            Component[] componentArray = ((Container)component).getComponents();
            int n2 = componentArray.length;
            int n3 = 0;
            while (n3 < n2) {
                this.removeListenersDescending(componentArray[n3]);
                ++n3;
            }
        }
    }

    private boolean parentWindowActive(Object object) {
        Container container = (Container)object;
        while (container != null) {
            if (container instanceof Window && ((Window)container).getFocusOwner() != null) {
                return true;
            }
            container = container.getParent();
        }
        return false;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        CellExpanderComponent cellExpanderComponent = null;
        if (this.ttipComp != null) {
            cellExpanderComponent = (CellExpanderComponent)this.ttipComp.get();
        }
        if (cellExpanderComponent != null) {
            ((Component)((Object)cellExpanderComponent)).removeMouseMotionListener(this);
        }
        this.ttipComp = null;
        this.hideTipWindow();
    }

    protected CellExpanderComponent getParentCellExpanderComponent(Component component) {
        CellExpanderComponent cellExpanderComponent = null;
        cellExpanderComponent = component instanceof CellExpanderComponent ? (CellExpanderComponent)((Object)component) : (CellExpanderComponent)((Object)SwingUtilities.getAncestorOfClass(class$com$ibm$db2$tools$common$support$CellExpanderComponent == null ? (class$com$ibm$db2$tools$common$support$CellExpanderComponent = CellExpanderManager.class$("com.ibm.db2.tools.common.support.CellExpanderComponent")) : class$com$ibm$db2$tools$common$support$CellExpanderComponent, component));
        CellExpanderComponent cellExpanderComponent2 = null;
        while (cellExpanderComponent != null) {
            cellExpanderComponent2 = cellExpanderComponent;
            cellExpanderComponent = (CellExpanderComponent)((Object)SwingUtilities.getAncestorOfClass(class$com$ibm$db2$tools$common$support$CellExpanderComponent == null ? CellExpanderManager.class$("com.ibm.db2.tools.common.support.CellExpanderComponent") : class$com$ibm$db2$tools$common$support$CellExpanderComponent, (Component)((Object)cellExpanderComponent2)));
        }
        return cellExpanderComponent2;
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        CellExpanderComponent cellExpanderComponent = this.getParentCellExpanderComponent((Component)mouseEvent.getSource());
        if (cellExpanderComponent != null) {
            ((Component)((Object)cellExpanderComponent)).removeMouseMotionListener(this);
            ((Component)((Object)cellExpanderComponent)).addMouseMotionListener(this);
            this.ttipComp = new WeakReference<CellExpanderComponent>(cellExpanderComponent);
            this.cellLocation = cellExpanderComponent.getCellExpanderLocation(mouseEvent);
            Point point = mouseEvent.getPoint();
            if (this.cellLocation == null || point.x < this.cellLocation.x || point.y < this.cellLocation.y) {
                this.cellLocation = null;
                return;
            }
            this.showTipWindow(mouseEvent);
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        CellExpanderComponent cellExpanderComponent = null;
        if (this.ttipComp != null) {
            cellExpanderComponent = (CellExpanderComponent)this.ttipComp.get();
        }
        boolean bl = false;
        if (cellExpanderComponent == null) {
            // empty if block
        }
        if (mouseEvent.getSource() instanceof CellExpander) {
            bl = true;
        } else if (mouseEvent.getSource() == cellExpanderComponent && this.tipWindow != null) {
            Point point = mouseEvent.getPoint();
            Rectangle rectangle = this.tipWindow.getBounds();
            Rectangle rectangle2 = ((Component)((Object)cellExpanderComponent)).getBounds();
            rectangle2.x = 0;
            rectangle2.y = 0;
            if (!CellExpanderManager.isRectangleContainingPoint(rectangle, point) && !CellExpanderManager.isRectangleContainingPoint(rectangle2, point)) {
                bl = true;
            }
        }
        if (bl) {
            if (cellExpanderComponent != null) {
                ((Component)((Object)cellExpanderComponent)).removeMouseMotionListener(this);
            }
            this.ttipComp = null;
            this.hideTipWindow();
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.redirectMouseEvent(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.redirectMouseEvent(mouseEvent);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.redirectMouseEvent(mouseEvent);
    }

    protected void redirectMouseEvent(MouseEvent mouseEvent) {
        Object object;
        CellExpanderComponent cellExpanderComponent = null;
        if (this.ttipComp != null) {
            cellExpanderComponent = (CellExpanderComponent)this.ttipComp.get();
        }
        if ((object = mouseEvent.getSource()) == cellExpanderComponent && mouseEvent.getClickCount() == 1) {
            long l2 = mouseEvent.getWhen() - this.releasedStamp;
            if (mouseEvent.getID() == 501 && l2 > 0L && l2 < 551L) {
                this.simDouble = true;
            }
            if (this.simDouble) {
                Point point = mouseEvent.getPoint();
                MouseEvent mouseEvent2 = new MouseEvent((Component)((Object)cellExpanderComponent), mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, 2, mouseEvent.isPopupTrigger());
                mouseEvent.consume();
                ((Component)((Object)cellExpanderComponent)).dispatchEvent(mouseEvent2);
            }
            if (mouseEvent.getID() == 500) {
                this.simDouble = false;
            }
        }
        if (object instanceof CellExpander && cellExpanderComponent != null && ((Component)((Object)cellExpanderComponent)).isShowing() && cellExpanderComponent != object) {
            Object object2;
            Point point = mouseEvent.getPoint();
            if (cellExpanderComponent != null) {
                point = SwingUtilities.convertPoint((Component)object, point, (Component)((Object)cellExpanderComponent));
            }
            if (mouseEvent.getID() == 501 || mouseEvent.getID() == 500 || mouseEvent.getID() == 502) {
                this.releasedStamp = mouseEvent.getWhen();
                object2 = cellExpanderComponent;
                SwingUtilities.invokeLater(new Runnable((CellExpanderComponent)object2){
                    private final /* synthetic */ CellExpanderComponent val$tipComponent;
                    {
                        this.val$tipComponent = cellExpanderComponent;
                    }

                    public void run() {
                        CellExpanderManager.this.hideTipWindow();
                        if (this.val$tipComponent instanceof Component) {
                            ((Component)((Object)this.val$tipComponent)).requestFocus();
                        }
                    }
                });
            }
            if (cellExpanderComponent instanceof Component) {
                ((Component)((Object)cellExpanderComponent)).requestFocus();
            }
            object2 = new MouseEvent((Component)((Object)cellExpanderComponent), mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
            mouseEvent.consume();
            ((Component)((Object)cellExpanderComponent)).dispatchEvent((AWTEvent)object2);
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        int n2 = mouseEvent.getModifiers();
        CellExpanderComponent cellExpanderComponent = (CellExpanderComponent)mouseEvent.getSource();
        Point point = cellExpanderComponent.getCellExpanderLocation(mouseEvent);
        if ((n2 & 0x10) > 0 || (n2 & 8) > 0 || point == null) {
            this.hideTipWindow();
        } else if (this.cellLocation == null || !point.equals(this.cellLocation)) {
            this.hideTipWindow();
            if (point != null) {
                this.cellLocation = point;
                this.showTipWindow(mouseEvent);
            } else {
                this.cellLocation = null;
            }
        }
    }

    public void ancestorAdded(AncestorEvent ancestorEvent) {
    }

    public void ancestorRemoved(AncestorEvent ancestorEvent) {
        Window window;
        Object object = ancestorEvent.getSource();
        if (!(!(object instanceof CellExpanderComponent) || ((Component)object).isVisible() || (window = (Window)SwingUtilities.getAncestorOfClass(class$java$awt$Window == null ? (class$java$awt$Window = CellExpanderManager.class$("java.awt.Window")) : class$java$awt$Window, (Component)object)) != null && window.isVisible())) {
            this.unregisterComponent((CellExpanderComponent)object);
        }
    }

    public void ancestorMoved(AncestorEvent ancestorEvent) {
    }

    protected static Frame frameForComponent(Component component) {
        while (!(component instanceof Frame)) {
            component = component.getParent();
        }
        return (Frame)component;
    }

    protected static boolean isRectangleContainingPoint(Rectangle rectangle, Point point) {
        return point.x > rectangle.x && point.x < rectangle.x + rectangle.width && point.y > rectangle.y && point.y < rectangle.y + rectangle.height;
    }

    public static String untag(String string) {
        int n2 = string.indexOf(60);
        if (n2 < 0) {
            return string;
        }
        ReuseStringBuffer reuseStringBuffer = ReuseStringBuffer.getBuffer();
        int n3 = 0;
        while (n2 > -1) {
            if (n2 > 0) {
                reuseStringBuffer.append(string.substring(n3, n2));
            }
            reuseStringBuffer.append("&lt;");
            n3 = n2 + 1;
            n2 = string.indexOf(60, n3);
        }
        if (n3 < string.length() - 1) {
            reuseStringBuffer.append(string.substring(n3));
        }
        return ReuseStringBuffer.toString(reuseStringBuffer);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

