/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.support;

import com.ibm.db2.tools.common.AssistEllipsis;
import com.ibm.db2.tools.common.smartguide.CustomToggleButton;
import com.ibm.db2.tools.common.smartx.support.DiagnosisRenderer;
import com.ibm.db2.tools.common.smartx.support.SmartManager;
import com.ibm.db2.tools.common.support.AssistManager;
import com.ibm.db2.tools.common.support.AssistRole;
import com.ibm.db2.tools.common.support.CellExpanderComponent;
import com.ibm.db2.tools.common.uamanager.InfoPopGnosis;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.io.Serializable;
import javax.accessibility.AccessibleRole;
import javax.swing.BorderFactory;
import javax.swing.JTable;
import javax.swing.JTree;

public class CellExpander
extends DiagnosisRenderer
implements Serializable {
    private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String cacheKey = "CellExpander";
    protected CellExpanderComponent parent;
    protected InfoPopGnosis diagnosis;

    public CellExpander(CellExpanderComponent cellExpanderComponent) {
        this.parent = cellExpanderComponent;
        this.leastWidth = 10;
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setOpaque(true);
        this.diagnosis = new InfoPopGnosis("");
        DiagnosisRenderer.AccessibleDiagnosisRenderer accessibleDiagnosisRenderer = (DiagnosisRenderer.AccessibleDiagnosisRenderer)super.getAccessibleContext();
        if (cellExpanderComponent instanceof JTable) {
            accessibleDiagnosisRenderer.setAccessibleRole(AssistRole.TABLE_CELL);
        } else if (cellExpanderComponent instanceof JTree) {
            accessibleDiagnosisRenderer.setAccessibleRole(AssistRole.TREE_NODE);
        } else if (cellExpanderComponent instanceof AssistEllipsis) {
            accessibleDiagnosisRenderer.setAccessibleRole(AssistRole.ELLIPSIS_EDITOR);
        } else if (cellExpanderComponent instanceof CustomToggleButton) {
            accessibleDiagnosisRenderer.setAccessibleRole(AccessibleRole.PAGE_TAB);
        }
    }

    protected void paintComponent(Graphics graphics) {
        Graphics graphics2 = graphics.create();
        Dimension dimension = this.getSize();
        graphics2.setColor(this.getBackground());
        graphics2.fillRect(0, 0, dimension.width, dimension.height);
        graphics2.setColor(this.getForeground());
        Point point = (Point)this.getClientProperty("translate.point");
        if (point != null) {
            graphics2.translate(point.x, point.y);
        }
        try {
            super.paintComponent(graphics2);
            Object var6_5 = null;
            graphics2.dispose();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            graphics2.dispose();
            throw throwable;
        }
    }

    public void setWidth(int n2) {
        this.setPreferredSize(null);
        this.wrap(n2);
    }

    public void setTipText(String string) {
        this.setTipText(string, 9999);
    }

    public void setTipText(String string, int n2) {
        this.setPreferredSize(null);
        this.diagnosis.setDescription(string);
        Graphics graphics = AssistManager.getParentGraphics((Container)((Object)this.parent));
        if (graphics == null) {
            return;
        }
        graphics.setFont(this.getFont());
        this.configure(graphics, this.diagnosis);
        this.wrap(n2);
        Dimension dimension = this.getPreferredSize();
        this.setSize(dimension);
        this.setMinimumSize(dimension);
        if (this.getAccessibleContext().getAccessibleName() == null) {
            this.getAccessibleContext().setAccessibleName(SmartManager.translateHtml(string, true));
        }
    }

    public String getTipText() {
        return this.diagnosis.getDescription();
    }

    public CellExpanderComponent getCellExpanderParent() {
        return this.parent;
    }
}

