/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.support;

import com.ibm.db2.tools.common.CommonTrace;

public class CUtil2 {
    private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static boolean db2available = false;

    public static int setDB2HelpSystemHostName(String string) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.support", "CUtil2", "setDB2HelpSystemHostname(String aHostName)", new Object[]{string});
        }
        int n2 = -1;
        if (db2available) {
            n2 = CUtil2.setHelpSystemHostName(string);
        }
        return CommonTrace.exit(commonTrace, n2);
    }

    public static String getDB2HelpSystemHostName() {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.support", "CUtil2", "getDB2HelpSystemHostName()");
        }
        String string = "";
        if (db2available) {
            string = CUtil2.getHelpSystemHostName();
        }
        return (String)CommonTrace.exit(commonTrace, string);
    }

    public static String getDB2HelpSystemHostNameByLevel(boolean bl) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.support", "CUtil2", "getDB2HelpSystemHostNameByLevel()", new Object[]{new Boolean(bl)});
        }
        String string = "";
        if (db2available) {
            string = CUtil2.getHelpSystemHostNameByLevel(bl);
        }
        return (String)CommonTrace.exit(commonTrace, string);
    }

    public static int setDB2HelpSystemPortNumber(String string) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.support", "CUtil2", "setDB2HelpSystemPortNumber(String aHostname)", new Object[]{string});
        }
        int n2 = -1;
        if (db2available) {
            n2 = CUtil2.setHelpSystemPortNumber(string);
        }
        return CommonTrace.exit(commonTrace, n2);
    }

    public static String getDB2HelpSystemPortNumber() {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.support", "CUtil2", "getDB2HelpSystemPortNumber()");
        }
        String string = "";
        if (db2available) {
            string = CUtil2.getHelpSystemPortNumber();
        }
        return (String)CommonTrace.exit(commonTrace, string);
    }

    public static String getDB2HelpSystemPortNumberByLevel(boolean bl) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.support", "CUtil2", "getDB2HelpSystemPortNumberByLevel()", new Object[]{new Boolean(bl)});
        }
        String string = "";
        if (db2available) {
            string = CUtil2.getHelpSystemPortNumberByLevel(bl);
        }
        return (String)CommonTrace.exit(commonTrace, string);
    }

    private static native int setHelpSystemHostName(String var0);

    private static native String getHelpSystemHostName();

    private static native String getHelpSystemHostNameByLevel(boolean var0);

    private static native int setHelpSystemPortNumber(String var0);

    private static native String getHelpSystemPortNumber();

    private static native String getHelpSystemPortNumberByLevel(boolean var0);

    private static boolean load(String string) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.support", "CUtil2", "load( String aLibrary )", new Object[]{string});
        }
        boolean bl = false;
        try {
            System.loadLibrary(string);
            bl = true;
        }
        catch (SecurityException securityException) {
            CommonTrace.catchBlock(commonTrace);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            CommonTrace.catchBlock(commonTrace);
        }
        return CommonTrace.exit(commonTrace, bl);
    }

    public static void main(String[] stringArray) {
        System.out.println("CUtil test . . .");
        int n2 = 0;
        while (n2 < stringArray.length) {
            System.out.println("\t" + stringArray[n2]);
            ++n2;
        }
        if (stringArray.length < 1) {
            System.out.println("\tThe first argument must name a function to test.");
            return;
        }
        String string = null;
        if (stringArray[0].equalsIgnoreCase("getDB2HelpSystemHostName")) {
            string = CUtil2.getDB2HelpSystemHostName();
            System.out.println("Results:\n\tgetDB2HelpSystemHostName=" + string);
            string = CUtil2.getDB2HelpSystemHostNameByLevel(false);
            System.out.println("Results:\n\tgetDB2HelpSystemHostName global   =" + string);
            string = CUtil2.getDB2HelpSystemHostNameByLevel(true);
            System.out.println("Results:\n\tgetDB2HelpSystemHostName instance =" + string);
        } else if (stringArray[0].equalsIgnoreCase("getDB2HelpSystemPortNumber")) {
            string = CUtil2.getDB2HelpSystemPortNumber();
            System.out.println("Results:\n\tgetDB2HelpSystemPortNumber=" + string);
            string = CUtil2.getDB2HelpSystemPortNumberByLevel(false);
            System.out.println("Results:\n\tgetDB2HelpSystemPortNumber global   =" + string);
            string = CUtil2.getDB2HelpSystemPortNumberByLevel(true);
            System.out.println("Results:\n\tgetDB2HelpSystemPortNumber instance =" + string);
        } else if (stringArray[0].equalsIgnoreCase("setDB2HelpSystemHostName")) {
            int n3;
            try {
                n3 = CUtil2.setDB2HelpSystemHostName(stringArray[1]);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                n3 = CUtil2.setDB2HelpSystemHostName("");
            }
            System.out.println("Return code = " + n3);
            string = CUtil2.getDB2HelpSystemHostName();
            System.out.println("Results:\nsetDB2HelpSystemHostName return code = " + n3);
            System.out.println("Results:\nsetDB2HelpSystemHostName= " + string);
        } else if (stringArray[0].equalsIgnoreCase("setDB2HelpSystemPortNumber")) {
            int n4;
            try {
                n4 = CUtil2.setDB2HelpSystemPortNumber(stringArray[1]);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                n4 = CUtil2.setDB2HelpSystemPortNumber("");
            }
            System.out.println("Return code = " + n4);
            string = CUtil2.getDB2HelpSystemPortNumber();
            System.out.println("Results:\n\tsetDB2HelpSystemPortNumber return code = " + n4);
            System.out.println("Results:\n\tsetDB2HelpSystemPortNumber= " + string);
        }
    }

    static {
        db2available = CUtil2.load("db2jcc2");
    }
}

