/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.support;

import com.ibm.db2.tools.common.CommonTrace;
import com.ibm.db2.tools.common.support.AssistManager;

public class CUtil {
    private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public static native void init();

    public static native String getDB2Language();

    public static native String getDB2LanguageDirName();

    public static native String getDB2Locale();

    public static native String getISOTerritory();

    public static native String getISOTerritoryFromString(String var0);

    public static native String getNormalizedLocaleFromString(String var0);

    public static native String getDB2Path();

    public static native String getDB2SDKVersion();

    public static native int getuid();

    public static native boolean isServerLanguage();

    public static native int sqloGetPreferredOEMCP();

    public static native String getEnvironmentVariableValue(String var0);

    private static boolean load(String string) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.support", "CUtil", "load( String aLibrary )", new Object[]{string});
        }
        boolean bl = false;
        try {
            System.loadLibrary(string);
            bl = true;
        }
        catch (SecurityException securityException) {
            CommonTrace.catchBlock(commonTrace);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            CommonTrace.catchBlock(commonTrace);
        }
        return CommonTrace.exit(commonTrace, bl);
    }

    public static void main(String[] stringArray) {
        System.out.println("CUtil test . . .");
        int n2 = 0;
        while (n2 < stringArray.length) {
            System.out.println("\t" + stringArray[n2]);
            ++n2;
        }
        if (stringArray.length < 1) {
            System.out.println("\tThe first argument must name a function to test.");
            return;
        }
        Object object = null;
        if (stringArray[0].equalsIgnoreCase("getDB2Path")) {
            object = CUtil.getDB2Path();
            System.out.println("Results:\n\tgetDB2Path=" + object);
        } else if (stringArray[0].equalsIgnoreCase("getDB2Language")) {
            object = CUtil.getDB2Language();
            System.out.println("Results:\n\tgetDB2Language=" + object);
        } else if (stringArray[0].equalsIgnoreCase("getDB2LanguageDirName")) {
            object = CUtil.getDB2Language();
            System.out.println("Results:\n\tgetDB2LanguageDirName=" + object);
        } else if (stringArray[0].equalsIgnoreCase("getDB2Locale")) {
            object = CUtil.getDB2Locale();
            System.out.println("Results:\n\tgetDB2Locale=" + object);
        } else if (stringArray[0].equalsIgnoreCase("getISOTerritory")) {
            object = CUtil.getISOTerritory();
            System.out.println("Results:\n\tgetISOTerritory=" + object);
        } else if (stringArray[0].equalsIgnoreCase("getISOTerritoryFromString")) {
            object = CUtil.getISOTerritoryFromString(stringArray[1]);
            System.out.println("Results:\n\tgetISOTerritoryFromString(" + stringArray[1] + ")=" + object);
        } else if (stringArray[0].equalsIgnoreCase("getDB2SDKVersion")) {
            object = CUtil.getDB2SDKVersion();
            System.out.println("Results:\n\tgetDB2SDKVersion=" + object);
        } else if (stringArray[0].equalsIgnoreCase("getuid")) {
            object = new Integer(CUtil.getuid());
            System.out.println("Results:\n\tgetuid=" + object);
        } else if (stringArray[0].equalsIgnoreCase("isServerLanguage")) {
            object = new Boolean(CUtil.isServerLanguage());
            System.out.println("Results:\n\tisServerLanguage=" + object);
        } else if (stringArray[0].equalsIgnoreCase("sqloGetPreferredOEMCP")) {
            object = new Integer(CUtil.sqloGetPreferredOEMCP());
            System.out.println("Results:\n\tsqloGetPreferredOEMCP=" + object);
        } else if (stringArray[0].equalsIgnoreCase("getEnvironmentVariableValue")) {
            object = CUtil.getEnvironmentVariableValue(stringArray[1]);
            System.out.println("Results:\n\tgetEnvironmentVariableValue=" + object);
        } else if (stringArray[0].equalsIgnoreCase("test")) {
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            boolean bl = false;
            if (stringArray.length > 1 && stringArray[1].equalsIgnoreCase("verbose")) {
                bl = true;
            }
            Object[][] objectArrayArray = new Object[][]{{"C:\\SQLLIB"}, {"en_US"}, {"en_US"}, {"8.1"}, {new Integer(-1)}, {new Integer(850)}};
            int n6 = 0;
            object = CUtil.getDB2Path();
            if (object.equals(objectArrayArray[n6][0])) {
                if (bl) {
                    System.out.println("Success: getDB2Path=" + object);
                }
                ++n4;
            } else {
                System.out.println("Failure: getDB2Path=" + object);
                ++n5;
            }
            object = CUtil.getDB2Language();
            if (object.equals(objectArrayArray[++n6][0])) {
                if (bl) {
                    System.out.println("Success: getDB2Language=" + object);
                }
                ++n4;
            } else {
                System.out.println("Failure: getDB2Language=" + object);
                ++n5;
            }
            object = CUtil.getDB2LanguageDirName();
            if (object.equals(objectArrayArray[++n6][0])) {
                if (bl) {
                    System.out.println("Success: getDB2LanguageDirName=" + object);
                }
                ++n4;
            } else {
                System.out.println("Failure: getDB2LanguageDirName=" + object);
                ++n5;
            }
            object = CUtil.getDB2SDKVersion();
            if (object.equals(objectArrayArray[++n6][0])) {
                if (bl) {
                    System.out.println("Success: getDB2SDKVersion=" + object);
                }
                ++n4;
            } else {
                System.out.println("Failure: getDB2SDKVersion=" + object);
                ++n5;
            }
            object = new Integer(CUtil.getuid());
            if (object.equals(objectArrayArray[++n6][0])) {
                if (bl) {
                    System.out.println("Success: getuid=" + object);
                }
                ++n4;
            } else {
                System.out.println("Failure: guid=" + object);
                ++n5;
            }
            object = new Integer(CUtil.sqloGetPreferredOEMCP());
            if (object.equals(objectArrayArray[++n6][0])) {
                if (bl) {
                    System.out.println("Success: sqloGetPreferredOEMCP=" + object);
                }
                ++n4;
            } else {
                System.out.println("Failure: sqloGetPreferredOEMCP=" + object);
                ++n5;
            }
            n3 = n4 + n5;
            System.out.println("CUtil: " + n4 + "/" + n3);
        }
    }

    static {
        boolean bl = CUtil.load(AssistManager.getRegisteredLibrary());
        if (bl) {
            CUtil.init();
        }
    }
}

